/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.search;

import java.nio.file.Paths;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.marker.SearchResult;

public class FindGradleProject
extends Recipe {
    public String getDisplayName() {
        return "Find Gradle projects";
    }

    public String getDescription() {
        return "Gradle projects are those with `build.gradle` or `build.gradle.kts` files.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TreeVisitor<Tree, ExecutionContext>(){

            public Tree preVisit(Tree tree, ExecutionContext ctx) {
                SourceFile sourceFile;
                if (tree instanceof SourceFile && ((sourceFile = (SourceFile)tree).getSourcePath().endsWith(Paths.get("build.gradle", new String[0])) || sourceFile.getSourcePath().endsWith(Paths.get("build.gradle.kts", new String[0])))) {
                    return SearchResult.found((Tree)sourceFile);
                }
                return tree;
            }
        };
    }
}

