/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.gradle.IsBuildGradle;
import org.openrewrite.groovy.GroovyVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;

public final class RemoveRepository
extends Recipe {
    @Option(displayName="Repository", description="The name of the repository to remove", example="jcenter")
    private final String repository;

    public String getDisplayName() {
        return "Remove repository";
    }

    public String getDescription() {
        return "Removes a repository from Gradle build scripts. Named repositories include \"jcenter\", \"mavenCentral\", \"mavenLocal\", and \"google\".";
    }

    protected IsBuildGradle<ExecutionContext> getSingleSourceApplicableTest() {
        return new IsBuildGradle<ExecutionContext>();
    }

    public GroovyVisitor<ExecutionContext> getVisitor() {
        final MethodMatcher repositories = new MethodMatcher("org.gradle.api.artifacts.dsl.RepositoryHandler " + this.repository + "()");
        return new GroovyVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                if (repositories.matches(method)) {
                    return null;
                }
                return super.visitMethodInvocation(method, (Object)ctx);
            }
        };
    }

    public RemoveRepository(String repository) {
        this.repository = repository;
    }

    public String getRepository() {
        return this.repository;
    }

    @NonNull
    public String toString() {
        return "RemoveRepository(repository=" + this.getRepository() + ")";
    }

    public boolean equals(@Nullable Object o2) {
        if (o2 == this) {
            return true;
        }
        if (!(o2 instanceof RemoveRepository)) {
            return false;
        }
        RemoveRepository other = (RemoveRepository)((Object)o2);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o2)) {
            return false;
        }
        String this$repository = this.getRepository();
        String other$repository = other.getRepository();
        return !(this$repository == null ? other$repository != null : !this$repository.equals(other$repository));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof RemoveRepository;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $repository = this.getRepository();
        result = result * 59 + ($repository == null ? 43 : $repository.hashCode());
        return result;
    }
}

