/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.util.Arrays;
import java.util.Collections;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.IsBuildGradle;
import org.openrewrite.groovy.GroovyVisitor;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;

public class DependencyUseMapNotation
extends Recipe {
    public String getDisplayName() {
        return "Use `Map` notation for Gradle dependency declarations";
    }

    public String getDescription() {
        return "In Gradle, dependencies can be expressed as a `String` like `\"groupId:artifactId:version\"`, or equivalently as a `Map` like `group: 'groupId', name: 'artifactId', version: 'version'`. This recipe replaces dependencies represented as `Strings` with an equivalent dependency represented as a `Map`.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new IsBuildGradle();
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final MethodMatcher dependencyDsl = new MethodMatcher("DependencyHandlerSpec *(..)");
        return new GroovyVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext context) {
                J.MethodInvocation m2 = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)context);
                if (!dependencyDsl.matches(m2)) {
                    return m2;
                }
                m2 = this.forBasicString(m2);
                m2 = this.forGString(m2);
                return m2;
            }

            private J.MethodInvocation forBasicString(J.MethodInvocation m2) {
                Expression e2 = (Expression)m2.getArguments().get(0);
                if (!(e2 instanceof J.Literal)) {
                    return m2;
                }
                J.Literal arg = (J.Literal)e2;
                if (arg.getType() != JavaType.Primitive.String) {
                    return m2;
                }
                String dependencyString = (String)arg.getValue();
                if (dependencyString == null) {
                    return m2;
                }
                String[] gav = dependencyString.split(":");
                G.MapEntry groupEntry = DependencyUseMapNotation.mapEntry("group", gav[0]).withMarkers(arg.getMarkers()).withPrefix(arg.getPrefix());
                G.MapEntry artifactEntry = DependencyUseMapNotation.mapEntry("name", gav[1]).withMarkers(arg.getMarkers());
                G.MapEntry versionEntry = DependencyUseMapNotation.mapEntry("version", gav[2]).withMarkers(arg.getMarkers());
                Expression lastArg = (Expression)m2.getArguments().get(m2.getArguments().size() - 1);
                m2 = lastArg instanceof J.Lambda ? m2.withArguments(Arrays.asList(groupEntry, artifactEntry, versionEntry, lastArg)) : m2.withArguments(Arrays.asList(groupEntry, artifactEntry, versionEntry));
                return this.updateTypeForMapArgument(m2);
            }

            private J.MethodInvocation forGString(J.MethodInvocation m2) {
                Expression e2 = (Expression)m2.getArguments().get(0);
                if (!(e2 instanceof G.GString)) {
                    return m2;
                }
                G.GString g2 = (G.GString)e2;
                if (g2.getStrings().size() != 2 || !(g2.getStrings().get(0) instanceof J.Literal) || !(g2.getStrings().get(1) instanceof G.GString.Value)) {
                    return m2;
                }
                J.Literal arg1 = (J.Literal)g2.getStrings().get(0);
                if (arg1.getType() != JavaType.Primitive.String || arg1.getValue() == null) {
                    return m2;
                }
                String[] ga2 = ((String)arg1.getValue()).split(":");
                if (ga2.length != 2) {
                    return m2;
                }
                G.GString.Value arg2 = (G.GString.Value)g2.getStrings().get(1);
                if (!(arg2.getTree() instanceof Expression)) {
                    return m2;
                }
                G.MapEntry groupEntry = DependencyUseMapNotation.mapEntry("group", ga2[0]).withMarkers(e2.getMarkers()).withPrefix(e2.getPrefix());
                G.MapEntry artifactEntry = DependencyUseMapNotation.mapEntry("name", ga2[1]).withMarkers(e2.getMarkers());
                G.MapEntry versionEntry = DependencyUseMapNotation.mapEntry("version", (Expression)arg2.getTree().withPrefix(Space.format((String)" "))).withMarkers(e2.getMarkers());
                Expression lastArg = (Expression)m2.getArguments().get(m2.getArguments().size() - 1);
                m2 = lastArg instanceof J.Lambda ? m2.withArguments(Arrays.asList(groupEntry, artifactEntry, versionEntry, lastArg)) : m2.withArguments(Arrays.asList(groupEntry, artifactEntry, versionEntry));
                return this.updateTypeForMapArgument(m2);
            }

            private J.MethodInvocation updateTypeForMapArgument(J.MethodInvocation m2) {
                JavaType.Method mtype = m2.getMethodType();
                if (mtype == null) {
                    return m2;
                }
                mtype = mtype.withParameterTypes(Collections.singletonList(JavaType.ShallowClass.build((String)"java.util.Map")));
                return m2.withMethodType(mtype);
            }
        };
    }

    private static G.MapEntry mapEntry(String key, String value) {
        return DependencyUseMapNotation.mapEntry(key, (Expression)new J.Literal(Tree.randomId(), Space.build((String)" ", Collections.emptyList()), Markers.EMPTY, (Object)value, "'" + value + "'", null, JavaType.Primitive.String));
    }

    private static G.MapEntry mapEntry(String key, Expression e2) {
        return new G.MapEntry(Tree.randomId(), Space.format((String)" "), Markers.EMPTY, JRightPadded.build((Object)new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, key, null, null)), e2, null);
    }
}

