/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.nio.file.Paths;
import java.util.function.Consumer;
import org.intellij.lang.annotations.Language;
import org.openrewrite.Parser;
import org.openrewrite.gradle.GradleParser;
import org.openrewrite.groovy.GroovyParser;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.test.SourceSpec;
import org.openrewrite.test.SourceSpecs;

public class Assertions {
    private static final Parser.Builder gradleParser = GradleParser.builder().setGroovyParser(GroovyParser.builder().logCompilationWarningsAndErrors(true));

    private Assertions() {
    }

    public static SourceSpecs buildGradle(@Nullable @Language(value="groovy") String before) {
        return Assertions.buildGradle(before, (SourceSpec<G.CompilationUnit> s2) -> {});
    }

    public static SourceSpecs buildGradle(@Nullable @Language(value="groovy") String before, Consumer<SourceSpec<G.CompilationUnit>> spec) {
        SourceSpec gradle = new SourceSpec(G.CompilationUnit.class, "gradle", gradleParser, before, null);
        gradle.path(Paths.get("build.gradle", new String[0]));
        spec.accept((SourceSpec<G.CompilationUnit>)gradle);
        return gradle;
    }

    public static SourceSpecs buildGradle(@Nullable @Language(value="groovy") String before, @Nullable @Language(value="groovy") String after) {
        return Assertions.buildGradle(before, after, s2 -> {});
    }

    public static SourceSpecs buildGradle(@Nullable @Language(value="groovy") String before, @Nullable @Language(value="groovy") String after, Consumer<SourceSpec<G.CompilationUnit>> spec) {
        SourceSpec gradle = new SourceSpec(G.CompilationUnit.class, "gradle", gradleParser, before, s2 -> after);
        gradle.path("build.gradle");
        spec.accept((SourceSpec<G.CompilationUnit>)gradle);
        return gradle;
    }

    public static SourceSpecs settingsGradle(@Nullable @Language(value="groovy") String before) {
        return Assertions.settingsGradle(before, (SourceSpec<G.CompilationUnit> s2) -> {});
    }

    public static SourceSpecs settingsGradle(@Nullable @Language(value="groovy") String before, Consumer<SourceSpec<G.CompilationUnit>> spec) {
        SourceSpec gradle = new SourceSpec(G.CompilationUnit.class, "gradle", gradleParser, before, null);
        gradle.path(Paths.get("settings.gradle", new String[0]));
        spec.accept((SourceSpec<G.CompilationUnit>)gradle);
        return gradle;
    }

    public static SourceSpecs settingsGradle(@Nullable @Language(value="groovy") String before, @Nullable @Language(value="groovy") String after) {
        return Assertions.settingsGradle(before, after, s2 -> {});
    }

    public static SourceSpecs settingsGradle(@Nullable @Language(value="groovy") String before, @Nullable @Language(value="groovy") String after, Consumer<SourceSpec<G.CompilationUnit>> spec) {
        SourceSpec gradle = new SourceSpec(G.CompilationUnit.class, "gradle", gradleParser, before, s2 -> after);
        gradle.path("settings.gradle");
        spec.accept((SourceSpec<G.CompilationUnit>)gradle);
        return gradle;
    }
}

