/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.type;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.gradle.model.internal.type.TypeWrapper;
import org.gradle.model.internal.type.WildcardWrapper;

class TypeVariableTypeWrapper
implements WildcardWrapper {
    private final String name;
    private final TypeWrapper[] bounds;
    private final int hashCode;

    public TypeVariableTypeWrapper(String name, TypeWrapper[] bounds, int hashCode) {
        this.name = name;
        this.bounds = bounds;
        this.hashCode = hashCode;
    }

    @Override
    public Class<?> getRawClass() {
        if (this.bounds.length > 0) {
            return this.bounds[0].getRawClass();
        }
        return Object.class;
    }

    @Override
    public boolean isAssignableFrom(TypeWrapper wrapper) {
        return false;
    }

    @Override
    public void collectClasses(ImmutableList.Builder<Class<?>> builder) {
        for (TypeWrapper bound : this.bounds) {
            bound.collectClasses(builder);
        }
    }

    @Override
    public String getRepresentation(boolean full) {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public TypeWrapper getUpperBound() {
        return this.bounds[0];
    }

    @Override
    @Nullable
    public TypeWrapper getLowerBound() {
        return null;
    }

    public boolean equals(Object o2) {
        if (!(o2 instanceof TypeVariableTypeWrapper)) {
            return false;
        }
        TypeVariableTypeWrapper var2 = (TypeVariableTypeWrapper)o2;
        return Objects.equal((Object)this.getName(), (Object)var2.getName()) && Arrays.equals(this.bounds, var2.bounds);
    }

    public int hashCode() {
        return this.hashCode;
    }
}

