/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.typeconversion;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.internal.exceptions.DiagnosticsVisitor;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.util.GUtil;

public class FlatteningNotationParser<N, T>
implements NotationParser<N, Set<T>> {
    private final NotationParser<N, T> delegate;

    public FlatteningNotationParser(NotationParser<N, T> delegate) {
        assert (delegate != null) : "delegate cannot be null";
        this.delegate = delegate;
    }

    @Override
    public void describe(DiagnosticsVisitor visitor) {
        this.delegate.describe(visitor);
        visitor.candidate("Collections or arrays of any other supported format. Nested collections/arrays will be flattened.");
    }

    @Override
    public Set<T> parseNotation(N notation) {
        Collection notations = GUtil.collectionize(notation);
        if (notations.isEmpty()) {
            return Collections.emptySet();
        }
        if (notations.size() == 1) {
            return Collections.singleton(this.delegate.parseNotation(notations.iterator().next()));
        }
        LinkedHashSet<T> out = new LinkedHashSet<T>();
        for (Object n2 : notations) {
            out.add(this.delegate.parseNotation(n2));
        }
        return out;
    }
}

