/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.remote.internal.inet;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.channels.SocketChannel;
import java.util.List;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.remote.Address;
import org.gradle.internal.remote.internal.ConnectCompletion;
import org.gradle.internal.remote.internal.ConnectException;
import org.gradle.internal.remote.internal.OutgoingConnector;
import org.gradle.internal.remote.internal.inet.InetEndpoint;
import org.gradle.internal.remote.internal.inet.SocketConnectCompletion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpOutgoingConnector
implements OutgoingConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(TcpOutgoingConnector.class);
    private static final int CONNECT_TIMEOUT = 10000;

    @Override
    public ConnectCompletion connect(Address destinationAddress) throws ConnectException {
        if (!(destinationAddress instanceof InetEndpoint)) {
            throw new IllegalArgumentException(String.format("Cannot create a connection to address of unknown type: %s.", destinationAddress));
        }
        InetEndpoint address = (InetEndpoint)destinationAddress;
        LOGGER.debug("Attempting to connect to {}.", (Object)address);
        List<InetAddress> candidateAddresses = address.getCandidates();
        try {
            IOException lastFailure = null;
            for (InetAddress candidate : candidateAddresses) {
                SocketChannel socketChannel;
                LOGGER.debug("Trying to connect to address {}.", (Object)candidate);
                try {
                    socketChannel = this.tryConnect(address, candidate);
                }
                catch (SocketException e2) {
                    LOGGER.debug("Cannot connect to address {}, skipping.", (Object)candidate);
                    lastFailure = e2;
                    continue;
                }
                catch (SocketTimeoutException e3) {
                    LOGGER.debug("Timeout connecting to address {}, skipping.", (Object)candidate);
                    lastFailure = e3;
                    continue;
                }
                LOGGER.debug("Connected to address {}.", (Object)socketChannel.socket().getRemoteSocketAddress());
                return new SocketConnectCompletion(socketChannel);
            }
            throw new ConnectException(String.format("Could not connect to server %s. Tried addresses: %s.", destinationAddress, candidateAddresses), lastFailure);
        }
        catch (ConnectException e4) {
            throw e4;
        }
        catch (Exception e5) {
            throw new RuntimeException(String.format("Could not connect to server %s. Tried addresses: %s.", destinationAddress, candidateAddresses), e5);
        }
    }

    private SocketChannel tryConnect(InetEndpoint address, InetAddress candidate) throws IOException {
        SocketChannel socketChannel = SocketChannel.open();
        try {
            socketChannel.socket().connect(new InetSocketAddress(candidate, address.getPort()), 10000);
            if (!this.detectSelfConnect(socketChannel)) {
                return socketChannel;
            }
            socketChannel.close();
        }
        catch (IOException e2) {
            socketChannel.close();
            throw e2;
        }
        catch (Throwable e3) {
            socketChannel.close();
            throw UncheckedException.throwAsUncheckedException(e3);
        }
        throw new java.net.ConnectException(String.format("Socket connected to itself on %s port %s.", candidate, address.getPort()));
    }

    boolean detectSelfConnect(SocketChannel socketChannel) {
        SocketAddress remoteAddress;
        Socket socket = socketChannel.socket();
        SocketAddress localAddress = socket.getLocalSocketAddress();
        if (localAddress.equals(remoteAddress = socket.getRemoteSocketAddress())) {
            LOGGER.debug("Detected that socket was bound to {} while connecting to {}. This looks like the socket connected to itself.", (Object)localAddress, (Object)remoteAddress);
            return true;
        }
        return false;
    }
}

