/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.operations;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationListener;
import org.gradle.internal.operations.BuildOperationListenerManager;
import org.gradle.internal.operations.OperationFinishEvent;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.operations.OperationProgressEvent;
import org.gradle.internal.operations.OperationStartEvent;

public class DefaultBuildOperationListenerManager
implements BuildOperationListenerManager {
    private List<ProgressShieldingBuildOperationListener> listeners = Collections.emptyList();
    private final Lock listenersLock = new ReentrantLock();
    private final BuildOperationListener broadcaster = new BuildOperationListener(){

        @Override
        public void started(BuildOperationDescriptor buildOperation, OperationStartEvent startEvent) {
            List listeners = DefaultBuildOperationListenerManager.this.listeners;
            for (int i2 = 0; i2 < listeners.size(); ++i2) {
                ((BuildOperationListener)listeners.get(i2)).started(buildOperation, startEvent);
            }
        }

        @Override
        public void progress(OperationIdentifier operationIdentifier, OperationProgressEvent progressEvent) {
            List listeners = DefaultBuildOperationListenerManager.this.listeners;
            for (int i2 = 0; i2 < listeners.size(); ++i2) {
                ((BuildOperationListener)listeners.get(i2)).progress(operationIdentifier, progressEvent);
            }
        }

        @Override
        public void finished(BuildOperationDescriptor buildOperation, OperationFinishEvent finishEvent) {
            List listeners = DefaultBuildOperationListenerManager.this.listeners;
            for (int i2 = listeners.size() - 1; i2 >= 0; --i2) {
                ((BuildOperationListener)listeners.get(i2)).finished(buildOperation, finishEvent);
            }
        }
    };

    @Override
    public void addListener(BuildOperationListener listener) {
        this.listenersLock.lock();
        try {
            ArrayList<ProgressShieldingBuildOperationListener> listeners = new ArrayList<ProgressShieldingBuildOperationListener>(this.listeners);
            listeners.add(new ProgressShieldingBuildOperationListener(listener));
            this.listeners = listeners;
        }
        finally {
            this.listenersLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(BuildOperationListener listener) {
        this.listenersLock.lock();
        try {
            ArrayList<ProgressShieldingBuildOperationListener> listeners = new ArrayList<ProgressShieldingBuildOperationListener>(this.listeners);
            ListIterator listIterator = listeners.listIterator();
            while (listIterator.hasNext()) {
                if (!((ProgressShieldingBuildOperationListener)listIterator.next()).delegate.equals(listener)) continue;
                listIterator.remove();
            }
            this.listeners = listeners;
        }
        finally {
            this.listenersLock.unlock();
        }
    }

    @Override
    public BuildOperationListener getBroadcaster() {
        return this.broadcaster;
    }

    private static class ProgressShieldingBuildOperationListener
    implements BuildOperationListener {
        private final Set<OperationIdentifier> active = Sets.newConcurrentHashSet();
        private final BuildOperationListener delegate;

        private ProgressShieldingBuildOperationListener(BuildOperationListener delegate) {
            this.delegate = delegate;
        }

        @Override
        public void started(BuildOperationDescriptor buildOperation, OperationStartEvent startEvent) {
            this.active.add(buildOperation.getId());
            this.delegate.started(buildOperation, startEvent);
        }

        @Override
        public void progress(OperationIdentifier operationIdentifier, OperationProgressEvent progressEvent) {
            if (this.active.contains(operationIdentifier)) {
                this.delegate.progress(operationIdentifier, progressEvent);
            }
        }

        @Override
        public void finished(BuildOperationDescriptor buildOperation, OperationFinishEvent finishEvent) {
            this.active.remove(buildOperation.getId());
            this.delegate.finished(buildOperation, finishEvent);
        }
    }
}

