/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.nativeintegration.filesystem.services;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.gradle.internal.nativeintegration.filesystem.FileModeAccessor;
import org.gradle.internal.nativeintegration.filesystem.FileModeMutator;
import org.gradle.internal.nativeintegration.filesystem.services.EmptyChmod;
import org.gradle.internal.nativeintegration.filesystem.services.FallbackStat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnsupportedFilePermissions
implements FileModeAccessor,
FileModeMutator {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnsupportedFilePermissions.class);
    private final AtomicBoolean warned = new AtomicBoolean();
    private final FallbackStat stat = new FallbackStat();
    private final EmptyChmod chmod = new EmptyChmod();

    @Override
    public int getUnixMode(File f2) throws IOException {
        this.maybeWarn();
        return this.stat.getUnixMode(f2);
    }

    @Override
    public void chmod(File file, int mode) throws Exception {
        this.maybeWarn();
        this.chmod.chmod(file, mode);
    }

    private void maybeWarn() {
        if (this.warned.compareAndSet(false, true)) {
            LOGGER.warn("Support for reading or changing file permissions is only available on this platform using Java 7 or later.");
        }
    }
}

