/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.text;

import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.logging.StandardOutputListener;

public class StreamBackedStandardOutputListener
implements StandardOutputListener {
    private final Appendable appendable;
    private final Flushable flushable;

    public StreamBackedStandardOutputListener(Appendable appendable) {
        this.appendable = appendable;
        this.flushable = appendable instanceof Flushable ? (Flushable)((Object)appendable) : new Flushable(){

            @Override
            public void flush() throws IOException {
            }
        };
    }

    public StreamBackedStandardOutputListener(OutputStream outputStream) {
        this(new OutputStreamWriter(outputStream));
    }

    @Override
    public void onOutput(CharSequence output) {
        try {
            this.appendable.append(output);
            this.flushable.flush();
        }
        catch (IOException e2) {
            throw new UncheckedIOException(e2);
        }
    }
}

