/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.io;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Locale;
import org.gradle.internal.io.LineBufferingOutputStream;
import org.gradle.internal.io.NullOutputStream;
import org.gradle.internal.io.TextStream;

public class LinePerThreadBufferingOutputStream
extends PrintStream {
    private final TextStream handler;
    private final ThreadLocal<PrintStream> stream = new ThreadLocal();

    public LinePerThreadBufferingOutputStream(TextStream handler) {
        super(NullOutputStream.INSTANCE, true);
        this.handler = handler;
    }

    private PrintStream getStream() {
        PrintStream printStream = this.stream.get();
        if (printStream == null) {
            printStream = new PrintStream(new LineBufferingOutputStream(this.handler));
            this.stream.set(printStream);
        }
        return printStream;
    }

    private PrintStream maybeGetStream() {
        return this.stream.get();
    }

    @Override
    public PrintStream append(CharSequence csq) {
        this.getStream().append(csq);
        return this;
    }

    @Override
    public PrintStream append(char c2) {
        this.getStream().append(c2);
        return this;
    }

    @Override
    public PrintStream append(CharSequence csq, int start, int end) {
        this.getStream().append(csq, start, end);
        return this;
    }

    @Override
    public boolean checkError() {
        return this.getStream().checkError();
    }

    @Override
    public void close() {
        PrintStream currentStream = this.maybeGetStream();
        if (currentStream != null) {
            this.stream.set(null);
            currentStream.close();
        } else {
            this.handler.endOfStream(null);
        }
    }

    @Override
    public void flush() {
        PrintStream stream = this.maybeGetStream();
        if (stream != null) {
            stream.flush();
        }
    }

    @Override
    public PrintStream format(String format, Object ... args) {
        this.getStream().format(format, args);
        return this;
    }

    @Override
    public PrintStream format(Locale l2, String format, Object ... args) {
        this.getStream().format(l2, format, args);
        return this;
    }

    @Override
    public void print(boolean b2) {
        this.getStream().print(b2);
    }

    @Override
    public void print(char c2) {
        this.getStream().print(c2);
    }

    @Override
    public void print(double d2) {
        this.getStream().print(d2);
    }

    @Override
    public void print(float f2) {
        this.getStream().print(f2);
    }

    @Override
    public void print(int i2) {
        this.getStream().print(i2);
    }

    @Override
    public void print(long l2) {
        this.getStream().print(l2);
    }

    @Override
    public void print(Object obj) {
        this.getStream().print(obj);
    }

    @Override
    public void print(char[] s2) {
        this.getStream().print(s2);
    }

    @Override
    public void print(String s2) {
        this.getStream().print(s2);
    }

    @Override
    public PrintStream printf(String format, Object ... args) {
        this.getStream().printf(format, args);
        return this;
    }

    @Override
    public PrintStream printf(Locale l2, String format, Object ... args) {
        this.getStream().printf(l2, format, args);
        return this;
    }

    @Override
    public void println() {
        this.getStream().println();
    }

    @Override
    public void println(boolean x2) {
        this.getStream().println(x2);
    }

    @Override
    public void println(char x2) {
        this.getStream().println(x2);
    }

    @Override
    public void println(char[] x2) {
        this.getStream().println(x2);
    }

    @Override
    public void println(double x2) {
        this.getStream().println(x2);
    }

    @Override
    public void println(float x2) {
        this.getStream().println(x2);
    }

    @Override
    public void println(int x2) {
        this.getStream().println(x2);
    }

    @Override
    public void println(long x2) {
        this.getStream().println(x2);
    }

    @Override
    public void println(Object x2) {
        this.getStream().println(x2);
    }

    @Override
    public void println(String x2) {
        this.getStream().println(x2);
    }

    @Override
    public void write(int b2) {
        this.getStream().write(b2);
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        this.getStream().write(buf, off, len);
    }

    @Override
    public void write(byte[] b2) throws IOException {
        this.getStream().write(b2);
    }
}

