/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.Callable;
import org.gradle.api.UncheckedIOException;

public final class UncheckedException
extends RuntimeException {
    private UncheckedException(Throwable cause) {
        super(cause);
    }

    private UncheckedException(String message, Throwable cause) {
        super(message, cause);
    }

    public static RuntimeException throwAsUncheckedException(Throwable t2) {
        return UncheckedException.throwAsUncheckedException(t2, false);
    }

    public static RuntimeException throwAsUncheckedException(Throwable t2, boolean preserveMessage) {
        if (t2 instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
        if (t2 instanceof RuntimeException) {
            throw (RuntimeException)t2;
        }
        if (t2 instanceof Error) {
            throw (Error)t2;
        }
        if (t2 instanceof IOException) {
            if (preserveMessage) {
                throw new UncheckedIOException(t2.getMessage(), t2);
            }
            throw new UncheckedIOException(t2);
        }
        if (preserveMessage) {
            throw new UncheckedException(t2.getMessage(), t2);
        }
        throw new UncheckedException(t2);
    }

    public static <T> T callUnchecked(Callable<T> callable) {
        try {
            return callable.call();
        }
        catch (Exception e2) {
            throw UncheckedException.throwAsUncheckedException(e2);
        }
    }

    public static RuntimeException unwrapAndRethrow(InvocationTargetException e2) {
        return UncheckedException.throwAsUncheckedException(e2.getTargetException());
    }
}

