/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.concurrent.ConcurrentMap;
import org.gradle.caching.BuildCacheEntryReader;
import org.gradle.caching.BuildCacheEntryWriter;
import org.gradle.caching.BuildCacheException;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.BuildCacheService;
import org.gradle.internal.io.StreamByteBuffer;

public class MapBasedBuildCacheService
implements BuildCacheService {
    private final ConcurrentMap<String, byte[]> delegate;

    public MapBasedBuildCacheService(ConcurrentMap<String, byte[]> delegate) {
        this.delegate = delegate;
    }

    @Override
    public boolean load(BuildCacheKey key, BuildCacheEntryReader reader) throws BuildCacheException {
        byte[] bytes = (byte[])this.delegate.get(key.getHashCode());
        if (bytes == null) {
            return false;
        }
        try {
            reader.readFrom(new ByteArrayInputStream(bytes));
        }
        catch (IOException e2) {
            throw new BuildCacheException("loading " + key, e2);
        }
        return true;
    }

    @Override
    public void store(BuildCacheKey key, BuildCacheEntryWriter output) throws BuildCacheException {
        StreamByteBuffer buffer = new StreamByteBuffer();
        try {
            output.writeTo(buffer.getOutputStream());
        }
        catch (IOException e2) {
            throw new BuildCacheException("storing " + key, e2);
        }
        this.delegate.put(key.getHashCode(), buffer.readAsByteArray());
    }

    @Override
    public void close() throws IOException {
    }
}

