/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junit.result;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import org.gradle.api.Action;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.tasks.testing.junit.result.TestClassResult;
import org.gradle.api.internal.tasks.testing.junit.result.TestFailure;
import org.gradle.api.internal.tasks.testing.junit.result.TestMethodResult;
import org.gradle.api.tasks.testing.TestResult;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.kryo.KryoBackedDecoder;
import org.gradle.internal.serialize.kryo.KryoBackedEncoder;

public class TestResultSerializer {
    private static final int RESULT_VERSION = 3;
    private final File resultsFile;

    public TestResultSerializer(File resultsDir) {
        this.resultsFile = new File(resultsDir, "results.bin");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Collection<TestClassResult> results) {
        try {
            FileOutputStream outputStream = new FileOutputStream(this.resultsFile);
            try {
                if (!results.isEmpty()) {
                    KryoBackedEncoder encoder = new KryoBackedEncoder(outputStream);
                    encoder.writeSmallInt(3);
                    this.write(results, (Encoder)encoder);
                    encoder.flush();
                }
            }
            finally {
                ((OutputStream)outputStream).close();
            }
        }
        catch (IOException e2) {
            throw new UncheckedIOException(e2);
        }
    }

    private void write(Collection<TestClassResult> results, Encoder encoder) throws IOException {
        encoder.writeSmallInt(results.size());
        for (TestClassResult result : results) {
            this.write(result, encoder);
        }
    }

    private void write(TestClassResult classResult, Encoder encoder) throws IOException {
        encoder.writeSmallLong(classResult.getId());
        encoder.writeString(classResult.getClassName());
        encoder.writeString(classResult.getClassDisplayName());
        encoder.writeLong(classResult.getStartTime());
        encoder.writeSmallInt(classResult.getResults().size());
        for (TestMethodResult methodResult : classResult.getResults()) {
            this.write(methodResult, encoder);
        }
    }

    private void write(TestMethodResult methodResult, Encoder encoder) throws IOException {
        encoder.writeSmallLong(methodResult.getId());
        encoder.writeString(methodResult.getName());
        encoder.writeString(methodResult.getDisplayName());
        encoder.writeSmallInt(methodResult.getResultType().ordinal());
        encoder.writeSmallLong(methodResult.getDuration());
        encoder.writeLong(methodResult.getEndTime());
        encoder.writeSmallInt(methodResult.getFailures().size());
        for (TestFailure testFailure : methodResult.getFailures()) {
            encoder.writeString(testFailure.getExceptionType());
            encoder.writeString(testFailure.getMessage());
            encoder.writeString(testFailure.getStackTrace());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(Action<? super TestClassResult> visitor) {
        if (!this.isHasResults()) {
            return;
        }
        try {
            FileInputStream inputStream = new FileInputStream(this.resultsFile);
            try {
                KryoBackedDecoder decoder = new KryoBackedDecoder(inputStream);
                int version = decoder.readSmallInt();
                if (version != 3) {
                    throw new IllegalArgumentException(String.format("Unexpected result file version %d found in %s.", version, this.resultsFile));
                }
                this.readResults(decoder, visitor);
            }
            finally {
                ((InputStream)inputStream).close();
            }
        }
        catch (Exception e2) {
            throw UncheckedException.throwAsUncheckedException(e2);
        }
    }

    public boolean isHasResults() {
        return this.resultsFile.exists() && this.resultsFile.length() > 0L;
    }

    private void readResults(Decoder decoder, Action<? super TestClassResult> visitor) throws ClassNotFoundException, IOException {
        int classCount = decoder.readSmallInt();
        for (int i2 = 0; i2 < classCount; ++i2) {
            TestClassResult classResult = this.readClassResult(decoder);
            visitor.execute(classResult);
        }
    }

    private TestClassResult readClassResult(Decoder decoder) throws IOException, ClassNotFoundException {
        long id = decoder.readSmallLong();
        String className = decoder.readString();
        String classDisplayName = decoder.readString();
        long startTime = decoder.readLong();
        TestClassResult result = new TestClassResult(id, className, classDisplayName, startTime);
        int testMethodCount = decoder.readSmallInt();
        for (int i2 = 0; i2 < testMethodCount; ++i2) {
            TestMethodResult methodResult = this.readMethodResult(decoder);
            result.add(methodResult);
        }
        return result;
    }

    private TestMethodResult readMethodResult(Decoder decoder) throws ClassNotFoundException, IOException {
        long id = decoder.readSmallLong();
        String name = decoder.readString();
        String displayName = decoder.readString();
        TestResult.ResultType resultType = TestResult.ResultType.values()[decoder.readSmallInt()];
        long duration = decoder.readSmallLong();
        long endTime = decoder.readLong();
        TestMethodResult methodResult = new TestMethodResult(id, name, displayName, resultType, duration, endTime);
        int failures = decoder.readSmallInt();
        for (int i2 = 0; i2 < failures; ++i2) {
            String exceptionType = decoder.readString();
            String message = decoder.readString();
            String stackTrace = decoder.readString();
            methodResult.addFailure(message, stackTrace, exceptionType);
        }
        return methodResult;
    }
}

