/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import java.io.File;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.annotation.processing.Processor;
import javax.tools.JavaCompiler;
import org.gradle.api.internal.tasks.compile.filter.AnnotationProcessorFilter;
import org.gradle.api.internal.tasks.compile.incremental.processing.AnnotationProcessingResult;
import org.gradle.api.internal.tasks.compile.incremental.processing.AnnotationProcessorResult;
import org.gradle.api.internal.tasks.compile.incremental.processing.IncrementalAnnotationProcessorType;
import org.gradle.api.internal.tasks.compile.processing.AggregatingProcessor;
import org.gradle.api.internal.tasks.compile.processing.AnnotationProcessorDeclaration;
import org.gradle.api.internal.tasks.compile.processing.DynamicProcessor;
import org.gradle.api.internal.tasks.compile.processing.IsolatingProcessor;
import org.gradle.api.internal.tasks.compile.processing.NonIncrementalProcessor;
import org.gradle.api.internal.tasks.compile.processing.SupportedOptionsCollectingProcessor;
import org.gradle.api.internal.tasks.compile.processing.TimeTrackingProcessor;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.concurrent.CompositeStoppable;

class AnnotationProcessingCompileTask
implements JavaCompiler.CompilationTask {
    private final JavaCompiler.CompilationTask delegate;
    private final Set<AnnotationProcessorDeclaration> processorDeclarations;
    private final List<File> annotationProcessorPath;
    private final AnnotationProcessingResult result;
    private URLClassLoader processorClassloader;
    private boolean called;

    AnnotationProcessingCompileTask(JavaCompiler.CompilationTask delegate, Set<AnnotationProcessorDeclaration> processorDeclarations, List<File> annotationProcessorPath, AnnotationProcessingResult result) {
        this.delegate = delegate;
        this.processorDeclarations = processorDeclarations;
        this.annotationProcessorPath = annotationProcessorPath;
        this.result = result;
    }

    @Override
    public void addModules(Iterable<String> moduleNames) {
    }

    @Override
    public void setProcessors(Iterable<? extends Processor> processors) {
        throw new UnsupportedOperationException("This decorator already handles annotation processing");
    }

    @Override
    public void setLocale(Locale locale) {
        this.delegate.setLocale(locale);
    }

    @Override
    public Boolean call() {
        if (this.called) {
            throw new IllegalStateException("Cannot reuse a compilation task");
        }
        this.called = true;
        try {
            this.setupProcessors();
            Boolean bl2 = this.delegate.call();
            return bl2;
        }
        finally {
            this.cleanupProcessors();
        }
    }

    private void setupProcessors() {
        this.processorClassloader = this.createProcessorClassLoader();
        ArrayList<Processor> processors = new ArrayList<Processor>(this.processorDeclarations.size());
        if (!this.processorDeclarations.isEmpty()) {
            SupportedOptionsCollectingProcessor supportedOptionsCollectingProcessor = new SupportedOptionsCollectingProcessor();
            for (AnnotationProcessorDeclaration declaredProcessor : this.processorDeclarations) {
                AnnotationProcessorResult processorResult = new AnnotationProcessorResult(this.result, declaredProcessor.getClassName());
                this.result.getAnnotationProcessorResults().add(processorResult);
                Class<?> processorClass = this.loadProcessor(declaredProcessor);
                Processor processor = this.instantiateProcessor(processorClass);
                supportedOptionsCollectingProcessor.addProcessor(processor);
                processor = this.decorateForIncrementalProcessing(processor, declaredProcessor.getType(), processorResult);
                processor = this.decorateForTimeTracking(processor, processorResult);
                processors.add(processor);
            }
            processors.add(supportedOptionsCollectingProcessor);
        }
        this.delegate.setProcessors(processors);
    }

    private URLClassLoader createProcessorClassLoader() {
        return new URLClassLoader(DefaultClassPath.of(this.annotationProcessorPath).getAsURLArray(), (ClassLoader)AnnotationProcessorFilter.getFilteredClassLoader(this.delegate.getClass().getClassLoader()));
    }

    private Class<?> loadProcessor(AnnotationProcessorDeclaration declaredProcessor) {
        try {
            return this.processorClassloader.loadClass(declaredProcessor.getClassName());
        }
        catch (ClassNotFoundException e2) {
            throw new IllegalArgumentException("Annotation processor '" + declaredProcessor.getClassName() + "' not found");
        }
    }

    private Processor instantiateProcessor(Class<?> processorClass) {
        try {
            return (Processor)processorClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e2) {
            throw new IllegalArgumentException("Could not instantiate annotation processor '" + processorClass.getName() + "'");
        }
    }

    private Processor decorateForIncrementalProcessing(Processor processor, IncrementalAnnotationProcessorType type, AnnotationProcessorResult processorResult) {
        switch (type) {
            case ISOLATING: {
                return new IsolatingProcessor(processor, processorResult);
            }
            case AGGREGATING: {
                return new AggregatingProcessor(processor, processorResult);
            }
            case DYNAMIC: {
                return new DynamicProcessor(processor, processorResult);
            }
        }
        return new NonIncrementalProcessor(processor, processorResult);
    }

    private Processor decorateForTimeTracking(Processor processor, AnnotationProcessorResult processorResult) {
        return new TimeTrackingProcessor(processor, processorResult);
    }

    private void cleanupProcessors() {
        CompositeStoppable.stoppable(this.processorClassloader).stop();
    }
}

