/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.executer.framework;

import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.executer.TestFilterBuilder;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.executer.TestFrameworkTemplate;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.executer.TestNames;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.executer.framework.TestFrameworkProvider;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.executer.framework.TestFrameworkStrategy;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.executer.framework.TestNgClassVisitor;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.testsreader.TestsReader;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.initialization.loadercache.ClassLoaderCache;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.testing.TestFramework;
import org.gradle.api.internal.tasks.testing.filter.DefaultTestFilter;
import org.gradle.api.internal.tasks.testing.testng.TestNGTestFramework;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.testing.Test;
import org.gradle.api.tasks.testing.testng.TestNGOptions;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.ServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TestNgTestFrameworkStrategy
implements TestFrameworkStrategy {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestNgTestFrameworkStrategy.class);
    private final Map<String, Optional<TestNgClassVisitor.ClassInfo>> classInfoCache = new HashMap<String, Optional<TestNgClassVisitor.ClassInfo>>();

    TestNgTestFrameworkStrategy() {
    }

    @Override
    public boolean isLifecycleFailureTest(TestsReader testsReader, String string, String string2) {
        return this.getClassInfo(testsReader, string).map(classInfo -> this.isLifecycleMethod(testsReader, string2, (TestNgClassVisitor.ClassInfo)classInfo)).orElse(false);
    }

    private boolean isLifecycleMethod(TestsReader testsReader, String string, TestNgClassVisitor.ClassInfo classInfo) {
        if (classInfo.getLifecycleMethods().contains(string)) {
            return true;
        }
        String string2 = classInfo.getSuperClass();
        if (string2 == null || string2.equals("java.lang.Object")) {
            return false;
        }
        return this.isLifecycleFailureTest(testsReader, string2, string);
    }

    @Override
    public TestFramework createRetrying(TestFrameworkTemplate testFrameworkTemplate, TestFramework testFramework, TestNames testNames) {
        DefaultTestFilter defaultTestFilter = this.testFilterFor(testNames, testFrameworkTemplate);
        return TestNGTestFrameworkProvider.testFrameworkProvider(testFrameworkTemplate, testFramework).testFrameworkFor(defaultTestFilter);
    }

    private DefaultTestFilter testFilterFor(TestNames testNames, TestFrameworkTemplate testFrameworkTemplate) {
        TestFilterBuilder testFilterBuilder = testFrameworkTemplate.filterBuilder();
        this.addFilters(testFrameworkTemplate.testsReader, testNames, testFilterBuilder);
        return testFilterBuilder.build();
    }

    private void addFilters(TestsReader testsReader, TestNames testNames, TestFilterBuilder testFilterBuilder) {
        testNames.stream().forEach(entry -> {
            String string = (String)entry.getKey();
            Set set = (Set)entry.getValue();
            if (set.isEmpty()) {
                testFilterBuilder.clazz(string);
                return;
            }
            Optional<TestNgClassVisitor.ClassInfo> optional = this.getClassInfo(testsReader, string);
            set.forEach(string3 -> {
                if (optional.isPresent()) {
                    TestNgClassVisitor.ClassInfo classInfo = (TestNgClassVisitor.ClassInfo)optional.get();
                    if (this.isLifecycleMethod(testsReader, (String)string3, classInfo)) {
                        testFilterBuilder.clazz(string);
                    } else {
                        String string4 = TestNgTestFrameworkStrategy.stripParameters(string3);
                        testFilterBuilder.test(string, string4);
                        classInfo.dependsOn(string4).forEach(string2 -> testFilterBuilder.test(string, (String)string2));
                    }
                } else {
                    testFilterBuilder.clazz(string);
                }
            });
        });
    }

    private Optional<TestNgClassVisitor.ClassInfo> getClassInfo(TestsReader testsReader, String string) {
        return this.classInfoCache.computeIfAbsent(string, string2 -> {
            Optional<Object> optional;
            try {
                optional = testsReader.readTestClassDirClass(string, TestNgClassVisitor::new);
            }
            catch (Throwable throwable) {
                LOGGER.warn("Unable to determine if class " + string + " has TestNG dependent tests", throwable);
                optional = Optional.empty();
            }
            return optional;
        });
    }

    private static String stripParameters(String string) {
        return string.replaceAll("\\[[^)]+](\\([^)]*\\))+$", "");
    }

    static class TestNGTestFrameworkProvider {
        static void copyOptions(TestNGOptions testNGOptions, TestNGOptions testNGOptions2) {
            testNGOptions2.setOutputDirectory(testNGOptions.getOutputDirectory());
            testNGOptions2.setIncludeGroups(testNGOptions.getIncludeGroups());
            testNGOptions2.setExcludeGroups(testNGOptions.getExcludeGroups());
            testNGOptions2.setConfigFailurePolicy(testNGOptions.getConfigFailurePolicy());
            testNGOptions2.setListeners(testNGOptions.getListeners());
            testNGOptions2.setParallel(testNGOptions.getParallel());
            testNGOptions2.setThreadCount(testNGOptions.getThreadCount());
            testNGOptions2.setUseDefaultListeners(testNGOptions.getUseDefaultListeners());
            testNGOptions2.setSuiteName(testNGOptions.getSuiteName());
            testNGOptions2.setTestName(testNGOptions.getTestName());
            testNGOptions2.setSuiteXmlFiles(testNGOptions.getSuiteXmlFiles());
            testNGOptions2.setPreserveOrder(testNGOptions.getPreserveOrder());
            testNGOptions2.setGroupByInstances(testNGOptions.getGroupByInstances());
            testNGOptions2.setSuiteXmlWriter(testNGOptions.getSuiteXmlWriter());
            testNGOptions2.setSuiteXmlBuilder(testNGOptions.getSuiteXmlBuilder());
        }

        static TestFrameworkProvider testFrameworkProvider(TestFrameworkTemplate testFrameworkTemplate, TestFramework testFramework) {
            if (TestFrameworkStrategy.gradleVersionIsAtLeast("8.0")) {
                return new TestFrameworkProvider.ProviderForCurrentGradleVersion(testFramework);
            }
            if (TestFrameworkStrategy.gradleVersionIsAtLeast("6.6")) {
                return new ProviderForGradleOlderThanV8(testFrameworkTemplate);
            }
            return new ProviderForGradleOlderThanV66(testFrameworkTemplate);
        }

        static class ProviderForGradleOlderThanV66
        implements TestFrameworkProvider {
            private final TestFrameworkTemplate template;

            public ProviderForGradleOlderThanV66(TestFrameworkTemplate testFrameworkTemplate) {
                this.template = testFrameworkTemplate;
            }

            @Override
            public TestFramework testFrameworkFor(DefaultTestFilter defaultTestFilter) {
                TestNGTestFramework testNGTestFramework = this.newInstance(this.template, defaultTestFilter);
                TestNGTestFrameworkProvider.copyOptions((TestNGOptions)this.template.task.getTestFramework().getOptions(), testNGTestFramework.getOptions());
                return testNGTestFramework;
            }

            private TestNGTestFramework newInstance(TestFrameworkTemplate testFrameworkTemplate, DefaultTestFilter defaultTestFilter) {
                try {
                    ServiceRegistry serviceRegistry = ((ProjectInternal)testFrameworkTemplate.task.getProject()).getServices();
                    ClassLoaderCache classLoaderCache = serviceRegistry.get(ClassLoaderCache.class);
                    Class<TestNGTestFramework> clazz = TestNGTestFramework.class;
                    Constructor constructor = clazz.getConstructor(Test.class, DefaultTestFilter.class, Instantiator.class, ClassLoaderCache.class);
                    return (TestNGTestFramework)constructor.newInstance(testFrameworkTemplate.task, defaultTestFilter, testFrameworkTemplate.instantiator, classLoaderCache);
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    throw new RuntimeException(reflectiveOperationException);
                }
            }
        }

        static class ProviderForGradleOlderThanV8
        implements TestFrameworkProvider {
            private final TestFrameworkTemplate template;

            public ProviderForGradleOlderThanV8(TestFrameworkTemplate testFrameworkTemplate) {
                this.template = testFrameworkTemplate;
            }

            @Override
            public TestFramework testFrameworkFor(DefaultTestFilter defaultTestFilter) {
                TestNGTestFramework testNGTestFramework = ProviderForGradleOlderThanV8.newInstance(this.template, defaultTestFilter);
                TestNGTestFrameworkProvider.copyOptions((TestNGOptions)this.template.task.getTestFramework().getOptions(), testNGTestFramework.getOptions());
                return testNGTestFramework;
            }

            private static TestNGTestFramework newInstance(TestFrameworkTemplate testFrameworkTemplate, DefaultTestFilter defaultTestFilter) {
                try {
                    Class<TestNGTestFramework> clazz = TestNGTestFramework.class;
                    Constructor constructor = clazz.getConstructor(Test.class, FileCollection.class, DefaultTestFilter.class, ObjectFactory.class);
                    return (TestNGTestFramework)constructor.newInstance(testFrameworkTemplate.task, testFrameworkTemplate.task.getClasspath(), defaultTestFilter, testFrameworkTemplate.objectFactory);
                }
                catch (ReflectiveOperationException reflectiveOperationException) {
                    throw new RuntimeException(reflectiveOperationException);
                }
            }
        }
    }
}

