/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.executer;

import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.executer.RoundResult;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.executer.TestDescriptorImpl;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.executer.TestNames;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.executer.framework.TestFrameworkStrategy;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.filter.ClassRetryMatcher;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.filter.RetryFilter;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.testsreader.TestsReader;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.internal.tasks.testing.TestCompleteEvent;
import org.gradle.api.internal.tasks.testing.TestDescriptorInternal;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.api.internal.tasks.testing.TestStartEvent;
import org.gradle.api.tasks.testing.TestFailure;
import org.gradle.api.tasks.testing.TestOutputEvent;
import org.gradle.api.tasks.testing.TestResult;

final class RetryTestResultProcessor
implements TestResultProcessor {
    private final TestFrameworkStrategy testFrameworkStrategy;
    private final RetryFilter filter;
    private final ClassRetryMatcher classRetryMatcher;
    private final TestsReader testsReader;
    private final TestResultProcessor delegate;
    private final int maxFailures;
    private boolean lastRetry;
    private boolean hasRetryFilteredFailures;
    private Method failureMethod;
    private final Map<Object, TestDescriptorInternal> activeDescriptorsById = new HashMap<Object, TestDescriptorInternal>();
    private TestNames currentRoundFailedTests = new TestNames();
    private TestNames previousRoundFailedTests = new TestNames();
    private Object rootTestDescriptorId;

    RetryTestResultProcessor(TestFrameworkStrategy testFrameworkStrategy, RetryFilter retryFilter, ClassRetryMatcher classRetryMatcher, TestsReader testsReader, TestResultProcessor testResultProcessor, int n2) {
        this.testFrameworkStrategy = testFrameworkStrategy;
        this.filter = retryFilter;
        this.classRetryMatcher = classRetryMatcher;
        this.testsReader = testsReader;
        this.delegate = testResultProcessor;
        this.maxFailures = n2;
    }

    @Override
    public void started(TestDescriptorInternal testDescriptorInternal, TestStartEvent testStartEvent) {
        if (this.rootTestDescriptorId == null) {
            this.rootTestDescriptorId = testDescriptorInternal.getId();
            this.activeDescriptorsById.put(testDescriptorInternal.getId(), testDescriptorInternal);
            this.delegate.started(testDescriptorInternal, testStartEvent);
        } else if (!testDescriptorInternal.getId().equals(this.rootTestDescriptorId)) {
            this.activeDescriptorsById.put(testDescriptorInternal.getId(), testDescriptorInternal);
            this.delegate.started(testDescriptorInternal, testStartEvent);
        }
    }

    @Override
    public void completed(Object object, TestCompleteEvent testCompleteEvent) {
        if (object.equals(this.rootTestDescriptorId)) {
            if (!this.lastRun()) {
                return;
            }
        } else {
            TestDescriptorInternal testDescriptorInternal = this.activeDescriptorsById.remove(object);
            if (testDescriptorInternal != null && testDescriptorInternal.getClassName() != null) {
                String string;
                String string3 = testDescriptorInternal.getClassName();
                boolean bl2 = this.previousRoundFailedTests.remove(string3, string = testDescriptorInternal.getName());
                if (bl2 && testCompleteEvent.getResultType() == TestResult.ResultType.SKIPPED) {
                    this.addRetry(string3, string);
                }
                if (this.isClassDescriptor(testDescriptorInternal)) {
                    this.previousRoundFailedTests.remove(string3, string2 -> {
                        if (this.testFrameworkStrategy.isLifecycleFailureTest(this.testsReader, string3, (String)string2)) {
                            this.emitFakePassedEvent(testDescriptorInternal, testCompleteEvent, (String)string2);
                            return true;
                        }
                        return false;
                    });
                }
            }
        }
        this.delegate.completed(object, testCompleteEvent);
    }

    private void addRetry(String string, String string2) {
        if (this.classRetryMatcher.retryWholeClass(string)) {
            this.currentRoundFailedTests.addClass(string);
        } else {
            this.currentRoundFailedTests.add(string, string2);
        }
    }

    private void emitFakePassedEvent(TestDescriptorInternal testDescriptorInternal, TestCompleteEvent testCompleteEvent, String string) {
        Object object = new Object();
        TestDescriptorImpl testDescriptorImpl = new TestDescriptorImpl(object, testDescriptorInternal, string);
        long l2 = testCompleteEvent.getEndTime();
        this.delegate.started(testDescriptorImpl, new TestStartEvent(l2, testDescriptorInternal.getId()));
        this.delegate.completed(object, new TestCompleteEvent(l2));
    }

    private boolean isClassDescriptor(TestDescriptorInternal testDescriptorInternal) {
        return testDescriptorInternal.getClassName() != null && testDescriptorInternal.getClassName().equals(testDescriptorInternal.getName());
    }

    @Override
    public void output(Object object, TestOutputEvent testOutputEvent) {
        this.delegate.output(object, testOutputEvent);
    }

    @Override
    public void failure(Object object, Throwable throwable) {
        this.failure(object);
        try {
            Method method = this.lookupFailureMethod();
            method.invoke((Object)this.delegate, object, throwable);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }

    private Method lookupFailureMethod() throws ReflectiveOperationException {
        if (this.failureMethod == null) {
            this.failureMethod = this.delegate.getClass().getMethod("failure", Object.class, Throwable.class);
        }
        return this.failureMethod;
    }

    public void failure(Object object, TestFailure testFailure) {
        this.failure(object);
        this.delegate.failure(object, testFailure);
    }

    private void failure(Object object) {
        String string;
        TestDescriptorInternal testDescriptorInternal = this.activeDescriptorsById.get(object);
        if (testDescriptorInternal != null && (string = testDescriptorInternal.getClassName()) != null) {
            if (this.filter.canRetry(string)) {
                this.addRetry(string, testDescriptorInternal.getName());
            } else {
                this.hasRetryFilteredFailures = true;
            }
        }
    }

    private boolean lastRun() {
        return this.currentRoundFailedTests.isEmpty() || this.lastRetry || this.currentRoundFailedTestsExceedsMaxFailures();
    }

    private boolean currentRoundFailedTestsExceedsMaxFailures() {
        return this.maxFailures > 0 && this.currentRoundFailedTests.size() >= this.maxFailures;
    }

    public RoundResult getResult() {
        return new RoundResult(this.currentRoundFailedTests, this.previousRoundFailedTests, this.lastRun(), this.hasRetryFilteredFailures);
    }

    public void reset(boolean bl2) {
        if (this.lastRun()) {
            throw new IllegalStateException("processor has completed");
        }
        this.lastRetry = bl2;
        this.previousRoundFailedTests = this.currentRoundFailedTests;
        this.currentRoundFailedTests = new TestNames();
        this.activeDescriptorsById.clear();
    }
}

