/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.gradle.testretry.internal.executer;

import java.lang.reflect.Constructor;
import java.util.Set;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.tasks.testing.JvmTestExecutionSpec;
import org.gradle.api.internal.tasks.testing.TestFramework;
import org.gradle.process.JavaForkOptions;
import org.gradle.util.GradleVersion;
import org.gradle.util.Path;

enum JvmTestExecutionSpecFactory {
    FACTORY_FOR_CURRENT_GRADLE_VERSION{

        @Override
        JvmTestExecutionSpec createExecutionSpec(TestFramework testFramework, JvmTestExecutionSpec jvmTestExecutionSpec) {
            return jvmTestExecutionSpec.copyWithTestFramework(testFramework);
        }
    }
    ,
    FACTORY_FOR_GRADLE_OLDER_THAN_V8{

        @Override
        JvmTestExecutionSpec createExecutionSpec(TestFramework testFramework, JvmTestExecutionSpec jvmTestExecutionSpec) {
            try {
                Class<JvmTestExecutionSpec> clazz = JvmTestExecutionSpec.class;
                Constructor constructor = clazz.getConstructor(TestFramework.class, Iterable.class, Iterable.class, FileTree.class, Boolean.TYPE, FileCollection.class, String.class, Path.class, Long.TYPE, JavaForkOptions.class, Integer.TYPE, Set.class);
                return (JvmTestExecutionSpec)constructor.newInstance(testFramework, jvmTestExecutionSpec.getClasspath(), jvmTestExecutionSpec.getModulePath(), jvmTestExecutionSpec.getCandidateClassFiles(), jvmTestExecutionSpec.isScanForTestClasses(), jvmTestExecutionSpec.getTestClassesDirs(), jvmTestExecutionSpec.getPath(), jvmTestExecutionSpec.getIdentityPath(), jvmTestExecutionSpec.getForkEvery(), jvmTestExecutionSpec.getJavaForkOptions(), jvmTestExecutionSpec.getMaxParallelForks(), jvmTestExecutionSpec.getPreviousFailedTestClasses());
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                throw new RuntimeException(reflectiveOperationException);
            }
        }
    }
    ,
    FACTORY_FOR_GRADLE_OLDER_THAN_V6_4{

        @Override
        JvmTestExecutionSpec createExecutionSpec(TestFramework testFramework, JvmTestExecutionSpec jvmTestExecutionSpec) {
            try {
                Class<JvmTestExecutionSpec> clazz = JvmTestExecutionSpec.class;
                Constructor constructor = clazz.getConstructor(TestFramework.class, Iterable.class, FileTree.class, Boolean.TYPE, FileCollection.class, String.class, Path.class, Long.TYPE, JavaForkOptions.class, Integer.TYPE, Set.class);
                return (JvmTestExecutionSpec)constructor.newInstance(testFramework, jvmTestExecutionSpec.getClasspath(), jvmTestExecutionSpec.getCandidateClassFiles(), jvmTestExecutionSpec.isScanForTestClasses(), jvmTestExecutionSpec.getTestClassesDirs(), jvmTestExecutionSpec.getPath(), jvmTestExecutionSpec.getIdentityPath(), jvmTestExecutionSpec.getForkEvery(), jvmTestExecutionSpec.getJavaForkOptions(), jvmTestExecutionSpec.getMaxParallelForks(), jvmTestExecutionSpec.getPreviousFailedTestClasses());
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                throw new RuntimeException(reflectiveOperationException);
            }
        }
    };


    abstract JvmTestExecutionSpec createExecutionSpec(TestFramework var1, JvmTestExecutionSpec var2);

    static JvmTestExecutionSpec testExecutionSpecFor(TestFramework testFramework, JvmTestExecutionSpec jvmTestExecutionSpec) {
        JvmTestExecutionSpecFactory jvmTestExecutionSpecFactory = JvmTestExecutionSpecFactory.getInstance();
        return jvmTestExecutionSpecFactory.createExecutionSpec(testFramework, jvmTestExecutionSpec);
    }

    private static JvmTestExecutionSpecFactory getInstance() {
        if (JvmTestExecutionSpecFactory.gradleVersionIsAtLeast("8.0")) {
            return FACTORY_FOR_CURRENT_GRADLE_VERSION;
        }
        if (JvmTestExecutionSpecFactory.gradleVersionIsAtLeast("6.4")) {
            return FACTORY_FOR_GRADLE_OLDER_THAN_V8;
        }
        return FACTORY_FOR_GRADLE_OLDER_THAN_V6_4;
    }

    private static boolean gradleVersionIsAtLeast(String string) {
        return GradleVersion.current().getBaseVersion().compareTo(GradleVersion.version(string)) >= 0;
    }
}

