/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.common.io.payload;

import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.api.extensions.Frame;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.common.io.payload.PayloadProcessor;
import java.nio.ByteBuffer;

public class DeMaskProcessor
implements PayloadProcessor {
    private byte[] maskBytes;
    private int maskInt;
    private int maskOffset;

    @Override
    public void process(ByteBuffer byteBuffer) {
        int n2;
        if (this.maskBytes == null) {
            return;
        }
        int n3 = this.maskInt;
        int n4 = byteBuffer.position();
        int n5 = byteBuffer.limit();
        int n6 = this.maskOffset;
        while ((n2 = n5 - n4) > 0) {
            if (n2 >= 4 && (n6 & 3) == 0) {
                byteBuffer.putInt(n4, byteBuffer.getInt(n4) ^ n3);
                n4 += 4;
                n6 += 4;
                continue;
            }
            byteBuffer.put(n4, (byte)(byteBuffer.get(n4) ^ this.maskBytes[n6 & 3]));
            ++n4;
            ++n6;
        }
        this.maskOffset = n6;
    }

    public void reset(byte[] byArray) {
        this.maskBytes = byArray;
        int n2 = 0;
        if (byArray != null) {
            for (byte by2 : byArray) {
                n2 = (n2 << 8) + (by2 & 0xFF);
            }
        }
        this.maskInt = n2;
        this.maskOffset = 0;
    }

    @Override
    public void reset(Frame frame) {
        this.reset(frame.getMask());
    }
}

