/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.common.frames;

import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.BufferUtil;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.api.ProtocolException;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.websocket.common.WebSocketFrame;
import java.nio.ByteBuffer;
import java.util.Arrays;

public abstract class ControlFrame
extends WebSocketFrame {
    public ControlFrame(byte by2) {
        super(by2);
    }

    @Override
    public void assertValid() {
        if (this.isControlFrame()) {
            if (this.getPayloadLength() > 125) {
                throw new ProtocolException("Desired payload length [" + this.getPayloadLength() + "] exceeds maximum control payload length [" + 125 + "]");
            }
            if ((this.finRsvOp & 0x80) == 0) {
                throw new ProtocolException("Cannot have FIN==false on Control frames");
            }
            if ((this.finRsvOp & 0x40) != 0) {
                throw new ProtocolException("Cannot have RSV1==true on Control frames");
            }
            if ((this.finRsvOp & 0x20) != 0) {
                throw new ProtocolException("Cannot have RSV2==true on Control frames");
            }
            if ((this.finRsvOp & 0x10) != 0) {
                throw new ProtocolException("Cannot have RSV3==true on Control frames");
            }
        }
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ControlFrame controlFrame = (ControlFrame)object;
        if (this.data == null ? controlFrame.data != null : !this.data.equals(controlFrame.data)) {
            return false;
        }
        if (this.finRsvOp != controlFrame.finRsvOp) {
            return false;
        }
        if (!Arrays.equals(this.mask, controlFrame.mask)) {
            return false;
        }
        return this.masked == controlFrame.masked;
    }

    public boolean isControlFrame() {
        return true;
    }

    @Override
    public boolean isDataFrame() {
        return false;
    }

    @Override
    public WebSocketFrame setPayload(ByteBuffer byteBuffer) {
        if (byteBuffer != null && byteBuffer.remaining() > 125) {
            throw new ProtocolException("Control Payloads can not exceed 125 bytes in length.");
        }
        return super.setPayload(byteBuffer);
    }

    @Override
    public ByteBuffer getPayload() {
        if (super.getPayload() == null) {
            return BufferUtil.EMPTY_BUFFER;
        }
        return super.getPayload();
    }
}

