/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public interface Promise<C> {
    default public void succeeded(C c2) {
    }

    default public void failed(Throwable throwable) {
    }

    public static class Wrapper<W>
    implements Promise<W> {
        private final Promise<W> promise;

        public Wrapper(Promise<W> promise) {
            this.promise = Objects.requireNonNull(promise);
        }

        @Override
        public void succeeded(W w2) {
            this.promise.succeeded(w2);
        }

        @Override
        public void failed(Throwable throwable) {
            this.promise.failed(throwable);
        }

        public Promise<W> unwrap() {
            Promise<W> promise = this.promise;
            while (promise instanceof Wrapper) {
                promise = ((Wrapper)promise).unwrap();
            }
            return promise;
        }
    }

    public static class Completable<S>
    extends CompletableFuture<S>
    implements Promise<S> {
        @Override
        public void succeeded(S s2) {
            this.complete(s2);
        }

        @Override
        public void failed(Throwable throwable) {
            this.completeExceptionally(throwable);
        }
    }
}

