/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.io;

import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.io.AbstractByteBufferPool;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.io.ByteBufferPool;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.BufferUtil;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.component.Dumpable;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.component.DumpableCollection;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.log.Logger;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;

public class MappedByteBufferPool
extends AbstractByteBufferPool
implements Dumpable {
    private static final Logger LOG = Log.getLogger(MappedByteBufferPool.class);
    private final ConcurrentMap<Integer, ByteBufferPool.Bucket> _directBuffers = new ConcurrentHashMap<Integer, ByteBufferPool.Bucket>();
    private final ConcurrentMap<Integer, ByteBufferPool.Bucket> _heapBuffers = new ConcurrentHashMap<Integer, ByteBufferPool.Bucket>();
    private final Function<Integer, ByteBufferPool.Bucket> _newBucket;
    private boolean _detailedDump = false;

    public MappedByteBufferPool() {
        this(-1);
    }

    public MappedByteBufferPool(int n2) {
        this(n2, -1);
    }

    public MappedByteBufferPool(int n2, int n3) {
        this(n2, n3, null);
    }

    public MappedByteBufferPool(int n2, int n3, Function<Integer, ByteBufferPool.Bucket> function) {
        this(n2, n3, function, 0L, 0L);
    }

    public MappedByteBufferPool(int n2, int n3, Function<Integer, ByteBufferPool.Bucket> function, long l2, long l3) {
        super(n2, n3, l2, l3);
        this._newBucket = function;
    }

    private ByteBufferPool.Bucket newBucket(int n2, boolean bl2) {
        return this._newBucket != null ? this._newBucket.apply(n2) : new ByteBufferPool.Bucket(this, this.capacityFor(n2), this.getMaxQueueLength(), this.updateMemory(bl2));
    }

    @Override
    public ByteBuffer acquire(int n2, boolean bl2) {
        int n3 = this.bucketFor(n2);
        int n4 = this.capacityFor(n3);
        ConcurrentMap<Integer, ByteBufferPool.Bucket> concurrentMap = this.bucketsFor(bl2);
        ByteBufferPool.Bucket bucket = (ByteBufferPool.Bucket)concurrentMap.get(n3);
        if (bucket == null) {
            return this.newByteBuffer(n4, bl2);
        }
        ByteBuffer byteBuffer = bucket.acquire();
        if (byteBuffer == null) {
            return this.newByteBuffer(n4, bl2);
        }
        return byteBuffer;
    }

    @Override
    public void release(ByteBuffer byteBuffer) {
        int n3;
        if (byteBuffer == null) {
            return;
        }
        int n4 = byteBuffer.capacity();
        if (n4 != this.capacityFor(n3 = this.bucketFor(n4))) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("ByteBuffer {} does not belong to this pool, discarding it", BufferUtil.toDetailString(byteBuffer));
            }
            return;
        }
        boolean bl2 = byteBuffer.isDirect();
        ConcurrentMap<Integer, ByteBufferPool.Bucket> concurrentMap = this.bucketsFor(bl2);
        ByteBufferPool.Bucket bucket = concurrentMap.computeIfAbsent(n3, n2 -> this.newBucket((int)n2, bl2));
        bucket.release(byteBuffer);
        this.releaseExcessMemory(bl2, this::releaseMemory);
    }

    protected void releaseMemory(boolean bl2) {
        long l2 = Long.MAX_VALUE;
        int n2 = -1;
        ConcurrentMap<Integer, ByteBufferPool.Bucket> concurrentMap = this.bucketsFor(bl2);
        Object object = concurrentMap.entrySet().iterator();
        while (object.hasNext()) {
            long l3;
            Map.Entry entry = object.next();
            ByteBufferPool.Bucket bucket = (ByteBufferPool.Bucket)entry.getValue();
            if (bucket.isEmpty() || (l3 = bucket.getLastUpdate()) >= l2) continue;
            l2 = l3;
            n2 = (Integer)entry.getKey();
        }
        if (n2 >= 0 && (object = (ByteBufferPool.Bucket)concurrentMap.remove(n2)) != null) {
            ((ByteBufferPool.Bucket)object).clear();
        }
    }

    protected int bucketFor(int n2) {
        return (int)Math.ceil((double)n2 / (double)this.getCapacityFactor());
    }

    protected int capacityFor(int n2) {
        return n2 * this.getCapacityFactor();
    }

    ConcurrentMap<Integer, ByteBufferPool.Bucket> bucketsFor(boolean bl2) {
        return bl2 ? this._directBuffers : this._heapBuffers;
    }

    public boolean isDetailedDump() {
        return this._detailedDump;
    }

    @Override
    public void dump(Appendable appendable, String string) throws IOException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(String.format("HeapMemory: %d/%d", this.getHeapMemory(), this.getMaxHeapMemory()));
        arrayList.add(String.format("DirectMemory: %d/%d", this.getDirectMemory(), this.getMaxDirectMemory()));
        if (this.isDetailedDump()) {
            arrayList.add(new DumpableCollection("Indirect Buckets", this._heapBuffers.values()));
            arrayList.add(new DumpableCollection("Direct Buckets", this._directBuffers.values()));
        } else {
            arrayList.add("Indirect Buckets size=" + this._heapBuffers.size());
            arrayList.add("Direct Buckets size=" + this._directBuffers.size());
        }
        Dumpable.dumpObjects(appendable, string, this, arrayList);
    }

    public String toString() {
        return String.format("%s@%x{maxQueueLength=%s, factor=%s}", this.getClass().getSimpleName(), this.hashCode(), this.getMaxQueueLength(), this.getCapacityFactor());
    }
}

