/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.io;

import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.io.Connection;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.io.EndPoint;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.io.SelectorManager;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.IO;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.component.ContainerLifeCycle;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.component.DumpableCollection;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.log.Logger;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.statistic.SampleStatistic;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.thread.ExecutionStrategy;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.thread.Scheduler;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.thread.strategy.EatWhatYouKill;
import java.io.Closeable;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class ManagedSelector
extends ContainerLifeCycle {
    private static final Logger LOG = Log.getLogger(ManagedSelector.class);
    private static final boolean FORCE_SELECT_NOW;
    private final AtomicBoolean _started = new AtomicBoolean(false);
    private boolean _selecting;
    private final SelectorManager _selectorManager;
    private final int _id;
    private final ExecutionStrategy _strategy;
    private Selector _selector;
    private Deque<SelectorUpdate> _updates = new ArrayDeque<SelectorUpdate>();
    private Deque<SelectorUpdate> _updateable = new ArrayDeque<SelectorUpdate>();
    private final SampleStatistic _keyStats = new SampleStatistic();

    public ManagedSelector(SelectorManager selectorManager, int n2) {
        this._selectorManager = selectorManager;
        this._id = n2;
        SelectorProducer selectorProducer = new SelectorProducer();
        Executor executor = selectorManager.getExecutor();
        this._strategy = new EatWhatYouKill(selectorProducer, executor);
        this.addBean(this._strategy, true);
        this.setStopTimeout(5000L);
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this._selector = this._selectorManager.newSelector();
        this._selectorManager.execute(this._strategy::produce);
        Start start = new Start();
        this.submit(start);
        start._started.await();
    }

    @Override
    protected void doStop() throws Exception {
        if (this._started.compareAndSet(true, false) && this._selector != null) {
            CloseConnections closeConnections = new CloseConnections();
            this.submit(closeConnections);
            closeConnections._complete.await();
            StopSelector stopSelector = new StopSelector();
            this.submit(stopSelector);
            stopSelector._stopped.await();
        }
        super.doStop();
    }

    protected int nioSelect(Selector selector, boolean bl2) throws IOException {
        return bl2 ? selector.selectNow() : selector.select();
    }

    protected int select(Selector selector) throws IOException {
        try {
            int n2 = this.nioSelect(selector, false);
            if (n2 == 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Selector {} woken with none selected", selector);
                }
                if (Thread.interrupted() && !this.isRunning()) {
                    throw new ClosedSelectorException();
                }
                if (FORCE_SELECT_NOW) {
                    n2 = this.nioSelect(selector, true);
                }
            }
            return n2;
        }
        catch (ClosedSelectorException closedSelectorException) {
            throw closedSelectorException;
        }
        catch (Throwable throwable) {
            this.handleSelectFailure(selector, throwable);
            return 0;
        }
    }

    protected void handleSelectFailure(Selector selector, Throwable throwable) throws IOException {
        LOG.info("Caught select() failure, trying to recover: {}", throwable.toString());
        if (LOG.isDebugEnabled()) {
            LOG.debug(throwable);
        }
        Selector selector2 = this._selectorManager.newSelector();
        for (SelectionKey selectionKey : selector.keys()) {
            SelectableChannel selectableChannel = selectionKey.channel();
            int n2 = ManagedSelector.safeInterestOps(selectionKey);
            if (n2 >= 0) {
                try {
                    Object object = selectionKey.attachment();
                    SelectionKey selectionKey2 = selectableChannel.register(selector2, n2, object);
                    if (object instanceof Selectable) {
                        ((Selectable)object).replaceKey(selectionKey2);
                    }
                    selectionKey.cancel();
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Transferred {} iOps={} att={}", selectableChannel, n2, object);
                }
                catch (Throwable throwable2) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Could not transfer {}", selectableChannel, throwable2);
                    }
                    IO.close(selectableChannel);
                }
                continue;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Invalid interestOps for {}", selectableChannel);
            }
            IO.close(selectableChannel);
        }
        IO.close(selector);
        this._selector = selector2;
    }

    protected void onSelectFailed(Throwable throwable) {
    }

    public void submit(SelectorUpdate selectorUpdate) {
        this.submit(selectorUpdate, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submit(SelectorUpdate selectorUpdate, boolean bl2) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Queued change lazy={} {} on {}", bl2, selectorUpdate, this);
        }
        Selector selector = null;
        ManagedSelector managedSelector = this;
        synchronized (managedSelector) {
            this._updates.offer(selectorUpdate);
            if (this._selecting && !bl2) {
                selector = this._selector;
                this._selecting = false;
            }
        }
        if (selector != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Wakeup on submit {}", this);
            }
            selector.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wakeup() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Wakeup {}", this);
        }
        Selector selector = null;
        ManagedSelector managedSelector = this;
        synchronized (managedSelector) {
            if (this._selecting) {
                selector = this._selector;
                this._selecting = false;
            }
        }
        if (selector != null) {
            selector.wakeup();
        }
    }

    private void execute(Runnable runnable) {
        block2: {
            try {
                this._selectorManager.execute(runnable);
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                if (!(runnable instanceof Closeable)) break block2;
                IO.close((Closeable)((Object)runnable));
            }
        }
    }

    private void processConnect(SelectionKey selectionKey, Connect connect) {
        SelectableChannel selectableChannel = selectionKey.channel();
        try {
            selectionKey.attach(connect.attachment);
            boolean bl2 = this._selectorManager.doFinishConnect(selectableChannel);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Connected {} {}", bl2, selectableChannel);
            }
            if (bl2) {
                if (!connect.timeout.cancel()) {
                    throw new SocketTimeoutException("Concurrent Connect Timeout");
                }
            } else {
                throw new ConnectException();
            }
            selectionKey.interestOps(0);
            this.execute(new CreateEndPoint(connect, selectionKey));
        }
        catch (Throwable throwable) {
            connect.failed(throwable);
        }
    }

    protected void endPointOpened(EndPoint endPoint) {
        this._selectorManager.endPointOpened(endPoint);
    }

    protected void endPointClosed(EndPoint endPoint) {
        this._selectorManager.endPointClosed(endPoint);
    }

    private void createEndPoint(SelectableChannel selectableChannel, SelectionKey selectionKey) throws IOException {
        EndPoint endPoint = this._selectorManager.newEndPoint(selectableChannel, this, selectionKey);
        Connection connection = this._selectorManager.newConnection(selectableChannel, endPoint, selectionKey.attachment());
        endPoint.setConnection(connection);
        this.submit(selector -> {
            SelectionKey selectionKey2 = selectionKey;
            if (selectionKey2.selector() != selector && (selectionKey2 = selectableChannel.keyFor(selector)) != null && endPoint instanceof Selectable) {
                ((Selectable)((Object)endPoint)).replaceKey(selectionKey2);
            }
            if (selectionKey2 != null) {
                selectionKey2.attach(endPoint);
            }
        }, true);
        endPoint.onOpen();
        this.endPointOpened(endPoint);
        this._selectorManager.connectionOpened(connection);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created {}", endPoint);
        }
    }

    void destroyEndPoint(EndPoint endPoint) {
        this.wakeup();
        this.execute(new DestroyEndPoint(endPoint));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getActionSize() {
        ManagedSelector managedSelector = this;
        synchronized (managedSelector) {
            return this._updates.size();
        }
    }

    static int safeReadyOps(SelectionKey selectionKey) {
        try {
            return selectionKey.readyOps();
        }
        catch (Throwable throwable) {
            LOG.ignore(throwable);
            return -1;
        }
    }

    static int safeInterestOps(SelectionKey selectionKey) {
        try {
            return selectionKey.interestOps();
        }
        catch (Throwable throwable) {
            LOG.ignore(throwable);
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dump(Appendable appendable, String string) throws IOException {
        Selector selector = this._selector;
        if (selector != null && selector.isOpen()) {
            ArrayList<SelectorUpdate> arrayList;
            DumpKeys dumpKeys = new DumpKeys();
            String string2 = DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(ZonedDateTime.now());
            Object object = this;
            synchronized (object) {
                arrayList = new ArrayList<SelectorUpdate>(this._updates);
                this._updates.addFirst(dumpKeys);
                this._selecting = false;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("wakeup on dump {}", this);
            }
            selector.wakeup();
            List<String> list = dumpKeys.get(5L, TimeUnit.SECONDS);
            object = DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(ZonedDateTime.now());
            if (list == null) {
                list = Collections.singletonList("No dump keys retrieved");
            }
            this.dumpObjects(appendable, string, new DumpableCollection("updates @ " + string2, arrayList), new DumpableCollection("keys @ " + (String)object, list));
        } else {
            this.dumpObjects(appendable, string, new Object[0]);
        }
    }

    @Override
    public String toString() {
        Selector selector = this._selector;
        return String.format("%s id=%s keys=%d selected=%d updates=%d", super.toString(), this._id, selector != null && selector.isOpen() ? selector.keys().size() : -1, selector != null && selector.isOpen() ? selector.selectedKeys().size() : -1, this.getActionSize());
    }

    static {
        String string = System.getProperty("com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.io.forceSelectNow");
        FORCE_SELECT_NOW = string != null ? Boolean.parseBoolean(string) : (string = System.getProperty("os.name")) != null && string.toLowerCase(Locale.ENGLISH).contains("windows");
    }

    private class DestroyEndPoint
    implements Closeable,
    Runnable {
        private final EndPoint endPoint;

        public DestroyEndPoint(EndPoint endPoint) {
            this.endPoint = endPoint;
        }

        @Override
        public void run() {
            Connection connection;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Destroyed {}", this.endPoint);
            }
            if ((connection = this.endPoint.getConnection()) != null) {
                ManagedSelector.this._selectorManager.connectionClosed(connection);
            }
            ManagedSelector.this.endPointClosed(this.endPoint);
        }

        @Override
        public void close() {
            this.run();
        }
    }

    private final class CreateEndPoint
    implements Runnable {
        private final Connect _connect;
        private final SelectionKey _key;

        private CreateEndPoint(Connect connect, SelectionKey selectionKey) {
            this._connect = connect;
            this._key = selectionKey;
        }

        @Override
        public void run() {
            try {
                ManagedSelector.this.createEndPoint(this._connect.channel, this._key);
            }
            catch (Throwable throwable) {
                IO.close(this._connect.channel);
                LOG.warn(String.valueOf(throwable), new Object[0]);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(throwable);
                }
                this._connect.failed(throwable);
            }
        }

        public String toString() {
            return String.format("CreateEndPoint@%x{%s}", this.hashCode(), this._connect);
        }
    }

    private class StopSelector
    implements SelectorUpdate {
        private final CountDownLatch _stopped = new CountDownLatch(1);

        private StopSelector() {
        }

        @Override
        public void update(Selector selector) {
            for (SelectionKey selectionKey : selector.keys()) {
                Object object;
                if (selectionKey == null || !((object = selectionKey.attachment()) instanceof Closeable)) continue;
                IO.close((Closeable)object);
            }
            ManagedSelector.this._selector = null;
            IO.close(selector);
            this._stopped.countDown();
        }
    }

    private class CloseConnections
    implements SelectorUpdate {
        private final Set<Closeable> _closed;
        private final CountDownLatch _complete = new CountDownLatch(1);

        private CloseConnections() {
            this((Set<Closeable>)null);
        }

        private CloseConnections(Set<Closeable> set) {
            this._closed = set;
        }

        @Override
        public void update(Selector selector) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Closing {} connections on {}", selector.keys().size(), ManagedSelector.this);
            }
            for (SelectionKey selectionKey : selector.keys()) {
                if (selectionKey == null || !selectionKey.isValid()) continue;
                Closeable closeable = null;
                Object object = selectionKey.attachment();
                if (object instanceof EndPoint) {
                    EndPoint endPoint = (EndPoint)object;
                    Connection connection = endPoint.getConnection();
                    closeable = connection != null ? connection : endPoint;
                }
                if (closeable == null) continue;
                if (this._closed == null) {
                    IO.close(closeable);
                    continue;
                }
                if (this._closed.contains(closeable)) continue;
                this._closed.add(closeable);
                IO.close(closeable);
            }
            this._complete.countDown();
        }
    }

    class Connect
    implements Runnable,
    SelectorUpdate {
        private final AtomicBoolean failed = new AtomicBoolean();
        private final SelectableChannel channel;
        private final Object attachment;
        private final Scheduler.Task timeout;

        Connect(SelectableChannel selectableChannel, Object object) {
            this.channel = selectableChannel;
            this.attachment = object;
            long l2 = ManagedSelector.this._selectorManager.getConnectTimeout();
            this.timeout = l2 > 0L ? ManagedSelector.this._selectorManager.getScheduler().schedule(this, l2, TimeUnit.MILLISECONDS) : null;
        }

        @Override
        public void update(Selector selector) {
            try {
                this.channel.register(selector, 8, this);
            }
            catch (Throwable throwable) {
                this.failed(throwable);
            }
        }

        @Override
        public void run() {
            if (ManagedSelector.this._selectorManager.isConnectionPending(this.channel)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Channel {} timed out while connecting, closing it", this.channel);
                }
                this.failed(new SocketTimeoutException("Connect Timeout"));
            }
        }

        public void failed(Throwable throwable) {
            if (this.failed.compareAndSet(false, true)) {
                if (this.timeout != null) {
                    this.timeout.cancel();
                }
                IO.close(this.channel);
                ManagedSelector.this._selectorManager.connectionFailed(this.channel, throwable, this.attachment);
            }
        }

        public String toString() {
            return String.format("Connect@%x{%s,%s}", this.hashCode(), this.channel, this.attachment);
        }
    }

    class Accept
    implements Closeable,
    Runnable,
    SelectorUpdate {
        private final SelectableChannel channel;
        private final Object attachment;
        private SelectionKey key;

        Accept(SelectableChannel selectableChannel, Object object) {
            this.channel = selectableChannel;
            this.attachment = object;
            ManagedSelector.this._selectorManager.onAccepting(selectableChannel);
        }

        @Override
        public void close() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("closed accept of {}", this.channel);
            }
            IO.close(this.channel);
        }

        @Override
        public void update(Selector selector) {
            block2: {
                try {
                    this.key = this.channel.register(selector, 0, this.attachment);
                    ManagedSelector.this.execute(this);
                }
                catch (Throwable throwable) {
                    IO.close(this.channel);
                    ManagedSelector.this._selectorManager.onAcceptFailed(this.channel, throwable);
                    if (!LOG.isDebugEnabled()) break block2;
                    LOG.debug(throwable);
                }
            }
        }

        @Override
        public void run() {
            try {
                ManagedSelector.this.createEndPoint(this.channel, this.key);
                ManagedSelector.this._selectorManager.onAccepted(this.channel);
            }
            catch (Throwable throwable) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(throwable);
                }
                this.failed(throwable);
            }
        }

        protected void failed(Throwable throwable) {
            IO.close(this.channel);
            LOG.warn(String.valueOf(throwable), new Object[0]);
            if (LOG.isDebugEnabled()) {
                LOG.debug(throwable);
            }
            ManagedSelector.this._selectorManager.onAcceptFailed(this.channel, throwable);
        }

        public String toString() {
            return String.format("%s@%x[%s]", this.getClass().getSimpleName(), this.hashCode(), this.channel);
        }
    }

    private static class DumpKeys
    implements SelectorUpdate {
        private final CountDownLatch latch = new CountDownLatch(1);
        private List<String> keys;

        private DumpKeys() {
        }

        @Override
        public void update(Selector selector) {
            Set<SelectionKey> set = selector.keys();
            ArrayList<String> arrayList = new ArrayList<String>(set.size());
            for (SelectionKey selectionKey : set) {
                if (selectionKey == null) continue;
                arrayList.add(String.format("SelectionKey@%x{i=%d}->%s", selectionKey.hashCode(), ManagedSelector.safeInterestOps(selectionKey), selectionKey.attachment()));
            }
            this.keys = arrayList;
            this.latch.countDown();
        }

        public List<String> get(long l2, TimeUnit timeUnit) {
            try {
                this.latch.await(l2, timeUnit);
            }
            catch (InterruptedException interruptedException) {
                LOG.ignore(interruptedException);
            }
            return this.keys;
        }
    }

    private class Start
    implements SelectorUpdate {
        private final CountDownLatch _started = new CountDownLatch(1);

        private Start() {
        }

        @Override
        public void update(Selector selector) {
            ManagedSelector.this._started.set(true);
            this._started.countDown();
        }
    }

    public static interface SelectorUpdate {
        public void update(Selector var1);
    }

    private class SelectorProducer
    implements ExecutionStrategy.Producer {
        private Set<SelectionKey> _keys = Collections.emptySet();
        private Iterator<SelectionKey> _cursor = Collections.emptyIterator();

        private SelectorProducer() {
        }

        @Override
        public Runnable produce() {
            do {
                Runnable runnable;
                if ((runnable = this.processSelected()) != null) {
                    return runnable;
                }
                this.processUpdates();
                this.updateKeys();
            } while (this.select());
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processUpdates() {
            int n2;
            Object object = ManagedSelector.this;
            synchronized (object) {
                Object object2 = ManagedSelector.this._updates;
                ManagedSelector.this._updates = ManagedSelector.this._updateable;
                ManagedSelector.this._updateable = (Deque)object2;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("updateable {}", ManagedSelector.this._updateable.size());
            }
            for (Object object2 : ManagedSelector.this._updateable) {
                if (ManagedSelector.this._selector == null) break;
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("update {}", object2);
                    }
                    object2.update(ManagedSelector.this._selector);
                }
                catch (Throwable throwable) {
                    LOG.warn(throwable);
                }
            }
            ManagedSelector.this._updateable.clear();
            ManagedSelector managedSelector = ManagedSelector.this;
            synchronized (managedSelector) {
                n2 = ManagedSelector.this._updates.size();
                ManagedSelector.this._selecting = n2 == 0;
                object = ManagedSelector.this._selecting ? null : ManagedSelector.this._selector;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("updates {}", n2);
            }
            if (object != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("wakeup on updates {}", this);
                }
                ((Selector)object).wakeup();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean select() {
            block10: {
                try {
                    int n2;
                    Selector selector = ManagedSelector.this._selector;
                    if (selector == null) break block10;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Selector {} waiting with {} keys", selector, selector.keys().size());
                    }
                    int n3 = ManagedSelector.this.select(selector);
                    selector = ManagedSelector.this._selector;
                    if (selector == null) break block10;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Selector {} woken up from select, {}/{}/{} selected", selector, n3, selector.selectedKeys().size(), selector.keys().size());
                    }
                    ManagedSelector managedSelector = ManagedSelector.this;
                    synchronized (managedSelector) {
                        ManagedSelector.this._selecting = false;
                        n2 = ManagedSelector.this._updates.size();
                    }
                    this._keys = selector.selectedKeys();
                    int n4 = this._keys.size();
                    if (n4 > 0) {
                        ManagedSelector.this._keyStats.record(n4);
                    }
                    Iterator<Object> iterator = this._cursor = n4 > 0 ? this._keys.iterator() : Collections.emptyIterator();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Selector {} processing {} keys, {} updates", selector, n4, n2);
                    }
                    return true;
                }
                catch (Throwable throwable) {
                    IO.close(ManagedSelector.this._selector);
                    ManagedSelector.this._selector = null;
                    if (ManagedSelector.this.isRunning()) {
                        LOG.warn("Fatal select() failure", throwable);
                        ManagedSelector.this.onSelectFailed(throwable);
                    }
                    LOG.warn(throwable.toString(), new Object[0]);
                    if (!LOG.isDebugEnabled()) break block10;
                    LOG.debug(throwable);
                }
            }
            return false;
        }

        private Runnable processSelected() {
            while (this._cursor.hasNext()) {
                SelectionKey selectionKey = this._cursor.next();
                Object object = selectionKey.attachment();
                SelectableChannel selectableChannel = selectionKey.channel();
                if (selectionKey.isValid()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("selected {} {} {} ", ManagedSelector.safeReadyOps(selectionKey), selectionKey, object);
                    }
                    try {
                        if (object instanceof Selectable) {
                            Runnable runnable = ((Selectable)object).onSelected();
                            if (runnable == null) continue;
                            return runnable;
                        }
                        if (selectionKey.isConnectable()) {
                            ManagedSelector.this.processConnect(selectionKey, (Connect)object);
                            continue;
                        }
                        throw new IllegalStateException("key=" + selectionKey + ", att=" + object + ", iOps=" + ManagedSelector.safeInterestOps(selectionKey) + ", rOps=" + ManagedSelector.safeReadyOps(selectionKey));
                    }
                    catch (CancelledKeyException cancelledKeyException) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Ignoring cancelled key for channel {}", selectableChannel);
                        }
                        IO.close(object instanceof EndPoint ? (EndPoint)object : selectableChannel);
                        continue;
                    }
                    catch (Throwable throwable) {
                        LOG.warn("Could not process key for channel {}", selectableChannel, throwable);
                        IO.close(object instanceof EndPoint ? (EndPoint)object : selectableChannel);
                        continue;
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Selector loop ignoring invalid key for channel {}", selectableChannel);
                }
                IO.close(object instanceof EndPoint ? (EndPoint)object : selectableChannel);
            }
            return null;
        }

        private void updateKeys() {
            for (SelectionKey selectionKey : this._keys) {
                Object object = selectionKey.attachment();
                if (!(object instanceof Selectable)) continue;
                ((Selectable)object).updateKey();
            }
            this._keys.clear();
        }

        public String toString() {
            return String.format("%s@%x", this.getClass().getSimpleName(), this.hashCode());
        }
    }

    public static interface Selectable {
        public Runnable onSelected();

        public void updateKey();

        public void replaceKey(SelectionKey var1);
    }
}

