/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.http;

import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.http.Http1FieldPreEncoder;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.http.HttpField;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.http.HttpFieldPreEncoder;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.http.HttpHeader;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.http.HttpVersion;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.log.Logger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ServiceLoader;

public class PreEncodedHttpField
extends HttpField {
    private static final Logger LOG = Log.getLogger(PreEncodedHttpField.class);
    private static final HttpFieldPreEncoder[] __encoders;
    private final byte[][] _encodedField = new byte[__encoders.length][];

    private static int index(HttpVersion httpVersion) {
        switch (httpVersion) {
            case HTTP_1_0: 
            case HTTP_1_1: {
                return 0;
            }
            case HTTP_2: {
                return 1;
            }
        }
        return -1;
    }

    public PreEncodedHttpField(HttpHeader httpHeader, String string, String string2) {
        super(httpHeader, string, string2);
        for (int i2 = 0; i2 < __encoders.length; ++i2) {
            this._encodedField[i2] = __encoders[i2].getEncodedField(httpHeader, string, string2);
        }
    }

    public PreEncodedHttpField(HttpHeader httpHeader, String string) {
        this(httpHeader, httpHeader.asString(), string);
    }

    public void putTo(ByteBuffer byteBuffer, HttpVersion httpVersion) {
        byteBuffer.put(this._encodedField[PreEncodedHttpField.index(httpVersion)]);
    }

    static {
        ArrayList<HttpFieldPreEncoder> arrayList = new ArrayList<HttpFieldPreEncoder>();
        Iterator<HttpFieldPreEncoder> iterator = ServiceLoader.load(HttpFieldPreEncoder.class).iterator();
        while (iterator.hasNext()) {
            try {
                HttpFieldPreEncoder httpFieldPreEncoder = iterator.next();
                if (PreEncodedHttpField.index(httpFieldPreEncoder.getHttpVersion()) < 0) continue;
                arrayList.add(httpFieldPreEncoder);
            }
            catch (Error | RuntimeException throwable) {
                LOG.debug(throwable);
            }
        }
        LOG.debug("HttpField encoders loaded: {}", arrayList);
        int n2 = arrayList.size();
        __encoders = new HttpFieldPreEncoder[n2 == 0 ? 1 : n2];
        for (HttpFieldPreEncoder httpFieldPreEncoder : arrayList) {
            int n3 = PreEncodedHttpField.index(httpFieldPreEncoder.getHttpVersion());
            if (__encoders[n3] == null) {
                PreEncodedHttpField.__encoders[n3] = httpFieldPreEncoder;
                continue;
            }
            LOG.warn("multiple PreEncoders for " + (Object)((Object)httpFieldPreEncoder.getHttpVersion()), new Object[0]);
        }
        if (__encoders[0] == null) {
            PreEncodedHttpField.__encoders[0] = new Http1FieldPreEncoder();
        }
    }
}

