/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.util;

import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.client.util.AbstractTypedContentProvider;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.io.ByteBufferPool;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.log.Log;
import com.gradle.scan.plugin.internal.dep.org.eclipse.jetty.util.log.Logger;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class PathContentProvider
extends AbstractTypedContentProvider {
    private static final Logger LOG = Log.getLogger(PathContentProvider.class);
    private final Path filePath;
    private final long fileSize;
    private final int bufferSize;
    private ByteBufferPool bufferPool;

    public PathContentProvider(Path path) throws IOException {
        this(path, 4096);
    }

    public PathContentProvider(Path path, int n2) throws IOException {
        this("application/octet-stream", path, n2);
    }

    public PathContentProvider(String string, Path path, int n2) throws IOException {
        super(string);
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            throw new NoSuchFileException(path.toString());
        }
        if (!Files.isReadable(path)) {
            throw new AccessDeniedException(path.toString());
        }
        this.filePath = path;
        this.fileSize = Files.size(path);
        this.bufferSize = n2;
    }

    @Override
    public long getLength() {
        return this.fileSize;
    }

    @Override
    public boolean isReproducible() {
        return true;
    }

    public void setByteBufferPool(ByteBufferPool byteBufferPool) {
        this.bufferPool = byteBufferPool;
    }

    @Override
    public Iterator<ByteBuffer> iterator() {
        return new PathIterator();
    }

    private class PathIterator
    implements Closeable,
    Iterator<ByteBuffer> {
        private ByteBuffer buffer;
        private SeekableByteChannel channel;
        private long position;

        private PathIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.position < PathContentProvider.this.getLength();
        }

        @Override
        public ByteBuffer next() {
            try {
                if (this.channel == null) {
                    this.buffer = PathContentProvider.this.bufferPool == null ? ByteBuffer.allocateDirect(PathContentProvider.this.bufferSize) : PathContentProvider.this.bufferPool.acquire(PathContentProvider.this.bufferSize, true);
                    this.channel = Files.newByteChannel(PathContentProvider.this.filePath, StandardOpenOption.READ);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Opened file {}", PathContentProvider.this.filePath);
                    }
                }
                this.buffer.clear();
                int n2 = this.channel.read(this.buffer);
                if (n2 < 0) {
                    throw new NoSuchElementException();
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Read {} bytes from {}", n2, PathContentProvider.this.filePath);
                }
                this.position += (long)n2;
                this.buffer.flip();
                return this.buffer;
            }
            catch (NoSuchElementException noSuchElementException) {
                this.close();
                throw noSuchElementException;
            }
            catch (Throwable throwable) {
                this.close();
                throw (NoSuchElementException)new NoSuchElementException().initCause(throwable);
            }
        }

        @Override
        public void close() {
            try {
                if (PathContentProvider.this.bufferPool != null && this.buffer != null) {
                    PathContentProvider.this.bufferPool.release(this.buffer);
                }
                if (this.channel != null) {
                    this.channel.close();
                }
            }
            catch (Throwable throwable) {
                LOG.ignore(throwable);
            }
        }
    }
}

