/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.apache.http.pool;

import com.gradle.scan.plugin.internal.dep.org.apache.http.concurrent.FutureCallback;
import com.gradle.scan.plugin.internal.dep.org.apache.http.pool.ConnFactory;
import com.gradle.scan.plugin.internal.dep.org.apache.http.pool.PoolEntry;
import com.gradle.scan.plugin.internal.dep.org.apache.http.pool.PoolEntryCallback;
import com.gradle.scan.plugin.internal.dep.org.apache.http.pool.PoolStats;
import com.gradle.scan.plugin.internal.dep.org.apache.http.pool.RouteSpecificPool;
import com.gradle.scan.plugin.internal.dep.org.apache.http.util.Args;
import com.gradle.scan.plugin.internal.dep.org.apache.http.util.Asserts;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class AbstractConnPool<T, C, E extends PoolEntry<T, C>> {
    private final Lock lock;
    private final Condition condition;
    private final ConnFactory<T, C> connFactory;
    private final Map<T, RouteSpecificPool<T, C, E>> routeToPool;
    private final Set<E> leased;
    private final LinkedList<E> available;
    private final LinkedList<Future<E>> pending;
    private final Map<T, Integer> maxPerRoute;
    private volatile boolean isShutDown;
    private volatile int defaultMaxPerRoute;
    private volatile int maxTotal;
    private volatile int validateAfterInactivity;

    public AbstractConnPool(ConnFactory<T, C> connFactory, int n2, int n3) {
        this.connFactory = Args.notNull(connFactory, "Connection factory");
        this.defaultMaxPerRoute = Args.positive(n2, "Max per route value");
        this.maxTotal = Args.positive(n3, "Max total value");
        this.lock = new ReentrantLock();
        this.condition = this.lock.newCondition();
        this.routeToPool = new HashMap<T, RouteSpecificPool<T, C, E>>();
        this.leased = new HashSet();
        this.available = new LinkedList();
        this.pending = new LinkedList();
        this.maxPerRoute = new HashMap<T, Integer>();
    }

    protected abstract E createEntry(T var1, C var2);

    protected void onLease(E e2) {
    }

    protected void onRelease(E e2) {
    }

    protected void onReuse(E e2) {
    }

    protected boolean validate(E e2) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws IOException {
        if (this.isShutDown) {
            return;
        }
        this.isShutDown = true;
        this.lock.lock();
        try {
            for (PoolEntry object : this.available) {
                object.close();
            }
            for (PoolEntry poolEntry : this.leased) {
                poolEntry.close();
            }
            for (RouteSpecificPool routeSpecificPool : this.routeToPool.values()) {
                routeSpecificPool.shutdown();
            }
            this.routeToPool.clear();
            this.leased.clear();
            this.available.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    private RouteSpecificPool<T, C, E> getPool(final T t2) {
        RouteSpecificPool routeSpecificPool = this.routeToPool.get(t2);
        if (routeSpecificPool == null) {
            routeSpecificPool = new RouteSpecificPool<T, C, E>(t2){

                @Override
                protected E createEntry(C c2) {
                    return AbstractConnPool.this.createEntry(t2, c2);
                }
            };
            this.routeToPool.put(t2, routeSpecificPool);
        }
        return routeSpecificPool;
    }

    private static Exception operationAborted() {
        return new CancellationException("Operation aborted");
    }

    public Future<E> lease(final T t2, final Object object, final FutureCallback<E> futureCallback) {
        Args.notNull(t2, "Route");
        Asserts.check(!this.isShutDown, "Connection pool shut down");
        return new Future<E>(){
            private final AtomicBoolean cancelled = new AtomicBoolean(false);
            private final AtomicBoolean done = new AtomicBoolean(false);
            private final AtomicReference<E> entryRef = new AtomicReference<Object>(null);

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean cancel(boolean bl2) {
                if (this.done.compareAndSet(false, true)) {
                    this.cancelled.set(true);
                    AbstractConnPool.this.lock.lock();
                    try {
                        AbstractConnPool.this.condition.signalAll();
                    }
                    finally {
                        AbstractConnPool.this.lock.unlock();
                    }
                    if (futureCallback != null) {
                        futureCallback.cancelled();
                    }
                    return true;
                }
                return false;
            }

            @Override
            public boolean isCancelled() {
                return this.cancelled.get();
            }

            @Override
            public boolean isDone() {
                return this.done.get();
            }

            @Override
            public E get() throws InterruptedException, ExecutionException {
                try {
                    return this.get(0L, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException timeoutException) {
                    throw new ExecutionException(timeoutException);
                }
            }

            /*
             * Exception decompiling
             */
            @Override
            public E get(long var1_1, TimeUnit var3_2) throws InterruptedException, ExecutionException, TimeoutException {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 1[TRYBLOCK]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private E getPoolEntryBlocking(T t2, Object object, long l2, TimeUnit timeUnit, Future<E> future) throws IOException, InterruptedException, ExecutionException, TimeoutException {
        Date date = null;
        if (l2 > 0L) {
            date = new Date(System.currentTimeMillis() + timeUnit.toMillis(l2));
        }
        this.lock.lock();
        try {
            int n2;
            do {
                int n3;
                E e2;
                Asserts.check(!this.isShutDown, "Connection pool shut down");
                if (future.isCancelled()) {
                    throw new ExecutionException(AbstractConnPool.operationAborted());
                }
                RouteSpecificPool<T, C, E> routeSpecificPool = this.getPool(t2);
                while ((e2 = routeSpecificPool.getFree(object)) != null) {
                    if (((PoolEntry)e2).isExpired(System.currentTimeMillis())) {
                        ((PoolEntry)e2).close();
                    }
                    if (!((PoolEntry)e2).isClosed()) break;
                    this.available.remove(e2);
                    routeSpecificPool.free(e2, false);
                }
                if (e2 != null) {
                    this.available.remove(e2);
                    this.leased.add(e2);
                    this.onReuse(e2);
                    E e3 = e2;
                    return e3;
                }
                int n4 = this.getMax(t2);
                int n5 = Math.max(0, routeSpecificPool.getAllocatedCount() + 1 - n4);
                if (n5 > 0) {
                    E e4;
                    for (n2 = 0; n2 < n5 && (e4 = routeSpecificPool.getLastUsed()) != null; ++n2) {
                        ((PoolEntry)e4).close();
                        this.available.remove(e4);
                        routeSpecificPool.remove(e4);
                    }
                }
                if (routeSpecificPool.getAllocatedCount() < n4 && (n3 = Math.max(this.maxTotal - (n2 = this.leased.size()), 0)) > 0) {
                    RouteSpecificPool routeSpecificPool2;
                    Object object2;
                    int n6 = this.available.size();
                    if (n6 > n3 - 1 && !this.available.isEmpty()) {
                        object2 = (PoolEntry)this.available.removeLast();
                        ((PoolEntry)object2).close();
                        routeSpecificPool2 = this.getPool(((PoolEntry)object2).getRoute());
                        routeSpecificPool2.remove(object2);
                    }
                    object2 = this.connFactory.create(t2);
                    e2 = routeSpecificPool.add(object2);
                    this.leased.add(e2);
                    routeSpecificPool2 = e2;
                    return (E)routeSpecificPool2;
                }
                n2 = 0;
                try {
                    routeSpecificPool.queue(future);
                    this.pending.add(future);
                    if (date != null) {
                        n2 = this.condition.awaitUntil(date) ? 1 : 0;
                    } else {
                        this.condition.await();
                        n2 = 1;
                    }
                    if (future.isCancelled()) {
                        throw new ExecutionException(AbstractConnPool.operationAborted());
                    }
                }
                finally {
                    routeSpecificPool.unqueue(future);
                    this.pending.remove(future);
                }
            } while (n2 != 0 || date == null || date.getTime() > System.currentTimeMillis());
            throw new TimeoutException("Timeout waiting for connection");
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(E e2, boolean bl2) {
        this.lock.lock();
        try {
            if (this.leased.remove(e2)) {
                RouteSpecificPool routeSpecificPool = this.getPool(((PoolEntry)e2).getRoute());
                routeSpecificPool.free(e2, bl2);
                if (bl2 && !this.isShutDown) {
                    this.available.addFirst(e2);
                } else {
                    ((PoolEntry)e2).close();
                }
                this.onRelease(e2);
                Future<E> future = routeSpecificPool.nextPending();
                if (future != null) {
                    this.pending.remove(future);
                } else {
                    future = this.pending.poll();
                }
                if (future != null) {
                    this.condition.signalAll();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private int getMax(T t2) {
        Integer n2 = this.maxPerRoute.get(t2);
        return n2 != null ? n2 : this.defaultMaxPerRoute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxTotal(int n2) {
        Args.positive(n2, "Max value");
        this.lock.lock();
        try {
            this.maxTotal = n2;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultMaxPerRoute(int n2) {
        Args.positive(n2, "Max per route value");
        this.lock.lock();
        try {
            this.defaultMaxPerRoute = n2;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PoolStats getTotalStats() {
        this.lock.lock();
        try {
            PoolStats poolStats = new PoolStats(this.leased.size(), this.pending.size(), this.available.size(), this.maxTotal);
            return poolStats;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PoolStats getStats(T t2) {
        Args.notNull(t2, "Route");
        this.lock.lock();
        try {
            RouteSpecificPool<T, C, E> routeSpecificPool = this.getPool(t2);
            PoolStats poolStats = new PoolStats(routeSpecificPool.getLeasedCount(), routeSpecificPool.getPendingCount(), routeSpecificPool.getAvailableCount(), this.getMax(t2));
            return poolStats;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enumAvailable(PoolEntryCallback<T, C> poolEntryCallback) {
        this.lock.lock();
        try {
            Iterator iterator = this.available.iterator();
            while (iterator.hasNext()) {
                PoolEntry poolEntry = (PoolEntry)iterator.next();
                poolEntryCallback.process(poolEntry);
                if (!poolEntry.isClosed()) continue;
                RouteSpecificPool routeSpecificPool = this.getPool(poolEntry.getRoute());
                routeSpecificPool.remove(poolEntry);
                iterator.remove();
            }
            this.purgePoolMap();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enumLeased(PoolEntryCallback<T, C> poolEntryCallback) {
        this.lock.lock();
        try {
            for (PoolEntry poolEntry : this.leased) {
                poolEntryCallback.process(poolEntry);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void purgePoolMap() {
        Iterator<Map.Entry<T, RouteSpecificPool<T, C, E>>> iterator = this.routeToPool.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<T, RouteSpecificPool<T, C, E>> entry = iterator.next();
            RouteSpecificPool<T, C, E> routeSpecificPool = entry.getValue();
            if (routeSpecificPool.getPendingCount() + routeSpecificPool.getAllocatedCount() != 0) continue;
            iterator.remove();
        }
    }

    public void closeIdle(long l2, TimeUnit timeUnit) {
        Args.notNull(timeUnit, "Time unit");
        long l3 = timeUnit.toMillis(l2);
        if (l3 < 0L) {
            l3 = 0L;
        }
        final long l4 = System.currentTimeMillis() - l3;
        this.enumAvailable(new PoolEntryCallback<T, C>(){

            @Override
            public void process(PoolEntry<T, C> poolEntry) {
                if (poolEntry.getUpdated() <= l4) {
                    poolEntry.close();
                }
            }
        });
    }

    public void closeExpired() {
        final long l2 = System.currentTimeMillis();
        this.enumAvailable(new PoolEntryCallback<T, C>(){

            @Override
            public void process(PoolEntry<T, C> poolEntry) {
                if (poolEntry.isExpired(l2)) {
                    poolEntry.close();
                }
            }
        });
    }

    public void setValidateAfterInactivity(int n2) {
        this.validateAfterInactivity = n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        this.lock.lock();
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("[leased: ");
            stringBuilder.append(this.leased);
            stringBuilder.append("][available: ");
            stringBuilder.append(this.available);
            stringBuilder.append("][pending: ");
            stringBuilder.append(this.pending);
            stringBuilder.append("]");
            String string = stringBuilder.toString();
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    static /* synthetic */ Exception access$200() {
        return AbstractConnPool.operationAborted();
    }

    static /* synthetic */ PoolEntry access$300(AbstractConnPool abstractConnPool, Object object, Object object2, long l2, TimeUnit timeUnit, Future future) throws IOException, InterruptedException, ExecutionException, TimeoutException {
        return abstractConnPool.getPoolEntryBlocking(object, object2, l2, timeUnit, future);
    }

    static /* synthetic */ int access$400(AbstractConnPool abstractConnPool) {
        return abstractConnPool.validateAfterInactivity;
    }
}

