/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.apache.commons.compress.utils;

import java.io.DataInput;
import java.io.IOException;

public final class ByteUtils {
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    public static long fromLittleEndian(DataInput dataInput, int n2) throws IOException {
        ByteUtils.checkReadLength(n2);
        long l2 = 0L;
        for (int i2 = 0; i2 < n2; ++i2) {
            long l3 = dataInput.readUnsignedByte();
            l2 |= l3 << i2 * 8;
        }
        return l2;
    }

    private static void checkReadLength(int n2) {
        if (n2 > 8) {
            throw new IllegalArgumentException("Can't read more than eight bytes into a long value");
        }
    }
}

