/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.apache.commons.compress.archivers.tar;

import com.gradle.scan.plugin.internal.dep.org.apache.commons.compress.archivers.ArchiveEntry;
import com.gradle.scan.plugin.internal.dep.org.apache.commons.compress.archivers.ArchiveOutputStream;
import com.gradle.scan.plugin.internal.dep.org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import com.gradle.scan.plugin.internal.dep.org.apache.commons.compress.archivers.zip.ZipEncoding;
import com.gradle.scan.plugin.internal.dep.org.apache.commons.compress.archivers.zip.ZipEncodingHelper;
import com.gradle.scan.plugin.internal.dep.org.apache.commons.compress.utils.CountingOutputStream;
import com.gradle.scan.plugin.internal.dep.org.apache.commons.compress.utils.FixedLengthBlockOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class TarArchiveOutputStream
extends ArchiveOutputStream {
    private long currSize;
    private String currName;
    private long currBytes;
    private final byte[] recordBuf;
    private int longFileMode = 0;
    private int bigNumberMode = 0;
    private int recordsWritten;
    private final int recordsPerBlock;
    private boolean closed;
    private boolean haveUnclosedEntry;
    private boolean finished;
    private final FixedLengthBlockOutputStream out;
    private final CountingOutputStream countingOut;
    private final ZipEncoding zipEncoding;
    final String encoding;
    private boolean addPaxHeadersForNonAsciiNames;
    private static final ZipEncoding ASCII = ZipEncodingHelper.getZipEncoding("ASCII");

    public TarArchiveOutputStream(OutputStream outputStream) {
        this(outputStream, -511);
    }

    public TarArchiveOutputStream(OutputStream outputStream, int n2) {
        this(outputStream, n2, null);
    }

    public TarArchiveOutputStream(OutputStream outputStream, int n2, String string) {
        int n3 = -511 == n2 ? 512 : n2;
        if (n3 <= 0 || n3 % 512 != 0) {
            throw new IllegalArgumentException("Block size must be a multiple of 512 bytes. Attempt to use set size of " + n2);
        }
        this.countingOut = new CountingOutputStream(outputStream);
        this.out = new FixedLengthBlockOutputStream(this.countingOut, 512);
        this.encoding = string;
        this.zipEncoding = ZipEncodingHelper.getZipEncoding(string);
        this.recordBuf = new byte[512];
        this.recordsPerBlock = n3 / 512;
    }

    public void setLongFileMode(int n2) {
        this.longFileMode = n2;
    }

    public void setBigNumberMode(int n2) {
        this.bigNumberMode = n2;
    }

    public void finish() throws IOException {
        if (this.finished) {
            throw new IOException("This archive has already been finished");
        }
        if (this.haveUnclosedEntry) {
            throw new IOException("This archive contains unclosed entries.");
        }
        this.writeEOFRecord();
        this.writeEOFRecord();
        this.padAsNeeded();
        this.out.flush();
        this.finished = true;
    }

    @Override
    public void close() throws IOException {
        try {
            if (!this.finished) {
                this.finish();
            }
        }
        finally {
            if (!this.closed) {
                this.out.close();
                this.closed = true;
            }
        }
    }

    public void putArchiveEntry(ArchiveEntry archiveEntry) throws IOException {
        if (this.finished) {
            throw new IOException("Stream has already been finished");
        }
        TarArchiveEntry tarArchiveEntry = (TarArchiveEntry)archiveEntry;
        if (tarArchiveEntry.isGlobalPaxHeader()) {
            byte[] byArray = this.encodeExtendedPaxHeadersContents(tarArchiveEntry.getExtraPaxHeaders());
            tarArchiveEntry.setSize(byArray.length);
            tarArchiveEntry.writeEntryHeader(this.recordBuf, this.zipEncoding, this.bigNumberMode == 1);
            this.writeRecord(this.recordBuf);
            this.currSize = tarArchiveEntry.getSize();
            this.currBytes = 0L;
            this.haveUnclosedEntry = true;
            this.write(byArray);
            this.closeArchiveEntry();
        } else {
            boolean bl2;
            HashMap<String, String> hashMap = new HashMap<String, String>();
            String string = tarArchiveEntry.getName();
            boolean bl3 = this.handleLongName(tarArchiveEntry, string, hashMap, "path", (byte)76, "file name");
            String string2 = tarArchiveEntry.getLinkName();
            boolean bl4 = bl2 = string2 != null && !string2.isEmpty() && this.handleLongName(tarArchiveEntry, string2, hashMap, "linkpath", (byte)75, "link name");
            if (this.bigNumberMode == 2) {
                this.addPaxHeadersForBigNumbers(hashMap, tarArchiveEntry);
            } else if (this.bigNumberMode != 1) {
                this.failForBigNumbers(tarArchiveEntry);
            }
            if (this.addPaxHeadersForNonAsciiNames && !bl3 && !ASCII.canEncode(string)) {
                hashMap.put("path", string);
            }
            if (this.addPaxHeadersForNonAsciiNames && !bl2 && (tarArchiveEntry.isLink() || tarArchiveEntry.isSymbolicLink()) && !ASCII.canEncode(string2)) {
                hashMap.put("linkpath", string2);
            }
            hashMap.putAll(tarArchiveEntry.getExtraPaxHeaders());
            if (!hashMap.isEmpty()) {
                this.writePaxHeaders(tarArchiveEntry, string, hashMap);
            }
            tarArchiveEntry.writeEntryHeader(this.recordBuf, this.zipEncoding, this.bigNumberMode == 1);
            this.writeRecord(this.recordBuf);
            this.currBytes = 0L;
            this.currSize = tarArchiveEntry.isDirectory() ? 0L : tarArchiveEntry.getSize();
            this.currName = string;
            this.haveUnclosedEntry = true;
        }
    }

    public void closeArchiveEntry() throws IOException {
        if (this.finished) {
            throw new IOException("Stream has already been finished");
        }
        if (!this.haveUnclosedEntry) {
            throw new IOException("No current entry to close");
        }
        this.out.flushBlock();
        if (this.currBytes < this.currSize) {
            throw new IOException("Entry '" + this.currName + "' closed at '" + this.currBytes + "' before the '" + this.currSize + "' bytes specified in the header were written");
        }
        this.recordsWritten = (int)((long)this.recordsWritten + this.currSize / 512L);
        if (0L != this.currSize % 512L) {
            ++this.recordsWritten;
        }
        this.haveUnclosedEntry = false;
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        if (!this.haveUnclosedEntry) {
            throw new IllegalStateException("No current tar entry");
        }
        if (this.currBytes + (long)n3 > this.currSize) {
            throw new IOException("Request to write '" + n3 + "' bytes exceeds size in header of '" + this.currSize + "' bytes for entry '" + this.currName + "'");
        }
        this.out.write(byArray, n2, n3);
        this.currBytes += (long)n3;
    }

    void writePaxHeaders(TarArchiveEntry tarArchiveEntry, String string, Map<String, String> map) throws IOException {
        String string2 = "./PaxHeaders.X/" + this.stripTo7Bits(string);
        if (string2.length() >= 100) {
            string2 = string2.substring(0, 99);
        }
        TarArchiveEntry tarArchiveEntry2 = new TarArchiveEntry(string2, 120);
        this.transferModTime(tarArchiveEntry, tarArchiveEntry2);
        byte[] byArray = this.encodeExtendedPaxHeadersContents(map);
        tarArchiveEntry2.setSize(byArray.length);
        this.putArchiveEntry(tarArchiveEntry2);
        this.write(byArray);
        this.closeArchiveEntry();
    }

    private byte[] encodeExtendedPaxHeadersContents(Map<String, String> map) {
        StringWriter stringWriter = new StringWriter();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            int n2 = string.length() + string2.length() + 3 + 2;
            String string3 = n2 + " " + string + "=" + string2 + "\n";
            int n3 = string3.getBytes(StandardCharsets.UTF_8).length;
            while (n2 != n3) {
                n2 = n3;
                string3 = n2 + " " + string + "=" + string2 + "\n";
                n3 = string3.getBytes(StandardCharsets.UTF_8).length;
            }
            stringWriter.write(string3);
        }
        return stringWriter.toString().getBytes(StandardCharsets.UTF_8);
    }

    private String stripTo7Bits(String string) {
        int n2 = string.length();
        StringBuilder stringBuilder = new StringBuilder(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = (char)(string.charAt(i2) & 0x7F);
            if (this.shouldBeReplaced(c2)) {
                stringBuilder.append("_");
                continue;
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    private boolean shouldBeReplaced(char c2) {
        return c2 == '\u0000' || c2 == '/' || c2 == '\\';
    }

    private void writeEOFRecord() throws IOException {
        Arrays.fill(this.recordBuf, (byte)0);
        this.writeRecord(this.recordBuf);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    private void writeRecord(byte[] byArray) throws IOException {
        if (byArray.length != 512) {
            throw new IOException("Record to write has length '" + byArray.length + "' which is not the record size of '" + 512 + "'");
        }
        this.out.write(byArray);
        ++this.recordsWritten;
    }

    private void padAsNeeded() throws IOException {
        int n2 = this.recordsWritten % this.recordsPerBlock;
        if (n2 != 0) {
            for (int i2 = n2; i2 < this.recordsPerBlock; ++i2) {
                this.writeEOFRecord();
            }
        }
    }

    private void addPaxHeadersForBigNumbers(Map<String, String> map, TarArchiveEntry tarArchiveEntry) {
        this.addPaxHeaderForBigNumber(map, "size", tarArchiveEntry.getSize(), 0x1FFFFFFFFL);
        this.addPaxHeaderForBigNumber(map, "gid", tarArchiveEntry.getLongGroupId(), 0x1FFFFFL);
        this.addPaxHeaderForBigNumber(map, "mtime", tarArchiveEntry.getModTime().getTime() / 1000L, 0x1FFFFFFFFL);
        this.addPaxHeaderForBigNumber(map, "uid", tarArchiveEntry.getLongUserId(), 0x1FFFFFL);
        this.addPaxHeaderForBigNumber(map, "SCHILY.devmajor", tarArchiveEntry.getDevMajor(), 0x1FFFFFL);
        this.addPaxHeaderForBigNumber(map, "SCHILY.devminor", tarArchiveEntry.getDevMinor(), 0x1FFFFFL);
        this.failForBigNumber("mode", tarArchiveEntry.getMode(), 0x1FFFFFL);
    }

    private void addPaxHeaderForBigNumber(Map<String, String> map, String string, long l2, long l3) {
        if (l2 < 0L || l2 > l3) {
            map.put(string, String.valueOf(l2));
        }
    }

    private void failForBigNumbers(TarArchiveEntry tarArchiveEntry) {
        this.failForBigNumber("entry size", tarArchiveEntry.getSize(), 0x1FFFFFFFFL);
        this.failForBigNumberWithPosixMessage("group id", tarArchiveEntry.getLongGroupId(), 0x1FFFFFL);
        this.failForBigNumber("last modification time", tarArchiveEntry.getModTime().getTime() / 1000L, 0x1FFFFFFFFL);
        this.failForBigNumber("user id", tarArchiveEntry.getLongUserId(), 0x1FFFFFL);
        this.failForBigNumber("mode", tarArchiveEntry.getMode(), 0x1FFFFFL);
        this.failForBigNumber("major device number", tarArchiveEntry.getDevMajor(), 0x1FFFFFL);
        this.failForBigNumber("minor device number", tarArchiveEntry.getDevMinor(), 0x1FFFFFL);
    }

    private void failForBigNumber(String string, long l2, long l3) {
        this.failForBigNumber(string, l2, l3, "");
    }

    private void failForBigNumberWithPosixMessage(String string, long l2, long l3) {
        this.failForBigNumber(string, l2, l3, " Use STAR or POSIX extensions to overcome this limit");
    }

    private void failForBigNumber(String string, long l2, long l3, String string2) {
        if (l2 < 0L || l2 > l3) {
            throw new IllegalArgumentException(string + " '" + l2 + "' is too big ( > " + l3 + " )." + string2);
        }
    }

    private boolean handleLongName(TarArchiveEntry tarArchiveEntry, String string, Map<String, String> map, String string2, byte by2, String string3) throws IOException {
        ByteBuffer byteBuffer = this.zipEncoding.encode(string);
        int n2 = byteBuffer.limit() - byteBuffer.position();
        if (n2 >= 100) {
            if (this.longFileMode == 3) {
                map.put(string2, string);
                return true;
            }
            if (this.longFileMode == 2) {
                TarArchiveEntry tarArchiveEntry2 = new TarArchiveEntry("././@LongLink", by2);
                tarArchiveEntry2.setSize((long)n2 + 1L);
                this.transferModTime(tarArchiveEntry, tarArchiveEntry2);
                this.putArchiveEntry(tarArchiveEntry2);
                this.write(byteBuffer.array(), byteBuffer.arrayOffset(), n2);
                this.write(0);
                this.closeArchiveEntry();
            } else if (this.longFileMode != 1) {
                throw new IllegalArgumentException(string3 + " '" + string + "' is too long ( > " + 100 + " bytes)");
            }
        }
        return false;
    }

    private void transferModTime(TarArchiveEntry tarArchiveEntry, TarArchiveEntry tarArchiveEntry2) {
        Date date = tarArchiveEntry.getModTime();
        long l2 = date.getTime() / 1000L;
        if (l2 < 0L || l2 > 0x1FFFFFFFFL) {
            date = new Date(0L);
        }
        tarArchiveEntry2.setModTime(date);
    }
}

