/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.datatype.jdk8;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.DeserializationContext;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.cfg.CoercionAction;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.type.LogicalType;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.datatype.jdk8.BaseScalarOptionalDeserializer;
import java.io.IOException;
import java.util.OptionalDouble;

class OptionalDoubleDeserializer
extends BaseScalarOptionalDeserializer<OptionalDouble> {
    static final OptionalDoubleDeserializer INSTANCE = new OptionalDoubleDeserializer();

    public OptionalDoubleDeserializer() {
        super(OptionalDouble.class, OptionalDouble.empty());
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Float;
    }

    @Override
    public OptionalDouble deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if (jsonParser.hasToken(JsonToken.VALUE_NUMBER_FLOAT)) {
            return OptionalDouble.of(jsonParser.getDoubleValue());
        }
        switch (jsonParser.currentTokenId()) {
            case 6: {
                String string = jsonParser.getText();
                Double d2 = this._checkDoubleSpecialValue(string);
                if (d2 != null) {
                    return OptionalDouble.of(d2);
                }
                CoercionAction coercionAction = this._checkFromStringCoercion(deserializationContext, string);
                if (coercionAction == CoercionAction.AsNull || coercionAction == CoercionAction.AsEmpty) {
                    return (OptionalDouble)this._empty;
                }
                string = string.trim();
                return OptionalDouble.of(this._parseDoublePrimitive(deserializationContext, string));
            }
            case 7: {
                return OptionalDouble.of(jsonParser.getDoubleValue());
            }
            case 11: {
                return (OptionalDouble)this.getNullValue(deserializationContext);
            }
            case 3: {
                return (OptionalDouble)this._deserializeFromArray(jsonParser, deserializationContext);
            }
        }
        return (OptionalDouble)deserializationContext.handleUnexpectedToken(this.getValueType(deserializationContext), jsonParser);
    }
}

