/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.cfg;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.DeserializationConfig;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.DeserializationFeature;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.MapperFeature;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.cfg.CoercionAction;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.cfg.CoercionInputShape;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.cfg.MutableCoercionConfig;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.type.LogicalType;
import java.io.Serializable;
import java.util.Map;

public class CoercionConfigs
implements Serializable {
    private static final int TARGET_TYPE_COUNT = LogicalType.values().length;
    protected CoercionAction _defaultAction;
    protected final MutableCoercionConfig _defaultCoercions;
    protected MutableCoercionConfig[] _perTypeCoercions;
    protected Map<Class<?>, MutableCoercionConfig> _perClassCoercions;

    public CoercionConfigs() {
        this(CoercionAction.TryConvert, new MutableCoercionConfig(), null, null);
    }

    protected CoercionConfigs(CoercionAction coercionAction, MutableCoercionConfig mutableCoercionConfig, MutableCoercionConfig[] mutableCoercionConfigArray, Map<Class<?>, MutableCoercionConfig> map) {
        this._defaultCoercions = mutableCoercionConfig;
        this._defaultAction = coercionAction;
        this._perTypeCoercions = mutableCoercionConfigArray;
        this._perClassCoercions = map;
    }

    public CoercionAction findCoercion(DeserializationConfig deserializationConfig, LogicalType logicalType, Class<?> clazz, CoercionInputShape coercionInputShape) {
        CoercionAction coercionAction;
        Object object;
        if (this._perClassCoercions != null && clazz != null && (object = this._perClassCoercions.get(clazz)) != null && (coercionAction = object.findAction(coercionInputShape)) != null) {
            return coercionAction;
        }
        if (this._perTypeCoercions != null && logicalType != null && (object = this._perTypeCoercions[logicalType.ordinal()]) != null && (coercionAction = object.findAction(coercionInputShape)) != null) {
            return coercionAction;
        }
        object = this._defaultCoercions.findAction(coercionInputShape);
        if (object != null) {
            return object;
        }
        switch (coercionInputShape) {
            case EmptyArray: {
                return deserializationConfig.isEnabled(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT) ? CoercionAction.AsNull : CoercionAction.Fail;
            }
            case Float: {
                if (logicalType != LogicalType.Integer) break;
                return deserializationConfig.isEnabled(DeserializationFeature.ACCEPT_FLOAT_AS_INT) ? CoercionAction.TryConvert : CoercionAction.Fail;
            }
            case Integer: {
                if (logicalType != LogicalType.Enum || !deserializationConfig.isEnabled(DeserializationFeature.FAIL_ON_NUMBERS_FOR_ENUMS)) break;
                return CoercionAction.Fail;
            }
        }
        boolean bl2 = this._isScalarType(logicalType);
        if (bl2 && !deserializationConfig.isEnabled(MapperFeature.ALLOW_COERCION_OF_SCALARS)) {
            return CoercionAction.Fail;
        }
        if (coercionInputShape == CoercionInputShape.EmptyString) {
            if (bl2 || deserializationConfig.isEnabled(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT)) {
                return CoercionAction.AsNull;
            }
            if (logicalType == LogicalType.OtherScalar) {
                return CoercionAction.TryConvert;
            }
            return CoercionAction.Fail;
        }
        return this._defaultAction;
    }

    public CoercionAction findCoercionFromBlankString(DeserializationConfig deserializationConfig, LogicalType logicalType, Class<?> clazz, CoercionAction coercionAction) {
        MutableCoercionConfig mutableCoercionConfig;
        Boolean bl2 = null;
        CoercionAction coercionAction2 = null;
        if (this._perClassCoercions != null && clazz != null && (mutableCoercionConfig = this._perClassCoercions.get(clazz)) != null) {
            bl2 = mutableCoercionConfig.getAcceptBlankAsEmpty();
            coercionAction2 = mutableCoercionConfig.findAction(CoercionInputShape.EmptyString);
        }
        if (this._perTypeCoercions != null && logicalType != null && (mutableCoercionConfig = this._perTypeCoercions[logicalType.ordinal()]) != null) {
            if (bl2 == null) {
                bl2 = mutableCoercionConfig.getAcceptBlankAsEmpty();
            }
            if (coercionAction2 == null) {
                coercionAction2 = mutableCoercionConfig.findAction(CoercionInputShape.EmptyString);
            }
        }
        if (bl2 == null) {
            bl2 = this._defaultCoercions.getAcceptBlankAsEmpty();
        }
        if (coercionAction2 == null) {
            coercionAction2 = this._defaultCoercions.findAction(CoercionInputShape.EmptyString);
        }
        if (Boolean.FALSE.equals(bl2)) {
            return coercionAction;
        }
        if (coercionAction2 != null) {
            return coercionAction2;
        }
        if (this._isScalarType(logicalType)) {
            return CoercionAction.AsNull;
        }
        if (deserializationConfig.isEnabled(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT)) {
            return CoercionAction.AsNull;
        }
        return coercionAction;
    }

    protected boolean _isScalarType(LogicalType logicalType) {
        return logicalType == LogicalType.Float || logicalType == LogicalType.Integer || logicalType == LogicalType.Boolean || logicalType == LogicalType.DateTime;
    }
}

