/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.esotericsoftware.kryo.util;

import com.gradle.scan.plugin.internal.dep.com.esotericsoftware.kryo.util.ObjectMap;

public class IntMap<V> {
    public int size;
    int[] keyTable;
    V[] valueTable;
    int capacity;
    int stashSize;
    V zeroValue;
    boolean hasZeroValue;
    private float loadFactor;
    private int hashShift;
    private int mask;
    private int threshold;
    private int stashCapacity;
    private int pushIterations;
    private boolean isBigTable;

    public IntMap() {
        this(32, 0.8f);
    }

    public IntMap(int n2, float f2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("initialCapacity must be >= 0: " + n2);
        }
        if (n2 > 0x40000000) {
            throw new IllegalArgumentException("initialCapacity is too large: " + n2);
        }
        this.capacity = ObjectMap.nextPowerOfTwo(n2);
        if (f2 <= 0.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0: " + f2);
        }
        this.loadFactor = f2;
        this.isBigTable = this.capacity >>> 16 != 0;
        this.threshold = (int)((float)this.capacity * f2);
        this.mask = this.capacity - 1;
        this.hashShift = 31 - Integer.numberOfTrailingZeros(this.capacity);
        this.stashCapacity = Math.max(3, (int)Math.ceil(Math.log(this.capacity)) * 2);
        this.pushIterations = Math.max(Math.min(this.capacity, 8), (int)Math.sqrt(this.capacity) / 8);
        this.keyTable = new int[this.capacity + this.stashCapacity];
        this.valueTable = new Object[this.keyTable.length];
    }

    public V put(int n2, V v2) {
        int n3;
        if (n2 == 0) {
            V v3 = this.zeroValue;
            this.zeroValue = v2;
            if (!this.hasZeroValue) {
                this.hasZeroValue = true;
                ++this.size;
            }
            return v3;
        }
        int[] nArray = this.keyTable;
        int n4 = this.mask;
        boolean bl2 = this.isBigTable;
        int n5 = n2 & n4;
        int n6 = nArray[n5];
        if (n6 == n2) {
            V v4 = this.valueTable[n5];
            this.valueTable[n5] = v2;
            return v4;
        }
        int n7 = this.hash2(n2);
        int n8 = nArray[n7];
        if (n8 == n2) {
            V v5 = this.valueTable[n7];
            this.valueTable[n7] = v2;
            return v5;
        }
        int n9 = this.hash3(n2);
        int n10 = nArray[n9];
        if (n10 == n2) {
            V v6 = this.valueTable[n9];
            this.valueTable[n9] = v2;
            return v6;
        }
        int n11 = -1;
        int n12 = -1;
        if (bl2 && (n12 = nArray[n11 = this.hash4(n2)]) == n2) {
            V v7 = this.valueTable[n11];
            this.valueTable[n11] = v2;
            return v7;
        }
        int n13 = n3 + this.stashSize;
        for (n3 = this.capacity; n3 < n13; ++n3) {
            if (nArray[n3] != n2) continue;
            V v8 = this.valueTable[n3];
            this.valueTable[n3] = v2;
            return v8;
        }
        if (n6 == 0) {
            nArray[n5] = n2;
            this.valueTable[n5] = v2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return null;
        }
        if (n8 == 0) {
            nArray[n7] = n2;
            this.valueTable[n7] = v2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return null;
        }
        if (n10 == 0) {
            nArray[n9] = n2;
            this.valueTable[n9] = v2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return null;
        }
        if (bl2 && n12 == 0) {
            nArray[n11] = n2;
            this.valueTable[n11] = v2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return null;
        }
        this.push(n2, v2, n5, n6, n7, n8, n9, n10, n11, n12);
        return null;
    }

    private void putResize(int n2, V v2) {
        if (n2 == 0) {
            this.zeroValue = v2;
            this.hasZeroValue = true;
            return;
        }
        int n3 = n2 & this.mask;
        int n4 = this.keyTable[n3];
        if (n4 == 0) {
            this.keyTable[n3] = n2;
            this.valueTable[n3] = v2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        int n5 = this.hash2(n2);
        int n6 = this.keyTable[n5];
        if (n6 == 0) {
            this.keyTable[n5] = n2;
            this.valueTable[n5] = v2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        int n7 = this.hash3(n2);
        int n8 = this.keyTable[n7];
        if (n8 == 0) {
            this.keyTable[n7] = n2;
            this.valueTable[n7] = v2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        int n9 = -1;
        int n10 = -1;
        if (this.isBigTable && (n10 = this.keyTable[n9 = this.hash4(n2)]) == 0) {
            this.keyTable[n9] = n2;
            this.valueTable[n9] = v2;
            if (this.size++ >= this.threshold) {
                this.resize(this.capacity << 1);
            }
            return;
        }
        this.push(n2, v2, n3, n4, n5, n6, n7, n8, n9, n10);
    }

    private void push(int n2, V v2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        V v3;
        int n11;
        int[] nArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n12 = this.mask;
        boolean bl2 = this.isBigTable;
        int n13 = 0;
        int n14 = this.pushIterations;
        int n15 = bl2 ? 4 : 3;
        while (true) {
            switch (ObjectMap.random.nextInt(n15)) {
                case 0: {
                    n11 = n4;
                    v3 = VArray[n3];
                    nArray[n3] = n2;
                    VArray[n3] = v2;
                    break;
                }
                case 1: {
                    n11 = n6;
                    v3 = VArray[n5];
                    nArray[n5] = n2;
                    VArray[n5] = v2;
                    break;
                }
                case 2: {
                    n11 = n8;
                    v3 = VArray[n7];
                    nArray[n7] = n2;
                    VArray[n7] = v2;
                    break;
                }
                default: {
                    n11 = n10;
                    v3 = VArray[n9];
                    nArray[n9] = n2;
                    VArray[n9] = v2;
                }
            }
            n3 = n11 & n12;
            n4 = nArray[n3];
            if (n4 == 0) {
                nArray[n3] = n11;
                VArray[n3] = v3;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            n5 = this.hash2(n11);
            n6 = nArray[n5];
            if (n6 == 0) {
                nArray[n5] = n11;
                VArray[n5] = v3;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            n7 = this.hash3(n11);
            n8 = nArray[n7];
            if (n8 == 0) {
                nArray[n7] = n11;
                VArray[n7] = v3;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            if (bl2 && (n10 = nArray[n9 = this.hash4(n11)]) == 0) {
                nArray[n9] = n11;
                VArray[n9] = v3;
                if (this.size++ >= this.threshold) {
                    this.resize(this.capacity << 1);
                }
                return;
            }
            if (++n13 == n14) break;
            n2 = n11;
            v2 = v3;
        }
        this.putStash(n11, v3);
    }

    private void putStash(int n2, V v2) {
        if (this.stashSize == this.stashCapacity) {
            this.resize(this.capacity << 1);
            this.put(n2, v2);
            return;
        }
        int n3 = this.capacity + this.stashSize;
        this.keyTable[n3] = n2;
        this.valueTable[n3] = v2;
        ++this.stashSize;
        ++this.size;
    }

    public V get(int n2) {
        if (n2 == 0) {
            if (!this.hasZeroValue) {
                return null;
            }
            return this.zeroValue;
        }
        int n3 = n2 & this.mask;
        if (this.keyTable[n3] != n2 && this.keyTable[n3 = this.hash2(n2)] != n2 && this.keyTable[n3 = this.hash3(n2)] != n2) {
            if (this.isBigTable) {
                n3 = this.hash4(n2);
                if (this.keyTable[n3] != n2) {
                    return this.getStash(n2, null);
                }
            } else {
                return this.getStash(n2, null);
            }
        }
        return this.valueTable[n3];
    }

    private V getStash(int n2, V v2) {
        int n3;
        int[] nArray = this.keyTable;
        int n4 = n3 + this.stashSize;
        for (n3 = this.capacity; n3 < n4; ++n3) {
            if (nArray[n3] != n2) continue;
            return this.valueTable[n3];
        }
        return v2;
    }

    public void clear() {
        int[] nArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n2 = this.capacity + this.stashSize;
        while (n2-- > 0) {
            nArray[n2] = 0;
            VArray[n2] = null;
        }
        this.size = 0;
        this.stashSize = 0;
        this.zeroValue = null;
        this.hasZeroValue = false;
    }

    private void resize(int n2) {
        int n3 = this.capacity + this.stashSize;
        this.capacity = n2;
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.mask = n2 - 1;
        this.hashShift = 31 - Integer.numberOfTrailingZeros(n2);
        this.stashCapacity = Math.max(3, (int)Math.ceil(Math.log(n2)) * 2);
        this.pushIterations = Math.max(Math.min(n2, 8), (int)Math.sqrt(n2) / 8);
        this.isBigTable = this.capacity >>> 16 != 0;
        int[] nArray = this.keyTable;
        V[] VArray = this.valueTable;
        this.keyTable = new int[n2 + this.stashCapacity];
        this.valueTable = new Object[n2 + this.stashCapacity];
        int n4 = this.size;
        this.size = this.hasZeroValue ? 1 : 0;
        this.stashSize = 0;
        if (n4 > 0) {
            for (int i2 = 0; i2 < n3; ++i2) {
                int n5 = nArray[i2];
                if (n5 == 0) continue;
                this.putResize(n5, VArray[i2]);
            }
        }
    }

    private int hash2(int n2) {
        return ((n2 *= -1105259343) ^ n2 >>> this.hashShift) & this.mask;
    }

    private int hash3(int n2) {
        return ((n2 *= -1262997959) ^ n2 >>> this.hashShift) & this.mask;
    }

    private int hash4(int n2) {
        return ((n2 *= -825114047) ^ n2 >>> this.hashShift) & this.mask;
    }

    public String toString() {
        int n2;
        if (this.size == 0) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('[');
        int[] nArray = this.keyTable;
        V[] VArray = this.valueTable;
        int n3 = nArray.length;
        if (this.hasZeroValue) {
            stringBuilder.append("0=");
            stringBuilder.append(this.zeroValue);
        } else {
            while (n3-- > 0) {
                n2 = nArray[n3];
                if (n2 == 0) continue;
                stringBuilder.append(n2);
                stringBuilder.append('=');
                stringBuilder.append(VArray[n3]);
                break;
            }
        }
        while (n3-- > 0) {
            n2 = nArray[n3];
            if (n2 == 0) continue;
            stringBuilder.append(", ");
            stringBuilder.append(n2);
            stringBuilder.append('=');
            stringBuilder.append(VArray[n3]);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

