/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.logging.configuration.WarningMode;
import org.gradle.internal.Factory;
import org.gradle.internal.featurelifecycle.DeprecatedFeatureUsage;
import org.gradle.internal.featurelifecycle.DeprecatedUsageBuildOperationProgressBroadaster;
import org.gradle.internal.featurelifecycle.FeatureHandler;
import org.gradle.internal.featurelifecycle.FeatureUsage;
import org.gradle.internal.featurelifecycle.IncubatingFeatureUsage;
import org.gradle.internal.featurelifecycle.LoggingDeprecatedFeatureHandler;
import org.gradle.internal.featurelifecycle.LoggingIncubatingFeatureHandler;
import org.gradle.internal.featurelifecycle.UsageLocationReporter;
import org.gradle.util.GradleVersion;

@ThreadSafe
public class SingleMessageLogger {
    private static final ThreadLocal<Boolean> ENABLED = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return true;
        }
    };
    public static final String INCUBATION_MESSAGE = "%s is an incubating feature.";
    private static LoggingDeprecatedFeatureHandler deprecatedFeatureHandler = new LoggingDeprecatedFeatureHandler();
    private static LoggingIncubatingFeatureHandler incubatingFeatureHandler = new LoggingIncubatingFeatureHandler();

    public static synchronized void reset() {
        deprecatedFeatureHandler.reset();
        incubatingFeatureHandler.reset();
    }

    public static synchronized void init(UsageLocationReporter reporter, WarningMode warningMode, DeprecatedUsageBuildOperationProgressBroadaster buildOperationProgressBroadaster) {
        deprecatedFeatureHandler.init(reporter, warningMode, buildOperationProgressBroadaster);
    }

    public static synchronized void reportSuppressedDeprecations() {
        deprecatedFeatureHandler.reportSuppressedDeprecations();
    }

    public static void nagUserOfReplacedPlugin(String pluginName, String replacement) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserOfDeprecatedPlugin(pluginName, String.format("Please use the %s plugin instead.", replacement));
        }
    }

    public static void nagUserOfPluginReplacedWithExternalOne(String pluginName, String replacement) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserOfDeprecatedPlugin(pluginName, String.format("Consider using the %s plugin instead.", replacement));
        }
    }

    public static void nagUserOfDeprecatedPlugin(String pluginName) {
        SingleMessageLogger.nagUserOfDeprecatedPlugin(pluginName, null);
    }

    public static void nagUserOfDeprecatedPlugin(String pluginName, int majorVersion, String upgradeGuideSection) {
        SingleMessageLogger.nagUserOfDeprecatedPlugin(pluginName, "Consult the upgrading guide for further information: " + new DocumentationRegistry().getDocumentationFor("upgrading_version_" + majorVersion, upgradeGuideSection));
    }

    public static void nagUserOfDeprecatedPlugin(String pluginName, @Nullable String advice) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(String.format("The %s plugin has been deprecated.", pluginName), SingleMessageLogger.thisWillBeRemovedMessage(), advice, null, DeprecatedFeatureUsage.Type.USER_CODE_DIRECT);
        }
    }

    public static void nagUserOfToolReplacedWithExternalOne(String toolName, String replacement) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(String.format("The %s has been deprecated.", toolName), SingleMessageLogger.thisWillBeRemovedMessage(), String.format("Consider using %s instead.", replacement), null, DeprecatedFeatureUsage.Type.USER_CODE_DIRECT);
        }
    }

    public static void nagUserOfReplacedTask(String taskName, String replacement) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(String.format("The %s task has been deprecated.", taskName), SingleMessageLogger.thisWillBeRemovedMessage(), String.format("Please use the %s task instead.", replacement), null, DeprecatedFeatureUsage.Type.USER_CODE_DIRECT);
        }
    }

    public static void nagUserOfReplacedTaskType(String taskName, String replacement) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(String.format("The %s task type has been deprecated.", taskName), SingleMessageLogger.thisWillBeRemovedMessage(), String.format("Please use the %s instead.", replacement), null, DeprecatedFeatureUsage.Type.USER_CODE_DIRECT);
        }
    }

    public static void nagUserOfReplacedMethod(String methodName, String replacement) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(String.format("The %s method has been deprecated.", methodName), SingleMessageLogger.thisWillBeRemovedMessage(), String.format("Please use the %s method instead.", replacement), null, DeprecatedFeatureUsage.Type.USER_CODE_DIRECT);
        }
    }

    public static void nagUserOfDiscontinuedMethodInvocation(String invocation) {
        SingleMessageLogger.nagUserOfDiscontinuedMethodInvocation(invocation, null);
    }

    public static void nagUserOfDiscontinuedMethodInvocation(String invocation, String advice) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(String.format("Using method %s has been deprecated.", invocation), SingleMessageLogger.thisWillBecomeAnError(), advice, null, DeprecatedFeatureUsage.Type.USER_CODE_DIRECT);
        }
    }

    public static void nagUserOfDiscontinuedInvocation(String invocation) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(String.format("%s has been deprecated.", invocation), SingleMessageLogger.thisWillBecomeAnError(), null, null, DeprecatedFeatureUsage.Type.USER_CODE_DIRECT);
        }
    }

    public static void nagUserOfReplacedMethodInvocation(String invocation, String replacement) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(String.format("Using method %s has been deprecated.", invocation), SingleMessageLogger.thisWillBecomeAnError(), String.format(String.format("Please use the %s method instead.", replacement), new Object[0]), null, DeprecatedFeatureUsage.Type.USER_CODE_DIRECT);
        }
    }

    public static void nagUserOfDiscontinuedMethod(String methodName) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(String.format("The %s method has been deprecated.", methodName), SingleMessageLogger.thisWillBeRemovedMessage(), null, null, DeprecatedFeatureUsage.Type.USER_CODE_DIRECT);
        }
    }

    public static void nagUserOfDiscontinuedMethod(String methodName, String advice) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(String.format("The %s method has been deprecated.", methodName), SingleMessageLogger.thisWillBeRemovedMessage(), advice, null, DeprecatedFeatureUsage.Type.USER_CODE_DIRECT);
        }
    }

    public static void nagUserOfDiscontinuedMethod(String methodName, String advice, String contextualAdvice) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(String.format("The %s method has been deprecated.", methodName), SingleMessageLogger.thisWillBeRemovedMessage(), advice, contextualAdvice, DeprecatedFeatureUsage.Type.USER_CODE_DIRECT);
        }
    }

    public static void nagUserOfReplacedProperty(String propertyName, String replacement) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(String.format("The %s property has been deprecated.", propertyName), SingleMessageLogger.thisWillBeRemovedMessage(), String.format("Please use the %s property instead.", replacement), null, DeprecatedFeatureUsage.Type.USER_CODE_DIRECT);
        }
    }

    public static void nagUserOfDiscontinuedProperty(String propertyName, String advice) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(String.format("The %s property has been deprecated.", propertyName), SingleMessageLogger.thisWillBeRemovedMessage(), advice, null, DeprecatedFeatureUsage.Type.USER_CODE_DIRECT);
        }
    }

    public static void nagUserOfReplacedNamedParameter(String parameterName, String replacement) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(String.format("The %s named parameter has been deprecated.", parameterName), SingleMessageLogger.thisWillBeRemovedMessage(), String.format("Please use the %s named parameter instead.", replacement), null, DeprecatedFeatureUsage.Type.USER_CODE_DIRECT);
        }
    }

    public static void nagUserWithDeprecatedBuildInvocationFeature(String summary, String advice) {
        SingleMessageLogger.nagUserWithDeprecatedBuildInvocationFeature(summary, SingleMessageLogger.thisWillBeRemovedMessage(), advice);
    }

    public static void nagUserWithDeprecatedBuildInvocationFeature(String summary, String removalDetails, String advice) {
        SingleMessageLogger.nagUserWith(String.format("%s has been deprecated.", summary), removalDetails, advice, null, DeprecatedFeatureUsage.Type.BUILD_INVOCATION);
    }

    public static void nagUserWithDeprecatedIndirectUserCodeCause(String summary, @Nullable String advice) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWithDeprecatedIndirectUserCodeCause(summary, advice, null);
        }
    }

    public static void nagUserWithDeprecatedIndirectUserCodeCause(String summary) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWithDeprecatedIndirectUserCodeCause(summary, null);
        }
    }

    public static void nagUserWithDeprecatedIndirectUserCodeCause(String summary, @Nullable String advice, @Nullable String contextualAdvice) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(String.format("%s has been deprecated.", summary), SingleMessageLogger.thisWillBeRemovedMessage(), advice, contextualAdvice, DeprecatedFeatureUsage.Type.USER_CODE_INDIRECT);
        }
    }

    public static void nagUserWithDeprecatedIndirectUserCodeCause(String summary, String removalDetails, String advice, String contextualAdvice) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(String.format("%s has been deprecated.", summary), removalDetails, advice, contextualAdvice, DeprecatedFeatureUsage.Type.USER_CODE_INDIRECT);
        }
    }

    public static void nagUserOfDeprecatedBehaviour(String behaviour) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(behaviour, String.format("This behaviour has been deprecated and %s", LoggingDeprecatedFeatureHandler.getRemovalDetails()), null, null, DeprecatedFeatureUsage.Type.USER_CODE_DIRECT);
        }
    }

    public static void nagUserOfReplacedConfiguration(String configurationName, ConfigurationDeprecationType deprecationType, List<String> replacements) {
        if (SingleMessageLogger.isEnabled()) {
            String summary = String.format("The %s configuration has been deprecated for %s.", configurationName, deprecationType.displayName());
            String suggestion = String.format("Please %s the %s configuration instead.", deprecationType.usage, Joiner.on((String)" or ").join(replacements));
            SingleMessageLogger.nagUserWith(summary, SingleMessageLogger.thisWillBecomeAnError(), suggestion, null, deprecationType.inUserCode ? DeprecatedFeatureUsage.Type.USER_CODE_DIRECT : DeprecatedFeatureUsage.Type.USER_CODE_INDIRECT);
        }
    }

    public static void nagUserOfDeprecatedThing(String thing, @Nullable String advice) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(thing, String.format("This has been deprecated and %s", LoggingDeprecatedFeatureHandler.getRemovalDetails()), advice, null, DeprecatedFeatureUsage.Type.USER_CODE_DIRECT);
        }
    }

    public static void nagUserOfDeprecatedThing(String thing) {
        SingleMessageLogger.nagUserOfDeprecatedThing(thing, null);
    }

    @VisibleForTesting
    static void nagUserWith(String summary) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(summary, null);
        }
    }

    public static void nagUserWith(String message, @Nullable String advice) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(message, SingleMessageLogger.thisWillBeRemovedMessage(), advice, null, DeprecatedFeatureUsage.Type.USER_CODE_DIRECT);
        }
    }

    public static void nagUserWith(String summary, String removalDetails, @Nullable String advice, @Nullable String contextualAdvice) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(deprecatedFeatureHandler, new DeprecatedFeatureUsage(summary, removalDetails, advice, contextualAdvice, DeprecatedFeatureUsage.Type.USER_CODE_DIRECT, SingleMessageLogger.class));
        }
    }

    public static void nagUserWith(String summary, String removalDetails, @Nullable String advice, @Nullable String contextualAdvice, DeprecatedFeatureUsage.Type usageType) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(deprecatedFeatureHandler, new DeprecatedFeatureUsage(summary, removalDetails, advice, contextualAdvice, usageType, SingleMessageLogger.class));
        }
    }

    private static synchronized <T extends FeatureUsage> void nagUserWith(FeatureHandler<T> handler, T usage) {
        handler.featureUsed(usage);
    }

    public static void nagUserOfDeprecated(String thing) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(String.format("%s has been deprecated.", thing), SingleMessageLogger.thisWillBeRemovedMessage(), null, null, DeprecatedFeatureUsage.Type.USER_CODE_DIRECT);
        }
    }

    public static void nagUserOfDeprecated(String thing, String advice) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserOfDeprecated(thing, advice, null);
        }
    }

    public static void nagUserOfDeprecated(String thing, String advice, @Nullable String contextualAdvice) {
        if (SingleMessageLogger.isEnabled()) {
            SingleMessageLogger.nagUserWith(String.format("%s has been deprecated.", thing), SingleMessageLogger.thisWillBeRemovedMessage(), advice, contextualAdvice, DeprecatedFeatureUsage.Type.USER_CODE_DIRECT);
        }
    }

    @Nullable
    public static <T> T whileDisabled(Factory<T> factory) {
        ENABLED.set(false);
        try {
            T t = factory.create();
            return t;
        }
        finally {
            ENABLED.set(true);
        }
    }

    public static void whileDisabled(Runnable action) {
        ENABLED.set(false);
        try {
            action.run();
        }
        finally {
            ENABLED.set(true);
        }
    }

    private static boolean isEnabled() {
        return ENABLED.get();
    }

    private static String thisWillBecomeAnError() {
        return String.format("This will fail with an error in Gradle %s.", GradleVersion.current().getNextMajor().getVersion());
    }

    private static String thisWillBeRemovedMessage() {
        return String.format("This %s", LoggingDeprecatedFeatureHandler.getRemovalDetails());
    }

    public static void incubatingFeatureUsed(String incubatingFeature) {
        SingleMessageLogger.nagUserWith(incubatingFeatureHandler, new IncubatingFeatureUsage(incubatingFeature, SingleMessageLogger.class));
    }

    @Nullable
    public static Throwable getDeprecationFailure() {
        return deprecatedFeatureHandler.getDeprecationFailure();
    }

    public static enum ConfigurationDeprecationType {
        DEPENDENCY_DECLARATION("use", true),
        CONSUMPTION("use attributes to consume", false),
        RESOLUTION("resolve", true),
        ARTIFACT_DECLARATION("use", true);

        public final String usage;
        public final boolean inUserCode;

        private ConfigurationDeprecationType(String usage, boolean inUserCode) {
            this.usage = usage;
            this.inUserCode = inUserCode;
        }

        public String displayName() {
            return this.name().toLowerCase().replace('_', ' ');
        }
    }
}

