/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junit;

import org.gradle.api.Action;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.api.internal.tasks.testing.junit.AbstractJUnitTestClassProcessor;
import org.gradle.api.internal.tasks.testing.junit.JUnitSpec;
import org.gradle.api.internal.tasks.testing.junit.JUnitTestClassExecutor;
import org.gradle.api.internal.tasks.testing.junit.JUnitTestEventAdapter;
import org.gradle.api.internal.tasks.testing.junit.TestClassExecutionEventGenerator;
import org.gradle.api.internal.tasks.testing.junit.TestClassExecutionListener;
import org.gradle.api.internal.tasks.testing.results.AttachParentTestResultProcessor;
import org.gradle.internal.actor.Actor;
import org.gradle.internal.actor.ActorFactory;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.time.Clock;

public class JUnitTestClassProcessor
extends AbstractJUnitTestClassProcessor<JUnitSpec> {
    public JUnitTestClassProcessor(JUnitSpec spec, IdGenerator<?> idGenerator, ActorFactory actorFactory, Clock clock) {
        super(spec, idGenerator, actorFactory, clock);
    }

    @Override
    protected TestResultProcessor createResultProcessorChain(TestResultProcessor resultProcessor) {
        AttachParentTestResultProcessor resultProcessorChain = new AttachParentTestResultProcessor(resultProcessor);
        return new TestClassExecutionEventGenerator(resultProcessorChain, this.idGenerator, this.clock);
    }

    @Override
    protected Action<String> createTestExecutor(Actor resultProcessorActor) {
        TestResultProcessor threadSafeResultProcessor = resultProcessorActor.getProxy(TestResultProcessor.class);
        TestClassExecutionListener threadSafeTestClassListener = resultProcessorActor.getProxy(TestClassExecutionListener.class);
        JUnitTestEventAdapter junitEventAdapter = new JUnitTestEventAdapter(threadSafeResultProcessor, this.clock, this.idGenerator);
        return new JUnitTestClassExecutor(Thread.currentThread().getContextClassLoader(), (JUnitSpec)this.spec, junitEventAdapter, threadSafeTestClassListener);
    }
}

