/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junit;

import org.gradle.api.Action;
import org.gradle.api.internal.tasks.testing.TestClassProcessor;
import org.gradle.api.internal.tasks.testing.TestClassRunInfo;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.api.internal.tasks.testing.junit.AbstractJUnitSpec;
import org.gradle.internal.actor.Actor;
import org.gradle.internal.actor.ActorFactory;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.time.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJUnitTestClassProcessor<T extends AbstractJUnitSpec>
implements TestClassProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractJUnitTestClassProcessor.class);
    protected final T spec;
    protected final IdGenerator<?> idGenerator;
    protected final Clock clock;
    private final ActorFactory actorFactory;
    private Actor resultProcessorActor;
    private Action<String> executor;

    public AbstractJUnitTestClassProcessor(T spec, IdGenerator<?> idGenerator, ActorFactory actorFactory, Clock clock) {
        this.idGenerator = idGenerator;
        this.spec = spec;
        this.actorFactory = actorFactory;
        this.clock = clock;
    }

    @Override
    public void startProcessing(TestResultProcessor resultProcessor) {
        TestResultProcessor resultProcessorChain = this.createResultProcessorChain(resultProcessor);
        this.resultProcessorActor = this.actorFactory.createBlockingActor(resultProcessorChain);
        this.executor = this.createTestExecutor(this.resultProcessorActor);
    }

    protected abstract TestResultProcessor createResultProcessorChain(TestResultProcessor var1);

    protected abstract Action<String> createTestExecutor(Actor var1);

    @Override
    public void processTestClass(TestClassRunInfo testClass) {
        LOGGER.debug("Executing test class {}", (Object)testClass.getTestClassName());
        this.executor.execute(testClass.getTestClassName());
    }

    @Override
    public void stop() {
        this.resultProcessorActor.stop();
    }

    @Override
    public void stopNow() {
        throw new UnsupportedOperationException("stopNow() should not be invoked on remote worker TestClassProcessor");
    }
}

