/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.gradle.IsBuildGradle;
import org.openrewrite.groovy.GroovyVisitor;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.semver.DependencyMatcher;

public final class ChangeDependencyArtifactId
extends Recipe {
    @Option(displayName="Dependency pattern", description="A dependency pattern specifying which dependencies should have their artifactId updated. Dependency patterns are a concise way of describing which dependencies are applicable to a recipe. Valid dependency patterns take one of these forms:\n\n* groupId:artifactId\n* groupId:artifactId:versionSelector\n* groupId:artifactId:versionSelector/versionPattern\n\n\"groupId\" and \"artifactId\" accept glob patterns.\n\"versionSelector\" accepts both literal version numbers and semver selectors.\n\"versionPattern\" is used for artifacts that encode variant/platform information in their version.Guava is a common example of such a library. Guava appends \"-jre\" or \"-android\" to its version to indicate platform compatibility.", example="com.fasterxml.jackson*:jackson-module*")
    private final String dependencyPattern;
    @Option(displayName="New artifactId", description="The new artifactId to use.", example="rewrite-core")
    private final String newArtifactId;
    @Option(displayName="Dependency configuration", description="The dependency configuration to search for dependencies in.", example="api", required=false)
    @Nullable
    private final String configuration;

    public String getDisplayName() {
        return "Change Gradle dependency artifactId";
    }

    public String getDescription() {
        return "Change the artifactId of a specified Gradle dependency. ";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new IsBuildGradle();
    }

    public Validated validate() {
        Validated validated = super.validate();
        if (this.dependencyPattern != null) {
            validated = validated.and(DependencyMatcher.build((String)this.dependencyPattern));
        }
        return validated;
    }

    protected GroovyVisitor<ExecutionContext> getVisitor() {
        return new GroovyVisitor<ExecutionContext>(){
            final DependencyMatcher depMatcher;
            final MethodMatcher dependencyDsl;
            {
                this.depMatcher = (DependencyMatcher)DependencyMatcher.build((String)ChangeDependencyArtifactId.this.dependencyPattern).getValue();
                this.dependencyDsl = new MethodMatcher("DependencyHandlerSpec *(..)");
            }

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext context) {
                J.MethodInvocation m = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)context);
                if (!this.dependencyDsl.matches(m) || ChangeDependencyArtifactId.this.configuration != null && !m.getSimpleName().equals(ChangeDependencyArtifactId.this.configuration)) {
                    return m;
                }
                List depArgs = m.getArguments();
                String versionStringDelimiter = "'";
                if (depArgs.get(0) instanceof J.Literal) {
                    String[] gavs;
                    String gav = (String)((J.Literal)depArgs.get(0)).getValue();
                    if (gav != null && (gavs = gav.split(":")).length >= 3 && !ChangeDependencyArtifactId.this.newArtifactId.equals(gavs[1]) && this.depMatcher.matches(gavs[0], gavs[1], gavs[2])) {
                        String valueSource = ((J.Literal)depArgs.get(0)).getValueSource();
                        String delimiter = valueSource == null ? versionStringDelimiter : valueSource.substring(0, valueSource.indexOf(gav));
                        String newGav = gavs[0] + ":" + ChangeDependencyArtifactId.this.newArtifactId + ":" + gavs[2];
                        m = m.withArguments(ListUtils.map((List)m.getArguments(), (n, arg) -> n == 0 ? ((J.Literal)arg).withValue((Object)newGav).withValueSource(delimiter + newGav + delimiter) : arg));
                    }
                } else if (depArgs.get(0) instanceof G.MapEntry) {
                    G.MapEntry artifactEntry = null;
                    String groupId = null;
                    String artifactId = null;
                    String version = null;
                    for (Expression e : depArgs) {
                        G.MapEntry arg2;
                        if (!(e instanceof G.MapEntry) || !((arg2 = (G.MapEntry)e).getKey() instanceof J.Literal) || !(arg2.getValue() instanceof J.Literal)) continue;
                        J.Literal key = (J.Literal)arg2.getKey();
                        J.Literal value = (J.Literal)arg2.getValue();
                        if (!(key.getValue() instanceof String) || !(value.getValue() instanceof String)) continue;
                        String keyValue = (String)key.getValue();
                        String valueValue = (String)value.getValue();
                        if ("group".equals(keyValue)) {
                            groupId = valueValue;
                            continue;
                        }
                        if ("name".equals(keyValue) && !ChangeDependencyArtifactId.this.newArtifactId.equals(valueValue)) {
                            artifactEntry = arg2;
                            artifactId = valueValue;
                            if (value.getValueSource() == null) continue;
                            versionStringDelimiter = value.getValueSource().substring(0, value.getValueSource().indexOf(valueValue));
                            continue;
                        }
                        if (!"version".equals(keyValue)) continue;
                        version = valueValue;
                    }
                    if (groupId == null || artifactId == null || version == null && !this.depMatcher.matches(groupId, artifactId) || version != null && !this.depMatcher.matches(groupId, artifactId, version)) {
                        return m;
                    }
                    String delimiter = versionStringDelimiter;
                    G.MapEntry finalArtifact = artifactEntry;
                    m = m.withArguments(ListUtils.map((List)m.getArguments(), arg -> {
                        if (arg == finalArtifact) {
                            return finalArtifact.withValue((Expression)((J.Literal)finalArtifact.getValue()).withValue((Object)ChangeDependencyArtifactId.this.newArtifactId).withValueSource(delimiter + ChangeDependencyArtifactId.this.newArtifactId + delimiter));
                        }
                        return arg;
                    }));
                }
                return m;
            }
        };
    }

    public ChangeDependencyArtifactId(String dependencyPattern, String newArtifactId, @Nullable String configuration) {
        this.dependencyPattern = dependencyPattern;
        this.newArtifactId = newArtifactId;
        this.configuration = configuration;
    }

    public String getDependencyPattern() {
        return this.dependencyPattern;
    }

    public String getNewArtifactId() {
        return this.newArtifactId;
    }

    @Nullable
    public String getConfiguration() {
        return this.configuration;
    }

    @NonNull
    public String toString() {
        return "ChangeDependencyArtifactId(dependencyPattern=" + this.getDependencyPattern() + ", newArtifactId=" + this.getNewArtifactId() + ", configuration=" + this.getConfiguration() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeDependencyArtifactId)) {
            return false;
        }
        ChangeDependencyArtifactId other = (ChangeDependencyArtifactId)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$dependencyPattern = this.getDependencyPattern();
        String other$dependencyPattern = other.getDependencyPattern();
        if (this$dependencyPattern == null ? other$dependencyPattern != null : !this$dependencyPattern.equals(other$dependencyPattern)) {
            return false;
        }
        String this$newArtifactId = this.getNewArtifactId();
        String other$newArtifactId = other.getNewArtifactId();
        if (this$newArtifactId == null ? other$newArtifactId != null : !this$newArtifactId.equals(other$newArtifactId)) {
            return false;
        }
        String this$configuration = this.getConfiguration();
        String other$configuration = other.getConfiguration();
        return !(this$configuration == null ? other$configuration != null : !this$configuration.equals(other$configuration));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangeDependencyArtifactId;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $dependencyPattern = this.getDependencyPattern();
        result = result * 59 + ($dependencyPattern == null ? 43 : $dependencyPattern.hashCode());
        String $newArtifactId = this.getNewArtifactId();
        result = result * 59 + ($newArtifactId == null ? 43 : $newArtifactId.hashCode());
        String $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : $configuration.hashCode());
        return result;
    }
}

