/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import io.github.resilience4j.retry.RetryRegistry;
import io.vavr.CheckedFunction1;
import java.io.Serializable;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import okhttp3.ConnectionSpec;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.gradle.IsBuildGradle;
import org.openrewrite.groovy.GroovyVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;

public final class UpgradePluginVersion
extends Recipe {
    private static final RetryConfig retryConfig = RetryConfig.custom().retryOnException(throwable -> throwable instanceof SocketTimeoutException || throwable instanceof TimeoutException).build();
    private static final RetryRegistry retryRegistry = RetryRegistry.of((RetryConfig)retryConfig);
    private static final OkHttpClient httpClient = new OkHttpClient.Builder().connectionSpecs(Arrays.asList(ConnectionSpec.CLEARTEXT, ConnectionSpec.MODERN_TLS, ConnectionSpec.COMPATIBLE_TLS)).build();
    private static final Retry gradlePluginPortalRetry = retryRegistry.retry("GradlePluginPortal");
    private static final CheckedFunction1<Request, Response> sendRequest = Retry.decorateCheckedFunction((Retry)gradlePluginPortalRetry, (CheckedFunction1 & Serializable)request -> httpClient.newCall(request).execute());
    @Option(displayName="Plugin id", description="The `ID` part of `plugin { ID }`, as a glob expression.", example="com.jfrog.bintray")
    private final String pluginIdPattern;
    @Option(displayName="New version", description="An exact version number, or node-style semver selector used to select the version number.", example="29.X")
    private final String newVersion;
    @Option(displayName="Version pattern", description="Allows version selection to be extended beyond the original Node Semver semantics. So for example,Setting 'version' to \"25-29\" can be paired with a metadata pattern of \"-jre\" to select Guava 29.0-jre", example="-jre", required=false)
    @Nullable
    private final String versionPattern;

    public String getDisplayName() {
        return "Update a Gradle plugin by id";
    }

    public String getDescription() {
        return "Update a Gradle plugin by id to a later version.";
    }

    public Validated validate() {
        Validated validated = super.validate();
        if (this.newVersion != null) {
            validated = validated.and(Semver.validate((String)this.newVersion, (String)this.versionPattern));
        }
        return validated;
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new IsBuildGradle();
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        final VersionComparator versionComparator = (VersionComparator)Semver.validate((String)this.newVersion, (String)this.versionPattern).getValue();
        assert (versionComparator != null);
        final MethodMatcher pluginMatcher = new MethodMatcher("PluginSpec id(..)", false);
        final MethodMatcher versionMatcher = new MethodMatcher("Plugin version(..)", false);
        return new GroovyVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext executionContext) {
                List pluginArgs;
                if (versionMatcher.matches(method) && method.getSelect() instanceof J.MethodInvocation && pluginMatcher.matches(method.getSelect()) && (pluginArgs = ((J.MethodInvocation)method.getSelect()).getArguments()).get(0) instanceof J.Literal) {
                    String currentVersion;
                    List versionArgs;
                    String pluginId = (String)((J.Literal)pluginArgs.get(0)).getValue();
                    assert (pluginId != null);
                    if (StringUtils.matchesGlob((String)pluginId, (String)UpgradePluginVersion.this.pluginIdPattern) && (versionArgs = method.getArguments()).get(0) instanceof J.Literal && (currentVersion = (String)((J.Literal)versionArgs.get(0)).getValue()) != null) {
                        return (J)versionComparator.upgrade(currentVersion, UpgradePluginVersion.availablePluginVersions(pluginId)).map(upgradeVersion -> method.withArguments(ListUtils.map((List)versionArgs, v -> {
                            J.Literal versionLiteral = (J.Literal)v;
                            assert (versionLiteral.getValueSource() != null);
                            return versionLiteral.withValue(upgradeVersion).withValueSource(versionLiteral.getValueSource().replace(currentVersion, (CharSequence)upgradeVersion));
                        }))).orElse(method);
                    }
                }
                return super.visitMethodInvocation(method, (Object)executionContext);
            }
        };
    }

    public static List<String> availablePluginVersions(String pluginId) {
        String uri = "https://plugins.gradle.org/plugin/" + pluginId;
        Request.Builder request = new Request.Builder().url(uri).get();
        try {
            Response response;
            block12: {
                ArrayList<String> arrayList;
                block13: {
                    response = (Response)sendRequest.apply((Object)request.build());
                    try {
                        if (!response.isSuccessful() || response.body() == null) break block12;
                        String responseBody = response.body().string();
                        ArrayList<String> versions = new ArrayList<String>();
                        Matcher matcher = Pattern.compile("href=\"/plugin/" + pluginId + "/([^\"]+)\"").matcher(responseBody);
                        int lastFind = 0;
                        while (matcher.find(lastFind)) {
                            versions.add(matcher.group(1));
                            lastFind = matcher.end();
                        }
                        matcher = Pattern.compile("Version ([^\\s]+) \\(latest\\)").matcher(responseBody);
                        if (matcher.find()) {
                            versions.add(matcher.group(1));
                        }
                        arrayList = versions;
                        if (response == null) break block13;
                    }
                    catch (Throwable throwable) {
                        if (response != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    response.close();
                }
                return arrayList;
            }
            if (response != null) {
                response.close();
            }
        }
        finally {
            return Collections.emptyList();
        }
        {
        }
    }

    public UpgradePluginVersion(String pluginIdPattern, String newVersion, @Nullable String versionPattern) {
        this.pluginIdPattern = pluginIdPattern;
        this.newVersion = newVersion;
        this.versionPattern = versionPattern;
    }

    public String getPluginIdPattern() {
        return this.pluginIdPattern;
    }

    public String getNewVersion() {
        return this.newVersion;
    }

    @Nullable
    public String getVersionPattern() {
        return this.versionPattern;
    }

    @NonNull
    public String toString() {
        return "UpgradePluginVersion(pluginIdPattern=" + this.getPluginIdPattern() + ", newVersion=" + this.getNewVersion() + ", versionPattern=" + this.getVersionPattern() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpgradePluginVersion)) {
            return false;
        }
        UpgradePluginVersion other = (UpgradePluginVersion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$pluginIdPattern = this.getPluginIdPattern();
        String other$pluginIdPattern = other.getPluginIdPattern();
        if (this$pluginIdPattern == null ? other$pluginIdPattern != null : !this$pluginIdPattern.equals(other$pluginIdPattern)) {
            return false;
        }
        String this$newVersion = this.getNewVersion();
        String other$newVersion = other.getNewVersion();
        if (this$newVersion == null ? other$newVersion != null : !this$newVersion.equals(other$newVersion)) {
            return false;
        }
        String this$versionPattern = this.getVersionPattern();
        String other$versionPattern = other.getVersionPattern();
        return !(this$versionPattern == null ? other$versionPattern != null : !this$versionPattern.equals(other$versionPattern));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof UpgradePluginVersion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $pluginIdPattern = this.getPluginIdPattern();
        result = result * 59 + ($pluginIdPattern == null ? 43 : $pluginIdPattern.hashCode());
        String $newVersion = this.getNewVersion();
        result = result * 59 + ($newVersion == null ? 43 : $newVersion.hashCode());
        String $versionPattern = this.getVersionPattern();
        result = result * 59 + ($versionPattern == null ? 43 : $versionPattern.hashCode());
        return result;
    }
}

