/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.util.List;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.gradle.IsBuildGradle;
import org.openrewrite.groovy.GroovyVisitor;
import org.openrewrite.groovy.tree.G;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;

public final class ChangeDependencyVersion
extends Recipe {
    @Option(displayName="Group", description="The first part of a dependency coordinate `com.google.guava:guava:VERSION`. This can be a glob expression.", example="com.fasterxml.jackson*")
    private final String groupId;
    @Option(displayName="Artifact", description="The second part of a dependency coordinate `com.google.guava:guava:VERSION`. This can be a glob expression.", example="jackson-module*")
    @Nullable
    private final String artifactId;
    @Option(displayName="New Version", description="The version number to update the dependency to", example="1.0")
    private final String newVersion;
    @Option(displayName="Dependency configuration", description="The dependency configuration to search for dependencies in.", example="api", required=false)
    @Nullable
    private final String configuration;

    public String getDisplayName() {
        return "Change a Gradle dependency version";
    }

    public String getDescription() {
        return "Finds dependencies declared in `build.gradle` files.";
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new IsBuildGradle();
    }

    protected GroovyVisitor<ExecutionContext> getVisitor() {
        final MethodMatcher dependency = new MethodMatcher("DependencyHandlerSpec *(..)");
        return new GroovyVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext context) {
                J.MethodInvocation m = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)context);
                if (dependency.matches(m) && (ChangeDependencyVersion.this.configuration == null || m.getSimpleName().equals(ChangeDependencyVersion.this.configuration))) {
                    List depArgs = m.getArguments();
                    String versionStringDelimiter = "'";
                    if (depArgs.get(0) instanceof J.Literal) {
                        String[] gavs;
                        String gav = (String)((J.Literal)depArgs.get(0)).getValue();
                        if (gav != null && (gavs = gav.split(":")).length >= 3 && StringUtils.matchesGlob((String)gavs[0], (String)ChangeDependencyVersion.this.groupId) && StringUtils.matchesGlob((String)gavs[1], (String)ChangeDependencyVersion.this.artifactId) && !StringUtils.matchesGlob((String)gavs[2], (String)ChangeDependencyVersion.this.newVersion)) {
                            String valueSource = ((J.Literal)depArgs.get(0)).getValueSource();
                            String delimiter = valueSource == null ? versionStringDelimiter : valueSource.substring(0, valueSource.indexOf(gav));
                            String newGav = gavs[0] + ":" + gavs[1] + ":" + ChangeDependencyVersion.this.newVersion;
                            m = m.withArguments(ListUtils.map((List)m.getArguments(), (n, arg) -> n == 0 ? ((J.Literal)arg).withValue((Object)newGav).withValueSource(delimiter + newGav + delimiter) : arg));
                        }
                    } else if (depArgs.get(0) instanceof G.MapEntry) {
                        G.MapEntry groupEntry = null;
                        G.MapEntry artifactEntry = null;
                        G.MapEntry versionEntry = null;
                        for (Expression e : depArgs) {
                            G.MapEntry arg2;
                            if (!(e instanceof G.MapEntry) || !((arg2 = (G.MapEntry)e).getKey() instanceof J.Literal) || !(arg2.getValue() instanceof J.Literal)) continue;
                            J.Literal key = (J.Literal)arg2.getKey();
                            J.Literal value = (J.Literal)arg2.getValue();
                            if (!(key.getValue() instanceof String) || !(value.getValue() instanceof String)) continue;
                            String keyValue = (String)key.getValue();
                            String valueValue = (String)value.getValue();
                            if ("group".equals(keyValue) && StringUtils.matchesGlob((String)valueValue, (String)ChangeDependencyVersion.this.groupId)) {
                                groupEntry = arg2;
                                continue;
                            }
                            if ("name".equals(keyValue) && StringUtils.matchesGlob((String)valueValue, (String)ChangeDependencyVersion.this.artifactId)) {
                                artifactEntry = arg2;
                                continue;
                            }
                            if (!"version".equals(keyValue) || valueValue.equals(ChangeDependencyVersion.this.newVersion)) continue;
                            if (value.getValueSource() != null) {
                                versionStringDelimiter = value.getValueSource().substring(0, value.getValueSource().indexOf(valueValue));
                            }
                            versionEntry = arg2;
                        }
                        if (groupEntry == null || artifactEntry == null || versionEntry == null) {
                            return m;
                        }
                        G.MapEntry finalVersion = versionEntry;
                        String delimiter = versionStringDelimiter;
                        m = m.withArguments(ListUtils.map((List)m.getArguments(), arg -> {
                            if (arg == finalVersion) {
                                return finalVersion.withValue((Expression)((J.Literal)finalVersion.getValue()).withValue((Object)ChangeDependencyVersion.this.newVersion).withValueSource(delimiter + ChangeDependencyVersion.this.newVersion + delimiter));
                            }
                            return arg;
                        }));
                    }
                }
                return m;
            }
        };
    }

    public ChangeDependencyVersion(String groupId, @Nullable String artifactId, String newVersion, @Nullable String configuration) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.newVersion = newVersion;
        this.configuration = configuration;
    }

    public String getGroupId() {
        return this.groupId;
    }

    @Nullable
    public String getArtifactId() {
        return this.artifactId;
    }

    public String getNewVersion() {
        return this.newVersion;
    }

    @Nullable
    public String getConfiguration() {
        return this.configuration;
    }

    @NonNull
    public String toString() {
        return "ChangeDependencyVersion(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", newVersion=" + this.getNewVersion() + ", configuration=" + this.getConfiguration() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeDependencyVersion)) {
            return false;
        }
        ChangeDependencyVersion other = (ChangeDependencyVersion)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$groupId = this.getGroupId();
        String other$groupId = other.getGroupId();
        if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
            return false;
        }
        String this$artifactId = this.getArtifactId();
        String other$artifactId = other.getArtifactId();
        if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
            return false;
        }
        String this$newVersion = this.getNewVersion();
        String other$newVersion = other.getNewVersion();
        if (this$newVersion == null ? other$newVersion != null : !this$newVersion.equals(other$newVersion)) {
            return false;
        }
        String this$configuration = this.getConfiguration();
        String other$configuration = other.getConfiguration();
        return !(this$configuration == null ? other$configuration != null : !this$configuration.equals(other$configuration));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ChangeDependencyVersion;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $groupId = this.getGroupId();
        result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
        String $artifactId = this.getArtifactId();
        result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
        String $newVersion = this.getNewVersion();
        result = result * 59 + ($newVersion == null ? 43 : $newVersion.hashCode());
        String $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : $configuration.hashCode());
        return result;
    }
}

