/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.gradle.IsBuildGradle;
import org.openrewrite.groovy.GroovyVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.FindMethods;
import org.openrewrite.java.tree.Flag;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.marker.Markers;

public final class AddRepository
extends Recipe {
    @Option(displayName="Repository", description="The name of the repository to add", example="mavenCentral")
    private final String repository;

    public String getDisplayName() {
        return "Add repository";
    }

    public String getDescription() {
        return "Adds a repository to Gradle build scripts. Named repositories include \"jcenter\", \"mavenCentral\", \"mavenLocal\", and \"google\"";
    }

    protected IsBuildGradle<ExecutionContext> getSingleSourceApplicableTest() {
        return new IsBuildGradle<ExecutionContext>();
    }

    protected GroovyVisitor<ExecutionContext> getVisitor() {
        final MethodMatcher repositories = new MethodMatcher("RewriteGradleProject repositories(groovy.lang.Closure)");
        return new GroovyVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext context) {
                J.MethodInvocation m = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)context);
                if (repositories.matches(m) && FindMethods.find((J)m, (String)("org.gradle.api.artifacts.dsl.RepositoryHandler " + AddRepository.this.repository + "()")).size() > 0) {
                    return m;
                }
                if (m.getArguments().size() < 1 || !(m.getArguments().get(0) instanceof J.Lambda)) {
                    return m;
                }
                J.Lambda arg = (J.Lambda)m.getArguments().get(0);
                if (!(arg.getBody() instanceof J.Block)) {
                    return m;
                }
                J.Block body = (J.Block)arg.getBody();
                JavaType.Method.Signature signature = new JavaType.Method.Signature((JavaType)JavaType.Class.build((String)"org.gradle.api.artifacts.repositories.MavenArtifactRepository"), Collections.emptyList());
                JavaType.Method methodType = JavaType.Method.build(Collections.singleton(Flag.Public), (JavaType.FullyQualified)JavaType.Class.build((String)"org.gradle.api.artifacts.dsl.RepositoryHandler"), (String)AddRepository.this.repository, (JavaType.Method.Signature)signature, (JavaType.Method.Signature)signature, Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
                J.MethodInvocation repositoryInvocation = new J.MethodInvocation(Tree.randomId(), Space.build((String)"\n    ", Collections.emptyList()), Markers.EMPTY, null, null, J.Identifier.build((UUID)Tree.randomId(), (Space)Space.EMPTY, (Markers)Markers.EMPTY, (String)AddRepository.this.repository, null, null), JContainer.build((Space)Space.EMPTY, Collections.singletonList(JRightPadded.build((Object)new J.Empty(Tree.randomId(), Space.EMPTY, Markers.EMPTY))), (Markers)Markers.EMPTY), methodType);
                body = body.withStatements(ListUtils.concat((Object)repositoryInvocation, (List)body.getStatements()));
                arg = arg.withBody((J)body);
                m = m.withArguments(Collections.singletonList(arg));
                return m;
            }
        };
    }

    public AddRepository(String repository) {
        this.repository = repository;
    }

    public String getRepository() {
        return this.repository;
    }

    @NonNull
    public String toString() {
        return "AddRepository(repository=" + this.getRepository() + ")";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddRepository)) {
            return false;
        }
        AddRepository other = (AddRepository)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$repository = this.getRepository();
        String other$repository = other.getRepository();
        return !(this$repository == null ? other$repository != null : !this$repository.equals(other$repository));
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof AddRepository;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $repository = this.getRepository();
        result = result * 59 + ($repository == null ? 43 : $repository.hashCode());
        return result;
    }
}

