/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.remote.internal.hub;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.internal.classloader.CachingClassLoader;
import org.gradle.internal.classloader.MultiParentClassLoader;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.ThreadSafe;
import org.gradle.internal.dispatch.BoundedDispatch;
import org.gradle.internal.dispatch.Dispatch;
import org.gradle.internal.dispatch.MethodInvocation;
import org.gradle.internal.dispatch.ProxyDispatchAdapter;
import org.gradle.internal.dispatch.ReflectionDispatch;
import org.gradle.internal.dispatch.StreamCompletion;
import org.gradle.internal.exceptions.DefaultMultiCauseException;
import org.gradle.internal.remote.ObjectConnection;
import org.gradle.internal.remote.internal.ConnectCompletion;
import org.gradle.internal.remote.internal.RemoteConnection;
import org.gradle.internal.remote.internal.hub.DefaultMethodArgsSerializer;
import org.gradle.internal.remote.internal.hub.InterHubMessageSerializer;
import org.gradle.internal.remote.internal.hub.JavaSerializationBackedMethodArgsSerializer;
import org.gradle.internal.remote.internal.hub.MessageHub;
import org.gradle.internal.remote.internal.hub.MethodInvocationSerializer;
import org.gradle.internal.remote.internal.hub.StreamFailureHandler;
import org.gradle.internal.remote.internal.hub.protocol.InterHubMessage;
import org.gradle.internal.serialize.SerializerRegistry;
import org.gradle.internal.serialize.kryo.TypeSafeSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageHubBackedObjectConnection
implements ObjectConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MessageHubBackedObjectConnection.class);
    private final MessageHub hub;
    private final List<Action<Throwable>> unrecoverableErrorHandlers = new ArrayList<Action<Throwable>>();
    private ConnectCompletion completion;
    private RemoteConnection<InterHubMessage> connection;
    private List<SerializerRegistry> paramSerializers = new ArrayList<SerializerRegistry>();
    private Set<ClassLoader> methodParamClassLoaders = new HashSet<ClassLoader>();
    private volatile boolean aborted;

    public MessageHubBackedObjectConnection(ExecutorFactory executorFactory, ConnectCompletion completion) {
        Action<Throwable> errorHandler = new Action<Throwable>(){

            @Override
            public void execute(Throwable throwable) {
                Throwable current = throwable;
                for (Action handler : MessageHubBackedObjectConnection.this.unrecoverableErrorHandlers) {
                    try {
                        handler.execute(current);
                    }
                    catch (Throwable e) {
                        current = new DefaultMultiCauseException("Error in unrecoverable error handler: " + handler, e, throwable);
                    }
                }
            }
        };
        this.hub = new MessageHub(completion.toString(), executorFactory, (Action<? super Throwable>)errorHandler);
        this.completion = completion;
        this.addUnrecoverableErrorHandler(new Action<Throwable>(){

            @Override
            public void execute(Throwable throwable) {
                if (!MessageHubBackedObjectConnection.this.aborted && !Thread.currentThread().isInterrupted()) {
                    LOGGER.error("Unexpected exception thrown.", throwable);
                }
            }
        });
    }

    @Override
    public void useJavaSerializationForParameters(ClassLoader incomingMessageClassLoader) {
        this.methodParamClassLoaders.add(incomingMessageClassLoader);
    }

    @Override
    public <T> void addIncoming(Class<T> type, T instance) {
        if (this.connection != null) {
            throw new GradleException("Cannot add incoming message handler after connection established.");
        }
        if (type.getClassLoader() != this.getClass().getClassLoader()) {
            this.methodParamClassLoaders.add(type.getClassLoader());
        }
        DispatchWrapper<T> handler = new DispatchWrapper<T>(instance);
        this.hub.addHandler(type.getName(), handler);
    }

    @Override
    public <T> T addOutgoing(Class<T> type) {
        if (this.connection != null) {
            throw new GradleException("Cannot add outgoing message transmitter after connection established.");
        }
        this.methodParamClassLoaders.add(type.getClassLoader());
        ProxyDispatchAdapter<T> adapter = new ProxyDispatchAdapter<T>(this.hub.getOutgoing(type.getName(), MethodInvocation.class), type, ThreadSafe.class);
        return adapter.getSource();
    }

    @Override
    public void useParameterSerializers(SerializerRegistry serializer) {
        this.paramSerializers.add(serializer);
    }

    @Override
    public void connect() {
        ClassLoader methodParamClassLoader = this.methodParamClassLoaders.size() == 0 ? this.getClass().getClassLoader() : (this.methodParamClassLoaders.size() == 1 ? this.methodParamClassLoaders.iterator().next() : new CachingClassLoader(new MultiParentClassLoader(this.methodParamClassLoaders)));
        DefaultMethodArgsSerializer argsSerializer = new DefaultMethodArgsSerializer(this.paramSerializers, new JavaSerializationBackedMethodArgsSerializer(methodParamClassLoader));
        InterHubMessageSerializer serializer = new InterHubMessageSerializer(new TypeSafeSerializer<MethodInvocation>(MethodInvocation.class, new MethodInvocationSerializer(methodParamClassLoader, argsSerializer)));
        this.connection = this.completion.create(serializer);
        this.hub.addConnection(this.connection);
        this.hub.noFurtherConnections();
        this.completion = null;
    }

    @Override
    public void requestStop() {
        this.hub.requestStop();
    }

    @Override
    public void stop() {
        CompositeStoppable.stoppable(this.hub, this.connection).stop();
    }

    @Override
    public void abort() {
        this.aborted = true;
        this.stop();
    }

    @Override
    public void addUnrecoverableErrorHandler(Action<Throwable> handler) {
        this.unrecoverableErrorHandlers.add(handler);
    }

    private static class DispatchWrapper<T>
    implements BoundedDispatch<MethodInvocation>,
    StreamFailureHandler {
        private final T instance;
        private final Dispatch<MethodInvocation> handler;

        DispatchWrapper(T instance) {
            this.instance = instance;
            this.handler = new ReflectionDispatch(instance);
        }

        @Override
        public void endStream() {
            if (this.instance instanceof StreamCompletion) {
                ((StreamCompletion)this.instance).endStream();
            }
        }

        @Override
        public void dispatch(MethodInvocation message) {
            this.handler.dispatch(message);
        }

        @Override
        public void handleStreamFailure(Throwable t) {
            if (this.instance instanceof StreamFailureHandler) {
                ((StreamFailureHandler)this.instance).handleStreamFailure(t);
            }
        }
    }
}

