/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.csharp;

import java.util.List;
import java.util.function.UnaryOperator;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.Tree;
import org.openrewrite.csharp.CSharpVisitor;
import org.openrewrite.csharp.marker.OmitBraces;
import org.openrewrite.csharp.marker.SingleExpressionBlock;
import org.openrewrite.csharp.tree.Cs;
import org.openrewrite.csharp.tree.CsContainer;
import org.openrewrite.csharp.tree.CsLeftPadded;
import org.openrewrite.csharp.tree.CsRightPadded;
import org.openrewrite.csharp.tree.CsSpace;
import org.openrewrite.java.JavaPrinter;
import org.openrewrite.java.marker.CompactConstructor;
import org.openrewrite.java.marker.Semicolon;
import org.openrewrite.java.marker.TrailingComma;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;

public class CSharpPrinter<P>
extends CSharpVisitor<PrintOutputCapture<P>> {
    private final CSharpJavaPrinter delegate = new CSharpJavaPrinter();
    private static final UnaryOperator<String> JAVA_MARKER_WRAPPER = out -> "/*~~" + out + (out.isEmpty() ? "" : "~~") + ">*/";

    public J visit(@Nullable Tree tree, PrintOutputCapture<P> p) {
        if (!(tree instanceof Cs)) {
            return this.delegate.visit(tree, p);
        }
        return (J)super.visit(tree, p);
    }

    @Override
    public J visitOperatorDeclaration(Cs.OperatorDeclaration node, PrintOutputCapture<P> p) {
        String operator;
        switch (node.getOperatorToken()) {
            case Plus: {
                operator = "+";
                break;
            }
            case Minus: {
                operator = "-";
                break;
            }
            case Bang: {
                operator = "!";
                break;
            }
            case Tilde: {
                operator = "~";
                break;
            }
            case PlusPlus: {
                operator = "++";
                break;
            }
            case MinusMinus: {
                operator = "--";
                break;
            }
            case Star: {
                operator = "*";
                break;
            }
            case Division: {
                operator = "/";
                break;
            }
            case Percent: {
                operator = "%";
                break;
            }
            case LeftShift: {
                operator = "<<";
                break;
            }
            case RightShift: {
                operator = ">>";
                break;
            }
            case LessThan: {
                operator = "<";
                break;
            }
            case GreaterThan: {
                operator = ">";
                break;
            }
            case LessThanEquals: {
                operator = "<=";
                break;
            }
            case GreaterThanEquals: {
                operator = ">=";
                break;
            }
            case Equals: {
                operator = "==";
                break;
            }
            case NotEquals: {
                operator = "!=";
                break;
            }
            case Ampersand: {
                operator = "&";
                break;
            }
            case Bar: {
                operator = "|";
                break;
            }
            case Caret: {
                operator = "^";
                break;
            }
            case True: {
                operator = "true";
                break;
            }
            case False: {
                operator = "false";
                break;
            }
            default: {
                throw new IllegalStateException("OperatorToken does not have a valid value");
            }
        }
        this.beforeSyntax((J)node, CsSpace.Location.POINTER_TYPE_PREFIX, p);
        this.visit(node.getAttributeLists(), p);
        this.visit(node.getModifiers(), p);
        this.visitRightPadded(node.getPadding().getExplicitInterfaceSpecifier(), CsRightPadded.Location.OPERATOR_DECLARATION_EXPLICIT_INTERFACE_SPECIFIER, ".", p);
        this.visit((Tree)node.getReturnType(), p);
        this.visit((Tree)node.getOperatorKeyword(), p);
        this.visit((Tree)node.getCheckedKeyword(), p);
        this.visitSpace(node.getPadding().getOperatorToken().getBefore(), CsSpace.Location.OPERATOR_DECLARATION_OPERATOR_TOKEN, p);
        p.append(operator);
        this.visitContainer("(", node.getPadding().getParameters(), CsContainer.Location.OPERATOR_DECLARATION_PARAMETERS, ",", ")", p);
        this.visit((Tree)node.getBody(), p);
        this.afterSyntax(node, p);
        return node;
    }

    @Override
    public J visitPointerType(Cs.PointerType node, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)node, CsSpace.Location.POINTER_TYPE_PREFIX, p);
        this.visitRightPadded(node.getPadding().getElementType(), CsRightPadded.Location.POINTER_TYPE_ELEMENT_TYPE, "*", p);
        this.afterSyntax(node, p);
        return node;
    }

    public Cs visitTry(Cs.Try tryable, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)tryable, Space.Location.TRY_PREFIX, p);
        p.append("try");
        this.visit((Tree)tryable.getBody(), p);
        this.visit(tryable.getCatches(), p);
        this.visitLeftPadded("finally", tryable.getPadding().getFinally(), CsLeftPadded.Location.TRY_FINALLIE, p);
        this.afterSyntax(tryable, p);
        return tryable;
    }

    public Cs visitTryCatch(Cs.Try.Catch catch_, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)catch_, Space.Location.CATCH_PREFIX, p);
        p.append("catch");
        if (((J.VariableDeclarations)catch_.getParameter().getTree()).getTypeExpression() != null) {
            this.visit((Tree)catch_.getParameter(), p);
        }
        this.visitLeftPadded("when", catch_.getPadding().getFilterExpression(), CsLeftPadded.Location.TRY_CATCH_FILTER_EXPRESSION, p);
        this.visit((Tree)catch_.getBody(), p);
        this.afterSyntax(catch_, p);
        return catch_;
    }

    public Cs visitArrayType(Cs.ArrayType newArray, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)newArray, CsSpace.Location.ARRAY_TYPE_PREFIX, p);
        this.visit((Tree)newArray.getTypeExpression(), p);
        this.visit(newArray.getDimensions(), p);
        this.afterSyntax(newArray, p);
        return newArray;
    }

    @Override
    public J visitAliasQualifiedName(Cs.AliasQualifiedName node, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)node, CsSpace.Location.ALIAS_QUALIFIED_NAME_PREFIX, p);
        this.visitRightPadded(node.getPadding().getAlias(), CsRightPadded.Location.ALIAS_QUALIFIED_NAME_ALIAS, p);
        p.append("::");
        this.visit((Tree)node.getName(), p);
        this.afterSyntax(node, p);
        return node;
    }

    @Override
    public J visitTypeParameter(Cs.TypeParameter node, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)node, CsSpace.Location.TYPE_PARAMETER_PREFIX, p);
        this.visit(node.getAttributeLists(), p);
        this.visitLeftPaddedEnum(node.getPadding().getVariance(), CsLeftPadded.Location.TYPE_PARAMETER_VARIANCE, p);
        this.visit((Tree)node.getName(), p);
        this.afterSyntax(node, p);
        return node;
    }

    @Override
    public J visitQueryExpression(Cs.QueryExpression node, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)node, CsSpace.Location.QUERY_EXPRESSION_PREFIX, p);
        this.visit((Tree)node.getFromClause(), p);
        this.visit((Tree)node.getBody(), p);
        this.afterSyntax(node, p);
        return node;
    }

    @Override
    public J visitQueryContinuation(Cs.QueryContinuation node, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)node, CsSpace.Location.QUERY_CONTINUATION_PREFIX, p);
        p.append("into");
        this.visit((Tree)node.getIdentifier(), p);
        this.visit((Tree)node.getBody(), p);
        this.afterSyntax(node, p);
        return node;
    }

    @Override
    public J visitFromClause(Cs.FromClause node, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)node, CsSpace.Location.FROM_CLAUSE_PREFIX, p);
        p.append("from");
        this.visit((Tree)node.getTypeIdentifier(), p);
        this.visitRightPadded(node.getPadding().getIdentifier(), CsRightPadded.Location.FROM_CLAUSE_IDENTIFIER, p);
        p.append("in");
        this.visit((Tree)node.getExpression(), p);
        this.afterSyntax(node, p);
        return node;
    }

    @Override
    public J visitQueryBody(Cs.QueryBody node, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)node, CsSpace.Location.QUERY_BODY_PREFIX, p);
        for (J j : node.getClauses()) {
            this.visit((Tree)j, p);
        }
        this.visit((Tree)node.getSelectOrGroup(), p);
        this.visit((Tree)node.getContinuation(), p);
        this.afterSyntax(node, p);
        return node;
    }

    @Override
    public J visitLetClause(Cs.LetClause node, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)node, CsSpace.Location.LET_CLAUSE_PREFIX, p);
        p.append("let");
        this.visitRightPadded(node.getPadding().getIdentifier(), CsRightPadded.Location.LET_CLAUSE_IDENTIFIER, p);
        p.append("=");
        this.visit((Tree)node.getExpression(), p);
        this.afterSyntax(node, p);
        return node;
    }

    @Override
    public J visitJoinClause(Cs.JoinClause node, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)node, CsSpace.Location.JOIN_CLAUSE_PREFIX, p);
        p.append("join");
        this.visitRightPadded(node.getPadding().getIdentifier(), CsRightPadded.Location.JOIN_CLAUSE_IDENTIFIER, p);
        p.append("in");
        this.visitRightPadded(node.getPadding().getInExpression(), CsRightPadded.Location.JOIN_CLAUSE_IN_EXPRESSION, p);
        p.append("on");
        this.visitRightPadded(node.getPadding().getLeftExpression(), CsRightPadded.Location.JOIN_CLAUSE_LEFT_EXPRESSION, p);
        p.append("equals");
        this.visit((Tree)node.getRightExpression(), p);
        this.visit((Tree)node.getInto(), p);
        this.afterSyntax(node, p);
        return node;
    }

    @Override
    public J visitWhereClause(Cs.WhereClause node, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)node, CsSpace.Location.WHERE_CLAUSE_PREFIX, p);
        p.append("where");
        this.visit((Tree)node.getCondition(), p);
        this.afterSyntax(node, p);
        return node;
    }

    @Override
    public J visitJoinIntoClause(Cs.JoinIntoClause node, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)node, CsSpace.Location.JOIN_INTO_CLAUSE_PREFIX, p);
        p.append("into");
        this.visit((Tree)node.getIdentifier(), p);
        this.afterSyntax(node, p);
        return node;
    }

    @Override
    public J visitOrderByClause(Cs.OrderByClause node, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)node, CsSpace.Location.JOIN_INTO_CLAUSE_PREFIX, p);
        p.append("orderby");
        this.visitRightPadded(node.getPadding().getOrderings(), CsRightPadded.Location.ORDER_BY_CLAUSE_ORDERINGS, ",", p);
        this.afterSyntax(node, p);
        return node;
    }

    @Override
    public J visitForEachVariableLoop(Cs.ForEachVariableLoop forEachLoop, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)forEachLoop, Space.Location.FOR_EACH_LOOP_PREFIX, p);
        p.append("foreach");
        Cs.ForEachVariableLoop.Control ctrl = forEachLoop.getControlElement();
        this.visitSpace(ctrl.getPrefix(), Space.Location.FOR_EACH_CONTROL_PREFIX, p);
        p.append('(');
        this.visitRightPadded(ctrl.getPadding().getVariable(), CsRightPadded.Location.FOR_EACH_VARIABLE_LOOP_CONTROL_VARIABLE, "in", p);
        this.visitRightPadded(ctrl.getPadding().getIterable(), CsRightPadded.Location.FOR_EACH_VARIABLE_LOOP_CONTROL_ITERABLE, "", p);
        p.append(')');
        this.visitStatement(forEachLoop.getPadding().getBody(), CsRightPadded.Location.FOR_EACH_VARIABLE_LOOP_BODY, p);
        this.afterSyntax(forEachLoop, p);
        return forEachLoop;
    }

    public Cs visitGroupClause(Cs.GroupClause node, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)node, CsSpace.Location.GROUP_CLAUSE_PREFIX, p);
        p.append("group");
        this.visitRightPadded(node.getPadding().getGroupExpression(), CsRightPadded.Location.GROUP_CLAUSE_GROUP_EXPRESSION, "by", p);
        this.visit((Tree)node.getKey(), p);
        this.afterSyntax(node, p);
        return node;
    }

    @Override
    public J visitSelectClause(Cs.SelectClause node, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)node, CsSpace.Location.SELECT_CLAUSE_PREFIX, p);
        p.append("select");
        this.visit((Tree)node.getExpression(), p);
        this.afterSyntax(node, p);
        return node;
    }

    @Override
    public J visitOrdering(Cs.Ordering node, PrintOutputCapture<P> p) {
        String direction = null;
        if (node.getDirection() != null) {
            direction = node.getDirection().toString().toLowerCase();
        }
        this.beforeSyntax((J)node, CsSpace.Location.ORDERING_PREFIX, p);
        this.visitRightPadded(node.getPadding().getExpression(), CsRightPadded.Location.ORDERING_EXPRESSION, p);
        p.append(direction);
        this.afterSyntax(node, p);
        return node;
    }

    protected <T extends J> void visitRightPadded(@Nullable JRightPadded<T> rightPadded, CsRightPadded.Location location, @Nullable String suffix, PrintOutputCapture<P> p) {
        if (rightPadded != null) {
            this.beforeSyntax(Space.EMPTY, rightPadded.getMarkers(), (CsSpace.Location)null, p);
            this.visit((Tree)rightPadded.getElement(), p);
            this.afterSyntax(rightPadded.getMarkers(), p);
            this.visitSpace(rightPadded.getAfter(), location.getAfterLocation(), p);
            if (suffix != null) {
                p.append(suffix);
            }
        }
    }

    @Override
    public J visitSwitchExpression(Cs.SwitchExpression node, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)node, CsSpace.Location.SWITCH_EXPRESSION_PREFIX, p);
        this.visitRightPadded(node.getPadding().getExpression(), CsRightPadded.Location.SWITCH_EXPRESSION_EXPRESSION, p);
        p.append("switch");
        this.visitContainer("{", node.getPadding().getArms(), CsContainer.Location.SWITCH_EXPRESSION_ARMS, ",", "}", p);
        this.afterSyntax(node, p);
        return node;
    }

    @Override
    public J visitSwitchStatement(Cs.SwitchStatement node, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)node, CsSpace.Location.SWITCH_STATEMENT_PREFIX, p);
        p.append("switch");
        this.visitContainer("(", node.getPadding().getExpression(), CsContainer.Location.SWITCH_STATEMENT_EXPRESSION, ",", ")", p);
        this.visitContainer("{", node.getPadding().getSections(), CsContainer.Location.SWITCH_STATEMENT_SECTIONS, "", "}", p);
        this.afterSyntax(node, p);
        return node;
    }

    @Override
    public J visitSwitchSection(Cs.SwitchSection node, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)node, CsSpace.Location.SWITCH_SECTION_PREFIX, p);
        this.visit(node.getLabels(), p);
        this.visitStatements(node.getPadding().getStatements(), CsRightPadded.Location.SWITCH_SECTION_STATEMENTS, p);
        this.afterSyntax(node, p);
        return node;
    }

    @Override
    public J visitUnsafeStatement(Cs.UnsafeStatement node, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)node, CsSpace.Location.UNSAFE_STATEMENT_PREFIX, p);
        p.append("unsafe");
        this.visit((Tree)node.getBlock(), p);
        this.afterSyntax(node, p);
        return node;
    }

    @Override
    public J visitCheckedExpression(Cs.CheckedExpression node, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)node, CsSpace.Location.CHECKED_EXPRESSION_PREFIX, p);
        this.visit((Tree)node.getCheckedOrUncheckedKeyword(), p);
        this.visit((Tree)node.getExpression(), p);
        this.afterSyntax(node, p);
        return node;
    }

    @Override
    public J visitCheckedStatement(Cs.CheckedStatement node, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)node, CsSpace.Location.CHECKED_STATEMENT_PREFIX, p);
        this.visit((Tree)node.getKeyword(), p);
        this.visit((Tree)node.getBlock(), p);
        this.afterSyntax(node, p);
        return node;
    }

    @Override
    public J visitRefExpression(Cs.RefExpression node, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)node, CsSpace.Location.REF_EXPRESSION_PREFIX, p);
        p.append("ref");
        this.visit((Tree)node.getExpression(), p);
        this.afterSyntax(node, p);
        return node;
    }

    @Override
    public J visitRefType(Cs.RefType node, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)node, CsSpace.Location.REF_TYPE_PREFIX, p);
        p.append("ref");
        this.visit((Tree)node.getReadonlyKeyword(), p);
        this.visit((Tree)node.getTypeIdentifier(), p);
        this.afterSyntax(node, p);
        return node;
    }

    @Override
    public J visitRangeExpression(Cs.RangeExpression node, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)node, CsSpace.Location.RANGE_EXPRESSION_PREFIX, p);
        this.visitRightPadded(node.getPadding().getStart(), CsRightPadded.Location.RANGE_EXPRESSION_START, p);
        p.append("..");
        this.visit((Tree)node.getEnd(), p);
        this.afterSyntax(node, p);
        return node;
    }

    @Override
    public J visitFixedStatement(Cs.FixedStatement node, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)node, CsSpace.Location.FIXED_STATEMENT_PREFIX, p);
        p.append("fixed");
        this.visit((Tree)node.getDeclarations(), p);
        this.visit((Tree)node.getBlock(), p);
        this.afterSyntax(node, p);
        return node;
    }

    @Override
    public J visitLockStatement(Cs.LockStatement node, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)node, CsSpace.Location.LOCK_STATEMENT_PREFIX, p);
        p.append("lock");
        this.visit((Tree)node.getExpression(), p);
        this.visitStatement(node.getPadding().getStatement(), CsRightPadded.Location.LOCK_STATEMENT_STATEMENT, p);
        this.afterSyntax(node, p);
        return node;
    }

    @Override
    public J visitCasePatternSwitchLabel(Cs.CasePatternSwitchLabel node, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)node, CsSpace.Location.CASE_PATTERN_SWITCH_LABEL_PREFIX, p);
        p.append("case");
        this.visit((Tree)node.getPattern(), p);
        this.visitLeftPadded("when", node.getPadding().getWhenClause(), CsLeftPadded.Location.CASE_PATTERN_SWITCH_LABEL_WHEN_CLAUSE, p);
        this.visitSpace(node.getColonToken(), CsSpace.Location.CASE_PATTERN_SWITCH_LABEL_COLON_TOKEN, p);
        p.append(":");
        this.afterSyntax(node, p);
        return node;
    }

    @Override
    public J visitDefaultSwitchLabel(Cs.DefaultSwitchLabel node, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)node, CsSpace.Location.DEFAULT_SWITCH_LABEL_PREFIX, p);
        p.append("default");
        this.visitSpace(node.getColonToken(), CsSpace.Location.CASE_PATTERN_SWITCH_LABEL_COLON_TOKEN, p);
        p.append(":");
        this.afterSyntax(node, p);
        return node;
    }

    @Override
    public J visitSwitchExpressionArm(Cs.SwitchExpressionArm node, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)node, CsSpace.Location.SWITCH_EXPRESSION_ARM_PREFIX, p);
        this.visit((Tree)node.getPattern(), p);
        this.visitLeftPadded("when", node.getPadding().getWhenExpression(), CsLeftPadded.Location.SWITCH_EXPRESSION_ARM_WHEN_EXPRESSION, p);
        this.visitLeftPadded("=>", node.getPadding().getExpression(), CsLeftPadded.Location.SWITCH_EXPRESSION_ARM_EXPRESSION, p);
        this.afterSyntax(node, p);
        return node;
    }

    @Override
    public J visitDefaultExpression(Cs.DefaultExpression node, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)node, CsSpace.Location.YIELD_PREFIX, p);
        p.append("default");
        if (node.getTypeOperator() != null) {
            this.visitContainer("(", node.getPadding().getTypeOperator(), CsContainer.Location.DEFAULT_EXPRESSION_TYPE_OPERATOR, "", ")", p);
        }
        this.afterSyntax(node, p);
        return node;
    }

    @Override
    public J visitYield(Cs.Yield node, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)node, CsSpace.Location.YIELD_PREFIX, p);
        p.append("yield");
        this.visitKeyword(node.getReturnOrBreakKeyword(), p);
        this.visit((Tree)node.getExpression(), p);
        this.afterSyntax(node, p);
        return node;
    }

    @Override
    public J visitImplicitElementAccess(Cs.ImplicitElementAccess node, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)node, CsSpace.Location.IMPLICIT_ELEMENT_ACCESS_PREFIX, p);
        this.visitContainer("[", node.getPadding().getArgumentList(), CsContainer.Location.IMPLICIT_ELEMENT_ACCESS_ARGUMENT_LIST, ",", "]", p);
        this.afterSyntax(node, p);
        return node;
    }

    public Cs visitTupleExpression(Cs.TupleExpression tupleExpression, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)tupleExpression, CsSpace.Location.TUPLE_EXPRESSION_PREFIX, p);
        this.visitContainer("(", tupleExpression.getPadding().getArguments(), CsContainer.Location.TUPLE_EXPRESSION_ARGUMENTS, ",", ")", p);
        this.afterSyntax(tupleExpression, p);
        return tupleExpression;
    }

    public Cs visitTupleType(Cs.TupleType node, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)node, CsSpace.Location.TUPLE_TYPE_PREFIX, p);
        this.visitContainer("(", node.getPadding().getElements(), CsContainer.Location.TUPLE_TYPE_ELEMENTS, ",", ")", p);
        this.afterSyntax(node, p);
        return node;
    }

    public Cs visitTupleElement(Cs.TupleElement node, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)node, CsSpace.Location.TUPLE_ELEMENT_PREFIX, p);
        this.visit((Tree)node.getType(), p);
        if (node.getName() != null) {
            this.visit((Tree)node.getName(), p);
        }
        this.afterSyntax(node, p);
        return node;
    }

    public Cs visitParenthesizedVariableDesignation(Cs.ParenthesizedVariableDesignation node, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)node, CsSpace.Location.PARENTHESIZED_VARIABLE_DESIGNATION_VARIABLES, p);
        this.visitContainer("(", node.getPadding().getVariables(), CsContainer.Location.PARENTHESIZED_VARIABLE_DESIGNATION_VARIABLES, ",", ")", p);
        this.afterSyntax(node, p);
        return node;
    }

    @Override
    public J visitArgument(Cs.Argument argument, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)argument, CsSpace.Location.ARGUMENT_PREFIX, p);
        Cs.Argument.Padding padding = argument.getPadding();
        if (argument.getNameColumn() != null) {
            this.visitRightPadded(padding.getNameColumn(), CsRightPadded.Location.ARGUMENT_NAME_COLUMN, p);
            p.append(':');
        }
        if (argument.getRefKindKeyword() != null) {
            this.visit((Tree)argument.getRefKindKeyword(), p);
        }
        this.visit((Tree)argument.getExpression(), p);
        this.afterSyntax(argument, p);
        return argument;
    }

    public Cs visitKeyword(Cs.Keyword keyword, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)keyword, CsSpace.Location.KEYWORD_PREFIX, p);
        p.append(keyword.getKind().toString().toLowerCase());
        this.afterSyntax(keyword, p);
        return keyword;
    }

    @Override
    public J visitBinaryPattern(Cs.BinaryPattern node, PrintOutputCapture<P> p) {
        String operator;
        switch (node.getOperator()) {
            case And: {
                operator = "and";
                break;
            }
            case Or: {
                operator = "or";
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.beforeSyntax((J)node, CsSpace.Location.BINARY_PATTERN_PREFIX, p);
        this.visit((Tree)node.getLeft(), p);
        this.visitSpace(node.getPadding().getOperator().getBefore(), CsSpace.Location.BINARY_PATTERN_OPERATOR, p);
        p.append(operator);
        this.visit((Tree)node.getRight(), p);
        this.afterSyntax(node, p);
        return node;
    }

    @Override
    public J visitConstantPattern(Cs.ConstantPattern node, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)node, CsSpace.Location.CONSTANT_PATTERN_PREFIX, p);
        this.visit((Tree)node.getValue(), p);
        this.afterSyntax(node, p);
        return node;
    }

    @Override
    public J visitDiscardPattern(Cs.DiscardPattern node, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)node, CsSpace.Location.DISCARD_PATTERN_PREFIX, p);
        p.append("_");
        this.afterSyntax(node, p);
        return node;
    }

    @Override
    public J visitListPattern(Cs.ListPattern node, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)node, CsSpace.Location.LIST_PATTERN_PREFIX, p);
        this.visitContainer("[", node.getPadding().getPatterns(), CsContainer.Location.LIST_PATTERN_PATTERNS, ",", "]", p);
        this.visit((Tree)node.getDesignation(), p);
        this.afterSyntax(node, p);
        return node;
    }

    @Override
    public J visitParenthesizedPattern(Cs.ParenthesizedPattern node, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)node, CsSpace.Location.PARENTHESIZED_PATTERN_PREFIX, p);
        this.visitContainer("(", node.getPadding().getPattern(), CsContainer.Location.PARENTHESIZED_PATTERN_PREFIX, ",", ")", p);
        this.afterSyntax(node, p);
        return node;
    }

    @Override
    public J visitRecursivePattern(Cs.RecursivePattern node, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)node, CsSpace.Location.RECURSIVE_PATTERN_PREFIX, p);
        this.visit((Tree)node.getTypeQualifier(), p);
        this.visit((Tree)node.getPositionalPattern(), p);
        this.visit((Tree)node.getPropertyPattern(), p);
        this.visit((Tree)node.getDesignation(), p);
        this.afterSyntax(node, p);
        return node;
    }

    @Override
    public J visitRelationalPattern(Cs.RelationalPattern node, PrintOutputCapture<P> p) {
        String operator;
        switch (node.getOperator()) {
            case LessThan: {
                operator = "<";
                break;
            }
            case LessThanOrEqual: {
                operator = "<=";
                break;
            }
            case GreaterThan: {
                operator = ">";
                break;
            }
            case GreaterThanOrEqual: {
                operator = ">=";
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.beforeSyntax((J)node, CsSpace.Location.RELATIONAL_PATTERN_PREFIX, p);
        this.visitSpace(node.getPadding().getOperator().getBefore(), CsSpace.Location.RELATIONAL_PATTERN_OPERATOR, p);
        p.append(operator);
        this.visit((Tree)node.getValue(), p);
        this.afterSyntax(node, p);
        return node;
    }

    @Override
    public J visitSlicePattern(Cs.SlicePattern node, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)node, CsSpace.Location.SLICE_PATTERN_PREFIX, p);
        p.append("..");
        this.afterSyntax(node, p);
        return node;
    }

    @Override
    public J visitTypePattern(Cs.TypePattern node, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)node, CsSpace.Location.TYPE_PATTERN_PREFIX, p);
        this.visit((Tree)node.getTypeIdentifier(), p);
        this.visit((Tree)node.getDesignation(), p);
        this.afterSyntax(node, p);
        return node;
    }

    @Override
    public J visitVarPattern(Cs.VarPattern node, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)node, CsSpace.Location.VAR_PATTERN_PREFIX, p);
        p.append("var");
        this.visit((Tree)node.getDesignation(), p);
        this.afterSyntax(node, p);
        return node;
    }

    @Override
    public J visitPositionalPatternClause(Cs.PositionalPatternClause node, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)node, CsSpace.Location.POSITIONAL_PATTERN_CLAUSE_PREFIX, p);
        this.visitContainer("(", node.getPadding().getSubpatterns(), CsContainer.Location.POSITIONAL_PATTERN_CLAUSE_SUBPATTERNS, ",", ")", p);
        this.afterSyntax(node, p);
        return node;
    }

    @Override
    public J visitPropertyPatternClause(Cs.PropertyPatternClause node, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)node, CsSpace.Location.PROPERTY_PATTERN_CLAUSE_PREFIX, p);
        this.visitContainer("{", node.getPadding().getSubpatterns(), CsContainer.Location.PROPERTY_PATTERN_CLAUSE_SUBPATTERNS, ",", "}", p);
        this.afterSyntax(node, p);
        return node;
    }

    @Override
    public J visitIsPattern(Cs.IsPattern node, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)node, CsSpace.Location.IS_PATTERN_PREFIX, p);
        this.visit((Tree)node.getExpression(), p);
        this.visitSpace(node.getPadding().getPattern().getBefore(), CsSpace.Location.IS_PATTERN_PATTERN, p);
        p.append("is");
        this.visit((Tree)node.getPattern(), p);
        this.afterSyntax(node, p);
        return node;
    }

    @Override
    public J visitSubpattern(Cs.Subpattern node, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)node, CsSpace.Location.SUBPATTERN_PREFIX, p);
        if (node.getName() != null) {
            this.visit((Tree)node.getName(), p);
            this.visitSpace(node.getPadding().getPattern().getBefore(), CsSpace.Location.SUBPATTERN_PATTERN, p);
            p.append(":");
        }
        this.visit((Tree)node.getPattern(), p);
        this.afterSyntax(node, p);
        return node;
    }

    @Override
    public J visitDiscardVariableDesignation(Cs.DiscardVariableDesignation node, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)node, CsSpace.Location.IS_PATTERN_PREFIX, p);
        this.visit((Tree)node.getDiscard(), p);
        this.afterSyntax(node, p);
        return node;
    }

    @Override
    public J visitSingleVariableDesignation(Cs.SingleVariableDesignation node, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)node, CsSpace.Location.SINGLE_VARIABLE_DESIGNATION_PREFIX, p);
        this.visit((Tree)node.getName(), p);
        this.afterSyntax(node, p);
        return node;
    }

    @Override
    public J visitUsingStatement(Cs.UsingStatement usingStatement, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)usingStatement, CsSpace.Location.NAMED_ARGUMENT_PREFIX, p);
        if (usingStatement.getAwaitKeyword() != null) {
            this.visit((Tree)usingStatement.getAwaitKeyword(), p);
        }
        this.visitLeftPadded("using", usingStatement.getPadding().getExpression(), CsLeftPadded.Location.USING_STATEMENT_EXPRESSION, p);
        this.visit((Tree)usingStatement.getStatement(), p);
        this.afterSyntax(usingStatement, p);
        return usingStatement;
    }

    @Override
    public J visitUnary(Cs.Unary unary, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)unary, Space.Location.UNARY_PREFIX, p);
        switch (unary.getOperator()) {
            case FromEnd: {
                p.append("^");
                this.visit((Tree)unary.getExpression(), p);
                break;
            }
            case PointerIndirection: {
                p.append("*");
                this.visit((Tree)unary.getExpression(), p);
                break;
            }
            case PointerType: {
                this.visit((Tree)unary.getExpression(), p);
                p.append("*");
                break;
            }
            case AddressOf: {
                p.append("&");
                this.visit((Tree)unary.getExpression(), p);
                break;
            }
            case SuppressNullableWarning: {
                this.visit((Tree)unary.getExpression(), p);
                p.append("!");
            }
        }
        this.afterSyntax(unary, p);
        return unary;
    }

    @Override
    public J visitAccessorDeclaration(Cs.AccessorDeclaration node, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)node, CsSpace.Location.ACCESSOR_DECLARATION_PREFIX, p);
        this.visit(node.getAttributes(), p);
        this.visit(node.getModifiers(), p);
        this.visitLeftPaddedEnum(node.getPadding().getKind(), CsLeftPadded.Location.ACCESSOR_DECLARATION_KIND, p);
        this.visit((Tree)node.getExpressionBody(), p);
        this.visit((Tree)node.getBody(), p);
        this.afterSyntax(node, p);
        return node;
    }

    @Override
    public J visitArrowExpressionClause(Cs.ArrowExpressionClause node, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)node, CsSpace.Location.ARROW_EXPRESSION_CLAUSE_PREFIX, p);
        p.append("=>");
        this.visitRightPadded(node.getPadding().getExpression(), CsRightPadded.Location.ARROW_EXPRESSION_CLAUSE_EXPRESSION, ";", p);
        this.afterSyntax(node, p);
        return node;
    }

    @Override
    public J visitStackAllocExpression(Cs.StackAllocExpression node, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)node, CsSpace.Location.STACK_ALLOC_EXPRESSION_PREFIX, p);
        p.append("stackalloc");
        J.NewArray newArray = node.getExpression();
        this.visitSpace(newArray.getPrefix(), Space.Location.NEW_ARRAY_INITIALIZER, p);
        this.visit((Tree)newArray.getTypeExpression(), p);
        this.visit(newArray.getDimensions(), p);
        this.visitContainer("{", (JContainer<J>)newArray.getPadding().getInitializer(), CsContainer.Location.ANY, ",", "}", p);
        this.afterSyntax(node, p);
        return node;
    }

    public Cs visitPointerFieldAccess(Cs.PointerFieldAccess node, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)node, CsSpace.Location.POINTER_FIELD_ACCESS_PREFIX, p);
        this.visit((Tree)node.getTarget(), p);
        this.visitLeftPadded("->", node.getPadding().getName(), CsLeftPadded.Location.POINTER_FIELD_ACCESS_NAME, p);
        this.afterSyntax(node, p);
        return node;
    }

    @Override
    public J visitGotoStatement(Cs.GotoStatement node, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)node, CsSpace.Location.GOTO_STATEMENT_PREFIX, p);
        p.append("goto");
        this.visit((Tree)node.getCaseOrDefaultKeyword(), p);
        this.visit((Tree)node.getTarget(), p);
        return node;
    }

    @Override
    public J visitEventDeclaration(Cs.EventDeclaration node, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)node, CsSpace.Location.EVENT_DECLARATION_PREFIX, p);
        this.visit(node.getAttributeLists(), p);
        this.visit(node.getModifiers(), p);
        this.visitLeftPadded("event", node.getPadding().getTypeExpression(), CsLeftPadded.Location.EVENT_DECLARATION_TYPE_EXPRESSION, p);
        this.visitRightPadded(node.getPadding().getInterfaceSpecifier(), CsRightPadded.Location.EVENT_DECLARATION_INTERFACE_SPECIFIER, ".", p);
        this.visit((Tree)node.getName(), p);
        this.visitContainer("{", node.getPadding().getAccessors(), CsContainer.Location.EVENT_DECLARATION_ACCESSORS, "", "}", p);
        return node;
    }

    public Cs visitCompilationUnit(Cs.CompilationUnit compilationUnit, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)compilationUnit, Space.Location.COMPILATION_UNIT_PREFIX, p);
        for (JRightPadded<Cs.ExternAlias> jRightPadded : compilationUnit.getPadding().getExterns()) {
            this.visitRightPadded(jRightPadded, CsRightPadded.Location.COMPILATION_UNIT_EXTERNS, p);
            p.append(';');
        }
        for (JRightPadded jRightPadded : compilationUnit.getPadding().getUsings()) {
            this.visitRightPadded(jRightPadded, CsRightPadded.Location.COMPILATION_UNIT_USINGS, p);
            p.append(';');
        }
        for (Cs.AttributeList attributeList : compilationUnit.getAttributeLists()) {
            this.visit((Tree)attributeList, p);
        }
        this.visitStatements(compilationUnit.getPadding().getMembers(), CsRightPadded.Location.COMPILATION_UNIT_MEMBERS, p);
        this.visitSpace(compilationUnit.getEof(), Space.Location.COMPILATION_UNIT_EOF, p);
        this.afterSyntax(compilationUnit, p);
        return compilationUnit;
    }

    @Override
    public J visitClassDeclaration(Cs.ClassDeclaration node, PrintOutputCapture<P> p) {
        String kind = "";
        switch (node.getPadding().getKind().getType()) {
            case Class: 
            case Annotation: {
                kind = "class";
                break;
            }
            case Enum: {
                kind = "enum";
                break;
            }
            case Interface: {
                kind = "interface";
                break;
            }
            case Record: {
                kind = "record";
                break;
            }
            case Value: {
                kind = "struct";
            }
        }
        this.beforeSyntax((J)node, Space.Location.CLASS_DECLARATION_PREFIX, p);
        this.visit(node.getAttributeList(), p);
        this.visit(node.getModifiers(), p);
        this.visitSpace(node.getPadding().getKind().getPrefix(), Space.Location.CLASS_KIND, p);
        p.append(kind);
        this.visit((Tree)node.getName(), p);
        this.visitContainer("<", node.getPadding().getTypeParameters(), CsContainer.Location.CLASS_DECLARATION_TYPE_PARAMETERS, ",", ">", p);
        this.visitContainer("(", node.getPadding().getPrimaryConstructor(), CsContainer.Location.CLASS_DECLARATION_PRIMARY_CONSTRUCTOR, ",", ")", p);
        this.visitLeftPadded(":", node.getPadding().getExtendings(), CsLeftPadded.Location.CLASS_DECLARATION_EXTENDINGS, p);
        this.visitContainer(node.getPadding().getExtendings() == null ? ":" : ",", node.getPadding().getImplementings(), CsContainer.Location.CLASS_DECLARATION_IMPLEMENTINGS, ",", "", p);
        this.visitContainer("", node.getPadding().getTypeParameterConstraintClauses(), CsContainer.Location.CLASS_DECLARATION_TYPE_PARAMETERS, "", "", p);
        this.visit((Tree)node.getBody(), p);
        this.afterSyntax(node, p);
        return node;
    }

    @Override
    public J visitMethodDeclaration(Cs.MethodDeclaration node, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)node, Space.Location.METHOD_DECLARATION_PREFIX, p);
        this.visit(node.getAttributes(), p);
        this.visit(node.getModifiers(), p);
        this.visit((Tree)node.getReturnTypeExpression(), p);
        this.visitRightPadded(node.getPadding().getExplicitInterfaceSpecifier(), CsRightPadded.Location.METHOD_DECLARATION_EXPLICIT_INTERFACE_SPECIFIER, ".", p);
        this.visit((Tree)node.getName(), p);
        this.visitContainer("<", node.getPadding().getTypeParameters(), CsContainer.Location.METHOD_DECLARATION_TYPE_PARAMETERS, ",", ">", p);
        if (!node.getMarkers().findFirst(CompactConstructor.class).isPresent()) {
            this.visitContainer("(", node.getPadding().getParameters(), CsContainer.Location.METHOD_DECLARATION_PARAMETERS, ",", ")", p);
        }
        this.visitContainer(node.getPadding().getTypeParameterConstraintClauses(), CsContainer.Location.METHOD_DECLARATION_TYPE_PARAMETER_CONSTRAINT_CLAUSES, p);
        this.visit((Tree)node.getBody(), p);
        this.afterSyntax(node, p);
        return node;
    }

    @Override
    public J visitAnnotatedStatement(Cs.AnnotatedStatement node, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)node, CsSpace.Location.ANNOTATED_STATEMENT_PREFIX, p);
        for (Cs.AttributeList attributeList : node.getAttributeLists()) {
            this.visit((Tree)attributeList, p);
        }
        this.visit((Tree)node.getStatement(), p);
        this.afterSyntax(node, p);
        return node;
    }

    @Override
    public J visitAttributeList(Cs.AttributeList attributeList, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)attributeList, CsSpace.Location.ATTRIBUTE_LIST_PREFIX, p);
        p.append('[');
        Cs.AttributeList.Padding padding = attributeList.getPadding();
        if (padding.getTarget() != null) {
            this.visitRightPadded(padding.getTarget(), CsRightPadded.Location.ATTRIBUTE_LIST_TARGET, p);
            p.append(':');
        }
        this.visitRightPadded(padding.getAttributes(), CsRightPadded.Location.ATTRIBUTE_LIST_ATTRIBUTES, ",", p);
        p.append(']');
        this.afterSyntax(attributeList, p);
        return attributeList;
    }

    @Override
    public J visitArrayRankSpecifier(Cs.ArrayRankSpecifier arrayRankSpecifier, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)arrayRankSpecifier, CsSpace.Location.ARRAY_RANK_SPECIFIER_PREFIX, p);
        this.visitContainer("", arrayRankSpecifier.getPadding().getSizes(), CsContainer.Location.ARRAY_RANK_SPECIFIER_SIZES, ",", "", p);
        this.afterSyntax(arrayRankSpecifier, p);
        return arrayRankSpecifier;
    }

    @Override
    public J visitAssignmentOperation(Cs.AssignmentOperation assignmentOperation, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)assignmentOperation, CsSpace.Location.ASSIGNMENT_OPERATION_PREFIX, p);
        this.visit((Tree)assignmentOperation.getVariable(), p);
        this.visitLeftPadded(assignmentOperation.getPadding().getOperator(), CsLeftPadded.Location.ASSIGNMENT_OPERATION_OPERATOR, p);
        if (assignmentOperation.getOperator() == Cs.AssignmentOperation.OperatorType.NullCoalescing) {
            p.append("??=");
        }
        this.visit((Tree)assignmentOperation.getAssignment(), p);
        this.afterSyntax(assignmentOperation, p);
        return assignmentOperation;
    }

    @Override
    public J visitAwaitExpression(Cs.AwaitExpression awaitExpression, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)awaitExpression, CsSpace.Location.AWAIT_EXPRESSION_PREFIX, p);
        p.append("await");
        this.visit((Tree)awaitExpression.getExpression(), p);
        this.afterSyntax(awaitExpression, p);
        return awaitExpression;
    }

    @Override
    public J visitBinary(Cs.Binary binary, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)binary, CsSpace.Location.BINARY_PREFIX, p);
        this.visit((Tree)binary.getLeft(), p);
        this.visitSpace(binary.getPadding().getOperator().getBefore(), Space.Location.BINARY_OPERATOR, p);
        if (binary.getOperator() == Cs.Binary.OperatorType.As) {
            p.append("as");
        } else if (binary.getOperator() == Cs.Binary.OperatorType.NullCoalescing) {
            p.append("??");
        }
        this.visit((Tree)binary.getRight(), p);
        this.afterSyntax(binary, p);
        return binary;
    }

    public Cs visitBlockScopeNamespaceDeclaration(Cs.BlockScopeNamespaceDeclaration namespaceDeclaration, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)namespaceDeclaration, CsSpace.Location.BLOCK_SCOPE_NAMESPACE_DECLARATION_PREFIX, p);
        p.append("namespace");
        this.visitRightPadded(namespaceDeclaration.getPadding().getName(), CsRightPadded.Location.BLOCK_SCOPE_NAMESPACE_DECLARATION_NAME, p);
        p.append('{');
        for (JRightPadded<Cs.ExternAlias> jRightPadded : namespaceDeclaration.getPadding().getExterns()) {
            this.visitRightPadded(jRightPadded, CsRightPadded.Location.COMPILATION_UNIT_EXTERNS, p);
            p.append(';');
        }
        for (JRightPadded jRightPadded : namespaceDeclaration.getPadding().getUsings()) {
            this.visitRightPadded(jRightPadded, CsRightPadded.Location.BLOCK_SCOPE_NAMESPACE_DECLARATION_USINGS, p);
            p.append(';');
        }
        this.visitStatements(namespaceDeclaration.getPadding().getMembers(), CsRightPadded.Location.BLOCK_SCOPE_NAMESPACE_DECLARATION_MEMBERS, p);
        this.visitSpace(namespaceDeclaration.getEnd(), CsSpace.Location.BLOCK_SCOPE_NAMESPACE_DECLARATION_END, p);
        p.append('}');
        this.afterSyntax(namespaceDeclaration, p);
        return namespaceDeclaration;
    }

    @Override
    public J visitCollectionExpression(Cs.CollectionExpression collectionExpression, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)collectionExpression, CsSpace.Location.COLLECTION_EXPRESSION_PREFIX, p);
        p.append('[');
        this.visitRightPadded(collectionExpression.getPadding().getElements(), CsRightPadded.Location.COLLECTION_EXPRESSION_ELEMENTS, ",", p);
        p.append(']');
        this.afterSyntax(collectionExpression, p);
        return collectionExpression;
    }

    @Override
    public J visitEnumDeclaration(Cs.EnumDeclaration node, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)node, CsSpace.Location.ENUM_DECLARATION_PREFIX, p);
        this.visit(node.getAttributeLists(), p);
        this.visit(node.getModifiers(), p);
        this.visitLeftPadded("enum", node.getPadding().getName(), CsLeftPadded.Location.ENUM_DECLARATION_NAME, p);
        if (node.getBaseType() != null) {
            this.visitLeftPadded(":", node.getPadding().getBaseType(), CsLeftPadded.Location.ENUM_DECLARATION_BASE_TYPE, p);
        }
        this.visitContainer("{", node.getPadding().getMembers(), CsContainer.Location.ENUM_DECLARATION_MEMBERS, ",", "}", p);
        this.afterSyntax(node, p);
        return node;
    }

    @Override
    public J visitExpressionStatement(Cs.ExpressionStatement expressionStatement, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)expressionStatement, CsSpace.Location.AWAIT_EXPRESSION_PREFIX, p);
        this.visitRightPadded(expressionStatement.getPadding().getExpression(), CsRightPadded.Location.EXPRESSION_STATEMENT_EXPRESSION, p);
        p.append(";");
        this.afterSyntax(expressionStatement, p);
        return expressionStatement;
    }

    @Override
    public J visitExternAlias(Cs.ExternAlias externAlias, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)externAlias, CsSpace.Location.EXTERN_ALIAS_PREFIX, p);
        p.append("extern");
        this.visitLeftPadded("alias", externAlias.getPadding().getIdentifier(), CsLeftPadded.Location.EXTERN_ALIAS_IDENTIFIER, p);
        this.afterSyntax(externAlias, p);
        return externAlias;
    }

    public Cs visitFileScopeNamespaceDeclaration(Cs.FileScopeNamespaceDeclaration namespaceDeclaration, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)namespaceDeclaration, CsSpace.Location.FILE_SCOPE_NAMESPACE_DECLARATION_PREFIX, p);
        p.append("namespace");
        this.visitRightPadded(namespaceDeclaration.getPadding().getName(), CsRightPadded.Location.FILE_SCOPE_NAMESPACE_DECLARATION_NAME, p);
        p.append(";");
        for (JRightPadded<Cs.ExternAlias> jRightPadded : namespaceDeclaration.getPadding().getExterns()) {
            this.visitRightPadded(jRightPadded, CsRightPadded.Location.COMPILATION_UNIT_EXTERNS, p);
            p.append(';');
        }
        for (JRightPadded jRightPadded : namespaceDeclaration.getPadding().getUsings()) {
            this.visitRightPadded(jRightPadded, CsRightPadded.Location.FILE_SCOPE_NAMESPACE_DECLARATION_USINGS, p);
            p.append(';');
        }
        this.visitStatements(namespaceDeclaration.getPadding().getMembers(), CsRightPadded.Location.FILE_SCOPE_NAMESPACE_DECLARATION_MEMBERS, p);
        return namespaceDeclaration;
    }

    @Override
    public J visitInterpolatedString(Cs.InterpolatedString interpolatedString, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)interpolatedString, CsSpace.Location.INTERPOLATED_STRING_PREFIX, p);
        p.append(interpolatedString.getStart());
        this.visitRightPadded(interpolatedString.getPadding().getParts(), CsRightPadded.Location.INTERPOLATED_STRING_PARTS, "", p);
        p.append(interpolatedString.getEnd());
        this.afterSyntax(interpolatedString, p);
        return interpolatedString;
    }

    @Override
    public J visitInterpolation(Cs.Interpolation interpolation, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)interpolation, CsSpace.Location.INTERPOLATION_PREFIX, p);
        p.append('{');
        this.visitRightPadded(interpolation.getPadding().getExpression(), CsRightPadded.Location.INTERPOLATION_EXPRESSION, p);
        if (interpolation.getAlignment() != null) {
            p.append(',');
            this.visitRightPadded(interpolation.getPadding().getAlignment(), CsRightPadded.Location.INTERPOLATION_ALIGNMENT, p);
        }
        if (interpolation.getFormat() != null) {
            p.append(':');
            this.visitRightPadded(interpolation.getPadding().getFormat(), CsRightPadded.Location.INTERPOLATION_FORMAT, p);
        }
        p.append('}');
        this.afterSyntax(interpolation, p);
        return interpolation;
    }

    @Override
    public J visitNullSafeExpression(Cs.NullSafeExpression nullSafeExpression, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)nullSafeExpression, CsSpace.Location.NULL_SAFE_EXPRESSION_PREFIX, p);
        this.visitRightPadded(nullSafeExpression.getPadding().getExpression(), CsRightPadded.Location.NULL_SAFE_EXPRESSION_EXPRESSION, p);
        p.append("?");
        this.afterSyntax(nullSafeExpression, p);
        return nullSafeExpression;
    }

    @Override
    public J visitPropertyDeclaration(Cs.PropertyDeclaration propertyDeclaration, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)propertyDeclaration, CsSpace.Location.PROPERTY_DECLARATION_PREFIX, p);
        this.visit(propertyDeclaration.getAttributeLists(), p);
        this.visit(propertyDeclaration.getModifiers(), p);
        this.visit((Tree)propertyDeclaration.getTypeExpression(), p);
        this.visitRightPadded(propertyDeclaration.getPadding().getInterfaceSpecifier(), CsRightPadded.Location.PROPERTY_DECLARATION_INTERFACE_SPECIFIER, ".", p);
        this.visit((Tree)propertyDeclaration.getName(), p);
        this.visit((Tree)propertyDeclaration.getAccessors(), p);
        this.visit((Tree)propertyDeclaration.getExpressionBody(), p);
        this.visitLeftPadded("=", propertyDeclaration.getPadding().getInitializer(), CsLeftPadded.Location.PROPERTY_DECLARATION_INITIALIZER, p);
        this.afterSyntax(propertyDeclaration, p);
        return propertyDeclaration;
    }

    @Override
    public J visitUsingDirective(Cs.UsingDirective usingDirective, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)usingDirective, CsSpace.Location.USING_DIRECTIVE_PREFIX, p);
        if (usingDirective.isGlobal()) {
            p.append("global");
            this.visitRightPadded(usingDirective.getPadding().getGlobal(), CsRightPadded.Location.USING_DIRECTIVE_GLOBAL, p);
        }
        p.append("using");
        if (usingDirective.isStatic()) {
            this.visitLeftPadded(usingDirective.getPadding().getStatic(), CsLeftPadded.Location.USING_DIRECTIVE_STATIC, p);
            p.append("static");
        } else if (usingDirective.getAlias() != null) {
            if (usingDirective.isUnsafe()) {
                this.visitLeftPadded(usingDirective.getPadding().getUnsafe(), CsLeftPadded.Location.USING_DIRECTIVE_UNSAFE, p);
                p.append("unsafe");
            }
            this.visitRightPadded(usingDirective.getPadding().getAlias(), CsRightPadded.Location.USING_DIRECTIVE_ALIAS, p);
            p.append('=');
        }
        this.visit((Tree)usingDirective.getNamespaceOrType(), p);
        this.afterSyntax(usingDirective, p);
        return usingDirective;
    }

    @Override
    public J visitConversionOperatorDeclaration(Cs.ConversionOperatorDeclaration node, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)node, CsSpace.Location.CONVERSION_OPERATOR_DECLARATION_PREFIX, p);
        for (J j : node.getModifiers()) {
            this.visit((Tree)j, p);
        }
        this.visitLeftPadded(node.getPadding().getKind(), CsLeftPadded.Location.CONVERSION_OPERATOR_DECLARATION_KIND, p);
        p.append(node.getKind().toString().toLowerCase());
        this.visitLeftPadded("operator", node.getPadding().getReturnType(), CsLeftPadded.Location.CONVERSION_OPERATOR_DECLARATION_RETURN_TYPE, p);
        this.visitContainer("(", node.getPadding().getParameters(), CsContainer.Location.CONVERSION_OPERATOR_DECLARATION_PARAMETERS, ",", ")", p);
        this.visit((Tree)node.getExpressionBody(), p);
        this.visit((Tree)node.getBody(), p);
        this.afterSyntax(node, p);
        return node;
    }

    @Override
    public J visitEnumMemberDeclaration(Cs.EnumMemberDeclaration node, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)node, CsSpace.Location.ENUM_MEMBER_DECLARATION_PREFIX, p);
        this.visit(node.getAttributeLists(), p);
        this.visit((Tree)node.getName(), p);
        this.visitLeftPadded("=", node.getPadding().getInitializer(), CsLeftPadded.Location.ENUM_MEMBER_DECLARATION_INITIALIZER, p);
        this.afterSyntax(node, p);
        return node;
    }

    @Override
    public J visitIndexerDeclaration(Cs.IndexerDeclaration node, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)node, CsSpace.Location.INDEXER_DECLARATION_PREFIX, p);
        for (J j : node.getModifiers()) {
            this.visit((Tree)j, p);
        }
        this.visit((Tree)node.getTypeExpression(), p);
        this.visitRightPadded(node.getPadding().getExplicitInterfaceSpecifier(), CsRightPadded.Location.INDEXER_DECLARATION_EXPLICIT_INTERFACE_SPECIFIER, ".", p);
        this.visit((Tree)node.getIndexer(), p);
        this.visitContainer("[", node.getPadding().getParameters(), CsContainer.Location.INDEXER_DECLARATION_PARAMETERS, ",", "]", p);
        this.visitLeftPadded("", node.getPadding().getExpressionBody(), CsLeftPadded.Location.INDEXER_DECLARATION_EXPRESSION_BODY, p);
        this.visit((Tree)node.getAccessors(), p);
        this.afterSyntax(node, p);
        return node;
    }

    @Override
    public J visitDelegateDeclaration(Cs.DelegateDeclaration node, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)node, CsSpace.Location.DELEGATE_DECLARATION_PREFIX, p);
        this.visit(node.getAttributes(), p);
        this.visit(node.getModifiers(), p);
        this.visitLeftPadded("delegate", node.getPadding().getReturnType(), CsLeftPadded.Location.DELEGATE_DECLARATION_RETURN_TYPE, p);
        this.visit((Tree)node.getIdentifier(), p);
        this.visitContainer("<", node.getPadding().getTypeParameters(), CsContainer.Location.CONVERSION_OPERATOR_DECLARATION_PARAMETERS, ",", ">", p);
        this.visitContainer("(", node.getPadding().getParameters(), CsContainer.Location.CONVERSION_OPERATOR_DECLARATION_PARAMETERS, ",", ")", p);
        this.visitContainer(node.getPadding().getTypeParameterConstraintClauses(), CsContainer.Location.DELEGATE_DECLARATION_TYPE_PARAMETER_CONSTRAINT_CLAUSES, p);
        this.afterSyntax(node, p);
        return node;
    }

    @Override
    public J visitDestructorDeclaration(Cs.DestructorDeclaration node, PrintOutputCapture<P> p) {
        J.MethodDeclaration method = node.getMethodCore();
        this.beforeSyntax((J)method, CsSpace.Location.DESTRUCTOR_DECLARATION_PREFIX, p);
        this.visitSpace(Space.EMPTY, Space.Location.ANNOTATIONS, p);
        this.visit(method.getLeadingAnnotations(), p);
        for (J.Modifier modifier : method.getModifiers()) {
            this.delegate.visit((Tree)modifier, p);
        }
        this.visit(method.getAnnotations().getName().getAnnotations(), p);
        p.append("~");
        this.visit((Tree)method.getName(), p);
        this.visitContainer("(", (JContainer<J>)method.getPadding().getParameters(), CsContainer.Location.METHOD_DECLARATION_PARAMETERS, ",", ")", p);
        this.visit((Tree)method.getBody(), p);
        this.afterSyntax(node, p);
        return node;
    }

    public Cs visitConstructor(Cs.Constructor constructor, PrintOutputCapture<P> p) {
        J.MethodDeclaration method = constructor.getConstructorCore();
        this.beforeSyntax((J)method, Space.Location.METHOD_DECLARATION_PREFIX, p);
        this.visitSpace(Space.EMPTY, Space.Location.ANNOTATIONS, p);
        this.visit(method.getLeadingAnnotations(), p);
        for (J.Modifier modifier : method.getModifiers()) {
            this.delegate.visit((Tree)modifier, p);
        }
        this.visit(method.getAnnotations().getName().getAnnotations(), p);
        this.visit((Tree)method.getName(), p);
        if (!method.getMarkers().findFirst(CompactConstructor.class).isPresent()) {
            this.visitContainer("(", (JContainer<J>)method.getPadding().getParameters(), CsContainer.Location.METHOD_DECLARATION_PARAMETERS, ",", ")", p);
        }
        this.visit((Tree)constructor.getInitializer(), p);
        this.visit((Tree)method.getBody(), p);
        this.afterSyntax(constructor, p);
        return constructor;
    }

    public Cs visitConstructorInitializer(Cs.ConstructorInitializer node, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)node, Space.Location.METHOD_DECLARATION_PREFIX, p);
        p.append(":");
        this.visit((Tree)node.getKeyword(), p);
        this.visitContainer("(", node.getPadding().getArguments(), CsContainer.Location.CONSTRUCTOR_INITIALIZER_ARGUMENTS, ",", ")", p);
        this.afterSyntax(node, p);
        return node;
    }

    public Cs visitLambda(Cs.Lambda lambda, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)lambda, Space.Location.LAMBDA_PREFIX, p);
        J.Lambda javaLambda = lambda.getLambdaExpression();
        this.visitMarkers(lambda.getMarkers(), p);
        this.visit(lambda.getModifiers(), p);
        this.visit((Tree)lambda.getReturnType(), p);
        this.visit((Tree)javaLambda, p);
        this.afterSyntax(lambda, p);
        return lambda;
    }

    @Override
    public Space visitSpace(Space space, CsSpace.Location loc, PrintOutputCapture<P> p) {
        return this.delegate.visitSpace(space, Space.Location.LANGUAGE_EXTENSION, p);
    }

    public Space visitSpace(Space space, Space.Location loc, PrintOutputCapture<P> p) {
        return this.delegate.visitSpace(space, loc, p);
    }

    protected void visitLeftPaddedEnum(@Nullable JLeftPadded<? extends Enum> leftPadded, CsLeftPadded.Location location, PrintOutputCapture<P> p) {
        if (leftPadded == null) {
            return;
        }
        this.visitLeftPadded(leftPadded, location, p);
        p.append(((Enum)leftPadded.getElement()).toString().toLowerCase());
    }

    protected void visitLeftPadded(@Nullable String prefix, @Nullable JLeftPadded<? extends J> leftPadded, CsLeftPadded.Location location, PrintOutputCapture<P> p) {
        if (leftPadded != null) {
            this.beforeSyntax(leftPadded.getBefore(), leftPadded.getMarkers(), location.getBeforeLocation(), p);
            if (prefix != null) {
                p.append(prefix);
            }
            this.visit((Tree)leftPadded.getElement(), p);
            this.afterSyntax(leftPadded.getMarkers(), p);
        }
    }

    protected void visitContainer(@Nullable String before, @Nullable JContainer<? extends J> container, CsContainer.Location location, String suffixBetween, @Nullable String after, PrintOutputCapture<P> p) {
        if (container == null) {
            return;
        }
        this.visitSpace(container.getBefore(), location.getBeforeLocation(), p);
        p.append(before);
        this.visitRightPadded(container.getPadding().getElements(), location.getElementLocation(), suffixBetween, p);
        p.append(after);
    }

    protected void visitRightPadded(List<? extends JRightPadded<? extends J>> nodes, CsRightPadded.Location location, String suffixBetween, PrintOutputCapture<P> p) {
        for (int i = 0; i < nodes.size(); ++i) {
            JRightPadded<? extends J> node = nodes.get(i);
            this.visit((Tree)node.getElement(), p);
            this.visitSpace(node.getAfter(), location.getAfterLocation(), p);
            this.visitMarkers(node.getMarkers(), p);
            if (i >= nodes.size() - 1) continue;
            p.append(suffixBetween);
        }
    }

    protected void visitStatements(@Nullable String before, @Nullable JContainer<Statement> container, CsContainer.Location location, @Nullable String after, PrintOutputCapture<P> p) {
        if (container == null) {
            return;
        }
        this.visitSpace(container.getBefore(), location.getBeforeLocation(), p);
        p.append(before);
        this.visitStatements(container.getPadding().getElements(), location.getElementLocation(), p);
        p.append(after);
    }

    protected void visitStatements(List<JRightPadded<Statement>> statements, CsRightPadded.Location location, PrintOutputCapture<P> p) {
        for (JRightPadded<Statement> paddedStat : statements) {
            this.visitStatement(paddedStat, location, p);
        }
    }

    protected void visitStatement(@Nullable JRightPadded<Statement> paddedStat, CsRightPadded.Location location, PrintOutputCapture<P> p) {
        if (paddedStat == null) {
            return;
        }
        this.visit((Tree)paddedStat.getElement(), p);
        this.visitSpace(paddedStat.getAfter(), location.getAfterLocation(), p);
        this.visitMarkers(paddedStat.getMarkers(), p);
        if (this.getCursor().getParent().getValue() instanceof J.Block && this.getCursor().getParent().getParent().getValue() instanceof J.NewClass) {
            p.append(',');
            return;
        }
        this.delegate.printStatementTerminator((Statement)paddedStat.getElement(), p);
    }

    @Override
    public J visitTypeParameterConstraintClause(Cs.TypeParameterConstraintClause typeParameterConstraintClause, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)typeParameterConstraintClause, CsSpace.Location.TYPE_PARAMETERS_CONSTRAINT_CLAUSE_PREFIX, p);
        p.append("where");
        this.visitRightPadded(typeParameterConstraintClause.getPadding().getTypeParameter(), CsRightPadded.Location.TYPE_PARAMETER_CONSTRAINT_CLAUSE_TYPE_PARAMETER, p);
        p.append(":");
        this.visitContainer("", typeParameterConstraintClause.getPadding().getTypeParameterConstraints(), CsContainer.Location.TYPE_PARAMETER_CONSTRAINT_CLAUSE_TYPE_CONSTRAINTS, ",", "", p);
        this.afterSyntax(typeParameterConstraintClause, p);
        return typeParameterConstraintClause;
    }

    @Override
    public J visitClassOrStructConstraint(Cs.ClassOrStructConstraint classOrStructConstraint, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)classOrStructConstraint, CsSpace.Location.TYPE_PARAMETERS_CONSTRAINT_PREFIX, p);
        p.append(classOrStructConstraint.getKind() == Cs.ClassOrStructConstraint.TypeKind.Class ? "class" : "struct");
        return classOrStructConstraint;
    }

    @Override
    public J visitConstructorConstraint(Cs.ConstructorConstraint constructorConstraint, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)constructorConstraint, CsSpace.Location.TYPE_PARAMETERS_CONSTRAINT_PREFIX, p);
        p.append("new()");
        return constructorConstraint;
    }

    @Override
    public J visitDefaultConstraint(Cs.DefaultConstraint defaultConstraint, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)defaultConstraint, CsSpace.Location.TYPE_PARAMETERS_CONSTRAINT_PREFIX, p);
        p.append("default");
        return defaultConstraint;
    }

    @Override
    public J visitInitializerExpression(Cs.InitializerExpression node, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)node, Space.Location.BLOCK_PREFIX, p);
        this.visitContainer("{", node.getPadding().getExpressions(), CsContainer.Location.INITIALIZER_EXPRESSION_EXPRESSIONS, ",", "}", p);
        this.afterSyntax(node, p);
        return node;
    }

    public <M extends Marker> M visitMarker(Marker marker, PrintOutputCapture<P> p) {
        return this.delegate.visitMarker(marker, p);
    }

    private void beforeSyntax(J j, Space.Location loc, PrintOutputCapture<P> p) {
        this.beforeSyntax(j.getPrefix(), j.getMarkers(), loc, p);
    }

    private void beforeSyntax(J j, CsSpace.Location loc, PrintOutputCapture<P> p) {
        this.beforeSyntax(j.getPrefix(), j.getMarkers(), loc, p);
    }

    private void beforeSyntax(Space prefix, Markers markers,  @Nullable CsSpace.Location loc, PrintOutputCapture<P> p) {
        for (Marker marker : markers.getMarkers()) {
            p.append(p.getMarkerPrinter().beforePrefix(marker, new Cursor(this.getCursor(), (Object)marker), JAVA_MARKER_WRAPPER));
        }
        if (loc != null) {
            this.visitSpace(prefix, loc, p);
        }
        this.visitMarkers(markers, p);
        for (Marker marker : markers.getMarkers()) {
            p.append(p.getMarkerPrinter().beforeSyntax(marker, new Cursor(this.getCursor(), (Object)marker), JAVA_MARKER_WRAPPER));
        }
    }

    private void beforeSyntax(Space prefix, Markers markers, // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable Space.Location loc, PrintOutputCapture<P> p) {
        for (Marker marker : markers.getMarkers()) {
            p.append(p.getMarkerPrinter().beforePrefix(marker, new Cursor(this.getCursor(), (Object)marker), JAVA_MARKER_WRAPPER));
        }
        if (loc != null) {
            this.visitSpace(prefix, loc, p);
        }
        this.visitMarkers(markers, p);
        for (Marker marker : markers.getMarkers()) {
            p.append(p.getMarkerPrinter().beforeSyntax(marker, new Cursor(this.getCursor(), (Object)marker), JAVA_MARKER_WRAPPER));
        }
    }

    private void afterSyntax(Cs g, PrintOutputCapture<P> p) {
        this.afterSyntax(g.getMarkers(), p);
    }

    private void afterSyntax(Markers markers, PrintOutputCapture<P> p) {
        for (Marker marker : markers.getMarkers()) {
            p.append(p.getMarkerPrinter().afterSyntax(marker, new Cursor(this.getCursor(), (Object)marker), JAVA_MARKER_WRAPPER));
        }
    }

    private class CSharpJavaPrinter
    extends JavaPrinter<P> {
        private CSharpJavaPrinter() {
        }

        public @Nullable J preVisit(@NonNull J tree, PrintOutputCapture<P> pPrintOutputCapture) {
            return (J)CSharpPrinter.this.preVisit((Tree)tree, pPrintOutputCapture);
        }

        public @Nullable J postVisit(@NonNull J tree, PrintOutputCapture<P> pPrintOutputCapture) {
            return (J)CSharpPrinter.this.postVisit((Tree)tree, pPrintOutputCapture);
        }

        public J visit(@Nullable Tree tree, PrintOutputCapture<P> p) {
            if (tree instanceof Cs) {
                return CSharpPrinter.this.visit(tree, p);
            }
            return (J)super.visit(tree, p);
        }

        public J visitNewArray(J.NewArray newArray, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)newArray, Space.Location.NEW_ARRAY_PREFIX, p);
            p.append("new");
            this.visit((Tree)newArray.getTypeExpression(), p);
            this.visit(newArray.getDimensions(), p);
            this.visitContainer("{", newArray.getPadding().getInitializer(), JContainer.Location.NEW_ARRAY_INITIALIZER, ",", "}", p);
            this.afterSyntax((J)newArray, p);
            return newArray;
        }

        public J visitImport(J.Import import_, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)import_, Space.Location.IMPORT_PREFIX, p);
            p.append("using");
            if (import_.isStatic()) {
                this.visitSpace(import_.getPadding().getStatic().getBefore(), Space.Location.STATIC_IMPORT, p);
                p.append("static");
            }
            this.visit((Tree)import_.getQualid(), p);
            this.afterSyntax((J)import_, p);
            return import_;
        }

        public J visitPackage(J.Package pkg, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)pkg, Space.Location.PACKAGE_PREFIX, p);
            p.append("namespace");
            this.visit((Tree)pkg.getExpression(), p);
            this.afterSyntax((J)pkg, p);
            return pkg;
        }

        public J visitClassDeclaration(J.ClassDeclaration classDecl, PrintOutputCapture<P> p) {
            Object parent = CSharpPrinter.this.getCursor().getValue();
            J csParent = parent instanceof J ? (J)parent : null;
            Cs.ClassDeclaration csClassDeclaration = csParent instanceof Cs.ClassDeclaration ? (Cs.ClassDeclaration)csParent : null;
            String kind = "";
            switch (classDecl.getPadding().getKind().getType()) {
                case Class: 
                case Annotation: {
                    kind = "class";
                    break;
                }
                case Enum: {
                    kind = "enum";
                    break;
                }
                case Interface: {
                    kind = "interface";
                    break;
                }
                case Record: {
                    kind = "record";
                    break;
                }
                case Value: {
                    kind = "struct";
                }
            }
            this.beforeSyntax((J)classDecl, Space.Location.CLASS_DECLARATION_PREFIX, p);
            this.visitSpace(Space.EMPTY, Space.Location.ANNOTATIONS, p);
            this.visit(classDecl.getLeadingAnnotations(), p);
            for (J.Modifier m : classDecl.getModifiers()) {
                this.visit((Tree)m, p);
            }
            this.visit(classDecl.getPadding().getKind().getAnnotations(), p);
            this.visitSpace(classDecl.getPadding().getKind().getPrefix(), Space.Location.CLASS_KIND, p);
            p.append(kind);
            this.visit((Tree)classDecl.getName(), p);
            this.visitContainer("<", classDecl.getPadding().getTypeParameters(), JContainer.Location.TYPE_PARAMETERS, ",", ">", p);
            this.visitContainer("(", classDecl.getPadding().getPrimaryConstructor(), JContainer.Location.RECORD_STATE_VECTOR, ",", ")", p);
            this.visitLeftPadded(":", classDecl.getPadding().getExtends(), JLeftPadded.Location.EXTENDS, p);
            this.visitContainer(classDecl.getPadding().getExtends() == null ? ":" : ",", classDecl.getPadding().getImplements(), JContainer.Location.IMPLEMENTS, ",", null, p);
            this.visitContainer("permits", classDecl.getPadding().getPermits(), JContainer.Location.PERMITS, ",", null, p);
            if (csClassDeclaration != null) {
                for (Cs.TypeParameterConstraintClause typeParameterClause : csClassDeclaration.getTypeParameterConstraintClauses()) {
                    CSharpPrinter.this.visit((Tree)typeParameterClause, p);
                }
            }
            this.visit((Tree)classDecl.getBody(), p);
            this.afterSyntax((J)classDecl, p);
            return classDecl;
        }

        public J visitAnnotation(J.Annotation annotation, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)annotation, Space.Location.ANNOTATION_PREFIX, p);
            p.append("[");
            this.visit((Tree)annotation.getAnnotationType(), p);
            this.visitContainer("(", annotation.getPadding().getArguments(), JContainer.Location.ANNOTATION_ARGUMENTS, ",", ")", p);
            p.append("]");
            this.afterSyntax((J)annotation, p);
            return annotation;
        }

        public J visitBlock(J.Block block, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)block, Space.Location.BLOCK_PREFIX, p);
            if (block.isStatic()) {
                p.append("static");
                this.visitRightPadded(block.getPadding().getStatic(), JRightPadded.Location.STATIC_INIT, p);
            }
            if (block.getMarkers().findFirst(SingleExpressionBlock.class).isPresent()) {
                p.append("=>");
                JRightPadded statement = (JRightPadded)block.getPadding().getStatements().get(0);
                if (statement.getElement() instanceof Cs.ExpressionStatement) {
                    this.visit((Tree)statement.getElement(), p);
                } else {
                    this.visitRightPadded(statement, JRightPadded.Location.BLOCK_STATEMENT, ";", p);
                }
            } else if (!block.getMarkers().findFirst(OmitBraces.class).isPresent()) {
                p.append('{');
                this.visitStatements(block.getPadding().getStatements(), JRightPadded.Location.BLOCK_STATEMENT, p);
                this.visitSpace(block.getEnd(), Space.Location.BLOCK_END, p);
                p.append('}');
            } else {
                if (!block.getStatements().isEmpty()) {
                    this.visitStatements(block.getPadding().getStatements(), JRightPadded.Location.BLOCK_STATEMENT, p);
                } else {
                    p.append(";");
                }
                this.visitSpace(block.getEnd(), Space.Location.BLOCK_END, p);
            }
            this.afterSyntax((J)block, p);
            return block;
        }

        protected void visitStatements(List<JRightPadded<Statement>> statements, JRightPadded.Location location, PrintOutputCapture<P> p) {
            for (int i = 0; i < statements.size(); ++i) {
                JRightPadded<Statement> paddedStat = statements.get(i);
                this.visitStatement(paddedStat, location, p);
                if (i >= statements.size() - 1 || (this.getCursor().getParent() == null || !(this.getCursor().getParent().getValue() instanceof J.NewClass)) && (this.getCursor().getParent() == null || !(this.getCursor().getParent().getValue() instanceof J.Block) || this.getCursor().getParent(2) == null || !(this.getCursor().getParent(2).getValue() instanceof J.NewClass))) continue;
                p.append(',');
            }
        }

        public J visitMethodDeclaration(J.MethodDeclaration method, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)method, Space.Location.METHOD_DECLARATION_PREFIX, p);
            this.visitSpace(Space.EMPTY, Space.Location.ANNOTATIONS, p);
            this.visit(method.getLeadingAnnotations(), p);
            for (J.Modifier m : method.getModifiers()) {
                this.visit((Tree)m, p);
            }
            this.visit((Tree)method.getReturnTypeExpression(), p);
            this.visit(method.getAnnotations().getName().getAnnotations(), p);
            this.visit((Tree)method.getName(), p);
            J.TypeParameters typeParameters = method.getAnnotations().getTypeParameters();
            if (typeParameters != null) {
                this.visit(typeParameters.getAnnotations(), p);
                this.visitSpace(typeParameters.getPrefix(), Space.Location.TYPE_PARAMETERS, p);
                this.visitMarkers(typeParameters.getMarkers(), p);
                p.append('<');
                this.visitRightPadded(typeParameters.getPadding().getTypeParameters(), JRightPadded.Location.TYPE_PARAMETER, ",", p);
                p.append('>');
            }
            if (!method.getMarkers().findFirst(CompactConstructor.class).isPresent()) {
                this.visitContainer("(", method.getPadding().getParameters(), JContainer.Location.METHOD_DECLARATION_PARAMETERS, ",", ")", p);
            }
            this.visitContainer("throws", method.getPadding().getThrows(), JContainer.Location.THROWS, ",", null, p);
            this.visit((Tree)method.getBody(), p);
            this.visitLeftPadded("default", method.getPadding().getDefaultValue(), JLeftPadded.Location.METHOD_DECLARATION_DEFAULT_VALUE, p);
            this.afterSyntax((J)method, p);
            return method;
        }

        public J visitMethodInvocation(J.MethodInvocation method, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)method, Space.Location.METHOD_INVOCATION_PREFIX, p);
            String prefix = !method.getSimpleName().isEmpty() ? "." : "";
            this.visitRightPadded(method.getPadding().getSelect(), JRightPadded.Location.METHOD_SELECT, prefix, p);
            this.visit((Tree)method.getName(), p);
            this.visitContainer("<", method.getPadding().getTypeParameters(), JContainer.Location.TYPE_PARAMETERS, ",", ">", p);
            this.visitContainer("(", method.getPadding().getArguments(), JContainer.Location.METHOD_INVOCATION_ARGUMENTS, ",", ")", p);
            this.afterSyntax((J)method, p);
            return method;
        }

        public J visitCatch(J.Try.Catch catch_, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)catch_, Space.Location.CATCH_PREFIX, p);
            p.append("catch");
            if (((J.VariableDeclarations)catch_.getParameter().getTree()).getTypeExpression() != null) {
                this.visit((Tree)catch_.getParameter(), p);
            }
            this.visit((Tree)catch_.getBody(), p);
            this.afterSyntax((J)catch_, p);
            return catch_;
        }

        public J visitForEachLoop(J.ForEachLoop forEachLoop, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)forEachLoop, Space.Location.FOR_EACH_LOOP_PREFIX, p);
            p.append("foreach");
            J.ForEachLoop.Control ctrl = forEachLoop.getControl();
            this.visitSpace(ctrl.getPrefix(), Space.Location.FOR_EACH_CONTROL_PREFIX, p);
            p.append('(');
            this.visitRightPadded(ctrl.getPadding().getVariable(), JRightPadded.Location.FOREACH_VARIABLE, "in", p);
            this.visitRightPadded(ctrl.getPadding().getIterable(), JRightPadded.Location.FOREACH_ITERABLE, "", p);
            p.append(')');
            this.visitStatement(forEachLoop.getPadding().getBody(), JRightPadded.Location.FOR_BODY, p);
            this.afterSyntax((J)forEachLoop, p);
            return forEachLoop;
        }

        public J visitInstanceOf(J.InstanceOf instanceOf, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)instanceOf, Space.Location.INSTANCEOF_PREFIX, p);
            this.visitRightPadded(instanceOf.getPadding().getExpression(), JRightPadded.Location.INSTANCEOF, "is", p);
            this.visit((Tree)instanceOf.getClazz(), p);
            this.visit((Tree)instanceOf.getPattern(), p);
            this.afterSyntax((J)instanceOf, p);
            return instanceOf;
        }

        public J visitLambda(J.Lambda lambda, PrintOutputCapture<P> p) {
            this.beforeSyntax((J)lambda, Space.Location.LAMBDA_PREFIX, p);
            this.visitSpace(lambda.getParameters().getPrefix(), Space.Location.LAMBDA_PARAMETERS_PREFIX, p);
            this.visitMarkers(lambda.getParameters().getMarkers(), p);
            if (lambda.getParameters().isParenthesized()) {
                p.append('(');
                this.visitRightPadded(lambda.getParameters().getPadding().getParameters(), JRightPadded.Location.LAMBDA_PARAM, ",", p);
                p.append(')');
            } else {
                this.visitRightPadded(lambda.getParameters().getPadding().getParameters(), JRightPadded.Location.LAMBDA_PARAM, ",", p);
            }
            this.visitSpace(lambda.getArrow(), Space.Location.LAMBDA_ARROW_PREFIX, p);
            p.append("=>");
            this.visit((Tree)lambda.getBody(), p);
            this.afterSyntax((J)lambda, p);
            return lambda;
        }

        public J visitPrimitive(J.Primitive primitive, PrintOutputCapture<P> p) {
            String keyword;
            switch (primitive.getType()) {
                case Boolean: {
                    keyword = "bool";
                    break;
                }
                case Byte: {
                    keyword = "byte";
                    break;
                }
                case Char: {
                    keyword = "char";
                    break;
                }
                case Double: {
                    keyword = "double";
                    break;
                }
                case Float: {
                    keyword = "float";
                    break;
                }
                case Int: {
                    keyword = "int";
                    break;
                }
                case Long: {
                    keyword = "long";
                    break;
                }
                case Short: {
                    keyword = "short";
                    break;
                }
                case Void: {
                    keyword = "void";
                    break;
                }
                case String: {
                    keyword = "string";
                    break;
                }
                case None: {
                    throw new IllegalStateException("Unable to print None primitive");
                }
                case Null: {
                    throw new IllegalStateException("Unable to print Null primitive");
                }
                default: {
                    throw new IllegalStateException("Unable to print non-primitive type");
                }
            }
            this.beforeSyntax((J)primitive, Space.Location.PRIMITIVE_PREFIX, p);
            p.append(keyword);
            this.afterSyntax((J)primitive, p);
            return primitive;
        }

        public J visitEnumValueSet(J.EnumValueSet enums, PrintOutputCapture<P> p) {
            return super.visitEnumValueSet(enums, p);
        }

        public <M extends Marker> M visitMarker(Marker marker, PrintOutputCapture<P> p) {
            if (marker instanceof Semicolon) {
                p.append(';');
            } else if (marker instanceof TrailingComma) {
                p.append(',');
                this.visitSpace(((TrailingComma)marker).getSuffix(), Space.Location.LANGUAGE_EXTENSION, p);
            }
            return (M)marker;
        }

        protected void printStatementTerminator(Statement s, PrintOutputCapture<P> p) {
            Cs.UsingStatement usingStatement;
            Statement usingBody;
            J.ForEachLoop loop;
            Cs.AwaitExpression awaitExpression;
            while (s instanceof Cs.AnnotatedStatement) {
                s = ((Cs.AnnotatedStatement)s).getStatement();
            }
            if (s instanceof Cs.ExpressionStatement || s instanceof Cs.AwaitExpression && ((Cs.AwaitExpression)s).getExpression() instanceof J.ForEachLoop && ((J.ForEachLoop)((Cs.AwaitExpression)s).getExpression()).getBody() instanceof J.Block) {
                return;
            }
            if (s instanceof Cs.AwaitExpression && (awaitExpression = (Cs.AwaitExpression)s).getExpression() instanceof J.ForEachLoop && (loop = (J.ForEachLoop)awaitExpression.getExpression()).getBody() instanceof J.Block) {
                p.append(';');
            }
            boolean usingStatementRequiresSemicolon = false;
            if (s instanceof Cs.UsingStatement && !((usingBody = (usingStatement = (Cs.UsingStatement)s).getStatement()) instanceof J.Block) && !(usingStatement.getStatement() instanceof Cs.UsingStatement) && !(usingStatement.getStatement() instanceof Cs.ExpressionStatement)) {
                usingStatementRequiresSemicolon = true;
            }
            if (s instanceof Cs.AssignmentOperation || s instanceof Cs.Yield || s instanceof Cs.DelegateDeclaration || usingStatementRequiresSemicolon || s instanceof Cs.PropertyDeclaration && ((Cs.PropertyDeclaration)s).getInitializer() != null || s instanceof Cs.EventDeclaration && ((Cs.EventDeclaration)s).getPadding().getAccessors() == null || s instanceof Cs.GotoStatement || s instanceof Cs.AccessorDeclaration && ((Cs.AccessorDeclaration)s).getBody() == null && ((Cs.AccessorDeclaration)s).getExpressionBody() == null) {
                p.append(';');
            } else {
                super.printStatementTerminator(s, p);
            }
        }
    }
}

