/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.csharp;

import java.util.List;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.csharp.tree.Cs;
import org.openrewrite.csharp.tree.CsContainer;
import org.openrewrite.csharp.tree.CsLeftPadded;
import org.openrewrite.csharp.tree.CsRightPadded;
import org.openrewrite.csharp.tree.CsSpace;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.marker.Markers;

public class CSharpVisitor<P>
extends JavaVisitor<P> {
    public boolean isAcceptable(SourceFile sourceFile, P p) {
        return sourceFile instanceof Cs;
    }

    public J visitCompilationUnit(Cs.CompilationUnit compilationUnit, P p) {
        compilationUnit = compilationUnit.withPrefix(this.visitSpace(compilationUnit.getPrefix(), Space.Location.COMPILATION_UNIT_PREFIX, p));
        compilationUnit = compilationUnit.withMarkers(this.visitMarkers(compilationUnit.getMarkers(), p));
        compilationUnit = compilationUnit.getPadding().withExterns(ListUtils.map(compilationUnit.getPadding().getExterns(), el -> this.visitRightPadded((JRightPadded)el, CsRightPadded.Location.COMPILATION_UNIT_EXTERNS, p)));
        compilationUnit = compilationUnit.getPadding().withUsings(ListUtils.map(compilationUnit.getPadding().getUsings(), el -> this.visitRightPadded((JRightPadded)el, CsRightPadded.Location.COMPILATION_UNIT_USINGS, p)));
        compilationUnit = compilationUnit.withAttributeLists(ListUtils.map(compilationUnit.getAttributeLists(), el -> (Cs.AttributeList)this.visit((Tree)el, p)));
        compilationUnit = compilationUnit.getPadding().withMembers(ListUtils.map(compilationUnit.getPadding().getMembers(), el -> this.visitRightPadded((JRightPadded)el, CsRightPadded.Location.COMPILATION_UNIT_MEMBERS, p)));
        compilationUnit = compilationUnit.withEof(this.visitSpace(compilationUnit.getEof(), Space.Location.COMPILATION_UNIT_EOF, p));
        return compilationUnit;
    }

    public J visitRefExpression(Cs.RefExpression refExpression, P p) {
        Expression tempExpression = (Expression)this.visitExpression(refExpression = refExpression.withPrefix(this.visitSpace(refExpression.getPrefix(), CsSpace.Location.REF_EXPRESSION_PREFIX, p)), p);
        if (!(tempExpression instanceof Cs.RefExpression)) {
            return tempExpression;
        }
        refExpression = (Cs.RefExpression)tempExpression;
        refExpression = refExpression.withMarkers(this.visitMarkers(refExpression.getMarkers(), p));
        refExpression = refExpression.withExpression((Expression)this.visitAndCast((Tree)refExpression.getExpression(), p));
        return refExpression;
    }

    public J visitPointerType(Cs.PointerType pointerType, P p) {
        Expression tempExpression = (Expression)this.visitExpression(pointerType = pointerType.withPrefix(this.visitSpace(pointerType.getPrefix(), CsSpace.Location.POINTER_TYPE_PREFIX, p)), p);
        if (!(tempExpression instanceof Cs.PointerType)) {
            return tempExpression;
        }
        pointerType = (Cs.PointerType)tempExpression;
        pointerType = pointerType.withMarkers(this.visitMarkers(pointerType.getMarkers(), p));
        pointerType = pointerType.getPadding().withElementType(this.visitRightPadded(pointerType.getPadding().getElementType(), CsRightPadded.Location.POINTER_TYPE_ELEMENT_TYPE, p));
        return pointerType;
    }

    public J visitRefType(Cs.RefType refType, P p) {
        Expression tempExpression = (Expression)this.visitExpression(refType = refType.withPrefix(this.visitSpace(refType.getPrefix(), CsSpace.Location.REF_TYPE_PREFIX, p)), p);
        if (!(tempExpression instanceof Cs.RefType)) {
            return tempExpression;
        }
        refType = (Cs.RefType)tempExpression;
        refType = refType.withMarkers(this.visitMarkers(refType.getMarkers(), p));
        refType = refType.withReadonlyKeyword((J.Modifier)this.visitAndCast((Tree)refType.getReadonlyKeyword(), p));
        refType = refType.withTypeIdentifier((TypeTree)this.visitAndCast((Tree)refType.getTypeIdentifier(), p));
        return refType;
    }

    public J visitForEachVariableLoop(Cs.ForEachVariableLoop forEachVariableLoop, P p) {
        Statement tempStatement = (Statement)this.visitStatement((Statement)(forEachVariableLoop = forEachVariableLoop.withPrefix(this.visitSpace(forEachVariableLoop.getPrefix(), CsSpace.Location.FOR_EACH_VARIABLE_LOOP_PREFIX, p))), p);
        if (!(tempStatement instanceof Cs.ForEachVariableLoop)) {
            return tempStatement;
        }
        forEachVariableLoop = (Cs.ForEachVariableLoop)tempStatement;
        forEachVariableLoop = forEachVariableLoop.withMarkers(this.visitMarkers(forEachVariableLoop.getMarkers(), p));
        forEachVariableLoop = forEachVariableLoop.withControlElement((Cs.ForEachVariableLoop.Control)this.visitAndCast((Tree)forEachVariableLoop.getControlElement(), p));
        forEachVariableLoop = forEachVariableLoop.getPadding().withBody(this.visitRightPadded(forEachVariableLoop.getPadding().getBody(), CsRightPadded.Location.FOR_EACH_VARIABLE_LOOP_BODY, p));
        return forEachVariableLoop;
    }

    public J visitForEachVariableLoopControl(Cs.ForEachVariableLoop.Control control, P p) {
        control = control.withPrefix(this.visitSpace(control.getPrefix(), CsSpace.Location.FOR_EACH_VARIABLE_LOOP_CONTROL_PREFIX, p));
        control = control.withMarkers(this.visitMarkers(control.getMarkers(), p));
        control = control.getPadding().withVariable(this.visitRightPadded(control.getPadding().getVariable(), CsRightPadded.Location.FOR_EACH_VARIABLE_LOOP_CONTROL_VARIABLE, p));
        control = control.getPadding().withIterable(this.visitRightPadded(control.getPadding().getIterable(), CsRightPadded.Location.FOR_EACH_VARIABLE_LOOP_CONTROL_ITERABLE, p));
        return control;
    }

    public J visitArgument(Cs.Argument argument, P p) {
        Expression tempExpression = (Expression)this.visitExpression(argument = argument.withPrefix(this.visitSpace(argument.getPrefix(), CsSpace.Location.ARGUMENT_PREFIX, p)), p);
        if (!(tempExpression instanceof Cs.Argument)) {
            return tempExpression;
        }
        argument = (Cs.Argument)tempExpression;
        argument = argument.withMarkers(this.visitMarkers(argument.getMarkers(), p));
        argument = argument.getPadding().withNameColumn(this.visitRightPadded(argument.getPadding().getNameColumn(), CsRightPadded.Location.ARGUMENT_NAME_COLUMN, p));
        argument = argument.withRefKindKeyword((Cs.Keyword)this.visitAndCast((Tree)argument.getRefKindKeyword(), p));
        argument = argument.withExpression((Expression)this.visitAndCast((Tree)argument.getExpression(), p));
        return argument;
    }

    public J visitAnnotatedStatement(Cs.AnnotatedStatement annotatedStatement, P p) {
        Statement tempStatement = (Statement)this.visitStatement(annotatedStatement = annotatedStatement.withPrefix(this.visitSpace(annotatedStatement.getPrefix(), CsSpace.Location.ANNOTATED_STATEMENT_PREFIX, p)), p);
        if (!(tempStatement instanceof Cs.AnnotatedStatement)) {
            return tempStatement;
        }
        annotatedStatement = (Cs.AnnotatedStatement)tempStatement;
        annotatedStatement = annotatedStatement.withMarkers(this.visitMarkers(annotatedStatement.getMarkers(), p));
        annotatedStatement = annotatedStatement.withAttributeLists(ListUtils.map(annotatedStatement.getAttributeLists(), el -> (Cs.AttributeList)this.visit((Tree)el, p)));
        annotatedStatement = annotatedStatement.withStatement((Statement)this.visitAndCast((Tree)annotatedStatement.getStatement(), p));
        return annotatedStatement;
    }

    public J visitArrayRankSpecifier(Cs.ArrayRankSpecifier arrayRankSpecifier, P p) {
        Expression tempExpression = (Expression)this.visitExpression(arrayRankSpecifier = arrayRankSpecifier.withPrefix(this.visitSpace(arrayRankSpecifier.getPrefix(), CsSpace.Location.ARRAY_RANK_SPECIFIER_PREFIX, p)), p);
        if (!(tempExpression instanceof Cs.ArrayRankSpecifier)) {
            return tempExpression;
        }
        arrayRankSpecifier = (Cs.ArrayRankSpecifier)tempExpression;
        arrayRankSpecifier = arrayRankSpecifier.withMarkers(this.visitMarkers(arrayRankSpecifier.getMarkers(), p));
        arrayRankSpecifier = arrayRankSpecifier.getPadding().withSizes(this.visitContainer(arrayRankSpecifier.getPadding().getSizes(), CsContainer.Location.ARRAY_RANK_SPECIFIER_SIZES, p));
        return arrayRankSpecifier;
    }

    public J visitAssignmentOperation(Cs.AssignmentOperation assignmentOperation, P p) {
        Statement tempStatement = (Statement)this.visitStatement(assignmentOperation = assignmentOperation.withPrefix(this.visitSpace(assignmentOperation.getPrefix(), CsSpace.Location.ASSIGNMENT_OPERATION_PREFIX, p)), p);
        if (!(tempStatement instanceof Cs.AssignmentOperation)) {
            return tempStatement;
        }
        assignmentOperation = (Cs.AssignmentOperation)tempStatement;
        Expression tempExpression = (Expression)this.visitExpression(assignmentOperation, p);
        if (!(tempExpression instanceof Cs.AssignmentOperation)) {
            return tempExpression;
        }
        assignmentOperation = (Cs.AssignmentOperation)tempExpression;
        assignmentOperation = assignmentOperation.withMarkers(this.visitMarkers(assignmentOperation.getMarkers(), p));
        assignmentOperation = assignmentOperation.withVariable((Expression)this.visitAndCast((Tree)assignmentOperation.getVariable(), p));
        assignmentOperation = assignmentOperation.getPadding().withOperator(this.visitLeftPadded(assignmentOperation.getPadding().getOperator(), CsLeftPadded.Location.ASSIGNMENT_OPERATION_OPERATOR, p));
        assignmentOperation = assignmentOperation.withAssignment((Expression)this.visitAndCast((Tree)assignmentOperation.getAssignment(), p));
        return assignmentOperation;
    }

    public J visitAttributeList(Cs.AttributeList attributeList, P p) {
        attributeList = attributeList.withPrefix(this.visitSpace(attributeList.getPrefix(), CsSpace.Location.ATTRIBUTE_LIST_PREFIX, p));
        attributeList = attributeList.withMarkers(this.visitMarkers(attributeList.getMarkers(), p));
        attributeList = attributeList.getPadding().withTarget(this.visitRightPadded(attributeList.getPadding().getTarget(), CsRightPadded.Location.ATTRIBUTE_LIST_TARGET, p));
        attributeList = attributeList.getPadding().withAttributes(ListUtils.map(attributeList.getPadding().getAttributes(), el -> this.visitRightPadded((JRightPadded)el, CsRightPadded.Location.ATTRIBUTE_LIST_ATTRIBUTES, p)));
        return attributeList;
    }

    public J visitAwaitExpression(Cs.AwaitExpression awaitExpression, P p) {
        Statement tempStatement = (Statement)this.visitStatement(awaitExpression = awaitExpression.withPrefix(this.visitSpace(awaitExpression.getPrefix(), CsSpace.Location.AWAIT_EXPRESSION_PREFIX, p)), p);
        if (!(tempStatement instanceof Cs.AwaitExpression)) {
            return tempStatement;
        }
        awaitExpression = (Cs.AwaitExpression)tempStatement;
        Expression tempExpression = (Expression)this.visitExpression(awaitExpression, p);
        if (!(tempExpression instanceof Cs.AwaitExpression)) {
            return tempExpression;
        }
        awaitExpression = (Cs.AwaitExpression)tempExpression;
        awaitExpression = awaitExpression.withMarkers(this.visitMarkers(awaitExpression.getMarkers(), p));
        awaitExpression = awaitExpression.withExpression((J)this.visitAndCast((Tree)awaitExpression.getExpression(), p));
        return awaitExpression;
    }

    public J visitStackAllocExpression(Cs.StackAllocExpression stackAllocExpression, P p) {
        Expression tempExpression = (Expression)this.visitExpression(stackAllocExpression = stackAllocExpression.withPrefix(this.visitSpace(stackAllocExpression.getPrefix(), CsSpace.Location.STACK_ALLOC_EXPRESSION_PREFIX, p)), p);
        if (!(tempExpression instanceof Cs.StackAllocExpression)) {
            return tempExpression;
        }
        stackAllocExpression = (Cs.StackAllocExpression)tempExpression;
        stackAllocExpression = stackAllocExpression.withMarkers(this.visitMarkers(stackAllocExpression.getMarkers(), p));
        stackAllocExpression = stackAllocExpression.withExpression((J.NewArray)this.visitAndCast((Tree)stackAllocExpression.getExpression(), p));
        return stackAllocExpression;
    }

    public J visitGotoStatement(Cs.GotoStatement gotoStatement, P p) {
        Statement tempStatement = (Statement)this.visitStatement(gotoStatement = gotoStatement.withPrefix(this.visitSpace(gotoStatement.getPrefix(), CsSpace.Location.GOTO_STATEMENT_PREFIX, p)), p);
        if (!(tempStatement instanceof Cs.GotoStatement)) {
            return tempStatement;
        }
        gotoStatement = (Cs.GotoStatement)tempStatement;
        gotoStatement = gotoStatement.withMarkers(this.visitMarkers(gotoStatement.getMarkers(), p));
        gotoStatement = gotoStatement.withCaseOrDefaultKeyword((Cs.Keyword)this.visitAndCast((Tree)gotoStatement.getCaseOrDefaultKeyword(), p));
        gotoStatement = gotoStatement.withTarget((Expression)this.visitAndCast((Tree)gotoStatement.getTarget(), p));
        return gotoStatement;
    }

    public J visitEventDeclaration(Cs.EventDeclaration eventDeclaration, P p) {
        Statement tempStatement = (Statement)this.visitStatement(eventDeclaration = eventDeclaration.withPrefix(this.visitSpace(eventDeclaration.getPrefix(), CsSpace.Location.EVENT_DECLARATION_PREFIX, p)), p);
        if (!(tempStatement instanceof Cs.EventDeclaration)) {
            return tempStatement;
        }
        eventDeclaration = (Cs.EventDeclaration)tempStatement;
        eventDeclaration = eventDeclaration.withMarkers(this.visitMarkers(eventDeclaration.getMarkers(), p));
        eventDeclaration = eventDeclaration.withAttributeLists(ListUtils.map(eventDeclaration.getAttributeLists(), el -> (Cs.AttributeList)this.visit((Tree)el, p)));
        eventDeclaration = eventDeclaration.withModifiers(ListUtils.map(eventDeclaration.getModifiers(), el -> (J.Modifier)this.visit((Tree)el, p)));
        eventDeclaration = eventDeclaration.getPadding().withTypeExpression(this.visitLeftPadded(eventDeclaration.getPadding().getTypeExpression(), CsLeftPadded.Location.EVENT_DECLARATION_TYPE_EXPRESSION, p));
        eventDeclaration = eventDeclaration.getPadding().withInterfaceSpecifier(this.visitRightPadded(eventDeclaration.getPadding().getInterfaceSpecifier(), CsRightPadded.Location.EVENT_DECLARATION_INTERFACE_SPECIFIER, p));
        eventDeclaration = eventDeclaration.withName((J.Identifier)this.visitAndCast((Tree)eventDeclaration.getName(), p));
        eventDeclaration = eventDeclaration.getPadding().withAccessors(this.visitContainer(eventDeclaration.getPadding().getAccessors(), CsContainer.Location.EVENT_DECLARATION_ACCESSORS, p));
        return eventDeclaration;
    }

    public J visitBinary(Cs.Binary binary, P p) {
        Expression tempExpression = (Expression)this.visitExpression(binary = binary.withPrefix(this.visitSpace(binary.getPrefix(), CsSpace.Location.BINARY_PREFIX, p)), p);
        if (!(tempExpression instanceof Cs.Binary)) {
            return tempExpression;
        }
        binary = (Cs.Binary)tempExpression;
        binary = binary.withMarkers(this.visitMarkers(binary.getMarkers(), p));
        binary = binary.withLeft((Expression)this.visitAndCast((Tree)binary.getLeft(), p));
        binary = binary.getPadding().withOperator(this.visitLeftPadded(binary.getPadding().getOperator(), CsLeftPadded.Location.BINARY_OPERATOR, p));
        binary = binary.withRight((Expression)this.visitAndCast((Tree)binary.getRight(), p));
        return binary;
    }

    public J visitBlockScopeNamespaceDeclaration(Cs.BlockScopeNamespaceDeclaration blockScopeNamespaceDeclaration, P p) {
        Statement tempStatement = (Statement)this.visitStatement(blockScopeNamespaceDeclaration = blockScopeNamespaceDeclaration.withPrefix(this.visitSpace(blockScopeNamespaceDeclaration.getPrefix(), CsSpace.Location.BLOCK_SCOPE_NAMESPACE_DECLARATION_PREFIX, p)), p);
        if (!(tempStatement instanceof Cs.BlockScopeNamespaceDeclaration)) {
            return tempStatement;
        }
        blockScopeNamespaceDeclaration = (Cs.BlockScopeNamespaceDeclaration)tempStatement;
        blockScopeNamespaceDeclaration = blockScopeNamespaceDeclaration.withMarkers(this.visitMarkers(blockScopeNamespaceDeclaration.getMarkers(), p));
        blockScopeNamespaceDeclaration = blockScopeNamespaceDeclaration.getPadding().withName(this.visitRightPadded(blockScopeNamespaceDeclaration.getPadding().getName(), CsRightPadded.Location.BLOCK_SCOPE_NAMESPACE_DECLARATION_NAME, p));
        blockScopeNamespaceDeclaration = blockScopeNamespaceDeclaration.getPadding().withExterns(ListUtils.map(blockScopeNamespaceDeclaration.getPadding().getExterns(), el -> this.visitRightPadded((JRightPadded)el, CsRightPadded.Location.BLOCK_SCOPE_NAMESPACE_DECLARATION_EXTERNS, p)));
        blockScopeNamespaceDeclaration = blockScopeNamespaceDeclaration.getPadding().withUsings(ListUtils.map(blockScopeNamespaceDeclaration.getPadding().getUsings(), el -> this.visitRightPadded((JRightPadded)el, CsRightPadded.Location.BLOCK_SCOPE_NAMESPACE_DECLARATION_USINGS, p)));
        blockScopeNamespaceDeclaration = blockScopeNamespaceDeclaration.getPadding().withMembers(ListUtils.map(blockScopeNamespaceDeclaration.getPadding().getMembers(), el -> this.visitRightPadded((JRightPadded)el, CsRightPadded.Location.BLOCK_SCOPE_NAMESPACE_DECLARATION_MEMBERS, p)));
        blockScopeNamespaceDeclaration = blockScopeNamespaceDeclaration.withEnd(this.visitSpace(blockScopeNamespaceDeclaration.getEnd(), CsSpace.Location.BLOCK_SCOPE_NAMESPACE_DECLARATION_END, p));
        return blockScopeNamespaceDeclaration;
    }

    public J visitCollectionExpression(Cs.CollectionExpression collectionExpression, P p) {
        Expression tempExpression = (Expression)this.visitExpression(collectionExpression = collectionExpression.withPrefix(this.visitSpace(collectionExpression.getPrefix(), CsSpace.Location.COLLECTION_EXPRESSION_PREFIX, p)), p);
        if (!(tempExpression instanceof Cs.CollectionExpression)) {
            return tempExpression;
        }
        collectionExpression = (Cs.CollectionExpression)tempExpression;
        collectionExpression = collectionExpression.withMarkers(this.visitMarkers(collectionExpression.getMarkers(), p));
        collectionExpression = collectionExpression.getPadding().withElements(ListUtils.map(collectionExpression.getPadding().getElements(), el -> this.visitRightPadded((JRightPadded)el, CsRightPadded.Location.COLLECTION_EXPRESSION_ELEMENTS, p)));
        return collectionExpression;
    }

    public J visitExpressionStatement(Cs.ExpressionStatement expressionStatement, P p) {
        Statement tempStatement = (Statement)this.visitStatement(expressionStatement = expressionStatement.withPrefix(this.visitSpace(expressionStatement.getPrefix(), CsSpace.Location.EXPRESSION_STATEMENT_PREFIX, p)), p);
        if (!(tempStatement instanceof Cs.ExpressionStatement)) {
            return tempStatement;
        }
        expressionStatement = (Cs.ExpressionStatement)tempStatement;
        expressionStatement = expressionStatement.withMarkers(this.visitMarkers(expressionStatement.getMarkers(), p));
        expressionStatement = expressionStatement.getPadding().withExpression(this.visitRightPadded(expressionStatement.getPadding().getExpression(), CsRightPadded.Location.EXPRESSION_STATEMENT_EXPRESSION, p));
        return expressionStatement;
    }

    public J visitExternAlias(Cs.ExternAlias externAlias, P p) {
        Statement tempStatement = (Statement)this.visitStatement(externAlias = externAlias.withPrefix(this.visitSpace(externAlias.getPrefix(), CsSpace.Location.EXTERN_ALIAS_PREFIX, p)), p);
        if (!(tempStatement instanceof Cs.ExternAlias)) {
            return tempStatement;
        }
        externAlias = (Cs.ExternAlias)tempStatement;
        externAlias = externAlias.withMarkers(this.visitMarkers(externAlias.getMarkers(), p));
        externAlias = externAlias.getPadding().withIdentifier(this.visitLeftPadded(externAlias.getPadding().getIdentifier(), CsLeftPadded.Location.EXTERN_ALIAS_IDENTIFIER, p));
        return externAlias;
    }

    public J visitFileScopeNamespaceDeclaration(Cs.FileScopeNamespaceDeclaration fileScopeNamespaceDeclaration, P p) {
        Statement tempStatement = (Statement)this.visitStatement(fileScopeNamespaceDeclaration = fileScopeNamespaceDeclaration.withPrefix(this.visitSpace(fileScopeNamespaceDeclaration.getPrefix(), CsSpace.Location.FILE_SCOPE_NAMESPACE_DECLARATION_PREFIX, p)), p);
        if (!(tempStatement instanceof Cs.FileScopeNamespaceDeclaration)) {
            return tempStatement;
        }
        fileScopeNamespaceDeclaration = (Cs.FileScopeNamespaceDeclaration)tempStatement;
        fileScopeNamespaceDeclaration = fileScopeNamespaceDeclaration.withMarkers(this.visitMarkers(fileScopeNamespaceDeclaration.getMarkers(), p));
        fileScopeNamespaceDeclaration = fileScopeNamespaceDeclaration.getPadding().withName(this.visitRightPadded(fileScopeNamespaceDeclaration.getPadding().getName(), CsRightPadded.Location.FILE_SCOPE_NAMESPACE_DECLARATION_NAME, p));
        fileScopeNamespaceDeclaration = fileScopeNamespaceDeclaration.getPadding().withExterns(ListUtils.map(fileScopeNamespaceDeclaration.getPadding().getExterns(), el -> this.visitRightPadded((JRightPadded)el, CsRightPadded.Location.FILE_SCOPE_NAMESPACE_DECLARATION_EXTERNS, p)));
        fileScopeNamespaceDeclaration = fileScopeNamespaceDeclaration.getPadding().withUsings(ListUtils.map(fileScopeNamespaceDeclaration.getPadding().getUsings(), el -> this.visitRightPadded((JRightPadded)el, CsRightPadded.Location.FILE_SCOPE_NAMESPACE_DECLARATION_USINGS, p)));
        fileScopeNamespaceDeclaration = fileScopeNamespaceDeclaration.getPadding().withMembers(ListUtils.map(fileScopeNamespaceDeclaration.getPadding().getMembers(), el -> this.visitRightPadded((JRightPadded)el, CsRightPadded.Location.FILE_SCOPE_NAMESPACE_DECLARATION_MEMBERS, p)));
        return fileScopeNamespaceDeclaration;
    }

    public J visitInterpolatedString(Cs.InterpolatedString interpolatedString, P p) {
        Expression tempExpression = (Expression)this.visitExpression(interpolatedString = interpolatedString.withPrefix(this.visitSpace(interpolatedString.getPrefix(), CsSpace.Location.INTERPOLATED_STRING_PREFIX, p)), p);
        if (!(tempExpression instanceof Cs.InterpolatedString)) {
            return tempExpression;
        }
        interpolatedString = (Cs.InterpolatedString)tempExpression;
        interpolatedString = interpolatedString.withMarkers(this.visitMarkers(interpolatedString.getMarkers(), p));
        interpolatedString = interpolatedString.getPadding().withParts(ListUtils.map(interpolatedString.getPadding().getParts(), el -> this.visitRightPadded((JRightPadded)el, CsRightPadded.Location.INTERPOLATED_STRING_PARTS, p)));
        return interpolatedString;
    }

    public J visitInterpolation(Cs.Interpolation interpolation, P p) {
        Expression tempExpression = (Expression)this.visitExpression(interpolation = interpolation.withPrefix(this.visitSpace(interpolation.getPrefix(), CsSpace.Location.INTERPOLATION_PREFIX, p)), p);
        if (!(tempExpression instanceof Cs.Interpolation)) {
            return tempExpression;
        }
        interpolation = (Cs.Interpolation)tempExpression;
        interpolation = interpolation.withMarkers(this.visitMarkers(interpolation.getMarkers(), p));
        interpolation = interpolation.getPadding().withExpression(this.visitRightPadded(interpolation.getPadding().getExpression(), CsRightPadded.Location.INTERPOLATION_EXPRESSION, p));
        interpolation = interpolation.getPadding().withAlignment(this.visitRightPadded(interpolation.getPadding().getAlignment(), CsRightPadded.Location.INTERPOLATION_ALIGNMENT, p));
        interpolation = interpolation.getPadding().withFormat(this.visitRightPadded(interpolation.getPadding().getFormat(), CsRightPadded.Location.INTERPOLATION_FORMAT, p));
        return interpolation;
    }

    public J visitNullSafeExpression(Cs.NullSafeExpression nullSafeExpression, P p) {
        Expression tempExpression = (Expression)this.visitExpression(nullSafeExpression = nullSafeExpression.withPrefix(this.visitSpace(nullSafeExpression.getPrefix(), CsSpace.Location.NULL_SAFE_EXPRESSION_PREFIX, p)), p);
        if (!(tempExpression instanceof Cs.NullSafeExpression)) {
            return tempExpression;
        }
        nullSafeExpression = (Cs.NullSafeExpression)tempExpression;
        nullSafeExpression = nullSafeExpression.withMarkers(this.visitMarkers(nullSafeExpression.getMarkers(), p));
        nullSafeExpression = nullSafeExpression.getPadding().withExpression(this.visitRightPadded(nullSafeExpression.getPadding().getExpression(), CsRightPadded.Location.NULL_SAFE_EXPRESSION_EXPRESSION, p));
        return nullSafeExpression;
    }

    public J visitStatementExpression(Cs.StatementExpression statementExpression, P p) {
        Expression tempExpression = (Expression)this.visitExpression(statementExpression = statementExpression.withPrefix(this.visitSpace(statementExpression.getPrefix(), CsSpace.Location.STATEMENT_EXPRESSION_PREFIX, p)), p);
        if (!(tempExpression instanceof Cs.StatementExpression)) {
            return tempExpression;
        }
        statementExpression = (Cs.StatementExpression)tempExpression;
        statementExpression = statementExpression.withMarkers(this.visitMarkers(statementExpression.getMarkers(), p));
        statementExpression = statementExpression.withStatement((Statement)this.visitAndCast((Tree)statementExpression.getStatement(), p));
        return statementExpression;
    }

    public J visitUsingDirective(Cs.UsingDirective usingDirective, P p) {
        Statement tempStatement = (Statement)this.visitStatement(usingDirective = usingDirective.withPrefix(this.visitSpace(usingDirective.getPrefix(), CsSpace.Location.USING_DIRECTIVE_PREFIX, p)), p);
        if (!(tempStatement instanceof Cs.UsingDirective)) {
            return tempStatement;
        }
        usingDirective = (Cs.UsingDirective)tempStatement;
        usingDirective = usingDirective.withMarkers(this.visitMarkers(usingDirective.getMarkers(), p));
        usingDirective = usingDirective.getPadding().withGlobal(this.visitRightPadded(usingDirective.getPadding().getGlobal(), CsRightPadded.Location.USING_DIRECTIVE_GLOBAL, p));
        usingDirective = usingDirective.getPadding().withStatic(this.visitLeftPadded(usingDirective.getPadding().getStatic(), CsLeftPadded.Location.USING_DIRECTIVE_STATIC, p));
        usingDirective = usingDirective.getPadding().withUnsafe(this.visitLeftPadded(usingDirective.getPadding().getUnsafe(), CsLeftPadded.Location.USING_DIRECTIVE_UNSAFE, p));
        usingDirective = usingDirective.getPadding().withAlias(this.visitRightPadded(usingDirective.getPadding().getAlias(), CsRightPadded.Location.USING_DIRECTIVE_ALIAS, p));
        usingDirective = usingDirective.withNamespaceOrType((TypeTree)this.visitAndCast((Tree)usingDirective.getNamespaceOrType(), p));
        return usingDirective;
    }

    public J visitPropertyDeclaration(Cs.PropertyDeclaration propertyDeclaration, P p) {
        Statement tempStatement = (Statement)this.visitStatement(propertyDeclaration = propertyDeclaration.withPrefix(this.visitSpace(propertyDeclaration.getPrefix(), CsSpace.Location.PROPERTY_DECLARATION_PREFIX, p)), p);
        if (!(tempStatement instanceof Cs.PropertyDeclaration)) {
            return tempStatement;
        }
        propertyDeclaration = (Cs.PropertyDeclaration)tempStatement;
        propertyDeclaration = propertyDeclaration.withMarkers(this.visitMarkers(propertyDeclaration.getMarkers(), p));
        propertyDeclaration = propertyDeclaration.withAttributeLists(ListUtils.map(propertyDeclaration.getAttributeLists(), el -> (Cs.AttributeList)this.visit((Tree)el, p)));
        propertyDeclaration = propertyDeclaration.withModifiers(ListUtils.map(propertyDeclaration.getModifiers(), el -> (J.Modifier)this.visit((Tree)el, p)));
        propertyDeclaration = propertyDeclaration.withTypeExpression((TypeTree)this.visitAndCast((Tree)propertyDeclaration.getTypeExpression(), p));
        propertyDeclaration = propertyDeclaration.getPadding().withInterfaceSpecifier(this.visitRightPadded(propertyDeclaration.getPadding().getInterfaceSpecifier(), CsRightPadded.Location.PROPERTY_DECLARATION_INTERFACE_SPECIFIER, p));
        propertyDeclaration = propertyDeclaration.withName((J.Identifier)this.visitAndCast((Tree)propertyDeclaration.getName(), p));
        propertyDeclaration = propertyDeclaration.withAccessors((J.Block)this.visitAndCast((Tree)propertyDeclaration.getAccessors(), p));
        propertyDeclaration = propertyDeclaration.withExpressionBody((Cs.ArrowExpressionClause)this.visitAndCast((Tree)propertyDeclaration.getExpressionBody(), p));
        propertyDeclaration = propertyDeclaration.getPadding().withInitializer(this.visitLeftPadded(propertyDeclaration.getPadding().getInitializer(), CsLeftPadded.Location.PROPERTY_DECLARATION_INITIALIZER, p));
        return propertyDeclaration;
    }

    public J visitKeyword(Cs.Keyword keyword, P p) {
        keyword = keyword.withPrefix(this.visitSpace(keyword.getPrefix(), CsSpace.Location.KEYWORD_PREFIX, p));
        keyword = keyword.withMarkers(this.visitMarkers(keyword.getMarkers(), p));
        return keyword;
    }

    public J visitLambda(Cs.Lambda lambda, P p) {
        Statement tempStatement = (Statement)this.visitStatement(lambda = lambda.withPrefix(this.visitSpace(lambda.getPrefix(), CsSpace.Location.LAMBDA_PREFIX, p)), p);
        if (!(tempStatement instanceof Cs.Lambda)) {
            return tempStatement;
        }
        lambda = (Cs.Lambda)tempStatement;
        Expression tempExpression = (Expression)this.visitExpression(lambda, p);
        if (!(tempExpression instanceof Cs.Lambda)) {
            return tempExpression;
        }
        lambda = (Cs.Lambda)tempExpression;
        lambda = lambda.withMarkers(this.visitMarkers(lambda.getMarkers(), p));
        lambda = lambda.withLambdaExpression((J.Lambda)this.visitAndCast((Tree)lambda.getLambdaExpression(), p));
        lambda = lambda.withModifiers(ListUtils.map(lambda.getModifiers(), el -> (J.Modifier)this.visit((Tree)el, p)));
        return lambda;
    }

    public J visitClassDeclaration(Cs.ClassDeclaration classDeclaration, P p) {
        Statement tempStatement = (Statement)this.visitStatement(classDeclaration = classDeclaration.withPrefix(this.visitSpace(classDeclaration.getPrefix(), CsSpace.Location.CLASS_DECLARATION_PREFIX, p)), p);
        if (!(tempStatement instanceof Cs.ClassDeclaration)) {
            return tempStatement;
        }
        classDeclaration = (Cs.ClassDeclaration)tempStatement;
        classDeclaration = classDeclaration.withMarkers(this.visitMarkers(classDeclaration.getMarkers(), p));
        classDeclaration = classDeclaration.withAttributeList(ListUtils.map(classDeclaration.getAttributeList(), el -> (Cs.AttributeList)this.visit((Tree)el, p)));
        classDeclaration = classDeclaration.withModifiers(ListUtils.map(classDeclaration.getModifiers(), el -> (J.Modifier)this.visit((Tree)el, p)));
        classDeclaration = classDeclaration.getPadding().withKind((J.ClassDeclaration.Kind)this.visitAndCast((Tree)classDeclaration.getPadding().getKind(), p));
        classDeclaration = classDeclaration.withName((J.Identifier)this.visitAndCast((Tree)classDeclaration.getName(), p));
        classDeclaration = classDeclaration.getPadding().withTypeParameters(this.visitContainer(classDeclaration.getPadding().getTypeParameters(), CsContainer.Location.CLASS_DECLARATION_TYPE_PARAMETERS, p));
        classDeclaration = classDeclaration.getPadding().withPrimaryConstructor(this.visitContainer(classDeclaration.getPadding().getPrimaryConstructor(), CsContainer.Location.CLASS_DECLARATION_PRIMARY_CONSTRUCTOR, p));
        classDeclaration = classDeclaration.getPadding().withExtendings(this.visitLeftPadded(classDeclaration.getPadding().getExtendings(), CsLeftPadded.Location.CLASS_DECLARATION_EXTENDINGS, p));
        classDeclaration = classDeclaration.getPadding().withImplementings(this.visitContainer(classDeclaration.getPadding().getImplementings(), CsContainer.Location.CLASS_DECLARATION_IMPLEMENTINGS, p));
        classDeclaration = classDeclaration.withBody((J.Block)this.visitAndCast((Tree)classDeclaration.getBody(), p));
        classDeclaration = classDeclaration.getPadding().withTypeParameterConstraintClauses(this.visitContainer(classDeclaration.getPadding().getTypeParameterConstraintClauses(), CsContainer.Location.CLASS_DECLARATION_TYPE_PARAMETER_CONSTRAINT_CLAUSES, p));
        return classDeclaration;
    }

    public J visitMethodDeclaration(Cs.MethodDeclaration methodDeclaration, P p) {
        Statement tempStatement = (Statement)this.visitStatement(methodDeclaration = methodDeclaration.withPrefix(this.visitSpace(methodDeclaration.getPrefix(), CsSpace.Location.METHOD_DECLARATION_PREFIX, p)), p);
        if (!(tempStatement instanceof Cs.MethodDeclaration)) {
            return tempStatement;
        }
        methodDeclaration = (Cs.MethodDeclaration)tempStatement;
        methodDeclaration = methodDeclaration.withMarkers(this.visitMarkers(methodDeclaration.getMarkers(), p));
        methodDeclaration = methodDeclaration.withAttributes(ListUtils.map(methodDeclaration.getAttributes(), el -> (Cs.AttributeList)this.visit((Tree)el, p)));
        methodDeclaration = methodDeclaration.withModifiers(ListUtils.map(methodDeclaration.getModifiers(), el -> (J.Modifier)this.visit((Tree)el, p)));
        methodDeclaration = methodDeclaration.getPadding().withTypeParameters(this.visitContainer(methodDeclaration.getPadding().getTypeParameters(), CsContainer.Location.METHOD_DECLARATION_TYPE_PARAMETERS, p));
        methodDeclaration = methodDeclaration.withReturnTypeExpression((TypeTree)this.visitAndCast((Tree)methodDeclaration.getReturnTypeExpression(), p));
        methodDeclaration = methodDeclaration.getPadding().withExplicitInterfaceSpecifier(this.visitRightPadded(methodDeclaration.getPadding().getExplicitInterfaceSpecifier(), CsRightPadded.Location.METHOD_DECLARATION_EXPLICIT_INTERFACE_SPECIFIER, p));
        methodDeclaration = methodDeclaration.withName((J.Identifier)this.visitAndCast((Tree)methodDeclaration.getName(), p));
        methodDeclaration = methodDeclaration.getPadding().withParameters(this.visitContainer(methodDeclaration.getPadding().getParameters(), CsContainer.Location.METHOD_DECLARATION_PARAMETERS, p));
        methodDeclaration = methodDeclaration.withBody((Statement)this.visitAndCast((Tree)methodDeclaration.getBody(), p));
        methodDeclaration = methodDeclaration.getPadding().withTypeParameterConstraintClauses(this.visitContainer(methodDeclaration.getPadding().getTypeParameterConstraintClauses(), CsContainer.Location.METHOD_DECLARATION_TYPE_PARAMETER_CONSTRAINT_CLAUSES, p));
        return methodDeclaration;
    }

    public J visitUsingStatement(Cs.UsingStatement usingStatement, P p) {
        Statement tempStatement = (Statement)this.visitStatement(usingStatement = usingStatement.withPrefix(this.visitSpace(usingStatement.getPrefix(), CsSpace.Location.USING_STATEMENT_PREFIX, p)), p);
        if (!(tempStatement instanceof Cs.UsingStatement)) {
            return tempStatement;
        }
        usingStatement = (Cs.UsingStatement)tempStatement;
        usingStatement = usingStatement.withMarkers(this.visitMarkers(usingStatement.getMarkers(), p));
        usingStatement = usingStatement.withAwaitKeyword((Cs.Keyword)this.visitAndCast((Tree)usingStatement.getAwaitKeyword(), p));
        usingStatement = usingStatement.getPadding().withExpression(this.visitLeftPadded(usingStatement.getPadding().getExpression(), CsLeftPadded.Location.USING_STATEMENT_EXPRESSION, p));
        usingStatement = usingStatement.withStatement((Statement)this.visitAndCast((Tree)usingStatement.getStatement(), p));
        return usingStatement;
    }

    public J visitTypeParameterConstraintClause(Cs.TypeParameterConstraintClause typeParameterConstraintClause, P p) {
        typeParameterConstraintClause = typeParameterConstraintClause.withPrefix(this.visitSpace(typeParameterConstraintClause.getPrefix(), CsSpace.Location.TYPE_PARAMETER_CONSTRAINT_CLAUSE_PREFIX, p));
        typeParameterConstraintClause = typeParameterConstraintClause.withMarkers(this.visitMarkers(typeParameterConstraintClause.getMarkers(), p));
        typeParameterConstraintClause = typeParameterConstraintClause.getPadding().withTypeParameter(this.visitRightPadded(typeParameterConstraintClause.getPadding().getTypeParameter(), CsRightPadded.Location.TYPE_PARAMETER_CONSTRAINT_CLAUSE_TYPE_PARAMETER, p));
        typeParameterConstraintClause = typeParameterConstraintClause.getPadding().withTypeParameterConstraints(this.visitContainer(typeParameterConstraintClause.getPadding().getTypeParameterConstraints(), CsContainer.Location.TYPE_PARAMETER_CONSTRAINT_CLAUSE_TYPE_PARAMETER_CONSTRAINTS, p));
        return typeParameterConstraintClause;
    }

    public J visitTypeConstraint(Cs.TypeConstraint typeConstraint, P p) {
        typeConstraint = typeConstraint.withPrefix(this.visitSpace(typeConstraint.getPrefix(), CsSpace.Location.TYPE_CONSTRAINT_PREFIX, p));
        typeConstraint = typeConstraint.withMarkers(this.visitMarkers(typeConstraint.getMarkers(), p));
        typeConstraint = typeConstraint.withTypeExpression((TypeTree)this.visitAndCast((Tree)typeConstraint.getTypeExpression(), p));
        return typeConstraint;
    }

    public J visitAllowsConstraintClause(Cs.AllowsConstraintClause allowsConstraintClause, P p) {
        allowsConstraintClause = allowsConstraintClause.withPrefix(this.visitSpace(allowsConstraintClause.getPrefix(), CsSpace.Location.ALLOWS_CONSTRAINT_CLAUSE_PREFIX, p));
        allowsConstraintClause = allowsConstraintClause.withMarkers(this.visitMarkers(allowsConstraintClause.getMarkers(), p));
        allowsConstraintClause = allowsConstraintClause.getPadding().withExpressions(this.visitContainer(allowsConstraintClause.getPadding().getExpressions(), CsContainer.Location.ALLOWS_CONSTRAINT_CLAUSE_EXPRESSIONS, p));
        return allowsConstraintClause;
    }

    public J visitRefStructConstraint(Cs.RefStructConstraint refStructConstraint, P p) {
        refStructConstraint = refStructConstraint.withPrefix(this.visitSpace(refStructConstraint.getPrefix(), CsSpace.Location.REF_STRUCT_CONSTRAINT_PREFIX, p));
        refStructConstraint = refStructConstraint.withMarkers(this.visitMarkers(refStructConstraint.getMarkers(), p));
        return refStructConstraint;
    }

    public J visitClassOrStructConstraint(Cs.ClassOrStructConstraint classOrStructConstraint, P p) {
        classOrStructConstraint = classOrStructConstraint.withPrefix(this.visitSpace(classOrStructConstraint.getPrefix(), CsSpace.Location.CLASS_OR_STRUCT_CONSTRAINT_PREFIX, p));
        classOrStructConstraint = classOrStructConstraint.withMarkers(this.visitMarkers(classOrStructConstraint.getMarkers(), p));
        return classOrStructConstraint;
    }

    public J visitConstructorConstraint(Cs.ConstructorConstraint constructorConstraint, P p) {
        constructorConstraint = constructorConstraint.withPrefix(this.visitSpace(constructorConstraint.getPrefix(), CsSpace.Location.CONSTRUCTOR_CONSTRAINT_PREFIX, p));
        constructorConstraint = constructorConstraint.withMarkers(this.visitMarkers(constructorConstraint.getMarkers(), p));
        return constructorConstraint;
    }

    public J visitDefaultConstraint(Cs.DefaultConstraint defaultConstraint, P p) {
        defaultConstraint = defaultConstraint.withPrefix(this.visitSpace(defaultConstraint.getPrefix(), CsSpace.Location.DEFAULT_CONSTRAINT_PREFIX, p));
        defaultConstraint = defaultConstraint.withMarkers(this.visitMarkers(defaultConstraint.getMarkers(), p));
        return defaultConstraint;
    }

    public J visitDeclarationExpression(Cs.DeclarationExpression declarationExpression, P p) {
        Expression tempExpression = (Expression)this.visitExpression(declarationExpression = declarationExpression.withPrefix(this.visitSpace(declarationExpression.getPrefix(), CsSpace.Location.DECLARATION_EXPRESSION_PREFIX, p)), p);
        if (!(tempExpression instanceof Cs.DeclarationExpression)) {
            return tempExpression;
        }
        declarationExpression = (Cs.DeclarationExpression)tempExpression;
        declarationExpression = declarationExpression.withMarkers(this.visitMarkers(declarationExpression.getMarkers(), p));
        declarationExpression = declarationExpression.withTypeExpression((TypeTree)this.visitAndCast((Tree)declarationExpression.getTypeExpression(), p));
        declarationExpression = declarationExpression.withVariables((Cs.VariableDesignation)this.visitAndCast((Tree)declarationExpression.getVariables(), p));
        return declarationExpression;
    }

    public J visitSingleVariableDesignation(Cs.SingleVariableDesignation singleVariableDesignation, P p) {
        Expression tempExpression = (Expression)this.visitExpression(singleVariableDesignation = singleVariableDesignation.withPrefix(this.visitSpace(singleVariableDesignation.getPrefix(), CsSpace.Location.SINGLE_VARIABLE_DESIGNATION_PREFIX, p)), p);
        if (!(tempExpression instanceof Cs.SingleVariableDesignation)) {
            return tempExpression;
        }
        singleVariableDesignation = (Cs.SingleVariableDesignation)tempExpression;
        singleVariableDesignation = singleVariableDesignation.withMarkers(this.visitMarkers(singleVariableDesignation.getMarkers(), p));
        singleVariableDesignation = singleVariableDesignation.withName((J.Identifier)this.visitAndCast((Tree)singleVariableDesignation.getName(), p));
        return singleVariableDesignation;
    }

    public J visitParenthesizedVariableDesignation(Cs.ParenthesizedVariableDesignation parenthesizedVariableDesignation, P p) {
        Expression tempExpression = (Expression)this.visitExpression(parenthesizedVariableDesignation = parenthesizedVariableDesignation.withPrefix(this.visitSpace(parenthesizedVariableDesignation.getPrefix(), CsSpace.Location.PARENTHESIZED_VARIABLE_DESIGNATION_PREFIX, p)), p);
        if (!(tempExpression instanceof Cs.ParenthesizedVariableDesignation)) {
            return tempExpression;
        }
        parenthesizedVariableDesignation = (Cs.ParenthesizedVariableDesignation)tempExpression;
        parenthesizedVariableDesignation = parenthesizedVariableDesignation.withMarkers(this.visitMarkers(parenthesizedVariableDesignation.getMarkers(), p));
        parenthesizedVariableDesignation = parenthesizedVariableDesignation.getPadding().withVariables(this.visitContainer(parenthesizedVariableDesignation.getPadding().getVariables(), CsContainer.Location.PARENTHESIZED_VARIABLE_DESIGNATION_VARIABLES, p));
        return parenthesizedVariableDesignation;
    }

    public J visitDiscardVariableDesignation(Cs.DiscardVariableDesignation discardVariableDesignation, P p) {
        Expression tempExpression = (Expression)this.visitExpression(discardVariableDesignation = discardVariableDesignation.withPrefix(this.visitSpace(discardVariableDesignation.getPrefix(), CsSpace.Location.DISCARD_VARIABLE_DESIGNATION_PREFIX, p)), p);
        if (!(tempExpression instanceof Cs.DiscardVariableDesignation)) {
            return tempExpression;
        }
        discardVariableDesignation = (Cs.DiscardVariableDesignation)tempExpression;
        discardVariableDesignation = discardVariableDesignation.withMarkers(this.visitMarkers(discardVariableDesignation.getMarkers(), p));
        discardVariableDesignation = discardVariableDesignation.withDiscard((J.Identifier)this.visitAndCast((Tree)discardVariableDesignation.getDiscard(), p));
        return discardVariableDesignation;
    }

    public J visitTupleExpression(Cs.TupleExpression tupleExpression, P p) {
        Expression tempExpression = (Expression)this.visitExpression(tupleExpression = tupleExpression.withPrefix(this.visitSpace(tupleExpression.getPrefix(), CsSpace.Location.TUPLE_EXPRESSION_PREFIX, p)), p);
        if (!(tempExpression instanceof Cs.TupleExpression)) {
            return tempExpression;
        }
        tupleExpression = (Cs.TupleExpression)tempExpression;
        tupleExpression = tupleExpression.withMarkers(this.visitMarkers(tupleExpression.getMarkers(), p));
        tupleExpression = tupleExpression.getPadding().withArguments(this.visitContainer(tupleExpression.getPadding().getArguments(), CsContainer.Location.TUPLE_EXPRESSION_ARGUMENTS, p));
        return tupleExpression;
    }

    public J visitConstructor(Cs.Constructor constructor, P p) {
        Statement tempStatement = (Statement)this.visitStatement(constructor = constructor.withPrefix(this.visitSpace(constructor.getPrefix(), CsSpace.Location.CONSTRUCTOR_PREFIX, p)), p);
        if (!(tempStatement instanceof Cs.Constructor)) {
            return tempStatement;
        }
        constructor = (Cs.Constructor)tempStatement;
        constructor = constructor.withMarkers(this.visitMarkers(constructor.getMarkers(), p));
        constructor = constructor.withInitializer((Cs.ConstructorInitializer)this.visitAndCast((Tree)constructor.getInitializer(), p));
        constructor = constructor.withConstructorCore((J.MethodDeclaration)this.visitAndCast((Tree)constructor.getConstructorCore(), p));
        return constructor;
    }

    public J visitDestructorDeclaration(Cs.DestructorDeclaration destructorDeclaration, P p) {
        Statement tempStatement = (Statement)this.visitStatement(destructorDeclaration = destructorDeclaration.withPrefix(this.visitSpace(destructorDeclaration.getPrefix(), CsSpace.Location.DESTRUCTOR_DECLARATION_PREFIX, p)), p);
        if (!(tempStatement instanceof Cs.DestructorDeclaration)) {
            return tempStatement;
        }
        destructorDeclaration = (Cs.DestructorDeclaration)tempStatement;
        destructorDeclaration = destructorDeclaration.withMarkers(this.visitMarkers(destructorDeclaration.getMarkers(), p));
        destructorDeclaration = destructorDeclaration.withMethodCore((J.MethodDeclaration)this.visitAndCast((Tree)destructorDeclaration.getMethodCore(), p));
        return destructorDeclaration;
    }

    public J visitUnary(Cs.Unary unary, P p) {
        Statement tempStatement = (Statement)this.visitStatement(unary = unary.withPrefix(this.visitSpace(unary.getPrefix(), CsSpace.Location.UNARY_PREFIX, p)), p);
        if (!(tempStatement instanceof Cs.Unary)) {
            return tempStatement;
        }
        unary = (Cs.Unary)tempStatement;
        Expression tempExpression = (Expression)this.visitExpression(unary, p);
        if (!(tempExpression instanceof Cs.Unary)) {
            return tempExpression;
        }
        unary = (Cs.Unary)tempExpression;
        unary = unary.withMarkers(this.visitMarkers(unary.getMarkers(), p));
        unary = unary.getPadding().withOperator(this.visitLeftPadded(unary.getPadding().getOperator(), CsLeftPadded.Location.UNARY_OPERATOR, p));
        unary = unary.withExpression((Expression)this.visitAndCast((Tree)unary.getExpression(), p));
        return unary;
    }

    public J visitConstructorInitializer(Cs.ConstructorInitializer constructorInitializer, P p) {
        constructorInitializer = constructorInitializer.withPrefix(this.visitSpace(constructorInitializer.getPrefix(), CsSpace.Location.CONSTRUCTOR_INITIALIZER_PREFIX, p));
        constructorInitializer = constructorInitializer.withMarkers(this.visitMarkers(constructorInitializer.getMarkers(), p));
        constructorInitializer = constructorInitializer.withKeyword((Cs.Keyword)this.visitAndCast((Tree)constructorInitializer.getKeyword(), p));
        constructorInitializer = constructorInitializer.getPadding().withArguments(this.visitContainer(constructorInitializer.getPadding().getArguments(), CsContainer.Location.CONSTRUCTOR_INITIALIZER_ARGUMENTS, p));
        return constructorInitializer;
    }

    public J visitTupleType(Cs.TupleType tupleType, P p) {
        Expression tempExpression = (Expression)this.visitExpression(tupleType = tupleType.withPrefix(this.visitSpace(tupleType.getPrefix(), CsSpace.Location.TUPLE_TYPE_PREFIX, p)), p);
        if (!(tempExpression instanceof Cs.TupleType)) {
            return tempExpression;
        }
        tupleType = (Cs.TupleType)tempExpression;
        tupleType = tupleType.withMarkers(this.visitMarkers(tupleType.getMarkers(), p));
        tupleType = tupleType.getPadding().withElements(this.visitContainer(tupleType.getPadding().getElements(), CsContainer.Location.TUPLE_TYPE_ELEMENTS, p));
        return tupleType;
    }

    public J visitTupleElement(Cs.TupleElement tupleElement, P p) {
        tupleElement = tupleElement.withPrefix(this.visitSpace(tupleElement.getPrefix(), CsSpace.Location.TUPLE_ELEMENT_PREFIX, p));
        tupleElement = tupleElement.withMarkers(this.visitMarkers(tupleElement.getMarkers(), p));
        tupleElement = tupleElement.withType((TypeTree)this.visitAndCast((Tree)tupleElement.getType(), p));
        tupleElement = tupleElement.withName((J.Identifier)this.visitAndCast((Tree)tupleElement.getName(), p));
        return tupleElement;
    }

    public J visitNewClass(Cs.NewClass newClass, P p) {
        Statement tempStatement = (Statement)this.visitStatement(newClass = newClass.withPrefix(this.visitSpace(newClass.getPrefix(), CsSpace.Location.NEW_CLASS_PREFIX, p)), p);
        if (!(tempStatement instanceof Cs.NewClass)) {
            return tempStatement;
        }
        newClass = (Cs.NewClass)tempStatement;
        Expression tempExpression = (Expression)this.visitExpression(newClass, p);
        if (!(tempExpression instanceof Cs.NewClass)) {
            return tempExpression;
        }
        newClass = (Cs.NewClass)tempExpression;
        newClass = newClass.withMarkers(this.visitMarkers(newClass.getMarkers(), p));
        newClass = newClass.withNewClassCore((J.NewClass)this.visitAndCast((Tree)newClass.getNewClassCore(), p));
        newClass = newClass.withInitializer((Cs.InitializerExpression)this.visitAndCast((Tree)newClass.getInitializer(), p));
        return newClass;
    }

    public J visitInitializerExpression(Cs.InitializerExpression initializerExpression, P p) {
        Expression tempExpression = (Expression)this.visitExpression(initializerExpression = initializerExpression.withPrefix(this.visitSpace(initializerExpression.getPrefix(), CsSpace.Location.INITIALIZER_EXPRESSION_PREFIX, p)), p);
        if (!(tempExpression instanceof Cs.InitializerExpression)) {
            return tempExpression;
        }
        initializerExpression = (Cs.InitializerExpression)tempExpression;
        initializerExpression = initializerExpression.withMarkers(this.visitMarkers(initializerExpression.getMarkers(), p));
        initializerExpression = initializerExpression.getPadding().withExpressions(this.visitContainer(initializerExpression.getPadding().getExpressions(), CsContainer.Location.INITIALIZER_EXPRESSION_EXPRESSIONS, p));
        return initializerExpression;
    }

    public J visitImplicitElementAccess(Cs.ImplicitElementAccess implicitElementAccess, P p) {
        Expression tempExpression = (Expression)this.visitExpression(implicitElementAccess = implicitElementAccess.withPrefix(this.visitSpace(implicitElementAccess.getPrefix(), CsSpace.Location.IMPLICIT_ELEMENT_ACCESS_PREFIX, p)), p);
        if (!(tempExpression instanceof Cs.ImplicitElementAccess)) {
            return tempExpression;
        }
        implicitElementAccess = (Cs.ImplicitElementAccess)tempExpression;
        implicitElementAccess = implicitElementAccess.withMarkers(this.visitMarkers(implicitElementAccess.getMarkers(), p));
        implicitElementAccess = implicitElementAccess.getPadding().withArgumentList(this.visitContainer(implicitElementAccess.getPadding().getArgumentList(), CsContainer.Location.IMPLICIT_ELEMENT_ACCESS_ARGUMENT_LIST, p));
        return implicitElementAccess;
    }

    public J visitYield(Cs.Yield yield, P p) {
        Statement tempStatement = (Statement)this.visitStatement(yield = yield.withPrefix(this.visitSpace(yield.getPrefix(), CsSpace.Location.YIELD_PREFIX, p)), p);
        if (!(tempStatement instanceof Cs.Yield)) {
            return tempStatement;
        }
        yield = (Cs.Yield)tempStatement;
        yield = yield.withMarkers(this.visitMarkers(yield.getMarkers(), p));
        yield = yield.withReturnOrBreakKeyword((Cs.Keyword)this.visitAndCast((Tree)yield.getReturnOrBreakKeyword(), p));
        yield = yield.withExpression((Expression)this.visitAndCast((Tree)yield.getExpression(), p));
        return yield;
    }

    public J visitDefaultExpression(Cs.DefaultExpression defaultExpression, P p) {
        Expression tempExpression = (Expression)this.visitExpression(defaultExpression = defaultExpression.withPrefix(this.visitSpace(defaultExpression.getPrefix(), CsSpace.Location.DEFAULT_EXPRESSION_PREFIX, p)), p);
        if (!(tempExpression instanceof Cs.DefaultExpression)) {
            return tempExpression;
        }
        defaultExpression = (Cs.DefaultExpression)tempExpression;
        defaultExpression = defaultExpression.withMarkers(this.visitMarkers(defaultExpression.getMarkers(), p));
        defaultExpression = defaultExpression.getPadding().withTypeOperator(this.visitContainer(defaultExpression.getPadding().getTypeOperator(), CsContainer.Location.DEFAULT_EXPRESSION_TYPE_OPERATOR, p));
        return defaultExpression;
    }

    public J visitIsPattern(Cs.IsPattern isPattern, P p) {
        Expression tempExpression = (Expression)this.visitExpression(isPattern = isPattern.withPrefix(this.visitSpace(isPattern.getPrefix(), CsSpace.Location.IS_PATTERN_PREFIX, p)), p);
        if (!(tempExpression instanceof Cs.IsPattern)) {
            return tempExpression;
        }
        isPattern = (Cs.IsPattern)tempExpression;
        isPattern = isPattern.withMarkers(this.visitMarkers(isPattern.getMarkers(), p));
        isPattern = isPattern.withExpression((Expression)this.visitAndCast((Tree)isPattern.getExpression(), p));
        isPattern = isPattern.getPadding().withPattern(this.visitLeftPadded(isPattern.getPadding().getPattern(), CsLeftPadded.Location.IS_PATTERN_PATTERN, p));
        return isPattern;
    }

    public J visitUnaryPattern(Cs.UnaryPattern unaryPattern, P p) {
        Expression tempExpression = (Expression)this.visitExpression(unaryPattern = unaryPattern.withPrefix(this.visitSpace(unaryPattern.getPrefix(), CsSpace.Location.UNARY_PATTERN_PREFIX, p)), p);
        if (!(tempExpression instanceof Cs.UnaryPattern)) {
            return tempExpression;
        }
        unaryPattern = (Cs.UnaryPattern)tempExpression;
        unaryPattern = unaryPattern.withMarkers(this.visitMarkers(unaryPattern.getMarkers(), p));
        unaryPattern = unaryPattern.withOperator((Cs.Keyword)this.visitAndCast((Tree)unaryPattern.getOperator(), p));
        unaryPattern = unaryPattern.withPattern((Cs.Pattern)this.visitAndCast((Tree)unaryPattern.getPattern(), p));
        return unaryPattern;
    }

    public J visitTypePattern(Cs.TypePattern typePattern, P p) {
        Expression tempExpression = (Expression)this.visitExpression(typePattern = typePattern.withPrefix(this.visitSpace(typePattern.getPrefix(), CsSpace.Location.TYPE_PATTERN_PREFIX, p)), p);
        if (!(tempExpression instanceof Cs.TypePattern)) {
            return tempExpression;
        }
        typePattern = (Cs.TypePattern)tempExpression;
        typePattern = typePattern.withMarkers(this.visitMarkers(typePattern.getMarkers(), p));
        typePattern = typePattern.withTypeIdentifier((TypeTree)this.visitAndCast((Tree)typePattern.getTypeIdentifier(), p));
        typePattern = typePattern.withDesignation((Cs.VariableDesignation)this.visitAndCast((Tree)typePattern.getDesignation(), p));
        return typePattern;
    }

    public J visitBinaryPattern(Cs.BinaryPattern binaryPattern, P p) {
        Expression tempExpression = (Expression)this.visitExpression(binaryPattern = binaryPattern.withPrefix(this.visitSpace(binaryPattern.getPrefix(), CsSpace.Location.BINARY_PATTERN_PREFIX, p)), p);
        if (!(tempExpression instanceof Cs.BinaryPattern)) {
            return tempExpression;
        }
        binaryPattern = (Cs.BinaryPattern)tempExpression;
        binaryPattern = binaryPattern.withMarkers(this.visitMarkers(binaryPattern.getMarkers(), p));
        binaryPattern = binaryPattern.withLeft((Cs.Pattern)this.visitAndCast((Tree)binaryPattern.getLeft(), p));
        binaryPattern = binaryPattern.getPadding().withOperator(this.visitLeftPadded(binaryPattern.getPadding().getOperator(), CsLeftPadded.Location.BINARY_PATTERN_OPERATOR, p));
        binaryPattern = binaryPattern.withRight((Cs.Pattern)this.visitAndCast((Tree)binaryPattern.getRight(), p));
        return binaryPattern;
    }

    public J visitConstantPattern(Cs.ConstantPattern constantPattern, P p) {
        Expression tempExpression = (Expression)this.visitExpression(constantPattern = constantPattern.withPrefix(this.visitSpace(constantPattern.getPrefix(), CsSpace.Location.CONSTANT_PATTERN_PREFIX, p)), p);
        if (!(tempExpression instanceof Cs.ConstantPattern)) {
            return tempExpression;
        }
        constantPattern = (Cs.ConstantPattern)tempExpression;
        constantPattern = constantPattern.withMarkers(this.visitMarkers(constantPattern.getMarkers(), p));
        constantPattern = constantPattern.withValue((Expression)this.visitAndCast((Tree)constantPattern.getValue(), p));
        return constantPattern;
    }

    public J visitDiscardPattern(Cs.DiscardPattern discardPattern, P p) {
        Expression tempExpression = (Expression)this.visitExpression(discardPattern = discardPattern.withPrefix(this.visitSpace(discardPattern.getPrefix(), CsSpace.Location.DISCARD_PATTERN_PREFIX, p)), p);
        if (!(tempExpression instanceof Cs.DiscardPattern)) {
            return tempExpression;
        }
        discardPattern = (Cs.DiscardPattern)tempExpression;
        discardPattern = discardPattern.withMarkers(this.visitMarkers(discardPattern.getMarkers(), p));
        return discardPattern;
    }

    public J visitListPattern(Cs.ListPattern listPattern, P p) {
        Expression tempExpression = (Expression)this.visitExpression(listPattern = listPattern.withPrefix(this.visitSpace(listPattern.getPrefix(), CsSpace.Location.LIST_PATTERN_PREFIX, p)), p);
        if (!(tempExpression instanceof Cs.ListPattern)) {
            return tempExpression;
        }
        listPattern = (Cs.ListPattern)tempExpression;
        listPattern = listPattern.withMarkers(this.visitMarkers(listPattern.getMarkers(), p));
        listPattern = listPattern.getPadding().withPatterns(this.visitContainer(listPattern.getPadding().getPatterns(), CsContainer.Location.LIST_PATTERN_PATTERNS, p));
        listPattern = listPattern.withDesignation((Cs.VariableDesignation)this.visitAndCast((Tree)listPattern.getDesignation(), p));
        return listPattern;
    }

    public J visitParenthesizedPattern(Cs.ParenthesizedPattern parenthesizedPattern, P p) {
        Expression tempExpression = (Expression)this.visitExpression(parenthesizedPattern = parenthesizedPattern.withPrefix(this.visitSpace(parenthesizedPattern.getPrefix(), CsSpace.Location.PARENTHESIZED_PATTERN_PREFIX, p)), p);
        if (!(tempExpression instanceof Cs.ParenthesizedPattern)) {
            return tempExpression;
        }
        parenthesizedPattern = (Cs.ParenthesizedPattern)tempExpression;
        parenthesizedPattern = parenthesizedPattern.withMarkers(this.visitMarkers(parenthesizedPattern.getMarkers(), p));
        parenthesizedPattern = parenthesizedPattern.getPadding().withPattern(this.visitContainer(parenthesizedPattern.getPadding().getPattern(), CsContainer.Location.PARENTHESIZED_PATTERN_PATTERN, p));
        return parenthesizedPattern;
    }

    public J visitRecursivePattern(Cs.RecursivePattern recursivePattern, P p) {
        Expression tempExpression = (Expression)this.visitExpression(recursivePattern = recursivePattern.withPrefix(this.visitSpace(recursivePattern.getPrefix(), CsSpace.Location.RECURSIVE_PATTERN_PREFIX, p)), p);
        if (!(tempExpression instanceof Cs.RecursivePattern)) {
            return tempExpression;
        }
        recursivePattern = (Cs.RecursivePattern)tempExpression;
        recursivePattern = recursivePattern.withMarkers(this.visitMarkers(recursivePattern.getMarkers(), p));
        recursivePattern = recursivePattern.withTypeQualifier((TypeTree)this.visitAndCast((Tree)recursivePattern.getTypeQualifier(), p));
        recursivePattern = recursivePattern.withPositionalPattern((Cs.PositionalPatternClause)this.visitAndCast((Tree)recursivePattern.getPositionalPattern(), p));
        recursivePattern = recursivePattern.withPropertyPattern((Cs.PropertyPatternClause)this.visitAndCast((Tree)recursivePattern.getPropertyPattern(), p));
        recursivePattern = recursivePattern.withDesignation((Cs.VariableDesignation)this.visitAndCast((Tree)recursivePattern.getDesignation(), p));
        return recursivePattern;
    }

    public J visitVarPattern(Cs.VarPattern varPattern, P p) {
        Expression tempExpression = (Expression)this.visitExpression(varPattern = varPattern.withPrefix(this.visitSpace(varPattern.getPrefix(), CsSpace.Location.VAR_PATTERN_PREFIX, p)), p);
        if (!(tempExpression instanceof Cs.VarPattern)) {
            return tempExpression;
        }
        varPattern = (Cs.VarPattern)tempExpression;
        varPattern = varPattern.withMarkers(this.visitMarkers(varPattern.getMarkers(), p));
        varPattern = varPattern.withDesignation((Cs.VariableDesignation)this.visitAndCast((Tree)varPattern.getDesignation(), p));
        return varPattern;
    }

    public J visitPositionalPatternClause(Cs.PositionalPatternClause positionalPatternClause, P p) {
        positionalPatternClause = positionalPatternClause.withPrefix(this.visitSpace(positionalPatternClause.getPrefix(), CsSpace.Location.POSITIONAL_PATTERN_CLAUSE_PREFIX, p));
        positionalPatternClause = positionalPatternClause.withMarkers(this.visitMarkers(positionalPatternClause.getMarkers(), p));
        positionalPatternClause = positionalPatternClause.getPadding().withSubpatterns(this.visitContainer(positionalPatternClause.getPadding().getSubpatterns(), CsContainer.Location.POSITIONAL_PATTERN_CLAUSE_SUBPATTERNS, p));
        return positionalPatternClause;
    }

    public J visitRelationalPattern(Cs.RelationalPattern relationalPattern, P p) {
        Expression tempExpression = (Expression)this.visitExpression(relationalPattern = relationalPattern.withPrefix(this.visitSpace(relationalPattern.getPrefix(), CsSpace.Location.RELATIONAL_PATTERN_PREFIX, p)), p);
        if (!(tempExpression instanceof Cs.RelationalPattern)) {
            return tempExpression;
        }
        relationalPattern = (Cs.RelationalPattern)tempExpression;
        relationalPattern = relationalPattern.withMarkers(this.visitMarkers(relationalPattern.getMarkers(), p));
        relationalPattern = relationalPattern.getPadding().withOperator(this.visitLeftPadded(relationalPattern.getPadding().getOperator(), CsLeftPadded.Location.RELATIONAL_PATTERN_OPERATOR, p));
        relationalPattern = relationalPattern.withValue((Expression)this.visitAndCast((Tree)relationalPattern.getValue(), p));
        return relationalPattern;
    }

    public J visitSlicePattern(Cs.SlicePattern slicePattern, P p) {
        Expression tempExpression = (Expression)this.visitExpression(slicePattern = slicePattern.withPrefix(this.visitSpace(slicePattern.getPrefix(), CsSpace.Location.SLICE_PATTERN_PREFIX, p)), p);
        if (!(tempExpression instanceof Cs.SlicePattern)) {
            return tempExpression;
        }
        slicePattern = (Cs.SlicePattern)tempExpression;
        slicePattern = slicePattern.withMarkers(this.visitMarkers(slicePattern.getMarkers(), p));
        return slicePattern;
    }

    public J visitPropertyPatternClause(Cs.PropertyPatternClause propertyPatternClause, P p) {
        propertyPatternClause = propertyPatternClause.withPrefix(this.visitSpace(propertyPatternClause.getPrefix(), CsSpace.Location.PROPERTY_PATTERN_CLAUSE_PREFIX, p));
        propertyPatternClause = propertyPatternClause.withMarkers(this.visitMarkers(propertyPatternClause.getMarkers(), p));
        propertyPatternClause = propertyPatternClause.getPadding().withSubpatterns(this.visitContainer(propertyPatternClause.getPadding().getSubpatterns(), CsContainer.Location.PROPERTY_PATTERN_CLAUSE_SUBPATTERNS, p));
        return propertyPatternClause;
    }

    public J visitSubpattern(Cs.Subpattern subpattern, P p) {
        Expression tempExpression = (Expression)this.visitExpression(subpattern = subpattern.withPrefix(this.visitSpace(subpattern.getPrefix(), CsSpace.Location.SUBPATTERN_PREFIX, p)), p);
        if (!(tempExpression instanceof Cs.Subpattern)) {
            return tempExpression;
        }
        subpattern = (Cs.Subpattern)tempExpression;
        subpattern = subpattern.withMarkers(this.visitMarkers(subpattern.getMarkers(), p));
        subpattern = subpattern.withName((Expression)this.visitAndCast((Tree)subpattern.getName(), p));
        subpattern = subpattern.getPadding().withPattern(this.visitLeftPadded(subpattern.getPadding().getPattern(), CsLeftPadded.Location.SUBPATTERN_PATTERN, p));
        return subpattern;
    }

    public J visitSwitchExpression(Cs.SwitchExpression switchExpression, P p) {
        Expression tempExpression = (Expression)this.visitExpression(switchExpression = switchExpression.withPrefix(this.visitSpace(switchExpression.getPrefix(), CsSpace.Location.SWITCH_EXPRESSION_PREFIX, p)), p);
        if (!(tempExpression instanceof Cs.SwitchExpression)) {
            return tempExpression;
        }
        switchExpression = (Cs.SwitchExpression)tempExpression;
        switchExpression = switchExpression.withMarkers(this.visitMarkers(switchExpression.getMarkers(), p));
        switchExpression = switchExpression.getPadding().withExpression(this.visitRightPadded(switchExpression.getPadding().getExpression(), CsRightPadded.Location.SWITCH_EXPRESSION_EXPRESSION, p));
        switchExpression = switchExpression.getPadding().withArms(this.visitContainer(switchExpression.getPadding().getArms(), CsContainer.Location.SWITCH_EXPRESSION_ARMS, p));
        return switchExpression;
    }

    public J visitSwitchExpressionArm(Cs.SwitchExpressionArm switchExpressionArm, P p) {
        switchExpressionArm = switchExpressionArm.withPrefix(this.visitSpace(switchExpressionArm.getPrefix(), CsSpace.Location.SWITCH_EXPRESSION_ARM_PREFIX, p));
        switchExpressionArm = switchExpressionArm.withMarkers(this.visitMarkers(switchExpressionArm.getMarkers(), p));
        switchExpressionArm = switchExpressionArm.withPattern((Cs.Pattern)this.visitAndCast((Tree)switchExpressionArm.getPattern(), p));
        switchExpressionArm = switchExpressionArm.getPadding().withWhenExpression(this.visitLeftPadded(switchExpressionArm.getPadding().getWhenExpression(), CsLeftPadded.Location.SWITCH_EXPRESSION_ARM_WHEN_EXPRESSION, p));
        switchExpressionArm = switchExpressionArm.getPadding().withExpression(this.visitLeftPadded(switchExpressionArm.getPadding().getExpression(), CsLeftPadded.Location.SWITCH_EXPRESSION_ARM_EXPRESSION, p));
        return switchExpressionArm;
    }

    public J visitSwitchSection(Cs.SwitchSection switchSection, P p) {
        Statement tempStatement = (Statement)this.visitStatement(switchSection = switchSection.withPrefix(this.visitSpace(switchSection.getPrefix(), CsSpace.Location.SWITCH_SECTION_PREFIX, p)), p);
        if (!(tempStatement instanceof Cs.SwitchSection)) {
            return tempStatement;
        }
        switchSection = (Cs.SwitchSection)tempStatement;
        switchSection = switchSection.withMarkers(this.visitMarkers(switchSection.getMarkers(), p));
        switchSection = switchSection.withLabels(ListUtils.map(switchSection.getLabels(), el -> (Cs.SwitchLabel)this.visit((Tree)el, p)));
        switchSection = switchSection.getPadding().withStatements(ListUtils.map(switchSection.getPadding().getStatements(), el -> this.visitRightPadded((JRightPadded)el, CsRightPadded.Location.SWITCH_SECTION_STATEMENTS, p)));
        return switchSection;
    }

    public J visitDefaultSwitchLabel(Cs.DefaultSwitchLabel defaultSwitchLabel, P p) {
        Expression tempExpression = (Expression)this.visitExpression(defaultSwitchLabel = defaultSwitchLabel.withPrefix(this.visitSpace(defaultSwitchLabel.getPrefix(), CsSpace.Location.DEFAULT_SWITCH_LABEL_PREFIX, p)), p);
        if (!(tempExpression instanceof Cs.DefaultSwitchLabel)) {
            return tempExpression;
        }
        defaultSwitchLabel = (Cs.DefaultSwitchLabel)tempExpression;
        defaultSwitchLabel = defaultSwitchLabel.withMarkers(this.visitMarkers(defaultSwitchLabel.getMarkers(), p));
        defaultSwitchLabel = defaultSwitchLabel.withColonToken(this.visitSpace(defaultSwitchLabel.getColonToken(), CsSpace.Location.DEFAULT_SWITCH_LABEL_COLON_TOKEN, p));
        return defaultSwitchLabel;
    }

    public J visitCasePatternSwitchLabel(Cs.CasePatternSwitchLabel casePatternSwitchLabel, P p) {
        Expression tempExpression = (Expression)this.visitExpression(casePatternSwitchLabel = casePatternSwitchLabel.withPrefix(this.visitSpace(casePatternSwitchLabel.getPrefix(), CsSpace.Location.CASE_PATTERN_SWITCH_LABEL_PREFIX, p)), p);
        if (!(tempExpression instanceof Cs.CasePatternSwitchLabel)) {
            return tempExpression;
        }
        casePatternSwitchLabel = (Cs.CasePatternSwitchLabel)tempExpression;
        casePatternSwitchLabel = casePatternSwitchLabel.withMarkers(this.visitMarkers(casePatternSwitchLabel.getMarkers(), p));
        casePatternSwitchLabel = casePatternSwitchLabel.withPattern((Cs.Pattern)this.visitAndCast((Tree)casePatternSwitchLabel.getPattern(), p));
        casePatternSwitchLabel = casePatternSwitchLabel.getPadding().withWhenClause(this.visitLeftPadded(casePatternSwitchLabel.getPadding().getWhenClause(), CsLeftPadded.Location.CASE_PATTERN_SWITCH_LABEL_WHEN_CLAUSE, p));
        casePatternSwitchLabel = casePatternSwitchLabel.withColonToken(this.visitSpace(casePatternSwitchLabel.getColonToken(), CsSpace.Location.CASE_PATTERN_SWITCH_LABEL_COLON_TOKEN, p));
        return casePatternSwitchLabel;
    }

    public J visitSwitchStatement(Cs.SwitchStatement switchStatement, P p) {
        Statement tempStatement = (Statement)this.visitStatement(switchStatement = switchStatement.withPrefix(this.visitSpace(switchStatement.getPrefix(), CsSpace.Location.SWITCH_STATEMENT_PREFIX, p)), p);
        if (!(tempStatement instanceof Cs.SwitchStatement)) {
            return tempStatement;
        }
        switchStatement = (Cs.SwitchStatement)tempStatement;
        switchStatement = switchStatement.withMarkers(this.visitMarkers(switchStatement.getMarkers(), p));
        switchStatement = switchStatement.getPadding().withExpression(this.visitContainer(switchStatement.getPadding().getExpression(), CsContainer.Location.SWITCH_STATEMENT_EXPRESSION, p));
        switchStatement = switchStatement.getPadding().withSections(this.visitContainer(switchStatement.getPadding().getSections(), CsContainer.Location.SWITCH_STATEMENT_SECTIONS, p));
        return switchStatement;
    }

    public J visitLockStatement(Cs.LockStatement lockStatement, P p) {
        Statement tempStatement = (Statement)this.visitStatement(lockStatement = lockStatement.withPrefix(this.visitSpace(lockStatement.getPrefix(), CsSpace.Location.LOCK_STATEMENT_PREFIX, p)), p);
        if (!(tempStatement instanceof Cs.LockStatement)) {
            return tempStatement;
        }
        lockStatement = (Cs.LockStatement)tempStatement;
        lockStatement = lockStatement.withMarkers(this.visitMarkers(lockStatement.getMarkers(), p));
        lockStatement = lockStatement.withExpression((J.ControlParentheses<Expression>)((J.ControlParentheses)this.visitAndCast((Tree)lockStatement.getExpression(), p)));
        lockStatement = lockStatement.getPadding().withStatement(this.visitRightPadded(lockStatement.getPadding().getStatement(), CsRightPadded.Location.LOCK_STATEMENT_STATEMENT, p));
        return lockStatement;
    }

    public J visitFixedStatement(Cs.FixedStatement fixedStatement, P p) {
        Statement tempStatement = (Statement)this.visitStatement(fixedStatement = fixedStatement.withPrefix(this.visitSpace(fixedStatement.getPrefix(), CsSpace.Location.FIXED_STATEMENT_PREFIX, p)), p);
        if (!(tempStatement instanceof Cs.FixedStatement)) {
            return tempStatement;
        }
        fixedStatement = (Cs.FixedStatement)tempStatement;
        fixedStatement = fixedStatement.withMarkers(this.visitMarkers(fixedStatement.getMarkers(), p));
        fixedStatement = fixedStatement.withDeclarations((J.ControlParentheses<J.VariableDeclarations>)((J.ControlParentheses)this.visitAndCast((Tree)fixedStatement.getDeclarations(), p)));
        fixedStatement = fixedStatement.withBlock((J.Block)this.visitAndCast((Tree)fixedStatement.getBlock(), p));
        return fixedStatement;
    }

    public J visitCheckedExpression(Cs.CheckedExpression checkedExpression, P p) {
        Expression tempExpression = (Expression)this.visitExpression(checkedExpression = checkedExpression.withPrefix(this.visitSpace(checkedExpression.getPrefix(), CsSpace.Location.CHECKED_EXPRESSION_PREFIX, p)), p);
        if (!(tempExpression instanceof Cs.CheckedExpression)) {
            return tempExpression;
        }
        checkedExpression = (Cs.CheckedExpression)tempExpression;
        checkedExpression = checkedExpression.withMarkers(this.visitMarkers(checkedExpression.getMarkers(), p));
        checkedExpression = checkedExpression.withCheckedOrUncheckedKeyword((Cs.Keyword)this.visitAndCast((Tree)checkedExpression.getCheckedOrUncheckedKeyword(), p));
        checkedExpression = checkedExpression.withExpression((J.ControlParentheses<Expression>)((J.ControlParentheses)this.visitAndCast((Tree)checkedExpression.getExpression(), p)));
        return checkedExpression;
    }

    public J visitCheckedStatement(Cs.CheckedStatement checkedStatement, P p) {
        Statement tempStatement = (Statement)this.visitStatement(checkedStatement = checkedStatement.withPrefix(this.visitSpace(checkedStatement.getPrefix(), CsSpace.Location.CHECKED_STATEMENT_PREFIX, p)), p);
        if (!(tempStatement instanceof Cs.CheckedStatement)) {
            return tempStatement;
        }
        checkedStatement = (Cs.CheckedStatement)tempStatement;
        checkedStatement = checkedStatement.withMarkers(this.visitMarkers(checkedStatement.getMarkers(), p));
        checkedStatement = checkedStatement.withKeyword((Cs.Keyword)this.visitAndCast((Tree)checkedStatement.getKeyword(), p));
        checkedStatement = checkedStatement.withBlock((J.Block)this.visitAndCast((Tree)checkedStatement.getBlock(), p));
        return checkedStatement;
    }

    public J visitUnsafeStatement(Cs.UnsafeStatement unsafeStatement, P p) {
        Statement tempStatement = (Statement)this.visitStatement(unsafeStatement = unsafeStatement.withPrefix(this.visitSpace(unsafeStatement.getPrefix(), CsSpace.Location.UNSAFE_STATEMENT_PREFIX, p)), p);
        if (!(tempStatement instanceof Cs.UnsafeStatement)) {
            return tempStatement;
        }
        unsafeStatement = (Cs.UnsafeStatement)tempStatement;
        unsafeStatement = unsafeStatement.withMarkers(this.visitMarkers(unsafeStatement.getMarkers(), p));
        unsafeStatement = unsafeStatement.withBlock((J.Block)this.visitAndCast((Tree)unsafeStatement.getBlock(), p));
        return unsafeStatement;
    }

    public J visitRangeExpression(Cs.RangeExpression rangeExpression, P p) {
        Expression tempExpression = (Expression)this.visitExpression(rangeExpression = rangeExpression.withPrefix(this.visitSpace(rangeExpression.getPrefix(), CsSpace.Location.RANGE_EXPRESSION_PREFIX, p)), p);
        if (!(tempExpression instanceof Cs.RangeExpression)) {
            return tempExpression;
        }
        rangeExpression = (Cs.RangeExpression)tempExpression;
        rangeExpression = rangeExpression.withMarkers(this.visitMarkers(rangeExpression.getMarkers(), p));
        rangeExpression = rangeExpression.getPadding().withStart(this.visitRightPadded(rangeExpression.getPadding().getStart(), CsRightPadded.Location.RANGE_EXPRESSION_START, p));
        rangeExpression = rangeExpression.withEnd((Expression)this.visitAndCast((Tree)rangeExpression.getEnd(), p));
        return rangeExpression;
    }

    public J visitQueryExpression(Cs.QueryExpression queryExpression, P p) {
        Expression tempExpression = (Expression)this.visitExpression(queryExpression = queryExpression.withPrefix(this.visitSpace(queryExpression.getPrefix(), CsSpace.Location.QUERY_EXPRESSION_PREFIX, p)), p);
        if (!(tempExpression instanceof Cs.QueryExpression)) {
            return tempExpression;
        }
        queryExpression = (Cs.QueryExpression)tempExpression;
        queryExpression = queryExpression.withMarkers(this.visitMarkers(queryExpression.getMarkers(), p));
        queryExpression = queryExpression.withFromClause((Cs.FromClause)this.visitAndCast((Tree)queryExpression.getFromClause(), p));
        queryExpression = queryExpression.withBody((Cs.QueryBody)this.visitAndCast((Tree)queryExpression.getBody(), p));
        return queryExpression;
    }

    public J visitQueryBody(Cs.QueryBody queryBody, P p) {
        queryBody = queryBody.withPrefix(this.visitSpace(queryBody.getPrefix(), CsSpace.Location.QUERY_BODY_PREFIX, p));
        queryBody = queryBody.withMarkers(this.visitMarkers(queryBody.getMarkers(), p));
        queryBody = queryBody.withClauses(ListUtils.map(queryBody.getClauses(), el -> (Cs.QueryClause)this.visit((Tree)el, p)));
        queryBody = queryBody.withSelectOrGroup((Cs.SelectOrGroupClause)this.visitAndCast((Tree)queryBody.getSelectOrGroup(), p));
        queryBody = queryBody.withContinuation((Cs.QueryContinuation)this.visitAndCast((Tree)queryBody.getContinuation(), p));
        return queryBody;
    }

    public J visitFromClause(Cs.FromClause fromClause, P p) {
        Expression tempExpression = (Expression)this.visitExpression(fromClause = fromClause.withPrefix(this.visitSpace(fromClause.getPrefix(), CsSpace.Location.FROM_CLAUSE_PREFIX, p)), p);
        if (!(tempExpression instanceof Cs.FromClause)) {
            return tempExpression;
        }
        fromClause = (Cs.FromClause)tempExpression;
        fromClause = fromClause.withMarkers(this.visitMarkers(fromClause.getMarkers(), p));
        fromClause = fromClause.withTypeIdentifier((TypeTree)this.visitAndCast((Tree)fromClause.getTypeIdentifier(), p));
        fromClause = fromClause.getPadding().withIdentifier(this.visitRightPadded(fromClause.getPadding().getIdentifier(), CsRightPadded.Location.FROM_CLAUSE_IDENTIFIER, p));
        fromClause = fromClause.withExpression((Expression)this.visitAndCast((Tree)fromClause.getExpression(), p));
        return fromClause;
    }

    public J visitLetClause(Cs.LetClause letClause, P p) {
        letClause = letClause.withPrefix(this.visitSpace(letClause.getPrefix(), CsSpace.Location.LET_CLAUSE_PREFIX, p));
        letClause = letClause.withMarkers(this.visitMarkers(letClause.getMarkers(), p));
        letClause = letClause.getPadding().withIdentifier(this.visitRightPadded(letClause.getPadding().getIdentifier(), CsRightPadded.Location.LET_CLAUSE_IDENTIFIER, p));
        letClause = letClause.withExpression((Expression)this.visitAndCast((Tree)letClause.getExpression(), p));
        return letClause;
    }

    public J visitJoinClause(Cs.JoinClause joinClause, P p) {
        joinClause = joinClause.withPrefix(this.visitSpace(joinClause.getPrefix(), CsSpace.Location.JOIN_CLAUSE_PREFIX, p));
        joinClause = joinClause.withMarkers(this.visitMarkers(joinClause.getMarkers(), p));
        joinClause = joinClause.getPadding().withIdentifier(this.visitRightPadded(joinClause.getPadding().getIdentifier(), CsRightPadded.Location.JOIN_CLAUSE_IDENTIFIER, p));
        joinClause = joinClause.getPadding().withInExpression(this.visitRightPadded(joinClause.getPadding().getInExpression(), CsRightPadded.Location.JOIN_CLAUSE_IN_EXPRESSION, p));
        joinClause = joinClause.getPadding().withLeftExpression(this.visitRightPadded(joinClause.getPadding().getLeftExpression(), CsRightPadded.Location.JOIN_CLAUSE_LEFT_EXPRESSION, p));
        joinClause = joinClause.withRightExpression((Expression)this.visitAndCast((Tree)joinClause.getRightExpression(), p));
        joinClause = joinClause.getPadding().withInto(this.visitLeftPadded(joinClause.getPadding().getInto(), CsLeftPadded.Location.JOIN_CLAUSE_INTO, p));
        return joinClause;
    }

    public J visitJoinIntoClause(Cs.JoinIntoClause joinIntoClause, P p) {
        joinIntoClause = joinIntoClause.withPrefix(this.visitSpace(joinIntoClause.getPrefix(), CsSpace.Location.JOIN_INTO_CLAUSE_PREFIX, p));
        joinIntoClause = joinIntoClause.withMarkers(this.visitMarkers(joinIntoClause.getMarkers(), p));
        joinIntoClause = joinIntoClause.withIdentifier((J.Identifier)this.visitAndCast((Tree)joinIntoClause.getIdentifier(), p));
        return joinIntoClause;
    }

    public J visitWhereClause(Cs.WhereClause whereClause, P p) {
        whereClause = whereClause.withPrefix(this.visitSpace(whereClause.getPrefix(), CsSpace.Location.WHERE_CLAUSE_PREFIX, p));
        whereClause = whereClause.withMarkers(this.visitMarkers(whereClause.getMarkers(), p));
        whereClause = whereClause.withCondition((Expression)this.visitAndCast((Tree)whereClause.getCondition(), p));
        return whereClause;
    }

    public J visitOrderByClause(Cs.OrderByClause orderByClause, P p) {
        orderByClause = orderByClause.withPrefix(this.visitSpace(orderByClause.getPrefix(), CsSpace.Location.ORDER_BY_CLAUSE_PREFIX, p));
        orderByClause = orderByClause.withMarkers(this.visitMarkers(orderByClause.getMarkers(), p));
        orderByClause = orderByClause.getPadding().withOrderings(ListUtils.map(orderByClause.getPadding().getOrderings(), el -> this.visitRightPadded((JRightPadded)el, CsRightPadded.Location.ORDER_BY_CLAUSE_ORDERINGS, p)));
        return orderByClause;
    }

    public J visitQueryContinuation(Cs.QueryContinuation queryContinuation, P p) {
        queryContinuation = queryContinuation.withPrefix(this.visitSpace(queryContinuation.getPrefix(), CsSpace.Location.QUERY_CONTINUATION_PREFIX, p));
        queryContinuation = queryContinuation.withMarkers(this.visitMarkers(queryContinuation.getMarkers(), p));
        queryContinuation = queryContinuation.withIdentifier((J.Identifier)this.visitAndCast((Tree)queryContinuation.getIdentifier(), p));
        queryContinuation = queryContinuation.withBody((Cs.QueryBody)this.visitAndCast((Tree)queryContinuation.getBody(), p));
        return queryContinuation;
    }

    public J visitOrdering(Cs.Ordering ordering, P p) {
        ordering = ordering.withPrefix(this.visitSpace(ordering.getPrefix(), CsSpace.Location.ORDERING_PREFIX, p));
        ordering = ordering.withMarkers(this.visitMarkers(ordering.getMarkers(), p));
        ordering = ordering.getPadding().withExpression(this.visitRightPadded(ordering.getPadding().getExpression(), CsRightPadded.Location.ORDERING_EXPRESSION, p));
        return ordering;
    }

    public J visitSelectClause(Cs.SelectClause selectClause, P p) {
        selectClause = selectClause.withPrefix(this.visitSpace(selectClause.getPrefix(), CsSpace.Location.SELECT_CLAUSE_PREFIX, p));
        selectClause = selectClause.withMarkers(this.visitMarkers(selectClause.getMarkers(), p));
        selectClause = selectClause.withExpression((Expression)this.visitAndCast((Tree)selectClause.getExpression(), p));
        return selectClause;
    }

    public J visitGroupClause(Cs.GroupClause groupClause, P p) {
        groupClause = groupClause.withPrefix(this.visitSpace(groupClause.getPrefix(), CsSpace.Location.GROUP_CLAUSE_PREFIX, p));
        groupClause = groupClause.withMarkers(this.visitMarkers(groupClause.getMarkers(), p));
        groupClause = groupClause.getPadding().withGroupExpression(this.visitRightPadded(groupClause.getPadding().getGroupExpression(), CsRightPadded.Location.GROUP_CLAUSE_GROUP_EXPRESSION, p));
        groupClause = groupClause.withKey((Expression)this.visitAndCast((Tree)groupClause.getKey(), p));
        return groupClause;
    }

    public J visitIndexerDeclaration(Cs.IndexerDeclaration indexerDeclaration, P p) {
        Statement tempStatement = (Statement)this.visitStatement(indexerDeclaration = indexerDeclaration.withPrefix(this.visitSpace(indexerDeclaration.getPrefix(), CsSpace.Location.INDEXER_DECLARATION_PREFIX, p)), p);
        if (!(tempStatement instanceof Cs.IndexerDeclaration)) {
            return tempStatement;
        }
        indexerDeclaration = (Cs.IndexerDeclaration)tempStatement;
        indexerDeclaration = indexerDeclaration.withMarkers(this.visitMarkers(indexerDeclaration.getMarkers(), p));
        indexerDeclaration = indexerDeclaration.withModifiers(ListUtils.map(indexerDeclaration.getModifiers(), el -> (J.Modifier)this.visit((Tree)el, p)));
        indexerDeclaration = indexerDeclaration.withTypeExpression((TypeTree)this.visitAndCast((Tree)indexerDeclaration.getTypeExpression(), p));
        indexerDeclaration = indexerDeclaration.withIndexer((Expression)this.visitAndCast((Tree)indexerDeclaration.getIndexer(), p));
        indexerDeclaration = indexerDeclaration.getPadding().withParameters(this.visitContainer(indexerDeclaration.getPadding().getParameters(), CsContainer.Location.INDEXER_DECLARATION_PARAMETERS, p));
        indexerDeclaration = indexerDeclaration.getPadding().withExpressionBody(this.visitLeftPadded(indexerDeclaration.getPadding().getExpressionBody(), CsLeftPadded.Location.INDEXER_DECLARATION_EXPRESSION_BODY, p));
        indexerDeclaration = indexerDeclaration.withAccessors((J.Block)this.visitAndCast((Tree)indexerDeclaration.getAccessors(), p));
        return indexerDeclaration;
    }

    public J visitDelegateDeclaration(Cs.DelegateDeclaration delegateDeclaration, P p) {
        Statement tempStatement = (Statement)this.visitStatement(delegateDeclaration = delegateDeclaration.withPrefix(this.visitSpace(delegateDeclaration.getPrefix(), CsSpace.Location.DELEGATE_DECLARATION_PREFIX, p)), p);
        if (!(tempStatement instanceof Cs.DelegateDeclaration)) {
            return tempStatement;
        }
        delegateDeclaration = (Cs.DelegateDeclaration)tempStatement;
        delegateDeclaration = delegateDeclaration.withMarkers(this.visitMarkers(delegateDeclaration.getMarkers(), p));
        delegateDeclaration = delegateDeclaration.withAttributes(ListUtils.map(delegateDeclaration.getAttributes(), el -> (Cs.AttributeList)this.visit((Tree)el, p)));
        delegateDeclaration = delegateDeclaration.withModifiers(ListUtils.map(delegateDeclaration.getModifiers(), el -> (J.Modifier)this.visit((Tree)el, p)));
        delegateDeclaration = delegateDeclaration.getPadding().withReturnType(this.visitLeftPadded(delegateDeclaration.getPadding().getReturnType(), CsLeftPadded.Location.DELEGATE_DECLARATION_RETURN_TYPE, p));
        delegateDeclaration = delegateDeclaration.withIdentifier((J.Identifier)this.visitAndCast((Tree)delegateDeclaration.getIdentifier(), p));
        delegateDeclaration = delegateDeclaration.getPadding().withTypeParameters(this.visitContainer(delegateDeclaration.getPadding().getTypeParameters(), CsContainer.Location.DELEGATE_DECLARATION_TYPE_PARAMETERS, p));
        delegateDeclaration = delegateDeclaration.getPadding().withParameters(this.visitContainer(delegateDeclaration.getPadding().getParameters(), CsContainer.Location.DELEGATE_DECLARATION_PARAMETERS, p));
        delegateDeclaration = delegateDeclaration.getPadding().withTypeParameterConstraintClauses(this.visitContainer(delegateDeclaration.getPadding().getTypeParameterConstraintClauses(), CsContainer.Location.DELEGATE_DECLARATION_TYPE_PARAMETER_CONSTRAINT_CLAUSES, p));
        return delegateDeclaration;
    }

    public J visitConversionOperatorDeclaration(Cs.ConversionOperatorDeclaration conversionOperatorDeclaration, P p) {
        Statement tempStatement = (Statement)this.visitStatement(conversionOperatorDeclaration = conversionOperatorDeclaration.withPrefix(this.visitSpace(conversionOperatorDeclaration.getPrefix(), CsSpace.Location.CONVERSION_OPERATOR_DECLARATION_PREFIX, p)), p);
        if (!(tempStatement instanceof Cs.ConversionOperatorDeclaration)) {
            return tempStatement;
        }
        conversionOperatorDeclaration = (Cs.ConversionOperatorDeclaration)tempStatement;
        conversionOperatorDeclaration = conversionOperatorDeclaration.withMarkers(this.visitMarkers(conversionOperatorDeclaration.getMarkers(), p));
        conversionOperatorDeclaration = conversionOperatorDeclaration.withModifiers(ListUtils.map(conversionOperatorDeclaration.getModifiers(), el -> (J.Modifier)this.visit((Tree)el, p)));
        conversionOperatorDeclaration = conversionOperatorDeclaration.getPadding().withKind(this.visitLeftPadded(conversionOperatorDeclaration.getPadding().getKind(), CsLeftPadded.Location.CONVERSION_OPERATOR_DECLARATION_KIND, p));
        conversionOperatorDeclaration = conversionOperatorDeclaration.getPadding().withReturnType(this.visitLeftPadded(conversionOperatorDeclaration.getPadding().getReturnType(), CsLeftPadded.Location.CONVERSION_OPERATOR_DECLARATION_RETURN_TYPE, p));
        conversionOperatorDeclaration = conversionOperatorDeclaration.getPadding().withParameters(this.visitContainer(conversionOperatorDeclaration.getPadding().getParameters(), CsContainer.Location.CONVERSION_OPERATOR_DECLARATION_PARAMETERS, p));
        conversionOperatorDeclaration = conversionOperatorDeclaration.getPadding().withExpressionBody(this.visitLeftPadded(conversionOperatorDeclaration.getPadding().getExpressionBody(), CsLeftPadded.Location.CONVERSION_OPERATOR_DECLARATION_EXPRESSION_BODY, p));
        conversionOperatorDeclaration = conversionOperatorDeclaration.withBody((J.Block)this.visitAndCast((Tree)conversionOperatorDeclaration.getBody(), p));
        return conversionOperatorDeclaration;
    }

    public J visitTypeParameter(Cs.TypeParameter typeParameter, P p) {
        typeParameter = typeParameter.withPrefix(this.visitSpace(typeParameter.getPrefix(), CsSpace.Location.TYPE_PARAMETER_PREFIX, p));
        typeParameter = typeParameter.withMarkers(this.visitMarkers(typeParameter.getMarkers(), p));
        typeParameter = typeParameter.withAttributeLists(ListUtils.map(typeParameter.getAttributeLists(), el -> (Cs.AttributeList)this.visit((Tree)el, p)));
        typeParameter = typeParameter.getPadding().withVariance(this.visitLeftPadded(typeParameter.getPadding().getVariance(), CsLeftPadded.Location.TYPE_PARAMETER_VARIANCE, p));
        typeParameter = typeParameter.withName((J.Identifier)this.visitAndCast((Tree)typeParameter.getName(), p));
        return typeParameter;
    }

    public J visitEnumDeclaration(Cs.EnumDeclaration enumDeclaration, P p) {
        Statement tempStatement = (Statement)this.visitStatement(enumDeclaration = enumDeclaration.withPrefix(this.visitSpace(enumDeclaration.getPrefix(), CsSpace.Location.ENUM_DECLARATION_PREFIX, p)), p);
        if (!(tempStatement instanceof Cs.EnumDeclaration)) {
            return tempStatement;
        }
        enumDeclaration = (Cs.EnumDeclaration)tempStatement;
        enumDeclaration = enumDeclaration.withMarkers(this.visitMarkers(enumDeclaration.getMarkers(), p));
        enumDeclaration = enumDeclaration.withAttributeLists(ListUtils.map(enumDeclaration.getAttributeLists(), el -> (Cs.AttributeList)this.visit((Tree)el, p)));
        enumDeclaration = enumDeclaration.withModifiers(ListUtils.map(enumDeclaration.getModifiers(), el -> (J.Modifier)this.visit((Tree)el, p)));
        enumDeclaration = enumDeclaration.getPadding().withName(this.visitLeftPadded(enumDeclaration.getPadding().getName(), CsLeftPadded.Location.ENUM_DECLARATION_NAME, p));
        enumDeclaration = enumDeclaration.getPadding().withBaseType(this.visitLeftPadded(enumDeclaration.getPadding().getBaseType(), CsLeftPadded.Location.ENUM_DECLARATION_BASE_TYPE, p));
        enumDeclaration = enumDeclaration.getPadding().withMembers(this.visitContainer(enumDeclaration.getPadding().getMembers(), CsContainer.Location.ENUM_DECLARATION_MEMBERS, p));
        return enumDeclaration;
    }

    public J visitEnumMemberDeclaration(Cs.EnumMemberDeclaration enumMemberDeclaration, P p) {
        Expression tempExpression = (Expression)this.visitExpression(enumMemberDeclaration = enumMemberDeclaration.withPrefix(this.visitSpace(enumMemberDeclaration.getPrefix(), CsSpace.Location.ENUM_MEMBER_DECLARATION_PREFIX, p)), p);
        if (!(tempExpression instanceof Cs.EnumMemberDeclaration)) {
            return tempExpression;
        }
        enumMemberDeclaration = (Cs.EnumMemberDeclaration)tempExpression;
        enumMemberDeclaration = enumMemberDeclaration.withMarkers(this.visitMarkers(enumMemberDeclaration.getMarkers(), p));
        enumMemberDeclaration = enumMemberDeclaration.withAttributeLists(ListUtils.map(enumMemberDeclaration.getAttributeLists(), el -> (Cs.AttributeList)this.visit((Tree)el, p)));
        enumMemberDeclaration = enumMemberDeclaration.withName((J.Identifier)this.visitAndCast((Tree)enumMemberDeclaration.getName(), p));
        enumMemberDeclaration = enumMemberDeclaration.getPadding().withInitializer(this.visitLeftPadded(enumMemberDeclaration.getPadding().getInitializer(), CsLeftPadded.Location.ENUM_MEMBER_DECLARATION_INITIALIZER, p));
        return enumMemberDeclaration;
    }

    public J visitAliasQualifiedName(Cs.AliasQualifiedName aliasQualifiedName, P p) {
        Expression tempExpression = (Expression)this.visitExpression(aliasQualifiedName = aliasQualifiedName.withPrefix(this.visitSpace(aliasQualifiedName.getPrefix(), CsSpace.Location.ALIAS_QUALIFIED_NAME_PREFIX, p)), p);
        if (!(tempExpression instanceof Cs.AliasQualifiedName)) {
            return tempExpression;
        }
        aliasQualifiedName = (Cs.AliasQualifiedName)tempExpression;
        aliasQualifiedName = aliasQualifiedName.withMarkers(this.visitMarkers(aliasQualifiedName.getMarkers(), p));
        aliasQualifiedName = aliasQualifiedName.getPadding().withAlias(this.visitRightPadded(aliasQualifiedName.getPadding().getAlias(), CsRightPadded.Location.ALIAS_QUALIFIED_NAME_ALIAS, p));
        aliasQualifiedName = aliasQualifiedName.withName((Expression)this.visitAndCast((Tree)aliasQualifiedName.getName(), p));
        return aliasQualifiedName;
    }

    public J visitArrayType(Cs.ArrayType arrayType, P p) {
        Expression tempExpression = (Expression)this.visitExpression(arrayType = arrayType.withPrefix(this.visitSpace(arrayType.getPrefix(), CsSpace.Location.ARRAY_TYPE_PREFIX, p)), p);
        if (!(tempExpression instanceof Cs.ArrayType)) {
            return tempExpression;
        }
        arrayType = (Cs.ArrayType)tempExpression;
        arrayType = arrayType.withMarkers(this.visitMarkers(arrayType.getMarkers(), p));
        arrayType = arrayType.withTypeExpression((TypeTree)this.visitAndCast((Tree)arrayType.getTypeExpression(), p));
        arrayType = arrayType.withDimensions(ListUtils.map(arrayType.getDimensions(), el -> (J.ArrayDimension)this.visit((Tree)el, p)));
        return arrayType;
    }

    public J visitTry(Cs.Try try_, P p) {
        Statement tempStatement = (Statement)this.visitStatement(try_ = try_.withPrefix(this.visitSpace(try_.getPrefix(), CsSpace.Location.TRY_PREFIX, p)), p);
        if (!(tempStatement instanceof Cs.Try)) {
            return tempStatement;
        }
        try_ = (Cs.Try)tempStatement;
        try_ = try_.withMarkers(this.visitMarkers(try_.getMarkers(), p));
        try_ = try_.withBody((J.Block)this.visitAndCast((Tree)try_.getBody(), p));
        try_ = try_.withCatches(ListUtils.map(try_.getCatches(), el -> (Cs.Try.Catch)this.visit((Tree)el, p)));
        try_ = try_.getPadding().withFinally(this.visitLeftPadded(try_.getPadding().getFinally(), CsLeftPadded.Location.TRY_FINALLIE, p));
        return try_;
    }

    public J visitTryCatch(Cs.Try.Catch catch_, P p) {
        catch_ = catch_.withPrefix(this.visitSpace(catch_.getPrefix(), CsSpace.Location.TRY_CATCH_PREFIX, p));
        catch_ = catch_.withMarkers(this.visitMarkers(catch_.getMarkers(), p));
        catch_ = catch_.withParameter((J.ControlParentheses<J.VariableDeclarations>)((J.ControlParentheses)this.visitAndCast((Tree)catch_.getParameter(), p)));
        catch_ = catch_.getPadding().withFilterExpression(this.visitLeftPadded(catch_.getPadding().getFilterExpression(), CsLeftPadded.Location.TRY_CATCH_FILTER_EXPRESSION, p));
        catch_ = catch_.withBody((J.Block)this.visitAndCast((Tree)catch_.getBody(), p));
        return catch_;
    }

    public J visitArrowExpressionClause(Cs.ArrowExpressionClause arrowExpressionClause, P p) {
        Statement tempStatement = (Statement)this.visitStatement(arrowExpressionClause = arrowExpressionClause.withPrefix(this.visitSpace(arrowExpressionClause.getPrefix(), CsSpace.Location.ARROW_EXPRESSION_CLAUSE_PREFIX, p)), p);
        if (!(tempStatement instanceof Cs.ArrowExpressionClause)) {
            return tempStatement;
        }
        arrowExpressionClause = (Cs.ArrowExpressionClause)tempStatement;
        arrowExpressionClause = arrowExpressionClause.withMarkers(this.visitMarkers(arrowExpressionClause.getMarkers(), p));
        arrowExpressionClause = arrowExpressionClause.getPadding().withExpression(this.visitRightPadded(arrowExpressionClause.getPadding().getExpression(), CsRightPadded.Location.ARROW_EXPRESSION_CLAUSE_EXPRESSION, p));
        return arrowExpressionClause;
    }

    public J visitAccessorDeclaration(Cs.AccessorDeclaration accessorDeclaration, P p) {
        Statement tempStatement = (Statement)this.visitStatement(accessorDeclaration = accessorDeclaration.withPrefix(this.visitSpace(accessorDeclaration.getPrefix(), CsSpace.Location.ACCESSOR_DECLARATION_PREFIX, p)), p);
        if (!(tempStatement instanceof Cs.AccessorDeclaration)) {
            return tempStatement;
        }
        accessorDeclaration = (Cs.AccessorDeclaration)tempStatement;
        accessorDeclaration = accessorDeclaration.withMarkers(this.visitMarkers(accessorDeclaration.getMarkers(), p));
        accessorDeclaration = accessorDeclaration.withAttributes(ListUtils.map(accessorDeclaration.getAttributes(), el -> (Cs.AttributeList)this.visit((Tree)el, p)));
        accessorDeclaration = accessorDeclaration.withModifiers(ListUtils.map(accessorDeclaration.getModifiers(), el -> (J.Modifier)this.visit((Tree)el, p)));
        accessorDeclaration = accessorDeclaration.getPadding().withKind(this.visitLeftPadded(accessorDeclaration.getPadding().getKind(), CsLeftPadded.Location.ACCESSOR_DECLARATION_KIND, p));
        accessorDeclaration = accessorDeclaration.withExpressionBody((Cs.ArrowExpressionClause)this.visitAndCast((Tree)accessorDeclaration.getExpressionBody(), p));
        accessorDeclaration = accessorDeclaration.withBody((J.Block)this.visitAndCast((Tree)accessorDeclaration.getBody(), p));
        return accessorDeclaration;
    }

    public J visitPointerFieldAccess(Cs.PointerFieldAccess pointerFieldAccess, P p) {
        Statement tempStatement = (Statement)this.visitStatement(pointerFieldAccess = pointerFieldAccess.withPrefix(this.visitSpace(pointerFieldAccess.getPrefix(), CsSpace.Location.POINTER_FIELD_ACCESS_PREFIX, p)), p);
        if (!(tempStatement instanceof Cs.PointerFieldAccess)) {
            return tempStatement;
        }
        pointerFieldAccess = (Cs.PointerFieldAccess)tempStatement;
        Expression tempExpression = (Expression)this.visitExpression(pointerFieldAccess, p);
        if (!(tempExpression instanceof Cs.PointerFieldAccess)) {
            return tempExpression;
        }
        pointerFieldAccess = (Cs.PointerFieldAccess)tempExpression;
        pointerFieldAccess = pointerFieldAccess.withMarkers(this.visitMarkers(pointerFieldAccess.getMarkers(), p));
        pointerFieldAccess = pointerFieldAccess.withTarget((Expression)this.visitAndCast((Tree)pointerFieldAccess.getTarget(), p));
        pointerFieldAccess = pointerFieldAccess.getPadding().withName(this.visitLeftPadded(pointerFieldAccess.getPadding().getName(), CsLeftPadded.Location.POINTER_FIELD_ACCESS_NAME, p));
        return pointerFieldAccess;
    }

    public <J2 extends J> JContainer<J2> visitContainer(@Nullable JContainer<J2> container, CsContainer.Location loc, P p) {
        if (container == null) {
            return null;
        }
        this.setCursor(new Cursor(this.getCursor(), container));
        Space before = this.visitSpace(container.getBefore(), loc.getBeforeLocation(), p);
        List js = ListUtils.map((List)container.getPadding().getElements(), t -> this.visitRightPadded((JRightPadded)t, loc.getElementLocation(), p));
        this.setCursor(this.getCursor().getParent());
        return js == container.getPadding().getElements() && before == container.getBefore() ? container : JContainer.build((Space)before, (List)js, (Markers)container.getMarkers());
    }

    public <T> JLeftPadded<T> visitLeftPadded(@Nullable JLeftPadded<T> left, CsLeftPadded.Location loc, P p) {
        if (left == null) {
            return null;
        }
        this.setCursor(new Cursor(this.getCursor(), left));
        Space before = this.visitSpace(left.getBefore(), loc.getBeforeLocation(), p);
        Object t = left.getElement();
        if (t instanceof J) {
            t = this.visitAndCast((Tree)((J)left.getElement()), p);
        }
        this.setCursor(this.getCursor().getParent());
        if (t == null) {
            if (left.getElement() == null && before == left.getBefore()) {
                return left;
            }
            return null;
        }
        return before == left.getBefore() && t == left.getElement() ? left : new JLeftPadded(before, t, left.getMarkers());
    }

    public <T> JRightPadded<T> visitRightPadded(@Nullable JRightPadded<T> right, CsRightPadded.Location loc, P p) {
        if (right == null) {
            return null;
        }
        this.setCursor(new Cursor(this.getCursor(), right));
        Object t = right.getElement();
        if (t instanceof J) {
            t = this.visitAndCast((Tree)((J)right.getElement()), p);
        }
        this.setCursor(this.getCursor().getParent());
        if (t == null) {
            return null;
        }
        Space after = this.visitSpace(right.getAfter(), loc.getAfterLocation(), p);
        Markers markers = this.visitMarkers(right.getMarkers(), p);
        return after == right.getAfter() && t == right.getElement() && markers == right.getMarkers() ? right : new JRightPadded<T>(t, after, markers);
    }

    public Space visitSpace(Space space, CsSpace.Location loc, P p) {
        return this.visitSpace(space, Space.Location.LANGUAGE_EXTENSION, p);
    }
}

