/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.csharp.remote;

import java.util.function.Function;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.csharp.CSharpVisitor;
import org.openrewrite.csharp.remote.Extensions;
import org.openrewrite.csharp.tree.Cs;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.NameTree;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.remote.Sender;
import org.openrewrite.remote.SenderContext;

public final class CSharpSender
implements Sender<Cs> {
    public void send(Cs after, @Nullable Cs before, SenderContext ctx) {
        Visitor visitor = new Visitor();
        visitor.visit((Tree)after, ctx.fork((TreeVisitor)visitor, (Tree)before));
        ctx.flush();
    }

    private static <T extends J> void sendContainer(JContainer<T> container, SenderContext ctx) {
        Extensions.sendContainer(container, ctx);
    }

    private static <T> void sendLeftPadded(JLeftPadded<T> leftPadded, SenderContext ctx) {
        Extensions.sendLeftPadded(leftPadded, ctx);
    }

    private static <T> void sendRightPadded(JRightPadded<T> rightPadded, SenderContext ctx) {
        Extensions.sendRightPadded(rightPadded, ctx);
    }

    private static void sendSpace(Space space, SenderContext ctx) {
        Extensions.sendSpace(space, ctx);
    }

    private static void sendComment(Comment comment, SenderContext ctx) {
        Extensions.sendComment(comment, ctx);
    }

    @Generated
    public CSharpSender() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        return o instanceof CSharpSender;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    @Generated
    public String toString() {
        return "CSharpSender()";
    }

    private static class Visitor
    extends CSharpVisitor<SenderContext> {
        private Visitor() {
        }

        public @Nullable J visit(@Nullable Tree tree, SenderContext ctx) {
            this.setCursor(new Cursor(this.getCursor(), (Object)tree));
            ctx.sendNode((Object)tree, Function.identity(), (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            this.setCursor(this.getCursor().getParent());
            return (J)tree;
        }

        public Cs.CompilationUnit visitCompilationUnit(Cs.CompilationUnit compilationUnit, SenderContext ctx) {
            ctx.sendValue((Object)compilationUnit, Cs.CompilationUnit::getId);
            ctx.sendNode((Object)compilationUnit, Cs.CompilationUnit::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)compilationUnit, Cs.CompilationUnit::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendValue((Object)compilationUnit, Cs.CompilationUnit::getSourcePath);
            ctx.sendTypedValue((Object)compilationUnit, Cs.CompilationUnit::getFileAttributes);
            ctx.sendValue((Object)compilationUnit, e -> e.getCharset() != null ? e.getCharset().name() : "UTF-8");
            ctx.sendValue((Object)compilationUnit, Cs.CompilationUnit::isCharsetBomMarked);
            ctx.sendTypedValue((Object)compilationUnit, Cs.CompilationUnit::getChecksum);
            ctx.sendNodes((Object)compilationUnit, e -> e.getPadding().getExterns(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1), e -> ((Cs.ExternAlias)e.getElement()).getId());
            ctx.sendNodes((Object)compilationUnit, e -> e.getPadding().getUsings(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1), e -> ((Cs.UsingDirective)e.getElement()).getId());
            ctx.sendNodes((Object)compilationUnit, Cs.CompilationUnit::getAttributeLists, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1), Tree::getId);
            ctx.sendNodes((Object)compilationUnit, e -> e.getPadding().getMembers(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1), e -> ((Statement)e.getElement()).getId());
            ctx.sendNode((Object)compilationUnit, Cs.CompilationUnit::getEof, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            return compilationUnit;
        }

        public Cs.OperatorDeclaration visitOperatorDeclaration(Cs.OperatorDeclaration operatorDeclaration, SenderContext ctx) {
            ctx.sendValue((Object)operatorDeclaration, Cs.OperatorDeclaration::getId);
            ctx.sendNode((Object)operatorDeclaration, Cs.OperatorDeclaration::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)operatorDeclaration, Cs.OperatorDeclaration::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNodes((Object)operatorDeclaration, Cs.OperatorDeclaration::getAttributeLists, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1), Tree::getId);
            ctx.sendNodes((Object)operatorDeclaration, Cs.OperatorDeclaration::getModifiers, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1), Tree::getId);
            ctx.sendNode((Object)operatorDeclaration, e -> e.getPadding().getExplicitInterfaceSpecifier(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            ctx.sendNode((Object)operatorDeclaration, Cs.OperatorDeclaration::getOperatorKeyword, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)operatorDeclaration, Cs.OperatorDeclaration::getCheckedKeyword, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)operatorDeclaration, e -> e.getPadding().getOperatorToken(), (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            ctx.sendNode((Object)operatorDeclaration, Cs.OperatorDeclaration::getReturnType, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)operatorDeclaration, e -> e.getPadding().getParameters(), (x$0, x$1) -> CSharpSender.sendContainer(x$0, x$1));
            ctx.sendNode((Object)operatorDeclaration, Cs.OperatorDeclaration::getBody, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendTypedValue((Object)operatorDeclaration, Cs.OperatorDeclaration::getMethodType);
            return operatorDeclaration;
        }

        public Cs.RefExpression visitRefExpression(Cs.RefExpression refExpression, SenderContext ctx) {
            ctx.sendValue((Object)refExpression, Cs.RefExpression::getId);
            ctx.sendNode((Object)refExpression, Cs.RefExpression::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)refExpression, Cs.RefExpression::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)refExpression, Cs.RefExpression::getExpression, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return refExpression;
        }

        public Cs.PointerType visitPointerType(Cs.PointerType pointerType, SenderContext ctx) {
            ctx.sendValue((Object)pointerType, Cs.PointerType::getId);
            ctx.sendNode((Object)pointerType, Cs.PointerType::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)pointerType, Cs.PointerType::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)pointerType, e -> e.getPadding().getElementType(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            return pointerType;
        }

        public Cs.RefType visitRefType(Cs.RefType refType, SenderContext ctx) {
            ctx.sendValue((Object)refType, Cs.RefType::getId);
            ctx.sendNode((Object)refType, Cs.RefType::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)refType, Cs.RefType::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)refType, Cs.RefType::getReadonlyKeyword, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)refType, Cs.RefType::getTypeIdentifier, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendTypedValue((Object)refType, Cs.RefType::getType);
            return refType;
        }

        public Cs.ForEachVariableLoop visitForEachVariableLoop(Cs.ForEachVariableLoop forEachVariableLoop, SenderContext ctx) {
            ctx.sendValue((Object)forEachVariableLoop, Cs.ForEachVariableLoop::getId);
            ctx.sendNode((Object)forEachVariableLoop, Cs.ForEachVariableLoop::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)forEachVariableLoop, Cs.ForEachVariableLoop::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)forEachVariableLoop, Cs.ForEachVariableLoop::getControlElement, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)forEachVariableLoop, e -> e.getPadding().getBody(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            return forEachVariableLoop;
        }

        public Cs.ForEachVariableLoop.Control visitForEachVariableLoopControl(Cs.ForEachVariableLoop.Control control, SenderContext ctx) {
            ctx.sendValue((Object)control, Cs.ForEachVariableLoop.Control::getId);
            ctx.sendNode((Object)control, Cs.ForEachVariableLoop.Control::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)control, Cs.ForEachVariableLoop.Control::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)control, e -> e.getPadding().getVariable(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            ctx.sendNode((Object)control, e -> e.getPadding().getIterable(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            return control;
        }

        public Cs.NameColon visitNameColon(Cs.NameColon nameColon, SenderContext ctx) {
            ctx.sendValue((Object)nameColon, Cs.NameColon::getId);
            ctx.sendNode((Object)nameColon, Cs.NameColon::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)nameColon, Cs.NameColon::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)nameColon, e -> e.getPadding().getName(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            return nameColon;
        }

        public Cs.Argument visitArgument(Cs.Argument argument, SenderContext ctx) {
            ctx.sendValue((Object)argument, Cs.Argument::getId);
            ctx.sendNode((Object)argument, Cs.Argument::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)argument, Cs.Argument::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)argument, e -> e.getPadding().getNameColumn(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            ctx.sendNode((Object)argument, Cs.Argument::getRefKindKeyword, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)argument, Cs.Argument::getExpression, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return argument;
        }

        public Cs.AnnotatedStatement visitAnnotatedStatement(Cs.AnnotatedStatement annotatedStatement, SenderContext ctx) {
            ctx.sendValue((Object)annotatedStatement, Cs.AnnotatedStatement::getId);
            ctx.sendNode((Object)annotatedStatement, Cs.AnnotatedStatement::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)annotatedStatement, Cs.AnnotatedStatement::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNodes((Object)annotatedStatement, Cs.AnnotatedStatement::getAttributeLists, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1), Tree::getId);
            ctx.sendNode((Object)annotatedStatement, Cs.AnnotatedStatement::getStatement, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return annotatedStatement;
        }

        public Cs.ArrayRankSpecifier visitArrayRankSpecifier(Cs.ArrayRankSpecifier arrayRankSpecifier, SenderContext ctx) {
            ctx.sendValue((Object)arrayRankSpecifier, Cs.ArrayRankSpecifier::getId);
            ctx.sendNode((Object)arrayRankSpecifier, Cs.ArrayRankSpecifier::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)arrayRankSpecifier, Cs.ArrayRankSpecifier::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)arrayRankSpecifier, e -> e.getPadding().getSizes(), (x$0, x$1) -> CSharpSender.sendContainer(x$0, x$1));
            return arrayRankSpecifier;
        }

        public Cs.AssignmentOperation visitAssignmentOperation(Cs.AssignmentOperation assignmentOperation, SenderContext ctx) {
            ctx.sendValue((Object)assignmentOperation, Cs.AssignmentOperation::getId);
            ctx.sendNode((Object)assignmentOperation, Cs.AssignmentOperation::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)assignmentOperation, Cs.AssignmentOperation::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)assignmentOperation, Cs.AssignmentOperation::getVariable, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)assignmentOperation, e -> e.getPadding().getOperator(), (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            ctx.sendNode((Object)assignmentOperation, Cs.AssignmentOperation::getAssignment, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendTypedValue((Object)assignmentOperation, Cs.AssignmentOperation::getType);
            return assignmentOperation;
        }

        public Cs.AttributeList visitAttributeList(Cs.AttributeList attributeList, SenderContext ctx) {
            ctx.sendValue((Object)attributeList, Cs.AttributeList::getId);
            ctx.sendNode((Object)attributeList, Cs.AttributeList::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)attributeList, Cs.AttributeList::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)attributeList, e -> e.getPadding().getTarget(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            ctx.sendNodes((Object)attributeList, e -> e.getPadding().getAttributes(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1), e -> ((J.Annotation)e.getElement()).getId());
            return attributeList;
        }

        public Cs.AwaitExpression visitAwaitExpression(Cs.AwaitExpression awaitExpression, SenderContext ctx) {
            ctx.sendValue((Object)awaitExpression, Cs.AwaitExpression::getId);
            ctx.sendNode((Object)awaitExpression, Cs.AwaitExpression::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)awaitExpression, Cs.AwaitExpression::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)awaitExpression, Cs.AwaitExpression::getExpression, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendTypedValue((Object)awaitExpression, Cs.AwaitExpression::getType);
            return awaitExpression;
        }

        public Cs.StackAllocExpression visitStackAllocExpression(Cs.StackAllocExpression stackAllocExpression, SenderContext ctx) {
            ctx.sendValue((Object)stackAllocExpression, Cs.StackAllocExpression::getId);
            ctx.sendNode((Object)stackAllocExpression, Cs.StackAllocExpression::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)stackAllocExpression, Cs.StackAllocExpression::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)stackAllocExpression, Cs.StackAllocExpression::getExpression, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return stackAllocExpression;
        }

        public Cs.GotoStatement visitGotoStatement(Cs.GotoStatement gotoStatement, SenderContext ctx) {
            ctx.sendValue((Object)gotoStatement, Cs.GotoStatement::getId);
            ctx.sendNode((Object)gotoStatement, Cs.GotoStatement::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)gotoStatement, Cs.GotoStatement::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)gotoStatement, Cs.GotoStatement::getCaseOrDefaultKeyword, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)gotoStatement, Cs.GotoStatement::getTarget, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return gotoStatement;
        }

        public Cs.EventDeclaration visitEventDeclaration(Cs.EventDeclaration eventDeclaration, SenderContext ctx) {
            ctx.sendValue((Object)eventDeclaration, Cs.EventDeclaration::getId);
            ctx.sendNode((Object)eventDeclaration, Cs.EventDeclaration::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)eventDeclaration, Cs.EventDeclaration::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNodes((Object)eventDeclaration, Cs.EventDeclaration::getAttributeLists, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1), Tree::getId);
            ctx.sendNodes((Object)eventDeclaration, Cs.EventDeclaration::getModifiers, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1), Tree::getId);
            ctx.sendNode((Object)eventDeclaration, e -> e.getPadding().getTypeExpression(), (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            ctx.sendNode((Object)eventDeclaration, e -> e.getPadding().getInterfaceSpecifier(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            ctx.sendNode((Object)eventDeclaration, Cs.EventDeclaration::getName, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)eventDeclaration, e -> e.getPadding().getAccessors(), (x$0, x$1) -> CSharpSender.sendContainer(x$0, x$1));
            return eventDeclaration;
        }

        public Cs.Binary visitBinary(Cs.Binary binary, SenderContext ctx) {
            ctx.sendValue((Object)binary, Cs.Binary::getId);
            ctx.sendNode((Object)binary, Cs.Binary::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)binary, Cs.Binary::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)binary, Cs.Binary::getLeft, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)binary, e -> e.getPadding().getOperator(), (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            ctx.sendNode((Object)binary, Cs.Binary::getRight, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendTypedValue((Object)binary, Cs.Binary::getType);
            return binary;
        }

        public Cs.BlockScopeNamespaceDeclaration visitBlockScopeNamespaceDeclaration(Cs.BlockScopeNamespaceDeclaration blockScopeNamespaceDeclaration, SenderContext ctx) {
            ctx.sendValue((Object)blockScopeNamespaceDeclaration, Cs.BlockScopeNamespaceDeclaration::getId);
            ctx.sendNode((Object)blockScopeNamespaceDeclaration, Cs.BlockScopeNamespaceDeclaration::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)blockScopeNamespaceDeclaration, Cs.BlockScopeNamespaceDeclaration::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)blockScopeNamespaceDeclaration, e -> e.getPadding().getName(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            ctx.sendNodes((Object)blockScopeNamespaceDeclaration, e -> e.getPadding().getExterns(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1), e -> ((Cs.ExternAlias)e.getElement()).getId());
            ctx.sendNodes((Object)blockScopeNamespaceDeclaration, e -> e.getPadding().getUsings(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1), e -> ((Cs.UsingDirective)e.getElement()).getId());
            ctx.sendNodes((Object)blockScopeNamespaceDeclaration, e -> e.getPadding().getMembers(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1), e -> ((Statement)e.getElement()).getId());
            ctx.sendNode((Object)blockScopeNamespaceDeclaration, Cs.BlockScopeNamespaceDeclaration::getEnd, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            return blockScopeNamespaceDeclaration;
        }

        public Cs.CollectionExpression visitCollectionExpression(Cs.CollectionExpression collectionExpression, SenderContext ctx) {
            ctx.sendValue((Object)collectionExpression, Cs.CollectionExpression::getId);
            ctx.sendNode((Object)collectionExpression, Cs.CollectionExpression::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)collectionExpression, Cs.CollectionExpression::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNodes((Object)collectionExpression, e -> e.getPadding().getElements(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1), e -> ((Expression)e.getElement()).getId());
            ctx.sendTypedValue((Object)collectionExpression, Cs.CollectionExpression::getType);
            return collectionExpression;
        }

        public Cs.ExpressionStatement visitExpressionStatement(Cs.ExpressionStatement expressionStatement, SenderContext ctx) {
            ctx.sendValue((Object)expressionStatement, Cs.ExpressionStatement::getId);
            ctx.sendNode((Object)expressionStatement, Cs.ExpressionStatement::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)expressionStatement, Cs.ExpressionStatement::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)expressionStatement, e -> e.getPadding().getExpression(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            return expressionStatement;
        }

        public Cs.ExternAlias visitExternAlias(Cs.ExternAlias externAlias, SenderContext ctx) {
            ctx.sendValue((Object)externAlias, Cs.ExternAlias::getId);
            ctx.sendNode((Object)externAlias, Cs.ExternAlias::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)externAlias, Cs.ExternAlias::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)externAlias, e -> e.getPadding().getIdentifier(), (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            return externAlias;
        }

        public Cs.FileScopeNamespaceDeclaration visitFileScopeNamespaceDeclaration(Cs.FileScopeNamespaceDeclaration fileScopeNamespaceDeclaration, SenderContext ctx) {
            ctx.sendValue((Object)fileScopeNamespaceDeclaration, Cs.FileScopeNamespaceDeclaration::getId);
            ctx.sendNode((Object)fileScopeNamespaceDeclaration, Cs.FileScopeNamespaceDeclaration::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)fileScopeNamespaceDeclaration, Cs.FileScopeNamespaceDeclaration::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)fileScopeNamespaceDeclaration, e -> e.getPadding().getName(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            ctx.sendNodes((Object)fileScopeNamespaceDeclaration, e -> e.getPadding().getExterns(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1), e -> ((Cs.ExternAlias)e.getElement()).getId());
            ctx.sendNodes((Object)fileScopeNamespaceDeclaration, e -> e.getPadding().getUsings(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1), e -> ((Cs.UsingDirective)e.getElement()).getId());
            ctx.sendNodes((Object)fileScopeNamespaceDeclaration, e -> e.getPadding().getMembers(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1), e -> ((Statement)e.getElement()).getId());
            return fileScopeNamespaceDeclaration;
        }

        public Cs.InterpolatedString visitInterpolatedString(Cs.InterpolatedString interpolatedString, SenderContext ctx) {
            ctx.sendValue((Object)interpolatedString, Cs.InterpolatedString::getId);
            ctx.sendNode((Object)interpolatedString, Cs.InterpolatedString::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)interpolatedString, Cs.InterpolatedString::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendValue((Object)interpolatedString, Cs.InterpolatedString::getStart);
            ctx.sendNodes((Object)interpolatedString, e -> e.getPadding().getParts(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1), e -> ((Expression)e.getElement()).getId());
            ctx.sendValue((Object)interpolatedString, Cs.InterpolatedString::getEnd);
            return interpolatedString;
        }

        public Cs.Interpolation visitInterpolation(Cs.Interpolation interpolation, SenderContext ctx) {
            ctx.sendValue((Object)interpolation, Cs.Interpolation::getId);
            ctx.sendNode((Object)interpolation, Cs.Interpolation::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)interpolation, Cs.Interpolation::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)interpolation, e -> e.getPadding().getExpression(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            ctx.sendNode((Object)interpolation, e -> e.getPadding().getAlignment(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            ctx.sendNode((Object)interpolation, e -> e.getPadding().getFormat(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            return interpolation;
        }

        public Cs.NullSafeExpression visitNullSafeExpression(Cs.NullSafeExpression nullSafeExpression, SenderContext ctx) {
            ctx.sendValue((Object)nullSafeExpression, Cs.NullSafeExpression::getId);
            ctx.sendNode((Object)nullSafeExpression, Cs.NullSafeExpression::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)nullSafeExpression, Cs.NullSafeExpression::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)nullSafeExpression, e -> e.getPadding().getExpression(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            return nullSafeExpression;
        }

        public Cs.StatementExpression visitStatementExpression(Cs.StatementExpression statementExpression, SenderContext ctx) {
            ctx.sendValue((Object)statementExpression, Cs.StatementExpression::getId);
            ctx.sendNode((Object)statementExpression, Cs.StatementExpression::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)statementExpression, Cs.StatementExpression::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)statementExpression, Cs.StatementExpression::getStatement, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return statementExpression;
        }

        public Cs.UsingDirective visitUsingDirective(Cs.UsingDirective usingDirective, SenderContext ctx) {
            ctx.sendValue((Object)usingDirective, Cs.UsingDirective::getId);
            ctx.sendNode((Object)usingDirective, Cs.UsingDirective::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)usingDirective, Cs.UsingDirective::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)usingDirective, e -> e.getPadding().getGlobal(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            ctx.sendNode((Object)usingDirective, e -> e.getPadding().getStatic(), (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            ctx.sendNode((Object)usingDirective, e -> e.getPadding().getUnsafe(), (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            ctx.sendNode((Object)usingDirective, e -> e.getPadding().getAlias(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            ctx.sendNode((Object)usingDirective, Cs.UsingDirective::getNamespaceOrType, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return usingDirective;
        }

        public Cs.PropertyDeclaration visitPropertyDeclaration(Cs.PropertyDeclaration propertyDeclaration, SenderContext ctx) {
            ctx.sendValue((Object)propertyDeclaration, Cs.PropertyDeclaration::getId);
            ctx.sendNode((Object)propertyDeclaration, Cs.PropertyDeclaration::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)propertyDeclaration, Cs.PropertyDeclaration::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNodes((Object)propertyDeclaration, Cs.PropertyDeclaration::getAttributeLists, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1), Tree::getId);
            ctx.sendNodes((Object)propertyDeclaration, Cs.PropertyDeclaration::getModifiers, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1), Tree::getId);
            ctx.sendNode((Object)propertyDeclaration, Cs.PropertyDeclaration::getTypeExpression, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)propertyDeclaration, e -> e.getPadding().getInterfaceSpecifier(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            ctx.sendNode((Object)propertyDeclaration, Cs.PropertyDeclaration::getName, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)propertyDeclaration, Cs.PropertyDeclaration::getAccessors, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)propertyDeclaration, Cs.PropertyDeclaration::getExpressionBody, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)propertyDeclaration, e -> e.getPadding().getInitializer(), (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            return propertyDeclaration;
        }

        public Cs.Keyword visitKeyword(Cs.Keyword keyword, SenderContext ctx) {
            ctx.sendValue((Object)keyword, Cs.Keyword::getId);
            ctx.sendNode((Object)keyword, Cs.Keyword::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)keyword, Cs.Keyword::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendValue((Object)keyword, Cs.Keyword::getKind);
            return keyword;
        }

        public Cs.Lambda visitLambda(Cs.Lambda lambda, SenderContext ctx) {
            ctx.sendValue((Object)lambda, Cs.Lambda::getId);
            ctx.sendNode((Object)lambda, Cs.Lambda::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)lambda, Cs.Lambda::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)lambda, Cs.Lambda::getLambdaExpression, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)lambda, Cs.Lambda::getReturnType, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNodes((Object)lambda, Cs.Lambda::getModifiers, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1), Tree::getId);
            return lambda;
        }

        public Cs.ClassDeclaration visitClassDeclaration(Cs.ClassDeclaration classDeclaration, SenderContext ctx) {
            ctx.sendValue((Object)classDeclaration, Cs.ClassDeclaration::getId);
            ctx.sendNode((Object)classDeclaration, Cs.ClassDeclaration::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)classDeclaration, Cs.ClassDeclaration::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNodes((Object)classDeclaration, Cs.ClassDeclaration::getAttributeList, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1), Tree::getId);
            ctx.sendNodes((Object)classDeclaration, Cs.ClassDeclaration::getModifiers, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1), Tree::getId);
            ctx.sendNode((Object)classDeclaration, e -> e.getPadding().getKind(), this::sendClassDeclarationKind);
            ctx.sendNode((Object)classDeclaration, Cs.ClassDeclaration::getName, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)classDeclaration, e -> e.getPadding().getTypeParameters(), (x$0, x$1) -> CSharpSender.sendContainer(x$0, x$1));
            ctx.sendNode((Object)classDeclaration, e -> e.getPadding().getPrimaryConstructor(), (x$0, x$1) -> CSharpSender.sendContainer(x$0, x$1));
            ctx.sendNode((Object)classDeclaration, e -> e.getPadding().getExtendings(), (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            ctx.sendNode((Object)classDeclaration, e -> e.getPadding().getImplementings(), (x$0, x$1) -> CSharpSender.sendContainer(x$0, x$1));
            ctx.sendNode((Object)classDeclaration, Cs.ClassDeclaration::getBody, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)classDeclaration, e -> e.getPadding().getTypeParameterConstraintClauses(), (x$0, x$1) -> CSharpSender.sendContainer(x$0, x$1));
            ctx.sendTypedValue((Object)classDeclaration, Cs.ClassDeclaration::getType);
            return classDeclaration;
        }

        public Cs.MethodDeclaration visitMethodDeclaration(Cs.MethodDeclaration methodDeclaration, SenderContext ctx) {
            ctx.sendValue((Object)methodDeclaration, Cs.MethodDeclaration::getId);
            ctx.sendNode((Object)methodDeclaration, Cs.MethodDeclaration::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)methodDeclaration, Cs.MethodDeclaration::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNodes((Object)methodDeclaration, Cs.MethodDeclaration::getAttributes, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1), Tree::getId);
            ctx.sendNodes((Object)methodDeclaration, Cs.MethodDeclaration::getModifiers, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1), Tree::getId);
            ctx.sendNode((Object)methodDeclaration, e -> e.getPadding().getTypeParameters(), (x$0, x$1) -> CSharpSender.sendContainer(x$0, x$1));
            ctx.sendNode((Object)methodDeclaration, Cs.MethodDeclaration::getReturnTypeExpression, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)methodDeclaration, e -> e.getPadding().getExplicitInterfaceSpecifier(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            ctx.sendNode((Object)methodDeclaration, Cs.MethodDeclaration::getName, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)methodDeclaration, e -> e.getPadding().getParameters(), (x$0, x$1) -> CSharpSender.sendContainer(x$0, x$1));
            ctx.sendNode((Object)methodDeclaration, Cs.MethodDeclaration::getBody, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendTypedValue((Object)methodDeclaration, Cs.MethodDeclaration::getMethodType);
            ctx.sendNode((Object)methodDeclaration, e -> e.getPadding().getTypeParameterConstraintClauses(), (x$0, x$1) -> CSharpSender.sendContainer(x$0, x$1));
            return methodDeclaration;
        }

        public Cs.UsingStatement visitUsingStatement(Cs.UsingStatement usingStatement, SenderContext ctx) {
            ctx.sendValue((Object)usingStatement, Cs.UsingStatement::getId);
            ctx.sendNode((Object)usingStatement, Cs.UsingStatement::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)usingStatement, Cs.UsingStatement::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)usingStatement, Cs.UsingStatement::getAwaitKeyword, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)usingStatement, e -> e.getPadding().getExpression(), (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            ctx.sendNode((Object)usingStatement, Cs.UsingStatement::getStatement, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return usingStatement;
        }

        public Cs.TypeParameterConstraintClause visitTypeParameterConstraintClause(Cs.TypeParameterConstraintClause typeParameterConstraintClause, SenderContext ctx) {
            ctx.sendValue((Object)typeParameterConstraintClause, Cs.TypeParameterConstraintClause::getId);
            ctx.sendNode((Object)typeParameterConstraintClause, Cs.TypeParameterConstraintClause::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)typeParameterConstraintClause, Cs.TypeParameterConstraintClause::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)typeParameterConstraintClause, e -> e.getPadding().getTypeParameter(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            ctx.sendNode((Object)typeParameterConstraintClause, e -> e.getPadding().getTypeParameterConstraints(), (x$0, x$1) -> CSharpSender.sendContainer(x$0, x$1));
            return typeParameterConstraintClause;
        }

        public Cs.TypeConstraint visitTypeConstraint(Cs.TypeConstraint typeConstraint, SenderContext ctx) {
            ctx.sendValue((Object)typeConstraint, Cs.TypeConstraint::getId);
            ctx.sendNode((Object)typeConstraint, Cs.TypeConstraint::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)typeConstraint, Cs.TypeConstraint::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)typeConstraint, Cs.TypeConstraint::getTypeExpression, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return typeConstraint;
        }

        public Cs.AllowsConstraintClause visitAllowsConstraintClause(Cs.AllowsConstraintClause allowsConstraintClause, SenderContext ctx) {
            ctx.sendValue((Object)allowsConstraintClause, Cs.AllowsConstraintClause::getId);
            ctx.sendNode((Object)allowsConstraintClause, Cs.AllowsConstraintClause::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)allowsConstraintClause, Cs.AllowsConstraintClause::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)allowsConstraintClause, e -> e.getPadding().getExpressions(), (x$0, x$1) -> CSharpSender.sendContainer(x$0, x$1));
            return allowsConstraintClause;
        }

        public Cs.RefStructConstraint visitRefStructConstraint(Cs.RefStructConstraint refStructConstraint, SenderContext ctx) {
            ctx.sendValue((Object)refStructConstraint, Cs.RefStructConstraint::getId);
            ctx.sendNode((Object)refStructConstraint, Cs.RefStructConstraint::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)refStructConstraint, Cs.RefStructConstraint::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            return refStructConstraint;
        }

        public Cs.ClassOrStructConstraint visitClassOrStructConstraint(Cs.ClassOrStructConstraint classOrStructConstraint, SenderContext ctx) {
            ctx.sendValue((Object)classOrStructConstraint, Cs.ClassOrStructConstraint::getId);
            ctx.sendNode((Object)classOrStructConstraint, Cs.ClassOrStructConstraint::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)classOrStructConstraint, Cs.ClassOrStructConstraint::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendValue((Object)classOrStructConstraint, Cs.ClassOrStructConstraint::getKind);
            return classOrStructConstraint;
        }

        public Cs.ConstructorConstraint visitConstructorConstraint(Cs.ConstructorConstraint constructorConstraint, SenderContext ctx) {
            ctx.sendValue((Object)constructorConstraint, Cs.ConstructorConstraint::getId);
            ctx.sendNode((Object)constructorConstraint, Cs.ConstructorConstraint::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)constructorConstraint, Cs.ConstructorConstraint::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            return constructorConstraint;
        }

        public Cs.DefaultConstraint visitDefaultConstraint(Cs.DefaultConstraint defaultConstraint, SenderContext ctx) {
            ctx.sendValue((Object)defaultConstraint, Cs.DefaultConstraint::getId);
            ctx.sendNode((Object)defaultConstraint, Cs.DefaultConstraint::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)defaultConstraint, Cs.DefaultConstraint::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            return defaultConstraint;
        }

        public Cs.DeclarationExpression visitDeclarationExpression(Cs.DeclarationExpression declarationExpression, SenderContext ctx) {
            ctx.sendValue((Object)declarationExpression, Cs.DeclarationExpression::getId);
            ctx.sendNode((Object)declarationExpression, Cs.DeclarationExpression::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)declarationExpression, Cs.DeclarationExpression::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)declarationExpression, Cs.DeclarationExpression::getTypeExpression, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)declarationExpression, Cs.DeclarationExpression::getVariables, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return declarationExpression;
        }

        public Cs.SingleVariableDesignation visitSingleVariableDesignation(Cs.SingleVariableDesignation singleVariableDesignation, SenderContext ctx) {
            ctx.sendValue((Object)singleVariableDesignation, Cs.SingleVariableDesignation::getId);
            ctx.sendNode((Object)singleVariableDesignation, Cs.SingleVariableDesignation::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)singleVariableDesignation, Cs.SingleVariableDesignation::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)singleVariableDesignation, Cs.SingleVariableDesignation::getName, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return singleVariableDesignation;
        }

        public Cs.ParenthesizedVariableDesignation visitParenthesizedVariableDesignation(Cs.ParenthesizedVariableDesignation parenthesizedVariableDesignation, SenderContext ctx) {
            ctx.sendValue((Object)parenthesizedVariableDesignation, Cs.ParenthesizedVariableDesignation::getId);
            ctx.sendNode((Object)parenthesizedVariableDesignation, Cs.ParenthesizedVariableDesignation::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)parenthesizedVariableDesignation, Cs.ParenthesizedVariableDesignation::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)parenthesizedVariableDesignation, e -> e.getPadding().getVariables(), (x$0, x$1) -> CSharpSender.sendContainer(x$0, x$1));
            ctx.sendTypedValue((Object)parenthesizedVariableDesignation, Cs.ParenthesizedVariableDesignation::getType);
            return parenthesizedVariableDesignation;
        }

        public Cs.DiscardVariableDesignation visitDiscardVariableDesignation(Cs.DiscardVariableDesignation discardVariableDesignation, SenderContext ctx) {
            ctx.sendValue((Object)discardVariableDesignation, Cs.DiscardVariableDesignation::getId);
            ctx.sendNode((Object)discardVariableDesignation, Cs.DiscardVariableDesignation::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)discardVariableDesignation, Cs.DiscardVariableDesignation::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)discardVariableDesignation, Cs.DiscardVariableDesignation::getDiscard, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return discardVariableDesignation;
        }

        public Cs.TupleExpression visitTupleExpression(Cs.TupleExpression tupleExpression, SenderContext ctx) {
            ctx.sendValue((Object)tupleExpression, Cs.TupleExpression::getId);
            ctx.sendNode((Object)tupleExpression, Cs.TupleExpression::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)tupleExpression, Cs.TupleExpression::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)tupleExpression, e -> e.getPadding().getArguments(), (x$0, x$1) -> CSharpSender.sendContainer(x$0, x$1));
            return tupleExpression;
        }

        public Cs.Constructor visitConstructor(Cs.Constructor constructor, SenderContext ctx) {
            ctx.sendValue((Object)constructor, Cs.Constructor::getId);
            ctx.sendNode((Object)constructor, Cs.Constructor::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)constructor, Cs.Constructor::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)constructor, Cs.Constructor::getInitializer, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)constructor, Cs.Constructor::getConstructorCore, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return constructor;
        }

        public Cs.DestructorDeclaration visitDestructorDeclaration(Cs.DestructorDeclaration destructorDeclaration, SenderContext ctx) {
            ctx.sendValue((Object)destructorDeclaration, Cs.DestructorDeclaration::getId);
            ctx.sendNode((Object)destructorDeclaration, Cs.DestructorDeclaration::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)destructorDeclaration, Cs.DestructorDeclaration::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)destructorDeclaration, Cs.DestructorDeclaration::getMethodCore, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return destructorDeclaration;
        }

        public Cs.Unary visitUnary(Cs.Unary unary, SenderContext ctx) {
            ctx.sendValue((Object)unary, Cs.Unary::getId);
            ctx.sendNode((Object)unary, Cs.Unary::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)unary, Cs.Unary::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)unary, e -> e.getPadding().getOperator(), (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            ctx.sendNode((Object)unary, Cs.Unary::getExpression, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendTypedValue((Object)unary, Cs.Unary::getType);
            return unary;
        }

        public Cs.ConstructorInitializer visitConstructorInitializer(Cs.ConstructorInitializer constructorInitializer, SenderContext ctx) {
            ctx.sendValue((Object)constructorInitializer, Cs.ConstructorInitializer::getId);
            ctx.sendNode((Object)constructorInitializer, Cs.ConstructorInitializer::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)constructorInitializer, Cs.ConstructorInitializer::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)constructorInitializer, Cs.ConstructorInitializer::getKeyword, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)constructorInitializer, e -> e.getPadding().getArguments(), (x$0, x$1) -> CSharpSender.sendContainer(x$0, x$1));
            return constructorInitializer;
        }

        public Cs.TupleType visitTupleType(Cs.TupleType tupleType, SenderContext ctx) {
            ctx.sendValue((Object)tupleType, Cs.TupleType::getId);
            ctx.sendNode((Object)tupleType, Cs.TupleType::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)tupleType, Cs.TupleType::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)tupleType, e -> e.getPadding().getElements(), (x$0, x$1) -> CSharpSender.sendContainer(x$0, x$1));
            ctx.sendTypedValue((Object)tupleType, Cs.TupleType::getType);
            return tupleType;
        }

        public Cs.TupleElement visitTupleElement(Cs.TupleElement tupleElement, SenderContext ctx) {
            ctx.sendValue((Object)tupleElement, Cs.TupleElement::getId);
            ctx.sendNode((Object)tupleElement, Cs.TupleElement::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)tupleElement, Cs.TupleElement::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)tupleElement, Cs.TupleElement::getType, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)tupleElement, Cs.TupleElement::getName, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return tupleElement;
        }

        public Cs.NewClass visitNewClass(Cs.NewClass newClass, SenderContext ctx) {
            ctx.sendValue((Object)newClass, Cs.NewClass::getId);
            ctx.sendNode((Object)newClass, Cs.NewClass::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)newClass, Cs.NewClass::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)newClass, Cs.NewClass::getNewClassCore, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)newClass, Cs.NewClass::getInitializer, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return newClass;
        }

        public Cs.InitializerExpression visitInitializerExpression(Cs.InitializerExpression initializerExpression, SenderContext ctx) {
            ctx.sendValue((Object)initializerExpression, Cs.InitializerExpression::getId);
            ctx.sendNode((Object)initializerExpression, Cs.InitializerExpression::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)initializerExpression, Cs.InitializerExpression::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)initializerExpression, e -> e.getPadding().getExpressions(), (x$0, x$1) -> CSharpSender.sendContainer(x$0, x$1));
            return initializerExpression;
        }

        public Cs.ImplicitElementAccess visitImplicitElementAccess(Cs.ImplicitElementAccess implicitElementAccess, SenderContext ctx) {
            ctx.sendValue((Object)implicitElementAccess, Cs.ImplicitElementAccess::getId);
            ctx.sendNode((Object)implicitElementAccess, Cs.ImplicitElementAccess::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)implicitElementAccess, Cs.ImplicitElementAccess::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)implicitElementAccess, e -> e.getPadding().getArgumentList(), (x$0, x$1) -> CSharpSender.sendContainer(x$0, x$1));
            return implicitElementAccess;
        }

        public Cs.Yield visitYield(Cs.Yield yield, SenderContext ctx) {
            ctx.sendValue((Object)yield, Cs.Yield::getId);
            ctx.sendNode((Object)yield, Cs.Yield::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)yield, Cs.Yield::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)yield, Cs.Yield::getReturnOrBreakKeyword, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)yield, Cs.Yield::getExpression, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return yield;
        }

        public Cs.DefaultExpression visitDefaultExpression(Cs.DefaultExpression defaultExpression, SenderContext ctx) {
            ctx.sendValue((Object)defaultExpression, Cs.DefaultExpression::getId);
            ctx.sendNode((Object)defaultExpression, Cs.DefaultExpression::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)defaultExpression, Cs.DefaultExpression::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)defaultExpression, e -> e.getPadding().getTypeOperator(), (x$0, x$1) -> CSharpSender.sendContainer(x$0, x$1));
            return defaultExpression;
        }

        public Cs.IsPattern visitIsPattern(Cs.IsPattern isPattern, SenderContext ctx) {
            ctx.sendValue((Object)isPattern, Cs.IsPattern::getId);
            ctx.sendNode((Object)isPattern, Cs.IsPattern::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)isPattern, Cs.IsPattern::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)isPattern, Cs.IsPattern::getExpression, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)isPattern, e -> e.getPadding().getPattern(), (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            return isPattern;
        }

        public Cs.UnaryPattern visitUnaryPattern(Cs.UnaryPattern unaryPattern, SenderContext ctx) {
            ctx.sendValue((Object)unaryPattern, Cs.UnaryPattern::getId);
            ctx.sendNode((Object)unaryPattern, Cs.UnaryPattern::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)unaryPattern, Cs.UnaryPattern::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)unaryPattern, Cs.UnaryPattern::getOperator, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)unaryPattern, Cs.UnaryPattern::getPattern, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return unaryPattern;
        }

        public Cs.TypePattern visitTypePattern(Cs.TypePattern typePattern, SenderContext ctx) {
            ctx.sendValue((Object)typePattern, Cs.TypePattern::getId);
            ctx.sendNode((Object)typePattern, Cs.TypePattern::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)typePattern, Cs.TypePattern::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)typePattern, Cs.TypePattern::getTypeIdentifier, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)typePattern, Cs.TypePattern::getDesignation, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return typePattern;
        }

        public Cs.BinaryPattern visitBinaryPattern(Cs.BinaryPattern binaryPattern, SenderContext ctx) {
            ctx.sendValue((Object)binaryPattern, Cs.BinaryPattern::getId);
            ctx.sendNode((Object)binaryPattern, Cs.BinaryPattern::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)binaryPattern, Cs.BinaryPattern::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)binaryPattern, Cs.BinaryPattern::getLeft, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)binaryPattern, e -> e.getPadding().getOperator(), (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            ctx.sendNode((Object)binaryPattern, Cs.BinaryPattern::getRight, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return binaryPattern;
        }

        public Cs.ConstantPattern visitConstantPattern(Cs.ConstantPattern constantPattern, SenderContext ctx) {
            ctx.sendValue((Object)constantPattern, Cs.ConstantPattern::getId);
            ctx.sendNode((Object)constantPattern, Cs.ConstantPattern::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)constantPattern, Cs.ConstantPattern::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)constantPattern, Cs.ConstantPattern::getValue, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return constantPattern;
        }

        public Cs.DiscardPattern visitDiscardPattern(Cs.DiscardPattern discardPattern, SenderContext ctx) {
            ctx.sendValue((Object)discardPattern, Cs.DiscardPattern::getId);
            ctx.sendNode((Object)discardPattern, Cs.DiscardPattern::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)discardPattern, Cs.DiscardPattern::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendTypedValue((Object)discardPattern, Cs.DiscardPattern::getType);
            return discardPattern;
        }

        public Cs.ListPattern visitListPattern(Cs.ListPattern listPattern, SenderContext ctx) {
            ctx.sendValue((Object)listPattern, Cs.ListPattern::getId);
            ctx.sendNode((Object)listPattern, Cs.ListPattern::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)listPattern, Cs.ListPattern::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)listPattern, e -> e.getPadding().getPatterns(), (x$0, x$1) -> CSharpSender.sendContainer(x$0, x$1));
            ctx.sendNode((Object)listPattern, Cs.ListPattern::getDesignation, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return listPattern;
        }

        public Cs.ParenthesizedPattern visitParenthesizedPattern(Cs.ParenthesizedPattern parenthesizedPattern, SenderContext ctx) {
            ctx.sendValue((Object)parenthesizedPattern, Cs.ParenthesizedPattern::getId);
            ctx.sendNode((Object)parenthesizedPattern, Cs.ParenthesizedPattern::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)parenthesizedPattern, Cs.ParenthesizedPattern::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)parenthesizedPattern, e -> e.getPadding().getPattern(), (x$0, x$1) -> CSharpSender.sendContainer(x$0, x$1));
            return parenthesizedPattern;
        }

        public Cs.RecursivePattern visitRecursivePattern(Cs.RecursivePattern recursivePattern, SenderContext ctx) {
            ctx.sendValue((Object)recursivePattern, Cs.RecursivePattern::getId);
            ctx.sendNode((Object)recursivePattern, Cs.RecursivePattern::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)recursivePattern, Cs.RecursivePattern::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)recursivePattern, Cs.RecursivePattern::getTypeQualifier, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)recursivePattern, Cs.RecursivePattern::getPositionalPattern, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)recursivePattern, Cs.RecursivePattern::getPropertyPattern, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)recursivePattern, Cs.RecursivePattern::getDesignation, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return recursivePattern;
        }

        public Cs.VarPattern visitVarPattern(Cs.VarPattern varPattern, SenderContext ctx) {
            ctx.sendValue((Object)varPattern, Cs.VarPattern::getId);
            ctx.sendNode((Object)varPattern, Cs.VarPattern::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)varPattern, Cs.VarPattern::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)varPattern, Cs.VarPattern::getDesignation, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return varPattern;
        }

        public Cs.PositionalPatternClause visitPositionalPatternClause(Cs.PositionalPatternClause positionalPatternClause, SenderContext ctx) {
            ctx.sendValue((Object)positionalPatternClause, Cs.PositionalPatternClause::getId);
            ctx.sendNode((Object)positionalPatternClause, Cs.PositionalPatternClause::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)positionalPatternClause, Cs.PositionalPatternClause::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)positionalPatternClause, e -> e.getPadding().getSubpatterns(), (x$0, x$1) -> CSharpSender.sendContainer(x$0, x$1));
            return positionalPatternClause;
        }

        public Cs.RelationalPattern visitRelationalPattern(Cs.RelationalPattern relationalPattern, SenderContext ctx) {
            ctx.sendValue((Object)relationalPattern, Cs.RelationalPattern::getId);
            ctx.sendNode((Object)relationalPattern, Cs.RelationalPattern::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)relationalPattern, Cs.RelationalPattern::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)relationalPattern, e -> e.getPadding().getOperator(), (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            ctx.sendNode((Object)relationalPattern, Cs.RelationalPattern::getValue, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return relationalPattern;
        }

        public Cs.SlicePattern visitSlicePattern(Cs.SlicePattern slicePattern, SenderContext ctx) {
            ctx.sendValue((Object)slicePattern, Cs.SlicePattern::getId);
            ctx.sendNode((Object)slicePattern, Cs.SlicePattern::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)slicePattern, Cs.SlicePattern::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            return slicePattern;
        }

        public Cs.PropertyPatternClause visitPropertyPatternClause(Cs.PropertyPatternClause propertyPatternClause, SenderContext ctx) {
            ctx.sendValue((Object)propertyPatternClause, Cs.PropertyPatternClause::getId);
            ctx.sendNode((Object)propertyPatternClause, Cs.PropertyPatternClause::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)propertyPatternClause, Cs.PropertyPatternClause::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)propertyPatternClause, e -> e.getPadding().getSubpatterns(), (x$0, x$1) -> CSharpSender.sendContainer(x$0, x$1));
            return propertyPatternClause;
        }

        public Cs.Subpattern visitSubpattern(Cs.Subpattern subpattern, SenderContext ctx) {
            ctx.sendValue((Object)subpattern, Cs.Subpattern::getId);
            ctx.sendNode((Object)subpattern, Cs.Subpattern::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)subpattern, Cs.Subpattern::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)subpattern, Cs.Subpattern::getName, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)subpattern, e -> e.getPadding().getPattern(), (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            return subpattern;
        }

        public Cs.SwitchExpression visitSwitchExpression(Cs.SwitchExpression switchExpression, SenderContext ctx) {
            ctx.sendValue((Object)switchExpression, Cs.SwitchExpression::getId);
            ctx.sendNode((Object)switchExpression, Cs.SwitchExpression::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)switchExpression, Cs.SwitchExpression::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)switchExpression, e -> e.getPadding().getExpression(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            ctx.sendNode((Object)switchExpression, e -> e.getPadding().getArms(), (x$0, x$1) -> CSharpSender.sendContainer(x$0, x$1));
            return switchExpression;
        }

        public Cs.SwitchExpressionArm visitSwitchExpressionArm(Cs.SwitchExpressionArm switchExpressionArm, SenderContext ctx) {
            ctx.sendValue((Object)switchExpressionArm, Cs.SwitchExpressionArm::getId);
            ctx.sendNode((Object)switchExpressionArm, Cs.SwitchExpressionArm::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)switchExpressionArm, Cs.SwitchExpressionArm::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)switchExpressionArm, Cs.SwitchExpressionArm::getPattern, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)switchExpressionArm, e -> e.getPadding().getWhenExpression(), (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            ctx.sendNode((Object)switchExpressionArm, e -> e.getPadding().getExpression(), (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            return switchExpressionArm;
        }

        public Cs.SwitchSection visitSwitchSection(Cs.SwitchSection switchSection, SenderContext ctx) {
            ctx.sendValue((Object)switchSection, Cs.SwitchSection::getId);
            ctx.sendNode((Object)switchSection, Cs.SwitchSection::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)switchSection, Cs.SwitchSection::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNodes((Object)switchSection, Cs.SwitchSection::getLabels, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1), Tree::getId);
            ctx.sendNodes((Object)switchSection, e -> e.getPadding().getStatements(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1), e -> ((Statement)e.getElement()).getId());
            return switchSection;
        }

        public Cs.DefaultSwitchLabel visitDefaultSwitchLabel(Cs.DefaultSwitchLabel defaultSwitchLabel, SenderContext ctx) {
            ctx.sendValue((Object)defaultSwitchLabel, Cs.DefaultSwitchLabel::getId);
            ctx.sendNode((Object)defaultSwitchLabel, Cs.DefaultSwitchLabel::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)defaultSwitchLabel, Cs.DefaultSwitchLabel::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)defaultSwitchLabel, Cs.DefaultSwitchLabel::getColonToken, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            return defaultSwitchLabel;
        }

        public Cs.CasePatternSwitchLabel visitCasePatternSwitchLabel(Cs.CasePatternSwitchLabel casePatternSwitchLabel, SenderContext ctx) {
            ctx.sendValue((Object)casePatternSwitchLabel, Cs.CasePatternSwitchLabel::getId);
            ctx.sendNode((Object)casePatternSwitchLabel, Cs.CasePatternSwitchLabel::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)casePatternSwitchLabel, Cs.CasePatternSwitchLabel::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)casePatternSwitchLabel, Cs.CasePatternSwitchLabel::getPattern, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)casePatternSwitchLabel, e -> e.getPadding().getWhenClause(), (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            ctx.sendNode((Object)casePatternSwitchLabel, Cs.CasePatternSwitchLabel::getColonToken, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            return casePatternSwitchLabel;
        }

        public Cs.SwitchStatement visitSwitchStatement(Cs.SwitchStatement switchStatement, SenderContext ctx) {
            ctx.sendValue((Object)switchStatement, Cs.SwitchStatement::getId);
            ctx.sendNode((Object)switchStatement, Cs.SwitchStatement::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)switchStatement, Cs.SwitchStatement::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)switchStatement, e -> e.getPadding().getExpression(), (x$0, x$1) -> CSharpSender.sendContainer(x$0, x$1));
            ctx.sendNode((Object)switchStatement, e -> e.getPadding().getSections(), (x$0, x$1) -> CSharpSender.sendContainer(x$0, x$1));
            return switchStatement;
        }

        public Cs.LockStatement visitLockStatement(Cs.LockStatement lockStatement, SenderContext ctx) {
            ctx.sendValue((Object)lockStatement, Cs.LockStatement::getId);
            ctx.sendNode((Object)lockStatement, Cs.LockStatement::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)lockStatement, Cs.LockStatement::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)lockStatement, Cs.LockStatement::getExpression, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)lockStatement, e -> e.getPadding().getStatement(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            return lockStatement;
        }

        public Cs.FixedStatement visitFixedStatement(Cs.FixedStatement fixedStatement, SenderContext ctx) {
            ctx.sendValue((Object)fixedStatement, Cs.FixedStatement::getId);
            ctx.sendNode((Object)fixedStatement, Cs.FixedStatement::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)fixedStatement, Cs.FixedStatement::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)fixedStatement, Cs.FixedStatement::getDeclarations, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)fixedStatement, Cs.FixedStatement::getBlock, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return fixedStatement;
        }

        public Cs.CheckedExpression visitCheckedExpression(Cs.CheckedExpression checkedExpression, SenderContext ctx) {
            ctx.sendValue((Object)checkedExpression, Cs.CheckedExpression::getId);
            ctx.sendNode((Object)checkedExpression, Cs.CheckedExpression::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)checkedExpression, Cs.CheckedExpression::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)checkedExpression, Cs.CheckedExpression::getCheckedOrUncheckedKeyword, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)checkedExpression, Cs.CheckedExpression::getExpression, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return checkedExpression;
        }

        public Cs.CheckedStatement visitCheckedStatement(Cs.CheckedStatement checkedStatement, SenderContext ctx) {
            ctx.sendValue((Object)checkedStatement, Cs.CheckedStatement::getId);
            ctx.sendNode((Object)checkedStatement, Cs.CheckedStatement::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)checkedStatement, Cs.CheckedStatement::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)checkedStatement, Cs.CheckedStatement::getKeyword, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)checkedStatement, Cs.CheckedStatement::getBlock, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return checkedStatement;
        }

        public Cs.UnsafeStatement visitUnsafeStatement(Cs.UnsafeStatement unsafeStatement, SenderContext ctx) {
            ctx.sendValue((Object)unsafeStatement, Cs.UnsafeStatement::getId);
            ctx.sendNode((Object)unsafeStatement, Cs.UnsafeStatement::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)unsafeStatement, Cs.UnsafeStatement::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)unsafeStatement, Cs.UnsafeStatement::getBlock, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return unsafeStatement;
        }

        public Cs.RangeExpression visitRangeExpression(Cs.RangeExpression rangeExpression, SenderContext ctx) {
            ctx.sendValue((Object)rangeExpression, Cs.RangeExpression::getId);
            ctx.sendNode((Object)rangeExpression, Cs.RangeExpression::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)rangeExpression, Cs.RangeExpression::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)rangeExpression, e -> e.getPadding().getStart(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            ctx.sendNode((Object)rangeExpression, Cs.RangeExpression::getEnd, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return rangeExpression;
        }

        public Cs.QueryExpression visitQueryExpression(Cs.QueryExpression queryExpression, SenderContext ctx) {
            ctx.sendValue((Object)queryExpression, Cs.QueryExpression::getId);
            ctx.sendNode((Object)queryExpression, Cs.QueryExpression::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)queryExpression, Cs.QueryExpression::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)queryExpression, Cs.QueryExpression::getFromClause, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)queryExpression, Cs.QueryExpression::getBody, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return queryExpression;
        }

        public Cs.QueryBody visitQueryBody(Cs.QueryBody queryBody, SenderContext ctx) {
            ctx.sendValue((Object)queryBody, Cs.QueryBody::getId);
            ctx.sendNode((Object)queryBody, Cs.QueryBody::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)queryBody, Cs.QueryBody::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNodes((Object)queryBody, Cs.QueryBody::getClauses, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1), Tree::getId);
            ctx.sendNode((Object)queryBody, Cs.QueryBody::getSelectOrGroup, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)queryBody, Cs.QueryBody::getContinuation, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return queryBody;
        }

        public Cs.FromClause visitFromClause(Cs.FromClause fromClause, SenderContext ctx) {
            ctx.sendValue((Object)fromClause, Cs.FromClause::getId);
            ctx.sendNode((Object)fromClause, Cs.FromClause::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)fromClause, Cs.FromClause::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)fromClause, Cs.FromClause::getTypeIdentifier, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)fromClause, e -> e.getPadding().getIdentifier(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            ctx.sendNode((Object)fromClause, Cs.FromClause::getExpression, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return fromClause;
        }

        public Cs.LetClause visitLetClause(Cs.LetClause letClause, SenderContext ctx) {
            ctx.sendValue((Object)letClause, Cs.LetClause::getId);
            ctx.sendNode((Object)letClause, Cs.LetClause::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)letClause, Cs.LetClause::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)letClause, e -> e.getPadding().getIdentifier(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            ctx.sendNode((Object)letClause, Cs.LetClause::getExpression, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return letClause;
        }

        public Cs.JoinClause visitJoinClause(Cs.JoinClause joinClause, SenderContext ctx) {
            ctx.sendValue((Object)joinClause, Cs.JoinClause::getId);
            ctx.sendNode((Object)joinClause, Cs.JoinClause::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)joinClause, Cs.JoinClause::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)joinClause, e -> e.getPadding().getIdentifier(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            ctx.sendNode((Object)joinClause, e -> e.getPadding().getInExpression(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            ctx.sendNode((Object)joinClause, e -> e.getPadding().getLeftExpression(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            ctx.sendNode((Object)joinClause, Cs.JoinClause::getRightExpression, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)joinClause, e -> e.getPadding().getInto(), (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            return joinClause;
        }

        public Cs.JoinIntoClause visitJoinIntoClause(Cs.JoinIntoClause joinIntoClause, SenderContext ctx) {
            ctx.sendValue((Object)joinIntoClause, Cs.JoinIntoClause::getId);
            ctx.sendNode((Object)joinIntoClause, Cs.JoinIntoClause::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)joinIntoClause, Cs.JoinIntoClause::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)joinIntoClause, Cs.JoinIntoClause::getIdentifier, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return joinIntoClause;
        }

        public Cs.WhereClause visitWhereClause(Cs.WhereClause whereClause, SenderContext ctx) {
            ctx.sendValue((Object)whereClause, Cs.WhereClause::getId);
            ctx.sendNode((Object)whereClause, Cs.WhereClause::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)whereClause, Cs.WhereClause::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)whereClause, Cs.WhereClause::getCondition, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return whereClause;
        }

        public Cs.OrderByClause visitOrderByClause(Cs.OrderByClause orderByClause, SenderContext ctx) {
            ctx.sendValue((Object)orderByClause, Cs.OrderByClause::getId);
            ctx.sendNode((Object)orderByClause, Cs.OrderByClause::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)orderByClause, Cs.OrderByClause::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNodes((Object)orderByClause, e -> e.getPadding().getOrderings(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1), e -> ((Cs.Ordering)e.getElement()).getId());
            return orderByClause;
        }

        public Cs.QueryContinuation visitQueryContinuation(Cs.QueryContinuation queryContinuation, SenderContext ctx) {
            ctx.sendValue((Object)queryContinuation, Cs.QueryContinuation::getId);
            ctx.sendNode((Object)queryContinuation, Cs.QueryContinuation::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)queryContinuation, Cs.QueryContinuation::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)queryContinuation, Cs.QueryContinuation::getIdentifier, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)queryContinuation, Cs.QueryContinuation::getBody, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return queryContinuation;
        }

        public Cs.Ordering visitOrdering(Cs.Ordering ordering, SenderContext ctx) {
            ctx.sendValue((Object)ordering, Cs.Ordering::getId);
            ctx.sendNode((Object)ordering, Cs.Ordering::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)ordering, Cs.Ordering::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)ordering, e -> e.getPadding().getExpression(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            ctx.sendValue((Object)ordering, Cs.Ordering::getDirection);
            return ordering;
        }

        public Cs.SelectClause visitSelectClause(Cs.SelectClause selectClause, SenderContext ctx) {
            ctx.sendValue((Object)selectClause, Cs.SelectClause::getId);
            ctx.sendNode((Object)selectClause, Cs.SelectClause::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)selectClause, Cs.SelectClause::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)selectClause, Cs.SelectClause::getExpression, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return selectClause;
        }

        public Cs.GroupClause visitGroupClause(Cs.GroupClause groupClause, SenderContext ctx) {
            ctx.sendValue((Object)groupClause, Cs.GroupClause::getId);
            ctx.sendNode((Object)groupClause, Cs.GroupClause::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)groupClause, Cs.GroupClause::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)groupClause, e -> e.getPadding().getGroupExpression(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            ctx.sendNode((Object)groupClause, Cs.GroupClause::getKey, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return groupClause;
        }

        public Cs.IndexerDeclaration visitIndexerDeclaration(Cs.IndexerDeclaration indexerDeclaration, SenderContext ctx) {
            ctx.sendValue((Object)indexerDeclaration, Cs.IndexerDeclaration::getId);
            ctx.sendNode((Object)indexerDeclaration, Cs.IndexerDeclaration::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)indexerDeclaration, Cs.IndexerDeclaration::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNodes((Object)indexerDeclaration, Cs.IndexerDeclaration::getModifiers, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1), Tree::getId);
            ctx.sendNode((Object)indexerDeclaration, Cs.IndexerDeclaration::getTypeExpression, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)indexerDeclaration, e -> e.getPadding().getExplicitInterfaceSpecifier(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            ctx.sendNode((Object)indexerDeclaration, Cs.IndexerDeclaration::getIndexer, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)indexerDeclaration, e -> e.getPadding().getParameters(), (x$0, x$1) -> CSharpSender.sendContainer(x$0, x$1));
            ctx.sendNode((Object)indexerDeclaration, e -> e.getPadding().getExpressionBody(), (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            ctx.sendNode((Object)indexerDeclaration, Cs.IndexerDeclaration::getAccessors, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return indexerDeclaration;
        }

        public Cs.DelegateDeclaration visitDelegateDeclaration(Cs.DelegateDeclaration delegateDeclaration, SenderContext ctx) {
            ctx.sendValue((Object)delegateDeclaration, Cs.DelegateDeclaration::getId);
            ctx.sendNode((Object)delegateDeclaration, Cs.DelegateDeclaration::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)delegateDeclaration, Cs.DelegateDeclaration::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNodes((Object)delegateDeclaration, Cs.DelegateDeclaration::getAttributes, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1), Tree::getId);
            ctx.sendNodes((Object)delegateDeclaration, Cs.DelegateDeclaration::getModifiers, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1), Tree::getId);
            ctx.sendNode((Object)delegateDeclaration, e -> e.getPadding().getReturnType(), (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            ctx.sendNode((Object)delegateDeclaration, Cs.DelegateDeclaration::getIdentifier, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)delegateDeclaration, e -> e.getPadding().getTypeParameters(), (x$0, x$1) -> CSharpSender.sendContainer(x$0, x$1));
            ctx.sendNode((Object)delegateDeclaration, e -> e.getPadding().getParameters(), (x$0, x$1) -> CSharpSender.sendContainer(x$0, x$1));
            ctx.sendNode((Object)delegateDeclaration, e -> e.getPadding().getTypeParameterConstraintClauses(), (x$0, x$1) -> CSharpSender.sendContainer(x$0, x$1));
            return delegateDeclaration;
        }

        public Cs.ConversionOperatorDeclaration visitConversionOperatorDeclaration(Cs.ConversionOperatorDeclaration conversionOperatorDeclaration, SenderContext ctx) {
            ctx.sendValue((Object)conversionOperatorDeclaration, Cs.ConversionOperatorDeclaration::getId);
            ctx.sendNode((Object)conversionOperatorDeclaration, Cs.ConversionOperatorDeclaration::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)conversionOperatorDeclaration, Cs.ConversionOperatorDeclaration::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNodes((Object)conversionOperatorDeclaration, Cs.ConversionOperatorDeclaration::getModifiers, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1), Tree::getId);
            ctx.sendNode((Object)conversionOperatorDeclaration, e -> e.getPadding().getKind(), (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            ctx.sendNode((Object)conversionOperatorDeclaration, e -> e.getPadding().getReturnType(), (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            ctx.sendNode((Object)conversionOperatorDeclaration, e -> e.getPadding().getParameters(), (x$0, x$1) -> CSharpSender.sendContainer(x$0, x$1));
            ctx.sendNode((Object)conversionOperatorDeclaration, e -> e.getPadding().getExpressionBody(), (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            ctx.sendNode((Object)conversionOperatorDeclaration, Cs.ConversionOperatorDeclaration::getBody, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return conversionOperatorDeclaration;
        }

        public Cs.TypeParameter visitTypeParameter(Cs.TypeParameter typeParameter, SenderContext ctx) {
            ctx.sendValue((Object)typeParameter, Cs.TypeParameter::getId);
            ctx.sendNode((Object)typeParameter, Cs.TypeParameter::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)typeParameter, Cs.TypeParameter::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNodes((Object)typeParameter, Cs.TypeParameter::getAttributeLists, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1), Tree::getId);
            ctx.sendNode((Object)typeParameter, e -> e.getPadding().getVariance(), (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            ctx.sendNode((Object)typeParameter, Cs.TypeParameter::getName, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return typeParameter;
        }

        public Cs.EnumDeclaration visitEnumDeclaration(Cs.EnumDeclaration enumDeclaration, SenderContext ctx) {
            ctx.sendValue((Object)enumDeclaration, Cs.EnumDeclaration::getId);
            ctx.sendNode((Object)enumDeclaration, Cs.EnumDeclaration::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)enumDeclaration, Cs.EnumDeclaration::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNodes((Object)enumDeclaration, Cs.EnumDeclaration::getAttributeLists, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1), Tree::getId);
            ctx.sendNodes((Object)enumDeclaration, Cs.EnumDeclaration::getModifiers, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1), Tree::getId);
            ctx.sendNode((Object)enumDeclaration, e -> e.getPadding().getName(), (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            ctx.sendNode((Object)enumDeclaration, e -> e.getPadding().getBaseType(), (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            ctx.sendNode((Object)enumDeclaration, e -> e.getPadding().getMembers(), (x$0, x$1) -> CSharpSender.sendContainer(x$0, x$1));
            return enumDeclaration;
        }

        public Cs.EnumMemberDeclaration visitEnumMemberDeclaration(Cs.EnumMemberDeclaration enumMemberDeclaration, SenderContext ctx) {
            ctx.sendValue((Object)enumMemberDeclaration, Cs.EnumMemberDeclaration::getId);
            ctx.sendNode((Object)enumMemberDeclaration, Cs.EnumMemberDeclaration::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)enumMemberDeclaration, Cs.EnumMemberDeclaration::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNodes((Object)enumMemberDeclaration, Cs.EnumMemberDeclaration::getAttributeLists, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1), Tree::getId);
            ctx.sendNode((Object)enumMemberDeclaration, Cs.EnumMemberDeclaration::getName, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)enumMemberDeclaration, e -> e.getPadding().getInitializer(), (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            return enumMemberDeclaration;
        }

        public Cs.AliasQualifiedName visitAliasQualifiedName(Cs.AliasQualifiedName aliasQualifiedName, SenderContext ctx) {
            ctx.sendValue((Object)aliasQualifiedName, Cs.AliasQualifiedName::getId);
            ctx.sendNode((Object)aliasQualifiedName, Cs.AliasQualifiedName::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)aliasQualifiedName, Cs.AliasQualifiedName::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)aliasQualifiedName, e -> e.getPadding().getAlias(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            ctx.sendNode((Object)aliasQualifiedName, Cs.AliasQualifiedName::getName, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return aliasQualifiedName;
        }

        public Cs.ArrayType visitArrayType(Cs.ArrayType arrayType, SenderContext ctx) {
            ctx.sendValue((Object)arrayType, Cs.ArrayType::getId);
            ctx.sendNode((Object)arrayType, Cs.ArrayType::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)arrayType, Cs.ArrayType::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)arrayType, Cs.ArrayType::getTypeExpression, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNodes((Object)arrayType, Cs.ArrayType::getDimensions, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1), Tree::getId);
            ctx.sendTypedValue((Object)arrayType, Cs.ArrayType::getType);
            return arrayType;
        }

        public Cs.Try visitTry(Cs.Try try_, SenderContext ctx) {
            ctx.sendValue((Object)try_, Cs.Try::getId);
            ctx.sendNode((Object)try_, Cs.Try::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)try_, Cs.Try::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)try_, Cs.Try::getBody, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNodes((Object)try_, Cs.Try::getCatches, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1), Tree::getId);
            ctx.sendNode((Object)try_, e -> e.getPadding().getFinally(), (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            return try_;
        }

        public Cs.Try.Catch visitTryCatch(Cs.Try.Catch catch_, SenderContext ctx) {
            ctx.sendValue((Object)catch_, Cs.Try.Catch::getId);
            ctx.sendNode((Object)catch_, Cs.Try.Catch::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)catch_, Cs.Try.Catch::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)catch_, Cs.Try.Catch::getParameter, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)catch_, e -> e.getPadding().getFilterExpression(), (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            ctx.sendNode((Object)catch_, Cs.Try.Catch::getBody, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return catch_;
        }

        public Cs.ArrowExpressionClause visitArrowExpressionClause(Cs.ArrowExpressionClause arrowExpressionClause, SenderContext ctx) {
            ctx.sendValue((Object)arrowExpressionClause, Cs.ArrowExpressionClause::getId);
            ctx.sendNode((Object)arrowExpressionClause, Cs.ArrowExpressionClause::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)arrowExpressionClause, Cs.ArrowExpressionClause::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)arrowExpressionClause, e -> e.getPadding().getExpression(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            return arrowExpressionClause;
        }

        public Cs.AccessorDeclaration visitAccessorDeclaration(Cs.AccessorDeclaration accessorDeclaration, SenderContext ctx) {
            ctx.sendValue((Object)accessorDeclaration, Cs.AccessorDeclaration::getId);
            ctx.sendNode((Object)accessorDeclaration, Cs.AccessorDeclaration::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)accessorDeclaration, Cs.AccessorDeclaration::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNodes((Object)accessorDeclaration, Cs.AccessorDeclaration::getAttributes, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1), Tree::getId);
            ctx.sendNodes((Object)accessorDeclaration, Cs.AccessorDeclaration::getModifiers, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1), Tree::getId);
            ctx.sendNode((Object)accessorDeclaration, e -> e.getPadding().getKind(), (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            ctx.sendNode((Object)accessorDeclaration, Cs.AccessorDeclaration::getExpressionBody, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)accessorDeclaration, Cs.AccessorDeclaration::getBody, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return accessorDeclaration;
        }

        public Cs.PointerFieldAccess visitPointerFieldAccess(Cs.PointerFieldAccess pointerFieldAccess, SenderContext ctx) {
            ctx.sendValue((Object)pointerFieldAccess, Cs.PointerFieldAccess::getId);
            ctx.sendNode((Object)pointerFieldAccess, Cs.PointerFieldAccess::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)pointerFieldAccess, Cs.PointerFieldAccess::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)pointerFieldAccess, Cs.PointerFieldAccess::getTarget, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)pointerFieldAccess, e -> e.getPadding().getName(), (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            ctx.sendTypedValue((Object)pointerFieldAccess, Cs.PointerFieldAccess::getType);
            return pointerFieldAccess;
        }

        public J.AnnotatedType visitAnnotatedType(J.AnnotatedType annotatedType, SenderContext ctx) {
            ctx.sendValue((Object)annotatedType, J.AnnotatedType::getId);
            ctx.sendNode((Object)annotatedType, J.AnnotatedType::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)annotatedType, J.AnnotatedType::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNodes((Object)annotatedType, J.AnnotatedType::getAnnotations, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1), Tree::getId);
            ctx.sendNode((Object)annotatedType, J.AnnotatedType::getTypeExpression, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return annotatedType;
        }

        public J.Annotation visitAnnotation(J.Annotation annotation, SenderContext ctx) {
            ctx.sendValue((Object)annotation, J.Annotation::getId);
            ctx.sendNode((Object)annotation, J.Annotation::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)annotation, J.Annotation::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)annotation, J.Annotation::getAnnotationType, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)annotation, e -> e.getPadding().getArguments(), (x$0, x$1) -> CSharpSender.sendContainer(x$0, x$1));
            return annotation;
        }

        public J.ArrayAccess visitArrayAccess(J.ArrayAccess arrayAccess, SenderContext ctx) {
            ctx.sendValue((Object)arrayAccess, J.ArrayAccess::getId);
            ctx.sendNode((Object)arrayAccess, J.ArrayAccess::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)arrayAccess, J.ArrayAccess::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)arrayAccess, J.ArrayAccess::getIndexed, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)arrayAccess, J.ArrayAccess::getDimension, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendTypedValue((Object)arrayAccess, J.ArrayAccess::getType);
            return arrayAccess;
        }

        public J.ArrayType visitArrayType(J.ArrayType arrayType, SenderContext ctx) {
            ctx.sendValue((Object)arrayType, J.ArrayType::getId);
            ctx.sendNode((Object)arrayType, J.ArrayType::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)arrayType, J.ArrayType::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)arrayType, J.ArrayType::getElementType, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNodes((Object)arrayType, J.ArrayType::getAnnotations, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1), Tree::getId);
            ctx.sendNode((Object)arrayType, J.ArrayType::getDimension, (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            ctx.sendTypedValue((Object)arrayType, J.ArrayType::getType);
            return arrayType;
        }

        public J.Assert visitAssert(J.Assert assert_, SenderContext ctx) {
            ctx.sendValue((Object)assert_, J.Assert::getId);
            ctx.sendNode((Object)assert_, J.Assert::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)assert_, J.Assert::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)assert_, J.Assert::getCondition, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)assert_, J.Assert::getDetail, (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            return assert_;
        }

        public J.Assignment visitAssignment(J.Assignment assignment, SenderContext ctx) {
            ctx.sendValue((Object)assignment, J.Assignment::getId);
            ctx.sendNode((Object)assignment, J.Assignment::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)assignment, J.Assignment::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)assignment, J.Assignment::getVariable, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)assignment, e -> e.getPadding().getAssignment(), (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            ctx.sendTypedValue((Object)assignment, J.Assignment::getType);
            return assignment;
        }

        public J.AssignmentOperation visitAssignmentOperation(J.AssignmentOperation assignmentOperation, SenderContext ctx) {
            ctx.sendValue((Object)assignmentOperation, J.AssignmentOperation::getId);
            ctx.sendNode((Object)assignmentOperation, J.AssignmentOperation::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)assignmentOperation, J.AssignmentOperation::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)assignmentOperation, J.AssignmentOperation::getVariable, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)assignmentOperation, e -> e.getPadding().getOperator(), (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            ctx.sendNode((Object)assignmentOperation, J.AssignmentOperation::getAssignment, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendTypedValue((Object)assignmentOperation, J.AssignmentOperation::getType);
            return assignmentOperation;
        }

        public J.Binary visitBinary(J.Binary binary, SenderContext ctx) {
            ctx.sendValue((Object)binary, J.Binary::getId);
            ctx.sendNode((Object)binary, J.Binary::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)binary, J.Binary::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)binary, J.Binary::getLeft, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)binary, e -> e.getPadding().getOperator(), (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            ctx.sendNode((Object)binary, J.Binary::getRight, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendTypedValue((Object)binary, J.Binary::getType);
            return binary;
        }

        public J.Block visitBlock(J.Block block, SenderContext ctx) {
            ctx.sendValue((Object)block, J.Block::getId);
            ctx.sendNode((Object)block, J.Block::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)block, J.Block::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)block, e -> e.getPadding().getStatic(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            ctx.sendNodes((Object)block, e -> e.getPadding().getStatements(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1), e -> ((Statement)e.getElement()).getId());
            ctx.sendNode((Object)block, J.Block::getEnd, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            return block;
        }

        public J.Break visitBreak(J.Break break_, SenderContext ctx) {
            ctx.sendValue((Object)break_, J.Break::getId);
            ctx.sendNode((Object)break_, J.Break::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)break_, J.Break::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)break_, J.Break::getLabel, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return break_;
        }

        public J.Case visitCase(J.Case case_, SenderContext ctx) {
            ctx.sendValue((Object)case_, J.Case::getId);
            ctx.sendNode((Object)case_, J.Case::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)case_, J.Case::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendValue((Object)case_, J.Case::getType);
            ctx.sendNode((Object)case_, e -> e.getPadding().getCaseLabels(), (x$0, x$1) -> CSharpSender.sendContainer(x$0, x$1));
            ctx.sendNode((Object)case_, e -> e.getPadding().getStatements(), (x$0, x$1) -> CSharpSender.sendContainer(x$0, x$1));
            ctx.sendNode((Object)case_, e -> e.getPadding().getBody(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            ctx.sendNode((Object)case_, J.Case::getGuard, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return case_;
        }

        public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDeclaration, SenderContext ctx) {
            ctx.sendValue((Object)classDeclaration, J.ClassDeclaration::getId);
            ctx.sendNode((Object)classDeclaration, J.ClassDeclaration::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)classDeclaration, J.ClassDeclaration::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNodes((Object)classDeclaration, J.ClassDeclaration::getLeadingAnnotations, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1), Tree::getId);
            ctx.sendNodes((Object)classDeclaration, J.ClassDeclaration::getModifiers, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1), Tree::getId);
            ctx.sendNode((Object)classDeclaration, e -> e.getPadding().getKind(), this::sendClassDeclarationKind);
            ctx.sendNode((Object)classDeclaration, J.ClassDeclaration::getName, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)classDeclaration, e -> e.getPadding().getTypeParameters(), (x$0, x$1) -> CSharpSender.sendContainer(x$0, x$1));
            ctx.sendNode((Object)classDeclaration, e -> e.getPadding().getPrimaryConstructor(), (x$0, x$1) -> CSharpSender.sendContainer(x$0, x$1));
            ctx.sendNode((Object)classDeclaration, e -> e.getPadding().getExtends(), (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            ctx.sendNode((Object)classDeclaration, e -> e.getPadding().getImplements(), (x$0, x$1) -> CSharpSender.sendContainer(x$0, x$1));
            ctx.sendNode((Object)classDeclaration, e -> e.getPadding().getPermits(), (x$0, x$1) -> CSharpSender.sendContainer(x$0, x$1));
            ctx.sendNode((Object)classDeclaration, J.ClassDeclaration::getBody, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendTypedValue((Object)classDeclaration, J.ClassDeclaration::getType);
            return classDeclaration;
        }

        private void sendClassDeclarationKind(J.ClassDeclaration.Kind kind, SenderContext ctx) {
            ctx.sendValue((Object)kind, J.ClassDeclaration.Kind::getId);
            ctx.sendNode((Object)kind, J.ClassDeclaration.Kind::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)kind, J.ClassDeclaration.Kind::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNodes((Object)kind, J.ClassDeclaration.Kind::getAnnotations, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1), Tree::getId);
            ctx.sendValue((Object)kind, J.ClassDeclaration.Kind::getType);
        }

        public J.Continue visitContinue(J.Continue continue_, SenderContext ctx) {
            ctx.sendValue((Object)continue_, J.Continue::getId);
            ctx.sendNode((Object)continue_, J.Continue::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)continue_, J.Continue::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)continue_, J.Continue::getLabel, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return continue_;
        }

        public J.DoWhileLoop visitDoWhileLoop(J.DoWhileLoop doWhileLoop, SenderContext ctx) {
            ctx.sendValue((Object)doWhileLoop, J.DoWhileLoop::getId);
            ctx.sendNode((Object)doWhileLoop, J.DoWhileLoop::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)doWhileLoop, J.DoWhileLoop::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)doWhileLoop, e -> e.getPadding().getBody(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            ctx.sendNode((Object)doWhileLoop, e -> e.getPadding().getWhileCondition(), (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            return doWhileLoop;
        }

        public J.Empty visitEmpty(J.Empty empty, SenderContext ctx) {
            ctx.sendValue((Object)empty, J.Empty::getId);
            ctx.sendNode((Object)empty, J.Empty::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)empty, J.Empty::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            return empty;
        }

        public J.EnumValue visitEnumValue(J.EnumValue enumValue, SenderContext ctx) {
            ctx.sendValue((Object)enumValue, J.EnumValue::getId);
            ctx.sendNode((Object)enumValue, J.EnumValue::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)enumValue, J.EnumValue::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNodes((Object)enumValue, J.EnumValue::getAnnotations, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1), Tree::getId);
            ctx.sendNode((Object)enumValue, J.EnumValue::getName, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)enumValue, J.EnumValue::getInitializer, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return enumValue;
        }

        public J.EnumValueSet visitEnumValueSet(J.EnumValueSet enumValueSet, SenderContext ctx) {
            ctx.sendValue((Object)enumValueSet, J.EnumValueSet::getId);
            ctx.sendNode((Object)enumValueSet, J.EnumValueSet::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)enumValueSet, J.EnumValueSet::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNodes((Object)enumValueSet, e -> e.getPadding().getEnums(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1), e -> ((J.EnumValue)e.getElement()).getId());
            ctx.sendValue((Object)enumValueSet, J.EnumValueSet::isTerminatedWithSemicolon);
            return enumValueSet;
        }

        public J.FieldAccess visitFieldAccess(J.FieldAccess fieldAccess, SenderContext ctx) {
            ctx.sendValue((Object)fieldAccess, J.FieldAccess::getId);
            ctx.sendNode((Object)fieldAccess, J.FieldAccess::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)fieldAccess, J.FieldAccess::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)fieldAccess, J.FieldAccess::getTarget, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)fieldAccess, e -> e.getPadding().getName(), (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            ctx.sendTypedValue((Object)fieldAccess, J.FieldAccess::getType);
            return fieldAccess;
        }

        public J.ForEachLoop visitForEachLoop(J.ForEachLoop forEachLoop, SenderContext ctx) {
            ctx.sendValue((Object)forEachLoop, J.ForEachLoop::getId);
            ctx.sendNode((Object)forEachLoop, J.ForEachLoop::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)forEachLoop, J.ForEachLoop::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)forEachLoop, J.ForEachLoop::getControl, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)forEachLoop, e -> e.getPadding().getBody(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            return forEachLoop;
        }

        public J.ForEachLoop.Control visitForEachControl(J.ForEachLoop.Control control, SenderContext ctx) {
            ctx.sendValue((Object)control, J.ForEachLoop.Control::getId);
            ctx.sendNode((Object)control, J.ForEachLoop.Control::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)control, J.ForEachLoop.Control::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)control, e -> e.getPadding().getVariable(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            ctx.sendNode((Object)control, e -> e.getPadding().getIterable(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            return control;
        }

        public J.ForLoop visitForLoop(J.ForLoop forLoop, SenderContext ctx) {
            ctx.sendValue((Object)forLoop, J.ForLoop::getId);
            ctx.sendNode((Object)forLoop, J.ForLoop::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)forLoop, J.ForLoop::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)forLoop, J.ForLoop::getControl, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)forLoop, e -> e.getPadding().getBody(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            return forLoop;
        }

        public J.ForLoop.Control visitForControl(J.ForLoop.Control control, SenderContext ctx) {
            ctx.sendValue((Object)control, J.ForLoop.Control::getId);
            ctx.sendNode((Object)control, J.ForLoop.Control::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)control, J.ForLoop.Control::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNodes((Object)control, e -> e.getPadding().getInit(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1), e -> ((Statement)e.getElement()).getId());
            ctx.sendNode((Object)control, e -> e.getPadding().getCondition(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            ctx.sendNodes((Object)control, e -> e.getPadding().getUpdate(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1), e -> ((Statement)e.getElement()).getId());
            return control;
        }

        public J.ParenthesizedTypeTree visitParenthesizedTypeTree(J.ParenthesizedTypeTree parenthesizedTypeTree, SenderContext ctx) {
            ctx.sendValue((Object)parenthesizedTypeTree, J.ParenthesizedTypeTree::getId);
            ctx.sendNode((Object)parenthesizedTypeTree, J.ParenthesizedTypeTree::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)parenthesizedTypeTree, J.ParenthesizedTypeTree::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNodes((Object)parenthesizedTypeTree, J.ParenthesizedTypeTree::getAnnotations, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1), Tree::getId);
            ctx.sendNode((Object)parenthesizedTypeTree, J.ParenthesizedTypeTree::getParenthesizedType, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return parenthesizedTypeTree;
        }

        public J.Identifier visitIdentifier(J.Identifier identifier, SenderContext ctx) {
            ctx.sendValue((Object)identifier, J.Identifier::getId);
            ctx.sendNode((Object)identifier, J.Identifier::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)identifier, J.Identifier::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNodes((Object)identifier, J.Identifier::getAnnotations, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1), Tree::getId);
            ctx.sendValue((Object)identifier, J.Identifier::getSimpleName);
            ctx.sendTypedValue((Object)identifier, J.Identifier::getType);
            ctx.sendTypedValue((Object)identifier, J.Identifier::getFieldType);
            return identifier;
        }

        public J.If visitIf(J.If if_, SenderContext ctx) {
            ctx.sendValue((Object)if_, J.If::getId);
            ctx.sendNode((Object)if_, J.If::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)if_, J.If::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)if_, J.If::getIfCondition, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)if_, e -> e.getPadding().getThenPart(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            ctx.sendNode((Object)if_, J.If::getElsePart, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return if_;
        }

        public J.If.Else visitElse(J.If.Else else_, SenderContext ctx) {
            ctx.sendValue((Object)else_, J.If.Else::getId);
            ctx.sendNode((Object)else_, J.If.Else::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)else_, J.If.Else::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)else_, e -> e.getPadding().getBody(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            return else_;
        }

        public J.Import visitImport(J.Import import_, SenderContext ctx) {
            ctx.sendValue((Object)import_, J.Import::getId);
            ctx.sendNode((Object)import_, J.Import::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)import_, J.Import::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)import_, e -> e.getPadding().getStatic(), (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            ctx.sendNode((Object)import_, J.Import::getQualid, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)import_, e -> e.getPadding().getAlias(), (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            return import_;
        }

        public J.InstanceOf visitInstanceOf(J.InstanceOf instanceOf, SenderContext ctx) {
            ctx.sendValue((Object)instanceOf, J.InstanceOf::getId);
            ctx.sendNode((Object)instanceOf, J.InstanceOf::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)instanceOf, J.InstanceOf::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)instanceOf, e -> e.getPadding().getExpression(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            ctx.sendNode((Object)instanceOf, J.InstanceOf::getClazz, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)instanceOf, J.InstanceOf::getPattern, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendTypedValue((Object)instanceOf, J.InstanceOf::getType);
            return instanceOf;
        }

        public J.DeconstructionPattern visitDeconstructionPattern(J.DeconstructionPattern deconstructionPattern, SenderContext ctx) {
            ctx.sendValue((Object)deconstructionPattern, J.DeconstructionPattern::getId);
            ctx.sendNode((Object)deconstructionPattern, J.DeconstructionPattern::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)deconstructionPattern, J.DeconstructionPattern::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)deconstructionPattern, J.DeconstructionPattern::getDeconstructor, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)deconstructionPattern, e -> e.getPadding().getNested(), (x$0, x$1) -> CSharpSender.sendContainer(x$0, x$1));
            ctx.sendTypedValue((Object)deconstructionPattern, J.DeconstructionPattern::getType);
            return deconstructionPattern;
        }

        public J.IntersectionType visitIntersectionType(J.IntersectionType intersectionType, SenderContext ctx) {
            ctx.sendValue((Object)intersectionType, J.IntersectionType::getId);
            ctx.sendNode((Object)intersectionType, J.IntersectionType::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)intersectionType, J.IntersectionType::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)intersectionType, e -> e.getPadding().getBounds(), (x$0, x$1) -> CSharpSender.sendContainer(x$0, x$1));
            return intersectionType;
        }

        public J.Label visitLabel(J.Label label, SenderContext ctx) {
            ctx.sendValue((Object)label, J.Label::getId);
            ctx.sendNode((Object)label, J.Label::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)label, J.Label::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)label, e -> e.getPadding().getLabel(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            ctx.sendNode((Object)label, J.Label::getStatement, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return label;
        }

        public J.Lambda visitLambda(J.Lambda lambda, SenderContext ctx) {
            ctx.sendValue((Object)lambda, J.Lambda::getId);
            ctx.sendNode((Object)lambda, J.Lambda::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)lambda, J.Lambda::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)lambda, J.Lambda::getParameters, this::sendLambdaParameters);
            ctx.sendNode((Object)lambda, J.Lambda::getArrow, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)lambda, J.Lambda::getBody, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendTypedValue((Object)lambda, J.Lambda::getType);
            return lambda;
        }

        private void sendLambdaParameters(J.Lambda.Parameters parameters, SenderContext ctx) {
            ctx.sendValue((Object)parameters, J.Lambda.Parameters::getId);
            ctx.sendNode((Object)parameters, J.Lambda.Parameters::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)parameters, J.Lambda.Parameters::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendValue((Object)parameters, J.Lambda.Parameters::isParenthesized);
            ctx.sendNodes((Object)parameters, e -> e.getPadding().getParameters(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1), e -> ((J)e.getElement()).getId());
        }

        public J.Literal visitLiteral(J.Literal literal, SenderContext ctx) {
            ctx.sendValue((Object)literal, J.Literal::getId);
            ctx.sendNode((Object)literal, J.Literal::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)literal, J.Literal::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendTypedValue((Object)literal, J.Literal::getValue);
            ctx.sendValue((Object)literal, J.Literal::getValueSource);
            ctx.sendValues((Object)literal, J.Literal::getUnicodeEscapes, Function.identity());
            ctx.sendValue((Object)literal, J.Literal::getType);
            return literal;
        }

        public J.MemberReference visitMemberReference(J.MemberReference memberReference, SenderContext ctx) {
            ctx.sendValue((Object)memberReference, J.MemberReference::getId);
            ctx.sendNode((Object)memberReference, J.MemberReference::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)memberReference, J.MemberReference::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)memberReference, e -> e.getPadding().getContaining(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            ctx.sendNode((Object)memberReference, e -> e.getPadding().getTypeParameters(), (x$0, x$1) -> CSharpSender.sendContainer(x$0, x$1));
            ctx.sendNode((Object)memberReference, e -> e.getPadding().getReference(), (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            ctx.sendTypedValue((Object)memberReference, J.MemberReference::getType);
            ctx.sendTypedValue((Object)memberReference, J.MemberReference::getMethodType);
            ctx.sendTypedValue((Object)memberReference, J.MemberReference::getVariableType);
            return memberReference;
        }

        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration methodDeclaration, SenderContext ctx) {
            ctx.sendValue((Object)methodDeclaration, J.MethodDeclaration::getId);
            ctx.sendNode((Object)methodDeclaration, J.MethodDeclaration::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)methodDeclaration, J.MethodDeclaration::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNodes((Object)methodDeclaration, J.MethodDeclaration::getLeadingAnnotations, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1), Tree::getId);
            ctx.sendNodes((Object)methodDeclaration, J.MethodDeclaration::getModifiers, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1), Tree::getId);
            ctx.sendNode((Object)methodDeclaration, e -> e.getAnnotations().getTypeParameters(), this::sendMethodTypeParameters);
            ctx.sendNode((Object)methodDeclaration, J.MethodDeclaration::getReturnTypeExpression, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)methodDeclaration, e -> e.getAnnotations().getName(), this::sendMethodIdentifierWithAnnotations);
            ctx.sendNode((Object)methodDeclaration, e -> e.getPadding().getParameters(), (x$0, x$1) -> CSharpSender.sendContainer(x$0, x$1));
            ctx.sendNode((Object)methodDeclaration, e -> e.getPadding().getThrows(), (x$0, x$1) -> CSharpSender.sendContainer(x$0, x$1));
            ctx.sendNode((Object)methodDeclaration, J.MethodDeclaration::getBody, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)methodDeclaration, e -> e.getPadding().getDefaultValue(), (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            ctx.sendTypedValue((Object)methodDeclaration, J.MethodDeclaration::getMethodType);
            return methodDeclaration;
        }

        private void sendMethodIdentifierWithAnnotations(J.MethodDeclaration.IdentifierWithAnnotations identifierWithAnnotations, SenderContext ctx) {
            ctx.sendNode((Object)identifierWithAnnotations, J.MethodDeclaration.IdentifierWithAnnotations::getIdentifier, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNodes((Object)identifierWithAnnotations, J.MethodDeclaration.IdentifierWithAnnotations::getAnnotations, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1), Tree::getId);
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation methodInvocation, SenderContext ctx) {
            ctx.sendValue((Object)methodInvocation, J.MethodInvocation::getId);
            ctx.sendNode((Object)methodInvocation, J.MethodInvocation::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)methodInvocation, J.MethodInvocation::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)methodInvocation, e -> e.getPadding().getSelect(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            ctx.sendNode((Object)methodInvocation, e -> e.getPadding().getTypeParameters(), (x$0, x$1) -> CSharpSender.sendContainer(x$0, x$1));
            ctx.sendNode((Object)methodInvocation, J.MethodInvocation::getName, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)methodInvocation, e -> e.getPadding().getArguments(), (x$0, x$1) -> CSharpSender.sendContainer(x$0, x$1));
            ctx.sendTypedValue((Object)methodInvocation, J.MethodInvocation::getMethodType);
            return methodInvocation;
        }

        public J.Modifier visitModifier(J.Modifier modifier, SenderContext ctx) {
            ctx.sendValue((Object)modifier, J.Modifier::getId);
            ctx.sendNode((Object)modifier, J.Modifier::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)modifier, J.Modifier::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendValue((Object)modifier, J.Modifier::getKeyword);
            ctx.sendValue((Object)modifier, J.Modifier::getType);
            ctx.sendNodes((Object)modifier, J.Modifier::getAnnotations, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1), Tree::getId);
            return modifier;
        }

        public J.MultiCatch visitMultiCatch(J.MultiCatch multiCatch, SenderContext ctx) {
            ctx.sendValue((Object)multiCatch, J.MultiCatch::getId);
            ctx.sendNode((Object)multiCatch, J.MultiCatch::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)multiCatch, J.MultiCatch::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNodes((Object)multiCatch, e -> e.getPadding().getAlternatives(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1), e -> ((NameTree)e.getElement()).getId());
            return multiCatch;
        }

        public J.NewArray visitNewArray(J.NewArray newArray, SenderContext ctx) {
            ctx.sendValue((Object)newArray, J.NewArray::getId);
            ctx.sendNode((Object)newArray, J.NewArray::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)newArray, J.NewArray::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)newArray, J.NewArray::getTypeExpression, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNodes((Object)newArray, J.NewArray::getDimensions, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1), Tree::getId);
            ctx.sendNode((Object)newArray, e -> e.getPadding().getInitializer(), (x$0, x$1) -> CSharpSender.sendContainer(x$0, x$1));
            ctx.sendTypedValue((Object)newArray, J.NewArray::getType);
            return newArray;
        }

        public J.ArrayDimension visitArrayDimension(J.ArrayDimension arrayDimension, SenderContext ctx) {
            ctx.sendValue((Object)arrayDimension, J.ArrayDimension::getId);
            ctx.sendNode((Object)arrayDimension, J.ArrayDimension::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)arrayDimension, J.ArrayDimension::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)arrayDimension, e -> e.getPadding().getIndex(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            return arrayDimension;
        }

        public J.NewClass visitNewClass(J.NewClass newClass, SenderContext ctx) {
            ctx.sendValue((Object)newClass, J.NewClass::getId);
            ctx.sendNode((Object)newClass, J.NewClass::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)newClass, J.NewClass::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)newClass, e -> e.getPadding().getEnclosing(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            ctx.sendNode((Object)newClass, J.NewClass::getNew, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)newClass, J.NewClass::getClazz, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)newClass, e -> e.getPadding().getArguments(), (x$0, x$1) -> CSharpSender.sendContainer(x$0, x$1));
            ctx.sendNode((Object)newClass, J.NewClass::getBody, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendTypedValue((Object)newClass, J.NewClass::getConstructorType);
            return newClass;
        }

        public J.NullableType visitNullableType(J.NullableType nullableType, SenderContext ctx) {
            ctx.sendValue((Object)nullableType, J.NullableType::getId);
            ctx.sendNode((Object)nullableType, J.NullableType::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)nullableType, J.NullableType::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNodes((Object)nullableType, J.NullableType::getAnnotations, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1), Tree::getId);
            ctx.sendNode((Object)nullableType, e -> e.getPadding().getTypeTree(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            return nullableType;
        }

        public J.Package visitPackage(J.Package package_, SenderContext ctx) {
            ctx.sendValue((Object)package_, J.Package::getId);
            ctx.sendNode((Object)package_, J.Package::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)package_, J.Package::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)package_, J.Package::getExpression, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNodes((Object)package_, J.Package::getAnnotations, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1), Tree::getId);
            return package_;
        }

        public J.ParameterizedType visitParameterizedType(J.ParameterizedType parameterizedType, SenderContext ctx) {
            ctx.sendValue((Object)parameterizedType, J.ParameterizedType::getId);
            ctx.sendNode((Object)parameterizedType, J.ParameterizedType::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)parameterizedType, J.ParameterizedType::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)parameterizedType, J.ParameterizedType::getClazz, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)parameterizedType, e -> e.getPadding().getTypeParameters(), (x$0, x$1) -> CSharpSender.sendContainer(x$0, x$1));
            ctx.sendTypedValue((Object)parameterizedType, J.ParameterizedType::getType);
            return parameterizedType;
        }

        public <J2 extends J> J.Parentheses<J2> visitParentheses(J.Parentheses<J2> parentheses, SenderContext ctx) {
            ctx.sendValue(parentheses, J.Parentheses::getId);
            ctx.sendNode(parentheses, J.Parentheses::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(parentheses, J.Parentheses::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode(parentheses, e -> e.getPadding().getTree(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            return parentheses;
        }

        public <J2 extends J> J.ControlParentheses<J2> visitControlParentheses(J.ControlParentheses<J2> controlParentheses, SenderContext ctx) {
            ctx.sendValue(controlParentheses, J.ControlParentheses::getId);
            ctx.sendNode(controlParentheses, J.ControlParentheses::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode(controlParentheses, J.ControlParentheses::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode(controlParentheses, e -> e.getPadding().getTree(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            return controlParentheses;
        }

        public J.Primitive visitPrimitive(J.Primitive primitive, SenderContext ctx) {
            ctx.sendValue((Object)primitive, J.Primitive::getId);
            ctx.sendNode((Object)primitive, J.Primitive::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)primitive, J.Primitive::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendValue((Object)primitive, J.Primitive::getType);
            return primitive;
        }

        public J.Return visitReturn(J.Return return_, SenderContext ctx) {
            ctx.sendValue((Object)return_, J.Return::getId);
            ctx.sendNode((Object)return_, J.Return::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)return_, J.Return::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)return_, J.Return::getExpression, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return return_;
        }

        public J.Switch visitSwitch(J.Switch switch_, SenderContext ctx) {
            ctx.sendValue((Object)switch_, J.Switch::getId);
            ctx.sendNode((Object)switch_, J.Switch::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)switch_, J.Switch::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)switch_, J.Switch::getSelector, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)switch_, J.Switch::getCases, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return switch_;
        }

        public J.SwitchExpression visitSwitchExpression(J.SwitchExpression switchExpression, SenderContext ctx) {
            ctx.sendValue((Object)switchExpression, J.SwitchExpression::getId);
            ctx.sendNode((Object)switchExpression, J.SwitchExpression::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)switchExpression, J.SwitchExpression::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)switchExpression, J.SwitchExpression::getSelector, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)switchExpression, J.SwitchExpression::getCases, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendTypedValue((Object)switchExpression, J.SwitchExpression::getType);
            return switchExpression;
        }

        public J.Synchronized visitSynchronized(J.Synchronized synchronized_, SenderContext ctx) {
            ctx.sendValue((Object)synchronized_, J.Synchronized::getId);
            ctx.sendNode((Object)synchronized_, J.Synchronized::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)synchronized_, J.Synchronized::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)synchronized_, J.Synchronized::getLock, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)synchronized_, J.Synchronized::getBody, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return synchronized_;
        }

        public J.Ternary visitTernary(J.Ternary ternary, SenderContext ctx) {
            ctx.sendValue((Object)ternary, J.Ternary::getId);
            ctx.sendNode((Object)ternary, J.Ternary::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)ternary, J.Ternary::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)ternary, J.Ternary::getCondition, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)ternary, e -> e.getPadding().getTruePart(), (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            ctx.sendNode((Object)ternary, e -> e.getPadding().getFalsePart(), (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            ctx.sendTypedValue((Object)ternary, J.Ternary::getType);
            return ternary;
        }

        public J.Throw visitThrow(J.Throw throw_, SenderContext ctx) {
            ctx.sendValue((Object)throw_, J.Throw::getId);
            ctx.sendNode((Object)throw_, J.Throw::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)throw_, J.Throw::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)throw_, J.Throw::getException, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return throw_;
        }

        public J.Try visitTry(J.Try try_, SenderContext ctx) {
            ctx.sendValue((Object)try_, J.Try::getId);
            ctx.sendNode((Object)try_, J.Try::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)try_, J.Try::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)try_, e -> e.getPadding().getResources(), (x$0, x$1) -> CSharpSender.sendContainer(x$0, x$1));
            ctx.sendNode((Object)try_, J.Try::getBody, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNodes((Object)try_, J.Try::getCatches, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1), Tree::getId);
            ctx.sendNode((Object)try_, e -> e.getPadding().getFinally(), (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            return try_;
        }

        public J.Try.Resource visitTryResource(J.Try.Resource resource, SenderContext ctx) {
            ctx.sendValue((Object)resource, J.Try.Resource::getId);
            ctx.sendNode((Object)resource, J.Try.Resource::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)resource, J.Try.Resource::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)resource, J.Try.Resource::getVariableDeclarations, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendValue((Object)resource, J.Try.Resource::isTerminatedWithSemicolon);
            return resource;
        }

        public J.Try.Catch visitCatch(J.Try.Catch catch_, SenderContext ctx) {
            ctx.sendValue((Object)catch_, J.Try.Catch::getId);
            ctx.sendNode((Object)catch_, J.Try.Catch::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)catch_, J.Try.Catch::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)catch_, J.Try.Catch::getParameter, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)catch_, J.Try.Catch::getBody, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return catch_;
        }

        public J.TypeCast visitTypeCast(J.TypeCast typeCast, SenderContext ctx) {
            ctx.sendValue((Object)typeCast, J.TypeCast::getId);
            ctx.sendNode((Object)typeCast, J.TypeCast::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)typeCast, J.TypeCast::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)typeCast, J.TypeCast::getClazz, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)typeCast, J.TypeCast::getExpression, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return typeCast;
        }

        public J.TypeParameter visitTypeParameter(J.TypeParameter typeParameter, SenderContext ctx) {
            ctx.sendValue((Object)typeParameter, J.TypeParameter::getId);
            ctx.sendNode((Object)typeParameter, J.TypeParameter::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)typeParameter, J.TypeParameter::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNodes((Object)typeParameter, J.TypeParameter::getAnnotations, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1), Tree::getId);
            ctx.sendNodes((Object)typeParameter, J.TypeParameter::getModifiers, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1), Tree::getId);
            ctx.sendNode((Object)typeParameter, J.TypeParameter::getName, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)typeParameter, e -> e.getPadding().getBounds(), (x$0, x$1) -> CSharpSender.sendContainer(x$0, x$1));
            return typeParameter;
        }

        private void sendMethodTypeParameters(J.TypeParameters typeParameters, SenderContext ctx) {
            ctx.sendValue((Object)typeParameters, J.TypeParameters::getId);
            ctx.sendNode((Object)typeParameters, J.TypeParameters::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)typeParameters, J.TypeParameters::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNodes((Object)typeParameters, J.TypeParameters::getAnnotations, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1), Tree::getId);
            ctx.sendNodes((Object)typeParameters, e -> e.getPadding().getTypeParameters(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1), e -> ((J.TypeParameter)e.getElement()).getId());
        }

        public J.Unary visitUnary(J.Unary unary, SenderContext ctx) {
            ctx.sendValue((Object)unary, J.Unary::getId);
            ctx.sendNode((Object)unary, J.Unary::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)unary, J.Unary::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)unary, e -> e.getPadding().getOperator(), (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            ctx.sendNode((Object)unary, J.Unary::getExpression, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendTypedValue((Object)unary, J.Unary::getType);
            return unary;
        }

        public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations variableDeclarations, SenderContext ctx) {
            ctx.sendValue((Object)variableDeclarations, J.VariableDeclarations::getId);
            ctx.sendNode((Object)variableDeclarations, J.VariableDeclarations::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)variableDeclarations, J.VariableDeclarations::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNodes((Object)variableDeclarations, J.VariableDeclarations::getLeadingAnnotations, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1), Tree::getId);
            ctx.sendNodes((Object)variableDeclarations, J.VariableDeclarations::getModifiers, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1), Tree::getId);
            ctx.sendNode((Object)variableDeclarations, J.VariableDeclarations::getTypeExpression, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)variableDeclarations, J.VariableDeclarations::getVarargs, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNodes((Object)variableDeclarations, J.VariableDeclarations::getDimensionsBeforeName, (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1), Function.identity());
            ctx.sendNodes((Object)variableDeclarations, e -> e.getPadding().getVariables(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1), e -> ((J.VariableDeclarations.NamedVariable)e.getElement()).getId());
            return variableDeclarations;
        }

        public J.VariableDeclarations.NamedVariable visitVariable(J.VariableDeclarations.NamedVariable namedVariable, SenderContext ctx) {
            ctx.sendValue((Object)namedVariable, J.VariableDeclarations.NamedVariable::getId);
            ctx.sendNode((Object)namedVariable, J.VariableDeclarations.NamedVariable::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)namedVariable, J.VariableDeclarations.NamedVariable::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)namedVariable, J.VariableDeclarations.NamedVariable::getName, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNodes((Object)namedVariable, J.VariableDeclarations.NamedVariable::getDimensionsAfterName, (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1), Function.identity());
            ctx.sendNode((Object)namedVariable, e -> e.getPadding().getInitializer(), (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            ctx.sendTypedValue((Object)namedVariable, J.VariableDeclarations.NamedVariable::getVariableType);
            return namedVariable;
        }

        public J.WhileLoop visitWhileLoop(J.WhileLoop whileLoop, SenderContext ctx) {
            ctx.sendValue((Object)whileLoop, J.WhileLoop::getId);
            ctx.sendNode((Object)whileLoop, J.WhileLoop::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)whileLoop, J.WhileLoop::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)whileLoop, J.WhileLoop::getCondition, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            ctx.sendNode((Object)whileLoop, e -> e.getPadding().getBody(), (x$0, x$1) -> CSharpSender.sendRightPadded(x$0, x$1));
            return whileLoop;
        }

        public J.Wildcard visitWildcard(J.Wildcard wildcard, SenderContext ctx) {
            ctx.sendValue((Object)wildcard, J.Wildcard::getId);
            ctx.sendNode((Object)wildcard, J.Wildcard::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)wildcard, J.Wildcard::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)wildcard, e -> e.getPadding().getBound(), (x$0, x$1) -> CSharpSender.sendLeftPadded(x$0, x$1));
            ctx.sendNode((Object)wildcard, J.Wildcard::getBoundedType, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return wildcard;
        }

        public J.Yield visitYield(J.Yield yield, SenderContext ctx) {
            ctx.sendValue((Object)yield, J.Yield::getId);
            ctx.sendNode((Object)yield, J.Yield::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)yield, J.Yield::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendValue((Object)yield, J.Yield::isImplicit);
            ctx.sendNode((Object)yield, J.Yield::getValue, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return yield;
        }

        public J.Unknown visitUnknown(J.Unknown unknown, SenderContext ctx) {
            ctx.sendValue((Object)unknown, J.Unknown::getId);
            ctx.sendNode((Object)unknown, J.Unknown::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)unknown, J.Unknown::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendNode((Object)unknown, J.Unknown::getSource, (arg_0, arg_1) -> ((SenderContext)ctx).sendTree(arg_0, arg_1));
            return unknown;
        }

        public J.Unknown.Source visitUnknownSource(J.Unknown.Source source, SenderContext ctx) {
            ctx.sendValue((Object)source, J.Unknown.Source::getId);
            ctx.sendNode((Object)source, J.Unknown.Source::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)source, J.Unknown.Source::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendValue((Object)source, J.Unknown.Source::getText);
            return source;
        }

        public J.Erroneous visitErroneous(J.Erroneous erroneous, SenderContext ctx) {
            ctx.sendValue((Object)erroneous, J.Erroneous::getId);
            ctx.sendNode((Object)erroneous, J.Erroneous::getPrefix, (x$0, x$1) -> CSharpSender.sendSpace(x$0, x$1));
            ctx.sendNode((Object)erroneous, J.Erroneous::getMarkers, (arg_0, arg_1) -> ((SenderContext)ctx).sendMarkers(arg_0, arg_1));
            ctx.sendValue((Object)erroneous, J.Erroneous::getText);
            return erroneous;
        }
    }
}

