/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.shaded.jgit.patch;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openrewrite.shaded.jgit.diff.DiffEntry;
import org.openrewrite.shaded.jgit.diff.EditList;
import org.openrewrite.shaded.jgit.internal.JGitText;
import org.openrewrite.shaded.jgit.lib.AbbreviatedObjectId;
import org.openrewrite.shaded.jgit.lib.Constants;
import org.openrewrite.shaded.jgit.lib.FileMode;
import org.openrewrite.shaded.jgit.patch.BinaryHunk;
import org.openrewrite.shaded.jgit.patch.HunkHeader;
import org.openrewrite.shaded.jgit.patch.Patch;
import org.openrewrite.shaded.jgit.util.QuotedString;
import org.openrewrite.shaded.jgit.util.RawParseUtils;
import org.openrewrite.shaded.jgit.util.TemporaryBuffer;

public class FileHeader
extends DiffEntry {
    private static final byte[] OLD_MODE = Constants.encodeASCII("old mode ");
    private static final byte[] NEW_MODE = Constants.encodeASCII("new mode ");
    static final byte[] DELETED_FILE_MODE = Constants.encodeASCII("deleted file mode ");
    static final byte[] NEW_FILE_MODE = Constants.encodeASCII("new file mode ");
    private static final byte[] COPY_FROM = Constants.encodeASCII("copy from ");
    private static final byte[] COPY_TO = Constants.encodeASCII("copy to ");
    private static final byte[] RENAME_OLD = Constants.encodeASCII("rename old ");
    private static final byte[] RENAME_NEW = Constants.encodeASCII("rename new ");
    private static final byte[] RENAME_FROM = Constants.encodeASCII("rename from ");
    private static final byte[] RENAME_TO = Constants.encodeASCII("rename to ");
    private static final byte[] SIMILARITY_INDEX = Constants.encodeASCII("similarity index ");
    private static final byte[] DISSIMILARITY_INDEX = Constants.encodeASCII("dissimilarity index ");
    static final byte[] INDEX = Constants.encodeASCII("index ");
    static final byte[] OLD_NAME = Constants.encodeASCII("--- ");
    static final byte[] NEW_NAME = Constants.encodeASCII("+++ ");
    final byte[] buf;
    final int startOffset;
    int endOffset;
    PatchType patchType;
    private List<HunkHeader> hunks;
    BinaryHunk forwardBinaryHunk;
    BinaryHunk reverseBinaryHunk;

    public FileHeader(byte[] headerLines, EditList edits, PatchType type) {
        this(headerLines, 0);
        this.endOffset = headerLines.length;
        int ptr = this.parseGitFileName(Patch.DIFF_GIT.length, headerLines.length);
        this.parseGitHeaders(ptr, headerLines.length);
        this.patchType = type;
        this.addHunk(new HunkHeader(this, edits));
    }

    FileHeader(byte[] b, int offset) {
        this.buf = b;
        this.startOffset = offset;
        this.changeType = DiffEntry.ChangeType.MODIFY;
        this.patchType = PatchType.UNIFIED;
    }

    int getParentCount() {
        return 1;
    }

    public byte[] getBuffer() {
        return this.buf;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public String getScriptText() {
        return this.getScriptText(null, null);
    }

    public String getScriptText(Charset oldCharset, Charset newCharset) {
        return this.getScriptText(new Charset[]{oldCharset, newCharset});
    }

    String getScriptText(Charset[] charsetGuess) {
        if (this.getHunks().isEmpty()) {
            return RawParseUtils.extractBinaryString(this.buf, this.startOffset, this.endOffset);
        }
        if (charsetGuess != null && charsetGuess.length != this.getParentCount() + 1) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().expectedCharacterEncodingGuesses, this.getParentCount() + 1));
        }
        if (FileHeader.trySimpleConversion(charsetGuess)) {
            Charset cs;
            Charset charset = cs = charsetGuess != null ? charsetGuess[0] : null;
            if (cs == null) {
                cs = StandardCharsets.UTF_8;
            }
            try {
                return RawParseUtils.decodeNoFallback(cs, this.buf, this.startOffset, this.endOffset);
            }
            catch (CharacterCodingException characterCodingException) {
                // empty catch block
            }
        }
        StringBuilder r = new StringBuilder(this.endOffset - this.startOffset);
        int hdrEnd = this.getHunks().get(0).getStartOffset();
        int ptr = this.startOffset;
        while (ptr < hdrEnd) {
            int eol = Math.min(hdrEnd, RawParseUtils.nextLF(this.buf, ptr));
            r.append(RawParseUtils.extractBinaryString(this.buf, ptr, eol));
            ptr = eol;
        }
        String[] files = this.extractFileLines(charsetGuess);
        int[] offsets = new int[files.length];
        for (HunkHeader hunkHeader : this.getHunks()) {
            hunkHeader.extractFileLines(r, files, offsets);
        }
        return r.toString();
    }

    private static boolean trySimpleConversion(Charset[] charsetGuess) {
        if (charsetGuess == null) {
            return true;
        }
        int i = 1;
        while (i < charsetGuess.length) {
            if (charsetGuess[i] != charsetGuess[0]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private String[] extractFileLines(Charset[] csGuess) {
        OutputStream[] tmp = new TemporaryBuffer[this.getParentCount() + 1];
        try {
            void var3_4;
            boolean bl = false;
            while (var3_4 < tmp.length) {
                tmp[var3_4] = new TemporaryBuffer.Heap(Integer.MAX_VALUE);
                ++var3_4;
            }
            for (HunkHeader hunkHeader : this.getHunks()) {
                hunkHeader.extractFileLines(tmp);
            }
            String[] stringArray = new String[tmp.length];
            int i2 = 0;
            while (i2 < tmp.length) {
                Charset cs;
                Charset charset = cs = csGuess != null ? csGuess[i2] : null;
                if (cs == null) {
                    cs = StandardCharsets.UTF_8;
                }
                stringArray[i2] = RawParseUtils.decode(cs, ((TemporaryBuffer)tmp[i2]).toByteArray());
                ++i2;
            }
            return stringArray;
        }
        catch (IOException iOException) {
            throw new RuntimeException(JGitText.get().cannotConvertScriptToText, iOException);
        }
    }

    public PatchType getPatchType() {
        return this.patchType;
    }

    public boolean hasMetaDataChanges() {
        return this.changeType != DiffEntry.ChangeType.MODIFY || this.newMode != this.oldMode;
    }

    public List<? extends HunkHeader> getHunks() {
        if (this.hunks == null) {
            return Collections.emptyList();
        }
        return this.hunks;
    }

    void addHunk(HunkHeader h) {
        if (h.getFileHeader() != this) {
            throw new IllegalArgumentException(JGitText.get().hunkBelongsToAnotherFile);
        }
        if (this.hunks == null) {
            this.hunks = new ArrayList<HunkHeader>();
        }
        this.hunks.add(h);
    }

    HunkHeader newHunkHeader(int offset) {
        return new HunkHeader(this, offset);
    }

    public BinaryHunk getForwardBinaryHunk() {
        return this.forwardBinaryHunk;
    }

    public BinaryHunk getReverseBinaryHunk() {
        return this.reverseBinaryHunk;
    }

    public EditList toEditList() {
        EditList r = new EditList();
        for (HunkHeader hunk : this.hunks) {
            r.addAll(hunk.toEditList());
        }
        return r;
    }

    /*
     * Unable to fully structure code
     */
    int parseGitFileName(int ptr, int end) {
        eol = RawParseUtils.nextLF(this.buf, ptr);
        bol = ptr;
        if (eol >= end) {
            return -1;
        }
        aStart = RawParseUtils.nextLF(this.buf, ptr, '/');
        if (aStart < eol) ** GOTO lbl25
        return eol;
lbl-1000:
        // 1 sources

        {
            sp = RawParseUtils.nextLF(this.buf, ptr, ' ');
            if (sp >= eol) {
                return eol;
            }
            bStart = RawParseUtils.nextLF(this.buf, sp, '/');
            if (bStart >= eol) {
                return eol;
            }
            if (this.eq(aStart, sp - 1, bStart, eol - 1)) {
                if (this.buf[bol] == 34) {
                    if (this.buf[sp - 2] != 34) {
                        return eol;
                    }
                    this.oldPath = QuotedString.GIT_PATH.dequote(this.buf, bol, sp - 1);
                    this.oldPath = FileHeader.p1(this.oldPath);
                } else {
                    this.oldPath = RawParseUtils.decode(StandardCharsets.UTF_8, this.buf, aStart, sp - 1);
                }
                this.newPath = this.oldPath;
                return eol;
            }
            ptr = sp;
lbl25:
            // 2 sources

            ** while (ptr < eol)
        }
lbl26:
        // 1 sources

        return eol;
    }

    int parseGitHeaders(int ptr, int end) {
        while (ptr < end) {
            int eol = RawParseUtils.nextLF(this.buf, ptr);
            if (FileHeader.isHunkHdr(this.buf, ptr, eol) >= 1) break;
            if (RawParseUtils.match(this.buf, ptr, OLD_NAME) >= 0) {
                this.parseOldName(ptr, eol);
            } else if (RawParseUtils.match(this.buf, ptr, NEW_NAME) >= 0) {
                this.parseNewName(ptr, eol);
            } else if (RawParseUtils.match(this.buf, ptr, OLD_MODE) >= 0) {
                this.oldMode = this.parseFileMode(ptr + OLD_MODE.length, eol);
            } else if (RawParseUtils.match(this.buf, ptr, NEW_MODE) >= 0) {
                this.newMode = this.parseFileMode(ptr + NEW_MODE.length, eol);
            } else if (RawParseUtils.match(this.buf, ptr, DELETED_FILE_MODE) >= 0) {
                this.oldMode = this.parseFileMode(ptr + DELETED_FILE_MODE.length, eol);
                this.newMode = FileMode.MISSING;
                this.changeType = DiffEntry.ChangeType.DELETE;
            } else if (RawParseUtils.match(this.buf, ptr, NEW_FILE_MODE) >= 0) {
                this.parseNewFileMode(ptr, eol);
            } else if (RawParseUtils.match(this.buf, ptr, COPY_FROM) >= 0) {
                this.oldPath = this.parseName(this.oldPath, ptr + COPY_FROM.length, eol);
                this.changeType = DiffEntry.ChangeType.COPY;
            } else if (RawParseUtils.match(this.buf, ptr, COPY_TO) >= 0) {
                this.newPath = this.parseName(this.newPath, ptr + COPY_TO.length, eol);
                this.changeType = DiffEntry.ChangeType.COPY;
            } else if (RawParseUtils.match(this.buf, ptr, RENAME_OLD) >= 0) {
                this.oldPath = this.parseName(this.oldPath, ptr + RENAME_OLD.length, eol);
                this.changeType = DiffEntry.ChangeType.RENAME;
            } else if (RawParseUtils.match(this.buf, ptr, RENAME_NEW) >= 0) {
                this.newPath = this.parseName(this.newPath, ptr + RENAME_NEW.length, eol);
                this.changeType = DiffEntry.ChangeType.RENAME;
            } else if (RawParseUtils.match(this.buf, ptr, RENAME_FROM) >= 0) {
                this.oldPath = this.parseName(this.oldPath, ptr + RENAME_FROM.length, eol);
                this.changeType = DiffEntry.ChangeType.RENAME;
            } else if (RawParseUtils.match(this.buf, ptr, RENAME_TO) >= 0) {
                this.newPath = this.parseName(this.newPath, ptr + RENAME_TO.length, eol);
                this.changeType = DiffEntry.ChangeType.RENAME;
            } else if (RawParseUtils.match(this.buf, ptr, SIMILARITY_INDEX) >= 0) {
                this.score = RawParseUtils.parseBase10(this.buf, ptr + SIMILARITY_INDEX.length, null);
            } else if (RawParseUtils.match(this.buf, ptr, DISSIMILARITY_INDEX) >= 0) {
                this.score = RawParseUtils.parseBase10(this.buf, ptr + DISSIMILARITY_INDEX.length, null);
            } else {
                if (RawParseUtils.match(this.buf, ptr, INDEX) < 0) break;
                this.parseIndexLine(ptr + INDEX.length, eol);
            }
            ptr = eol;
        }
        return ptr;
    }

    void parseOldName(int ptr, int eol) {
        this.oldPath = FileHeader.p1(this.parseName(this.oldPath, ptr + OLD_NAME.length, eol));
        if (this.oldPath == "/dev/null") {
            this.changeType = DiffEntry.ChangeType.ADD;
        }
    }

    void parseNewName(int ptr, int eol) {
        this.newPath = FileHeader.p1(this.parseName(this.newPath, ptr + NEW_NAME.length, eol));
        if (this.newPath == "/dev/null") {
            this.changeType = DiffEntry.ChangeType.DELETE;
        }
    }

    void parseNewFileMode(int ptr, int eol) {
        this.oldMode = FileMode.MISSING;
        this.newMode = this.parseFileMode(ptr + NEW_FILE_MODE.length, eol);
        this.changeType = DiffEntry.ChangeType.ADD;
    }

    int parseTraditionalHeaders(int ptr, int end) {
        while (ptr < end) {
            int eol = RawParseUtils.nextLF(this.buf, ptr);
            if (FileHeader.isHunkHdr(this.buf, ptr, eol) >= 1) break;
            if (RawParseUtils.match(this.buf, ptr, OLD_NAME) >= 0) {
                this.parseOldName(ptr, eol);
            } else {
                if (RawParseUtils.match(this.buf, ptr, NEW_NAME) < 0) break;
                this.parseNewName(ptr, eol);
            }
            ptr = eol;
        }
        return ptr;
    }

    private String parseName(String expect, int ptr, int end) {
        String r;
        if (ptr == end) {
            return expect;
        }
        if (this.buf[ptr] == 34) {
            r = QuotedString.GIT_PATH.dequote(this.buf, ptr, end - 1);
        } else {
            int tab = end;
            while (ptr < tab && this.buf[tab - 1] != 9) {
                --tab;
            }
            if (ptr == tab) {
                tab = end;
            }
            r = RawParseUtils.decode(StandardCharsets.UTF_8, this.buf, ptr, tab - 1);
        }
        if (r.equals("/dev/null")) {
            r = "/dev/null";
        }
        return r;
    }

    private static String p1(String r) {
        int s = r.indexOf(47);
        return s > 0 ? r.substring(s + 1) : r;
    }

    FileMode parseFileMode(int ptr, int end) {
        int tmp = 0;
        while (ptr < end - 1) {
            tmp <<= 3;
            tmp += this.buf[ptr++] - 48;
        }
        return FileMode.fromBits(tmp);
    }

    void parseIndexLine(int ptr, int end) {
        int dot2 = RawParseUtils.nextLF(this.buf, ptr, '.');
        int mode = RawParseUtils.nextLF(this.buf, dot2, ' ');
        this.oldId = AbbreviatedObjectId.fromString(this.buf, ptr, dot2 - 1);
        this.newId = AbbreviatedObjectId.fromString(this.buf, dot2 + 1, mode - 1);
        if (mode < end) {
            this.newMode = this.oldMode = this.parseFileMode(mode, end);
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean eq(int aPtr, int aEnd, int bPtr, int bEnd) {
        if (aEnd - aPtr == bEnd - bPtr) ** GOTO lbl5
        return false;
lbl-1000:
        // 1 sources

        {
            if (this.buf[aPtr++] == this.buf[bPtr++]) continue;
            return false;
lbl5:
            // 2 sources

            ** while (aPtr < aEnd)
        }
lbl6:
        // 1 sources

        return true;
    }

    static int isHunkHdr(byte[] buf, int start, int end) {
        int ptr = start;
        while (ptr < end && buf[ptr] == 64) {
            ++ptr;
        }
        if (ptr - start < 2) {
            return 0;
        }
        if (ptr == end || buf[ptr++] != 32) {
            return 0;
        }
        if (ptr == end || buf[ptr++] != 45) {
            return 0;
        }
        return ptr - 3 - start;
    }

    public static enum PatchType {
        UNIFIED,
        BINARY,
        GIT_BINARY;

    }
}

