/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.binary;

import java.nio.file.Path;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.binary.Binary;
import org.openrewrite.internal.StreamUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.Markers;
import org.openrewrite.tree.ParseError;

public class BinaryParser
implements Parser {
    @Override
    public Stream<SourceFile> parseInputs(Iterable<Parser.Input> sources, @Nullable Path relativeTo, ExecutionContext ctx) {
        return StreamSupport.stream(sources.spliterator(), false).map(source -> {
            Path path = source.getRelativePath(relativeTo);
            try {
                return new Binary(Tree.randomId(), path, Markers.EMPTY, source.getFileAttributes(), null, StreamUtils.readAllBytes(source.getSource(ctx)));
            }
            catch (Throwable t) {
                ctx.getOnError().accept(t);
                return ParseError.build(this, source, relativeTo, ctx, t);
            }
        });
    }

    @Override
    public boolean accept(Path path) {
        return true;
    }

    @Override
    public Path sourcePathFromSourceText(Path prefix, String sourceCode) {
        return prefix.resolve("file");
    }
}

