/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.marketplace;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.univocity.parsers.csv.CsvFormat;
import com.univocity.parsers.csv.CsvWriter;
import com.univocity.parsers.csv.CsvWriterSettings;
import io.micrometer.core.instrument.util.StringUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.intellij.lang.annotations.Language;
import org.openrewrite.config.DataTableDescriptor;
import org.openrewrite.config.OptionDescriptor;
import org.openrewrite.marketplace.RecipeBundle;
import org.openrewrite.marketplace.RecipeListing;
import org.openrewrite.marketplace.RecipeMarketplace;

public class RecipeMarketplaceWriter {
    private static final Set<String> EXCLUDED_DATA_TABLES = new HashSet<String>(Arrays.asList("org.openrewrite.table.SearchResults", "org.openrewrite.table.SourcesFileResults", "org.openrewrite.table.SourcesFileErrors", "org.openrewrite.table.RecipeRunStats", "org.openrewrite.table.ParseFailures"));
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_DEFAULT);

    @Language(value="csv")
    public String toCsv(RecipeMarketplace marketplace) {
        StringWriter sw = new StringWriter();
        this.toCsv(marketplace, sw);
        return sw.toString();
    }

    public void toCsv(RecipeMarketplace marketplace, Path csvFile) {
        try (BufferedWriter writer = Files.newBufferedWriter(csvFile, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            this.toCsv(marketplace, writer);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toCsv(RecipeMarketplace marketplace, Writer writer) {
        CsvWriterSettings settings = new CsvWriterSettings();
        ((CsvFormat)settings.getFormat()).setLineSeparator("\n");
        try (CsvWriter csv = new CsvWriter(writer, settings);){
            int i;
            int maxCategoryDepth = this.calculateMaxCategoryDepth(marketplace.getRoot(), -1) + 1;
            boolean hasOptions = this.hasAnyOptions(marketplace.getRoot());
            boolean hasDataTables = this.hasAnyDataTables(marketplace.getRoot());
            boolean hasVersion = this.hasAnyVersion(marketplace);
            boolean hasTeam = this.hasAnyTeam(marketplace);
            boolean hasCategoryDescription = this.hasAnyCategoryDescription(marketplace.getRoot());
            List<String> metadataKeys = this.collectMetadataKeys(marketplace);
            ArrayList<String> headers = new ArrayList<String>();
            headers.add("ecosystem");
            headers.add("packageName");
            if (hasVersion) {
                headers.add("requestedVersion");
                headers.add("version");
            }
            headers.add("name");
            headers.add("displayName");
            headers.add("description");
            headers.add("recipeCount");
            for (i = 1; i <= maxCategoryDepth; ++i) {
                headers.add("category" + i);
            }
            if (hasCategoryDescription) {
                for (i = 1; i <= maxCategoryDepth; ++i) {
                    headers.add("category" + i + "Description");
                }
            }
            headers.addAll(metadataKeys);
            if (hasTeam) {
                headers.add("team");
            }
            if (hasOptions) {
                headers.add("options");
            }
            if (hasDataTables) {
                headers.add("dataTables");
            }
            csv.writeHeaders(headers);
            this.writeCsvRecursive(csv, marketplace.getRoot(), Collections.emptyList(), Collections.emptyList(), maxCategoryDepth, hasOptions, hasDataTables, hasTeam, hasVersion, hasCategoryDescription, metadataKeys);
        }
    }

    private void writeCsvRecursive(CsvWriter csv, RecipeMarketplace.Category category, List<String> categoryPath, List<String> categoryDescriptionPath, int maxCategoryDepth, boolean hasOptions, boolean hasDataTables, boolean hasTeam, boolean hasVersion, boolean hasCategoryDescription, List<String> metadataKeys) {
        for (RecipeListing recipe : category.getRecipes()) {
            int i;
            ArrayList<String> row = new ArrayList<String>();
            RecipeBundle bundle = recipe.getBundle();
            row.add(bundle.getPackageEcosystem());
            row.add(bundle.getPackageName());
            if (hasVersion) {
                row.add(StringUtils.isBlank((String)bundle.getRequestedVersion()) ? "" : bundle.getRequestedVersion());
                row.add(StringUtils.isBlank((String)bundle.getVersion()) ? "" : bundle.getVersion());
            }
            row.add(recipe.getName());
            row.add(recipe.getDisplayName());
            row.add(recipe.getDescription());
            row.add(Integer.toString(recipe.getRecipeCount()));
            int padding = maxCategoryDepth - categoryPath.size();
            for (i = 0; i < maxCategoryDepth; ++i) {
                if (i < padding) {
                    row.add("");
                    continue;
                }
                row.add(categoryPath.get(i - padding));
            }
            if (hasCategoryDescription) {
                for (i = 0; i < maxCategoryDepth; ++i) {
                    if (i < padding) {
                        row.add("");
                        continue;
                    }
                    row.add(categoryDescriptionPath.get(i - padding));
                }
            }
            Map<String, Object> metadata = recipe.getMetadata();
            for (String key : metadataKeys) {
                Object value = metadata.get(key);
                row.add(value != null ? String.valueOf(value) : "");
            }
            if (hasTeam) {
                row.add(StringUtils.isBlank((String)bundle.getTeam()) ? "" : bundle.getTeam());
            }
            if (hasOptions) {
                row.add(this.optionsToJson(recipe.getOptions()));
            }
            if (hasDataTables) {
                row.add(this.dataTablesToJson(recipe.getDataTables()));
            }
            csv.writeRow(row.toArray(new String[0]));
        }
        for (RecipeMarketplace.Category child : category.getCategories()) {
            ArrayList<String> childPath = new ArrayList<String>(categoryPath);
            childPath.add(0, child.getDisplayName());
            ArrayList<String> childDescriptionPath = new ArrayList<String>(categoryDescriptionPath);
            childDescriptionPath.add(0, child.getDescription());
            this.writeCsvRecursive(csv, child, childPath, childDescriptionPath, maxCategoryDepth, hasOptions, hasDataTables, hasTeam, hasVersion, hasCategoryDescription, metadataKeys);
        }
    }

    private String optionsToJson(List<OptionDescriptor> options) {
        if (options.isEmpty()) {
            return "";
        }
        try {
            return JSON_MAPPER.writeValueAsString(options);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Failed to serialize options to JSON", e);
        }
    }

    private String dataTablesToJson(List<DataTableDescriptor> dataTables) {
        List filtered = dataTables.stream().filter(dt -> !EXCLUDED_DATA_TABLES.contains(dt.getName())).collect(Collectors.toList());
        if (filtered.isEmpty()) {
            return "";
        }
        try {
            return JSON_MAPPER.writeValueAsString(filtered);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Failed to serialize data tables to JSON", e);
        }
    }

    private int calculateMaxCategoryDepth(RecipeMarketplace.Category category, int currentDepth) {
        int max = currentDepth;
        for (RecipeMarketplace.Category child : category.getCategories()) {
            int childDepth = this.calculateMaxCategoryDepth(child, currentDepth + 1);
            max = Math.max(max, childDepth);
        }
        return max;
    }

    private boolean hasAnyOptions(RecipeMarketplace.Category category) {
        for (RecipeListing recipe : category.getRecipes()) {
            if (recipe.getOptions().isEmpty()) continue;
            return true;
        }
        for (RecipeMarketplace.Category child : category.getCategories()) {
            if (!this.hasAnyOptions(child)) continue;
            return true;
        }
        return false;
    }

    private boolean hasAnyDataTables(RecipeMarketplace.Category category) {
        for (RecipeListing recipe : category.getRecipes()) {
            for (DataTableDescriptor dt : recipe.getDataTables()) {
                if (EXCLUDED_DATA_TABLES.contains(dt.getName())) continue;
                return true;
            }
        }
        for (RecipeMarketplace.Category child : category.getCategories()) {
            if (!this.hasAnyDataTables(child)) continue;
            return true;
        }
        return false;
    }

    private boolean hasAnyTeam(RecipeMarketplace marketplace) {
        for (RecipeListing recipe : marketplace.getAllRecipes()) {
            RecipeBundle bundle = recipe.getBundle();
            if (!StringUtils.isNotBlank((String)bundle.getTeam())) continue;
            return true;
        }
        return false;
    }

    private boolean hasAnyVersion(RecipeMarketplace marketplace) {
        for (RecipeListing recipe : marketplace.getAllRecipes()) {
            RecipeBundle bundle = recipe.getBundle();
            if (!StringUtils.isNotBlank((String)bundle.getVersion())) continue;
            return true;
        }
        return false;
    }

    private boolean hasAnyCategoryDescription(RecipeMarketplace.Category root) {
        for (RecipeMarketplace.Category child : root.getCategories()) {
            if (!this.hasAnyCategoryDescriptionRecursive(child)) continue;
            return true;
        }
        return false;
    }

    private boolean hasAnyCategoryDescriptionRecursive(RecipeMarketplace.Category category) {
        if (StringUtils.isNotBlank((String)category.getDescription())) {
            return true;
        }
        for (RecipeMarketplace.Category child : category.getCategories()) {
            if (!this.hasAnyCategoryDescriptionRecursive(child)) continue;
            return true;
        }
        return false;
    }

    private List<String> collectMetadataKeys(RecipeMarketplace marketplace) {
        TreeSet<String> keys = new TreeSet<String>();
        for (RecipeListing recipe : marketplace.getAllRecipes()) {
            keys.addAll(recipe.getMetadata().keySet());
        }
        return new ArrayList<String>(keys);
    }
}

