/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.marketplace;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.cfg.ConstructorDetector;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import com.univocity.parsers.csv.CsvParser;
import com.univocity.parsers.csv.CsvParserSettings;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.intellij.lang.annotations.Language;
import org.jspecify.annotations.Nullable;
import org.openrewrite.config.CategoryDescriptor;
import org.openrewrite.config.DataTableDescriptor;
import org.openrewrite.config.OptionDescriptor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.marketplace.RecipeBundle;
import org.openrewrite.marketplace.RecipeListing;
import org.openrewrite.marketplace.RecipeMarketplace;

public class RecipeMarketplaceReader {
    private static final ObjectMapper JSON_MAPPER = ((JsonMapper)((JsonMapper.Builder)JsonMapper.builder().constructorDetector(ConstructorDetector.USE_PROPERTIES_BASED)).build()).registerModule((Module)new ParameterNamesModule()).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);

    public RecipeMarketplace fromCsv(@Language(value="csv") String csv) {
        return this.fromCsv(new StringReader(csv));
    }

    public RecipeMarketplace fromCsv(Path csv) {
        try {
            return this.fromCsv(Files.newBufferedReader(csv));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to read from CSV", e);
        }
    }

    public RecipeMarketplace fromCsv(InputStream csv) {
        return this.fromCsv(new InputStreamReader(csv));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecipeMarketplace fromCsv(Reader csv) {
        CsvParserSettings settings = new CsvParserSettings();
        settings.setLineSeparatorDetectionEnabled(true);
        settings.setHeaderExtractionEnabled(false);
        settings.setNullValue("");
        settings.setDelimiterDetectionEnabled(true, new char[]{',', '\t', ';'});
        settings.setMaxCharsPerColumn(-1);
        CsvParser parser = new CsvParser(settings);
        parser.beginParsing(csv);
        try {
            String[] row;
            RecipeMarketplace marketplace = new RecipeMarketplace();
            List<NamedColumn> headers = null;
            while ((row = parser.parseNext()) != null) {
                if (row.length == 0 || row.length == 1 && row[0] == null) continue;
                if (headers == null) {
                    headers = this.parseHeaders(row);
                    continue;
                }
                this.readRecipe(row, marketplace, headers);
            }
            RecipeMarketplace recipeMarketplace = marketplace;
            return recipeMarketplace;
        }
        finally {
            parser.stopParsing();
        }
    }

    private List<NamedColumn> parseHeaders(@Nullable String[] row) {
        ArrayList<NamedColumn> headers = new ArrayList<NamedColumn>();
        for (String headerName : row) {
            if (headerName == null) continue;
            headerName = headerName.trim();
            headers.add(Column.fromString(headerName));
        }
        return headers;
    }

    private void readRecipe(@Nullable String[] row, RecipeMarketplace marketplace, List<NamedColumn> headers) {
        String name = null;
        String displayName = null;
        String description = null;
        Duration estimatedEffortPerOccurrence = null;
        String ecosystem = null;
        String packageName = null;
        String requestedVersion = null;
        String version = null;
        int recipeCount = 1;
        String team = null;
        TreeMap<Integer, String> categoryDisplayNames = new TreeMap<Integer, String>();
        TreeMap<Integer, String> categoryDescriptions = new TreeMap<Integer, String>();
        ArrayList<OptionDescriptor> options = new ArrayList<OptionDescriptor>();
        ArrayList<DataTableDescriptor> dataTables = new ArrayList<DataTableDescriptor>();
        LinkedHashMap<String, String> metadata = new LinkedHashMap<String, String>();
        block19: for (int i = 0; i < row.length && i < headers.size(); ++i) {
            String value = row[i];
            if (value != null && StringUtils.isBlank(value = value.trim())) {
                value = null;
            }
            NamedColumn column = headers.get(i);
            switch (column.getColumn().ordinal()) {
                case 0: {
                    name = value;
                    continue block19;
                }
                case 1: {
                    displayName = value;
                    continue block19;
                }
                case 2: {
                    description = value;
                    continue block19;
                }
                case 3: {
                    if (value == null) continue block19;
                    try {
                        estimatedEffortPerOccurrence = Duration.parse(value);
                        continue block19;
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Invalid duration format for estimatedEffortPerOccurrence: '" + value + "'. Expected ISO-8601 duration format (e.g., PT5M, PT1H)", e);
                    }
                }
                case 4: {
                    if (value == null) continue block19;
                    int categoryIndex = column.getIndex();
                    categoryDisplayNames.put(categoryIndex, value);
                    continue block19;
                }
                case 5: {
                    if (value == null) continue block19;
                    int categoryIndex = column.getIndex();
                    categoryDescriptions.put(categoryIndex, value);
                    continue block19;
                }
                case 6: {
                    ecosystem = value;
                    continue block19;
                }
                case 7: {
                    packageName = value;
                    continue block19;
                }
                case 8: {
                    requestedVersion = value;
                    continue block19;
                }
                case 9: {
                    version = value;
                    continue block19;
                }
                case 10: {
                    recipeCount = value == null ? 1 : Integer.parseInt(value);
                    continue block19;
                }
                case 11: {
                    team = value;
                    continue block19;
                }
                case 12: {
                    if (value == null) continue block19;
                    options.addAll(this.parseOptionsFromJson(value));
                    continue block19;
                }
                case 13: {
                    if (value == null) continue block19;
                    dataTables.addAll(this.parseDataTablesFromJson(value));
                    continue block19;
                }
                case 14: {
                    if (value == null) continue block19;
                    metadata.put(column.getHeaderName(), value);
                }
            }
        }
        if (name == null) {
            throw new IllegalArgumentException("CSV file must contain a column named 'name' and each row must have a value for it");
        }
        if (packageName == null) {
            throw new IllegalArgumentException("CSV file must contain a column named 'packageName' and each row must have a value for it");
        }
        if (ecosystem == null) {
            throw new IllegalArgumentException("CSV file must contain a column named 'ecosystem' and each row must have a value for it");
        }
        RecipeBundle bundle = new RecipeBundle(ecosystem.toLowerCase(), packageName, requestedVersion, version, team);
        RecipeListing listing = new RecipeListing(marketplace, name, displayName != null ? displayName : name, description != null ? description : "", estimatedEffortPerOccurrence, options, dataTables, recipeCount, bundle);
        listing.getMetadata().putAll(metadata);
        ArrayList<CategoryDescriptor> categoryPath = new ArrayList<CategoryDescriptor>();
        for (Map.Entry entry : categoryDisplayNames.entrySet()) {
            int index = (Integer)entry.getKey();
            String catDisplayName = (String)entry.getValue();
            String catDescription = categoryDescriptions.getOrDefault(index, "");
            categoryPath.add(new CategoryDescriptor(catDisplayName, "", catDescription, Collections.emptySet(), false, -1, true));
        }
        Collections.reverse(categoryPath);
        marketplace.install(listing, categoryPath);
    }

    private List<OptionDescriptor> parseOptionsFromJson(String json) {
        try {
            return (List)JSON_MAPPER.readValue(json, (TypeReference)new TypeReference<List<OptionDescriptor>>(){});
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to parse options JSON: " + json, e);
        }
    }

    private List<DataTableDescriptor> parseDataTablesFromJson(String json) {
        try {
            return (List)JSON_MAPPER.readValue(json, (TypeReference)new TypeReference<List<DataTableDescriptor>>(){});
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to parse data tables JSON: " + json, e);
        }
    }

    private static enum Column {
        NAME("name"),
        DISPLAY_NAME("displayName"),
        DESCRIPTION("description"),
        ESTIMATED_EFFORT_PER_OCCURRENCE("estimatedEffortPerOccurrence"),
        CATEGORY("category"),
        CATEGORY_DESCRIPTION("categoryDescription"),
        ECOSYSTEM("ecosystem"),
        PACKAGE_NAME("packageName"),
        REQUESTED_VERSION("requestedVersion"),
        VERSION("version"),
        RECIPE_COUNT("recipeCount"),
        TEAM("team"),
        OPTIONS("options"),
        DATA_TABLES("dataTables"),
        UNKNOWN("_unknown");

        private final String columnName;
        private static final Pattern CATEGORY_PATTERN;
        private static final Pattern CATEGORY_DESCRIPTION_PATTERN;

        public static NamedColumn fromString(String key) {
            Matcher categoryDescriptionMatcher = CATEGORY_DESCRIPTION_PATTERN.matcher(key);
            if (categoryDescriptionMatcher.matches()) {
                String indexStr = categoryDescriptionMatcher.group(1);
                int index = indexStr.isEmpty() ? 1 : Integer.parseInt(indexStr);
                return new NamedColumn(CATEGORY_DESCRIPTION, key, index);
            }
            Matcher categoryMatcher = CATEGORY_PATTERN.matcher(key);
            if (categoryMatcher.matches()) {
                String indexStr = categoryMatcher.group(1);
                int index = indexStr.isEmpty() ? 1 : Integer.parseInt(indexStr);
                return new NamedColumn(CATEGORY, key, index);
            }
            for (Column column : Column.values()) {
                if (!column.columnName.equalsIgnoreCase(key)) continue;
                return new NamedColumn(column, key, -1);
            }
            return new NamedColumn(UNKNOWN, key, -1);
        }

        @Generated
        public String getColumnName() {
            return this.columnName;
        }

        @Generated
        private Column(String columnName) {
            this.columnName = columnName;
        }

        static {
            CATEGORY_PATTERN = Pattern.compile("category(\\d*)", 2);
            CATEGORY_DESCRIPTION_PATTERN = Pattern.compile("category(\\d*)Description", 2);
        }
    }

    private static final class NamedColumn {
        private final Column column;
        private final String headerName;
        private final int index;

        @Generated
        public NamedColumn(Column column, String headerName, int index) {
            this.column = column;
            this.headerName = headerName;
            this.index = index;
        }

        @Generated
        public Column getColumn() {
            return this.column;
        }

        @Generated
        public String getHeaderName() {
            return this.headerName;
        }

        @Generated
        public int getIndex() {
            return this.index;
        }

        @Generated
        public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NamedColumn)) {
                return false;
            }
            NamedColumn other = (NamedColumn)o;
            if (this.getIndex() != other.getIndex()) {
                return false;
            }
            Column this$column = this.getColumn();
            Column other$column = other.getColumn();
            if (this$column == null ? other$column != null : !((Object)((Object)this$column)).equals((Object)other$column)) {
                return false;
            }
            String this$headerName = this.getHeaderName();
            String other$headerName = other.getHeaderName();
            return !(this$headerName == null ? other$headerName != null : !this$headerName.equals(other$headerName));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getIndex();
            Column $column = this.getColumn();
            result = result * 59 + ($column == null ? 43 : ((Object)((Object)$column)).hashCode());
            String $headerName = this.getHeaderName();
            result = result * 59 + ($headerName == null ? 43 : $headerName.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "RecipeMarketplaceReader.NamedColumn(column=" + (Object)((Object)this.getColumn()) + ", headerName=" + this.getHeaderName() + ", index=" + this.getIndex() + ")";
        }
    }
}

