/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.marketplace;

import java.time.Duration;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.NlsRewrite;
import org.openrewrite.Recipe;
import org.openrewrite.config.DataTableDescriptor;
import org.openrewrite.config.OptionDescriptor;
import org.openrewrite.config.RecipeDescriptor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.marketplace.RecipeBundle;
import org.openrewrite.marketplace.RecipeBundleReader;
import org.openrewrite.marketplace.RecipeBundleResolver;
import org.openrewrite.marketplace.RecipeMarketplace;

public class RecipeListing
implements Comparable<RecipeListing> {
    private final @Nullable RecipeMarketplace marketplace;
    private final String name;
    private final @NlsRewrite.DisplayName String displayName;
    private final @NlsRewrite.Description String description;
    private final @Nullable Duration estimatedEffortPerOccurrence;
    private final List<OptionDescriptor> options;
    private final List<DataTableDescriptor> dataTables;
    private final int recipeCount;
    private final Map<String, Object> metadata = new LinkedHashMap<String, Object>();
    private final RecipeBundle bundle;

    public RecipeBundleReader resolve() {
        if (this.marketplace != null) {
            for (RecipeBundleResolver resolver : this.marketplace.getResolvers()) {
                if (!resolver.getEcosystem().equals(this.bundle.getPackageEcosystem())) continue;
                return resolver.resolve(this.bundle);
            }
        }
        throw new IllegalStateException("This listing has not been configured with a resolver.");
    }

    public RecipeDescriptor describe() {
        return this.resolve().describe(this);
    }

    public Recipe prepare(Map<String, Object> options) {
        return this.resolve().prepare(this, options);
    }

    @Override
    public int compareTo(RecipeListing o) {
        return this.name.compareTo(o.name);
    }

    public static RecipeListing fromDescriptor(RecipeDescriptor descriptor, RecipeBundle bundle) {
        int recipeCount = 1;
        RecipeDescriptor d = descriptor;
        LinkedList<RecipeDescriptor> queue = new LinkedList<RecipeDescriptor>(Collections.singleton(descriptor));
        while (!queue.isEmpty()) {
            recipeCount += d.getRecipeList().size();
            queue.addAll(d.getRecipeList());
            d = (RecipeDescriptor)queue.poll();
        }
        return new RecipeListing(null, descriptor.getName(), descriptor.getDisplayName(), descriptor.getDescription(), descriptor.getEstimatedEffortPerOccurrence(), descriptor.getOptions(), descriptor.getDataTables(), recipeCount, bundle);
    }

    @Generated
    public @Nullable RecipeMarketplace getMarketplace() {
        return this.marketplace;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public @Nullable Duration getEstimatedEffortPerOccurrence() {
        return this.estimatedEffortPerOccurrence;
    }

    @Generated
    public List<OptionDescriptor> getOptions() {
        return this.options;
    }

    @Generated
    public List<DataTableDescriptor> getDataTables() {
        return this.dataTables;
    }

    @Generated
    public int getRecipeCount() {
        return this.recipeCount;
    }

    @Generated
    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    @Generated
    public RecipeBundle getBundle() {
        return this.bundle;
    }

    @Generated
    public RecipeListing(@Nullable RecipeMarketplace marketplace, String name, String displayName, String description, @Nullable Duration estimatedEffortPerOccurrence, List<OptionDescriptor> options, List<DataTableDescriptor> dataTables, int recipeCount, RecipeBundle bundle) {
        this.marketplace = marketplace;
        this.name = name;
        this.displayName = displayName;
        this.description = description;
        this.estimatedEffortPerOccurrence = estimatedEffortPerOccurrence;
        this.options = options;
        this.dataTables = dataTables;
        this.recipeCount = recipeCount;
        this.bundle = bundle;
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RecipeListing)) {
            return false;
        }
        RecipeListing other = (RecipeListing)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof RecipeListing;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    @NonNull
    @Generated
    public RecipeListing withMarketplace(@Nullable RecipeMarketplace marketplace) {
        return this.marketplace == marketplace ? this : new RecipeListing(marketplace, this.name, this.displayName, this.description, this.estimatedEffortPerOccurrence, this.options, this.dataTables, this.recipeCount, this.bundle);
    }

    @NonNull
    @Generated
    RecipeListing withBundle(RecipeBundle bundle) {
        return this.bundle == bundle ? this : new RecipeListing(this.marketplace, this.name, this.displayName, this.description, this.estimatedEffortPerOccurrence, this.options, this.dataTables, this.recipeCount, bundle);
    }
}

