/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.marketplace;

import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;

public class RecipeClassLoader
extends URLClassLoader {
    private final ClassLoader parent;
    private static final List<String> PARENT_DELEGATED_PREFIXES = Arrays.asList("org.openrewrite.Column", "org.openrewrite.Cursor", "org.openrewrite.DelegatingExecutionContext", "org.openrewrite.ExecutionContext", "org.openrewrite.InMemoryExecutionContext", "org.openrewrite.Option", "org.openrewrite.DataTable", "org.openrewrite.ParseExceptionResult", "org.openrewrite.ParseWarning", "org.openrewrite.Recipe", "org.openrewrite.Result", "org.openrewrite.ScanningRecipe", "org.openrewrite.SourceFile", "org.openrewrite.Charset", "org.openrewrite.Checksum", "org.openrewrite.remote", "org.openrewrite.Parser", "org.openrewrite.Tree", "org.openrewrite.Validated", "org.openrewrite.ValidationException", "org.openrewrite.config", "org.openrewrite.internal", "org.openrewrite.marker", "org.openrewrite.scheduling", "org.openrewrite.style", "org.openrewrite.template", "org.openrewrite.trait", "org.openrewrite.FileAttributes", "org.openrewrite.PrintOutputCapture", "org.openrewrite.ipc.http.HttpSender", "org.openrewrite.java.internal.TypesInUse", "org.openrewrite.maven.MavenDownloadingException", "org.openrewrite.maven.MavenDownloadingExceptions", "org.openrewrite.maven.MavenExecutionContextView", "org.openrewrite.maven.MavenSettings", "org.openrewrite.maven.internal", "org.openrewrite.text.PlainText", "org.openrewrite.quark.Quark", "org.openrewrite.java.JavaParser", "org.openrewrite.java.MethodMatcher");

    public RecipeClassLoader(@Nullable Path recipeJar, List<Path> classpath) {
        this(RecipeClassLoader.getUrls(recipeJar, classpath), RecipeClassLoader.class.getClassLoader());
    }

    public RecipeClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, (ClassLoader)null);
        this.parent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> foundClass = this.findLoadedClass(name);
            if (foundClass != null) {
                if (resolve) {
                    this.resolveClass(foundClass);
                }
                return foundClass;
            }
            try {
                foundClass = this.shouldDelegateToParent(name) ? this.parent.loadClass(name) : this.findClass(name);
            }
            catch (ClassNotFoundException e) {
                foundClass = this.parent.loadClass(name);
            }
            if (resolve) {
                this.resolveClass(foundClass);
            }
            return foundClass;
        }
    }

    private boolean shouldDelegateToParent(String className) {
        for (String prefix : this.getAdditionalParentDelegatedPackages()) {
            if (!className.startsWith(prefix)) continue;
            return true;
        }
        if (className.startsWith("org.slf4j") || className.startsWith("com.fasterxml.jackson")) {
            return true;
        }
        if (!className.startsWith("org.openrewrite")) {
            return false;
        }
        for (String prefix : PARENT_DELEGATED_PREFIXES) {
            if (!className.startsWith(prefix)) continue;
            return true;
        }
        return this.isTreeMarkerStyleType(className);
    }

    private boolean isTreeMarkerStyleType(String className) {
        String[] parts = className.split("\\.");
        if (parts.length < 4) {
            return false;
        }
        for (int i = 2; i < parts.length - 1; ++i) {
            String part = parts[i];
            if (!"tree".equals(part) && !"marker".equals(part) && !"style".equals(part)) continue;
            return true;
        }
        if (!className.contains("$")) {
            String last = parts[parts.length - 1];
            String secondToLast = parts[parts.length - 2];
            return last.endsWith("Visitor") && last.toLowerCase().startsWith(secondToLast.toLowerCase()) && last.length() == secondToLast.length() + "Visitor".length();
        }
        return false;
    }

    protected List<String> getAdditionalParentDelegatedPackages() {
        return Collections.emptyList();
    }

    public static URL[] getUrls(@Nullable Path recipeJar, List<Path> classpath) {
        return (URL[])Stream.concat(classpath.stream(), Stream.of(recipeJar)).filter(Objects::nonNull).map(Path::toUri).map(uri -> {
            try {
                return uri.toURL();
            }
            catch (MalformedURLException e) {
                throw new UncheckedIOException(e);
            }
        }).toArray(URL[]::new);
    }
}

