/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FindSourceFiles;
import org.openrewrite.Option;
import org.openrewrite.PathUtils;
import org.openrewrite.Preconditions;
import org.openrewrite.RecipeException;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.jgit.ignore.FastIgnoreRule;
import org.openrewrite.jgit.ignore.IgnoreNode;
import org.openrewrite.text.PlainText;
import org.openrewrite.text.PlainTextVisitor;

public final class ExcludeFileFromGitignore
extends ScanningRecipe<Repository> {
    @Option(displayName="Paths", description="The paths to find and remove from the gitignore files.", example="/folder/file.txt")
    private final List<String> paths;

    @Override
    public String getDisplayName() {
        return "Remove ignoral of files or directories from .gitignore";
    }

    @Override
    public String getDescription() {
        return "This recipe will remove a file or directory from the .gitignore file. If the file or directory is already in the .gitignore file, it will be removed or negated. If the file or directory is not in the .gitignore file, no action will be taken.";
    }

    @Override
    public Repository getInitialValue(ExecutionContext ctx) {
        return new Repository();
    }

    @Override
    public TreeVisitor<?, ExecutionContext> getScanner(final Repository acc) {
        return Preconditions.check(new FindSourceFiles("**/.gitignore"), new PlainTextVisitor<ExecutionContext>(){

            @Override
            public PlainText visitText(PlainText text, ExecutionContext ctx) {
                try {
                    acc.addGitignoreFile(text);
                }
                catch (IOException e) {
                    throw new RecipeException("Failed to parse the .gitignore file", new Object[]{e});
                }
                return super.visitText(text, ctx);
            }
        });
    }

    @Override
    public Collection<? extends SourceFile> generate(Repository acc, ExecutionContext ctx) {
        for (String path : this.paths) {
            acc.exclude(path);
        }
        return Collections.emptyList();
    }

    @Override
    public TreeVisitor<?, ExecutionContext> getVisitor(final Repository acc) {
        return Preconditions.check(new FindSourceFiles("**/.gitignore"), new PlainTextVisitor<ExecutionContext>(){

            @Override
            public PlainText visitText(PlainText text, ExecutionContext ctx) {
                CustomIgnoreNode ignoreNode = (CustomIgnoreNode)acc.rules.get(ExcludeFileFromGitignore.asGitignoreFileLocation(text));
                if (ignoreNode != null) {
                    String separator = text.getText().contains("\r\n") ? "\r\n" : "\n";
                    List<String> newRules = ignoreNode.getRules().stream().map(IgnoreRule::getText).collect(Collectors.toList());
                    String[] currentContent = text.getText().split(separator);
                    text = text.withText(String.join((CharSequence)separator, this.sortRules(currentContent, newRules)));
                }
                return text;
            }

            private List<String> sortRules(String[] originalRules, List<String> newRules) {
                LinkedList<String> results = new LinkedList<String>();
                Arrays.stream(originalRules).filter(line -> {
                    if (StringUtils.isBlank(line) || line.startsWith("#")) {
                        return true;
                    }
                    return newRules.stream().anyMatch(line::equalsIgnoreCase);
                }).forEach(results::add);
                int resultsIndexCurrentlyAt = 0;
                for (String newRule : newRules) {
                    List resultsSubList = results.subList(resultsIndexCurrentlyAt, results.size());
                    if (resultsSubList.stream().noneMatch(rule -> rule.equalsIgnoreCase(newRule))) {
                        if (resultsIndexCurrentlyAt >= results.size()) {
                            results.add(newRule);
                        } else {
                            results.add(resultsIndexCurrentlyAt, newRule);
                        }
                    } else {
                        resultsIndexCurrentlyAt += resultsSubList.indexOf(newRule);
                    }
                    ++resultsIndexCurrentlyAt;
                }
                return this.distinctValuesStartingReversed(results);
            }

            private List<String> distinctValuesStartingReversed(List<String> list) {
                LinkedList<String> filteredList = new LinkedList<String>();
                ListIterator<String> iterator = list.listIterator(list.size());
                while (iterator.hasPrevious()) {
                    String previous = iterator.previous();
                    if (!StringUtils.isBlank(previous) && !previous.startsWith("#") && filteredList.contains(previous)) continue;
                    filteredList.addFirst(previous);
                }
                return filteredList;
            }
        });
    }

    private static String asGitignoreFileLocation(PlainText text) {
        String gitignoreFileName = PathUtils.separatorsToUnix(text.getSourcePath().toString());
        gitignoreFileName = gitignoreFileName.startsWith("/") ? gitignoreFileName : "/" + gitignoreFileName;
        return gitignoreFileName.substring(0, gitignoreFileName.lastIndexOf("/") + 1);
    }

    @Generated
    public ExcludeFileFromGitignore(List<String> paths) {
        this.paths = paths;
    }

    @Generated
    public List<String> getPaths() {
        return this.paths;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ExcludeFileFromGitignore(paths=" + this.getPaths() + ")";
    }

    @Override
    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExcludeFileFromGitignore)) {
            return false;
        }
        ExcludeFileFromGitignore other = (ExcludeFileFromGitignore)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$paths = this.getPaths();
        List<String> other$paths = other.getPaths();
        return !(this$paths == null ? other$paths != null : !((Object)this$paths).equals(other$paths));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ExcludeFileFromGitignore;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $paths = this.getPaths();
        result = result * 59 + ($paths == null ? 43 : ((Object)$paths).hashCode());
        return result;
    }

    public static class Repository {
        private final Map<String, CustomIgnoreNode> rules = new HashMap<String, CustomIgnoreNode>();

        public void exclude(String path) {
            String normalizedPath = (path = PathUtils.separatorsToUnix(path)).startsWith("/") ? path : "/" + path;
            List impactingFiles = this.rules.keySet().stream().filter(k -> normalizedPath.toLowerCase().startsWith(k.toLowerCase())).sorted(Comparator.comparingInt(String::length).reversed()).collect(Collectors.toList());
            for (String impactingFile : impactingFiles) {
                CustomIgnoreNode ignoreNode = this.rules.get(impactingFile);
                String nestedPath = normalizedPath.substring(impactingFile.length() - 1);
                while (IgnoreNode.MatchResult.IGNORED == ignoreNode.isIgnored(nestedPath)) {
                    List<IgnoreRule> existingRules = ignoreNode.getRules();
                    LinkedHashSet<FastIgnoreRule> remainingRules = new LinkedHashSet<FastIgnoreRule>();
                    for (int i = existingRules.size() - 1; i > -1; --i) {
                        IgnoreRule rule = existingRules.get(i);
                        remainingRules.addAll(rule.negateIfNecessary(nestedPath));
                    }
                    ArrayList<FastIgnoreRule> ignoreRules = new ArrayList<FastIgnoreRule>(remainingRules);
                    Collections.reverse(ignoreRules);
                    ignoreNode = new CustomIgnoreNode(ignoreRules, ignoreNode.getPath());
                    if (ignoreRules.size() != existingRules.size()) continue;
                    break;
                }
                this.rules.put(impactingFile, ignoreNode);
                if (IgnoreNode.MatchResult.CHECK_PARENT == ignoreNode.isIgnored(nestedPath)) continue;
            }
        }

        public void addGitignoreFile(PlainText text) throws IOException {
            CustomIgnoreNode ignoreNode = CustomIgnoreNode.of(text);
            this.rules.put(ignoreNode.path, ignoreNode);
        }
    }

    private static class IgnoreRule {
        private final FastIgnoreRule rule;
        private final String text;

        public IgnoreRule(FastIgnoreRule rule) {
            this.rule = rule;
            this.text = rule.toString();
        }

        public boolean isMatch(String path) {
            return this.rule.isMatch(path, true, false) || this.rule.isMatch(path, true, true);
        }

        public boolean getResult() {
            return this.rule.getResult();
        }

        public List<FastIgnoreRule> negateIfNecessary(String nestedPath) {
            if (!this.isMatch(nestedPath) || !this.getResult()) {
                return Collections.singletonList(this.rule);
            }
            if (this.text.equals(nestedPath)) {
                return Collections.emptyList();
            }
            if (this.isMatch(nestedPath)) {
                if (this.text.contains("*")) {
                    return this.getWildcardRules(nestedPath);
                }
                if (("/" + this.text).equals(nestedPath)) {
                    return Arrays.asList(new FastIgnoreRule("!" + nestedPath), this.rule);
                }
                if (!this.rule.dirOnly()) {
                    return Arrays.asList(new FastIgnoreRule("!" + nestedPath), this.rule);
                }
                return IgnoreRule.traversePaths(this.text, nestedPath, null, null);
            }
            return Collections.singletonList(this.rule);
        }

        public String toString() {
            return this.text;
        }

        private List<FastIgnoreRule> getWildcardRules(String nestedPath) {
            if (!this.isMatch(nestedPath)) {
                return Collections.singletonList(this.rule);
            }
            if (this.text.startsWith("!")) {
                return Collections.singletonList(this.rule);
            }
            if (this.isWildcardedBetween(1, -1) || this.splitRuleParts().length > 1 && this.isWildcardedBetween(0, 1) && this.isWildcardedBetween(-1, 0)) {
                return Collections.singletonList(this.rule);
            }
            if (!this.hasOnlyOneWildcardGroup()) {
                return Collections.singletonList(this.rule);
            }
            if (!this.isFullWildcard()) {
                return Arrays.asList(new FastIgnoreRule("!" + nestedPath), this.rule);
            }
            String wildcard = "*";
            if (this.text.contains("**")) {
                wildcard = "**";
            }
            if (this.isWildcardedBetween(0, 1)) {
                return IgnoreRule.traversePaths(this.text, nestedPath, null, (this.text.startsWith("/") ? "/" : "") + wildcard);
            }
            if (this.isWildcardedBetween(-1, 0)) {
                return IgnoreRule.traversePaths(this.text, nestedPath, wildcard + (this.text.endsWith("/") ? "/" : ""), null);
            }
            return Collections.singletonList(this.rule);
        }

        private boolean isFullWildcard() {
            if (!this.text.contains("*")) {
                return false;
            }
            int begin = this.text.indexOf("*");
            int end = this.text.lastIndexOf("*");
            return !(begin != 0 && this.text.charAt(begin - 1) != '/' || end != this.text.length() - 1 && this.text.charAt(end + 1) != '/');
        }

        private boolean hasOnlyOneWildcardGroup() {
            int lastWildcard;
            if (!this.text.contains("*")) {
                return false;
            }
            int firstWildcard = this.text.indexOf("*");
            return firstWildcard == (lastWildcard = this.text.lastIndexOf("*")) || lastWildcard - firstWildcard == 1;
        }

        private boolean isWildcardedBetween(int start, int end) {
            int endIdx;
            if (!this.text.contains("*")) {
                return false;
            }
            String[] parts = this.splitRuleParts();
            int startIdx = start;
            if (startIdx < 0) {
                startIdx = parts.length + start;
            }
            if ((endIdx = end) <= 0) {
                endIdx = parts.length + end;
            }
            for (int i = startIdx; i < endIdx; ++i) {
                if (!parts[i].contains("*")) continue;
                return true;
            }
            return false;
        }

        private String[] splitRuleParts() {
            String rulePath = this.text;
            if (rulePath.startsWith("!")) {
                rulePath = rulePath.substring(1);
            }
            if (rulePath.startsWith("/")) {
                rulePath = rulePath.substring(1);
            }
            if (rulePath.endsWith("/")) {
                rulePath = rulePath.substring(0, rulePath.length() - 1);
            }
            return rulePath.split("/");
        }

        private static List<FastIgnoreRule> traversePaths(String originalRule, String path, @org.jspecify.annotations.Nullable String wildcardSuffix, @org.jspecify.annotations.Nullable String wildcardPrefix) {
            String rule = originalRule;
            ArrayList<FastIgnoreRule> traversedRemainingRules = new ArrayList<FastIgnoreRule>();
            if (wildcardSuffix != null && rule.endsWith(wildcardSuffix)) {
                rule = rule.substring(0, rule.length() - wildcardSuffix.length());
            }
            if (wildcardPrefix != null && rule.startsWith(wildcardPrefix)) {
                rule = path.substring(0, path.indexOf(rule.substring(wildcardPrefix.length()))) + rule.substring(wildcardPrefix.length());
                traversedRemainingRules.add(new FastIgnoreRule(originalRule + (originalRule.endsWith("/") ? "*" : "/*")));
                traversedRemainingRules.add(new FastIgnoreRule("!" + rule));
            }
            StringBuilder rulePath = new StringBuilder(rule);
            String pathToTraverse = path.substring(rule.length());
            if (originalRule.contains("*")) {
                if (pathToTraverse.isEmpty() && wildcardSuffix != null) {
                    return Arrays.asList(new FastIgnoreRule("!" + rule), new FastIgnoreRule(originalRule + (originalRule.endsWith("/") ? "*" : "/*")));
                }
                if (pathToTraverse.isEmpty() && wildcardPrefix != null) {
                    return Arrays.asList(new FastIgnoreRule("!" + rule), new FastIgnoreRule(originalRule));
                }
            } else if (pathToTraverse.replace("/", "").isEmpty()) {
                return Arrays.asList(new FastIgnoreRule("!" + rule), new FastIgnoreRule(originalRule));
            }
            String pathToSplit = pathToTraverse.startsWith("/") ? pathToTraverse.substring(1) : pathToTraverse;
            pathToSplit = pathToSplit.endsWith("/") ? pathToSplit.substring(0, pathToSplit.length() - 1) : pathToSplit;
            String[] splitPath = pathToSplit.split("/");
            for (int j = 0; j < splitPath.length; ++j) {
                String s = splitPath[j];
                traversedRemainingRules.add(new FastIgnoreRule(rulePath + (wildcardSuffix != null ? wildcardSuffix : "*")));
                rulePath.append(s);
                traversedRemainingRules.add(new FastIgnoreRule("!" + rulePath + (j < splitPath.length - 1 || path.endsWith("/") ? "/" : "")));
                rulePath.append("/");
            }
            Collections.reverse(traversedRemainingRules);
            return traversedRemainingRules;
        }

        @Generated
        public String getText() {
            return this.text;
        }
    }

    private static class CustomIgnoreNode {
        private final List<IgnoreRule> rules;
        private final String path;

        public CustomIgnoreNode(List<FastIgnoreRule> rules, String path) {
            this.rules = rules.stream().map(IgnoreRule::new).collect(Collectors.toList());
            this.path = path;
        }

        static CustomIgnoreNode of(PlainText text) throws IOException {
            String gitignoreFileName = ExcludeFileFromGitignore.asGitignoreFileLocation(text);
            IgnoreNode ignoreNode = new IgnoreNode();
            ignoreNode.parse(gitignoreFileName, (InputStream)new ByteArrayInputStream(text.getText().getBytes()));
            return new CustomIgnoreNode(ignoreNode.getRules(), gitignoreFileName);
        }

        public IgnoreNode.MatchResult isIgnored(String path) {
            for (int i = this.rules.size() - 1; i > -1; --i) {
                IgnoreRule rule = this.rules.get(i);
                if (!rule.isMatch(path)) continue;
                if (rule.getResult()) {
                    return IgnoreNode.MatchResult.IGNORED;
                }
                return IgnoreNode.MatchResult.NOT_IGNORED;
            }
            return IgnoreNode.MatchResult.CHECK_PARENT;
        }

        @Generated
        public List<IgnoreRule> getRules() {
            return this.rules;
        }

        @Generated
        public String getPath() {
            return this.path;
        }
    }
}

