/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.text;

import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.binary.Binary;
import org.openrewrite.quark.Quark;
import org.openrewrite.remote.Remote;

public class RemoveByteOrderMark
extends Recipe {
    @Override
    public String getDisplayName() {
        return "Remove byte order mark (BOM)";
    }

    @Override
    public String getDescription() {
        return "Removes UTF-8 byte order marks from the beginning of files.\n\nThe BOM character (U+FEFF) is generally unnecessary in UTF-8 files and can cause issues with some tools.";
    }

    @Override
    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Override
            public Tree visit(@Nullable Tree tree, ExecutionContext ctx) {
                SourceFile sourceFile = (SourceFile)Objects.requireNonNull(tree);
                if (sourceFile instanceof Quark || sourceFile instanceof Remote || sourceFile instanceof Binary) {
                    return sourceFile;
                }
                try {
                    if (sourceFile.isCharsetBomMarked()) {
                        return sourceFile.withCharsetBomMarked(false);
                    }
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
                return sourceFile;
            }
        };
    }
}

